<?php

/*
200 - Everything is OK
201 - Created Successfully
202 - Accepted
204 - No Content
301 - Moved Permanently
400 - Bad Request
401 - Unauthorized
404 - Not Found
500 - Internal Server Error
*/


session_start();
include('includes/database_include.php');
include('process/functions.php');

// Function to send email
function email_notification( $fname = null, $email = null, $subdomain = null ){
    
    $to_doc = "azad.kabir@gmail.com";
	$to_company = "support@ddxrx.net";
	
	$subject = "New User Registration";

	// Always set content-type when sending HTML email
	$headers = "MIME-Version: 1.0" . "\r\n";
	$headers .= "Content-type:text/html;charset=UTF-8" . "\r\n";
	$headers .= 'From: <no-reply@ddxrx.com>' . "\r\n";
	$headers .= 'Reply-To: no-reply@ddxrx.com';

    // If Subdomain set
    if( isset($subdomain) ){
        $subdomain_output = '
        <tr style="border-bottom: 1px solid #EEEEEE!important;">
            <td style="padding-top: 10px; padding-bottom: 10px; font-weight: 500; width: 120px;">Sub Domain</td>
            <td>'.$subdomain.'</td>
        </tr>
        ';
    }else{
        $subdomain_output = '';
    }

	$result_email = '
	<tbody>
		<tr style="border-bottom: 1px solid #EEEEEE!important;">
			<td style="padding-top: 10px; padding-bottom: 10px; font-weight: 500; width: 120px;">Customer Name</td>
			<td>'.$fname.'</td>
		</tr>
		<tr style="border-bottom: 1px solid #EEEEEE!important;">
			<td style="padding-top: 10px; padding-bottom: 10px; font-weight: 500; width: 120px;">Customer Email</td>
			<td>'.$email.'</td>
		</tr>
        '.$subdomain_output.'
	</tbody>
	';

	// Email Message to company
	$message_company = '
		<div style="background:#2ecc71; padding-top:50px; padding-bottom: 30px; text-align:center; border-radius:5px;">
			<h6 style="font-size:18px; font-weight:700; color:#FFFFFF; margin-bottom:10px; margin-top:0px; line-height:1em;">A new user has registered</h6>
			<p style="font-size:14px; color:rgba(255,255,255, 0.7); width: 40%; margin:0 auto; margin-bottom:20px;">A Client on ddxrx has signed up for an account.</p>
			<div style="background:#FFFFFF; width: 30%; margin:0 auto; margin-bottom:30px; border-radius:5px; padding:30px;">
				<table style=" font-size: 14px; width: 100%; text-align:left">'
					.$result_email.
				'</table>
			</div>
			<p style="font-size:11px; color:rgba(255,255,255, 0.5); text-align:center; width:30%; text-align:center; margin:0 auto;">This message was generated automatically because a client has registered a new account.</p>
		</div>
	';

	mail($to_company,$subject,$message_company,$headers);
	mail($to_doc,$subject,$message_company,$headers);

}

// Generate random number and string
function generateRandomString($length = 10) {
    $characters = '0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ';
    $charactersLength = strlen($characters);
    $randomString = '';
    for ($i = 0; $i < $length; $i++) {
        $randomString .= $characters[rand(0, $charactersLength - 1)];
    }
    return $randomString;
}

// Get nurse ID based on the version
function get_version_nurse(){
    
    $version = get_version();
    
    $sql = "SELECT * FROM nurse WHERE groupid = '$version'";
    $result = mysqli_query(ddxrxDBConnect(), $sql);
    $arr_nurse = array();
    
    if (mysqli_num_rows($result) > 0) {
        while($row = mysqli_fetch_assoc($result)) {
            
            array_push($arr_nurse, $row['user_id']);
            
        }
    }
    
    mysqli_close(ddxrxDBConnect());
    
    return $arr_nurse;
    
};

// Generate message for nurse and patients
function message_nurse( $patient_id = null ){
    
    $nurse_ids = get_version_nurse();
    
    $room_id = generateRandomString(10);
    $participant_id = generateRandomString(10);
    
    if( isset($patient_id) ){
        
        $sql = "INSERT INTO messenger_chat_room (room_id, participant_id, status_patient, status_nurse, status_doctor) VALUES ('$room_id', '$participant_id', 'unread', 'unread', 'unread');";
        $sql .= "INSERT INTO messenger_messages (room_id, sender_id, sender_type, message, message_type) VALUES ('$room_id', '0', '0', 'A new user with the name of Jonathan has signed up for an account', 'text');";
        $sql .= "INSERT INTO messenger_participants (participant_id, user_chat_id) VALUES ('$participant_id', '$patient_id');";
        
        foreach ($nurse_ids as $nurse_id){
            $sql .= "INSERT INTO messenger_participants (participant_id, user_chat_id) VALUES ('$participant_id', '$nurse_id');";
        }
    
    }
    
    mysqli_multi_query(ddxrxDBConnect(), $sql);
    
    mysqli_close(ddxrxDBConnect());
    
}


if($_SERVER['REQUEST_METHOD'] == "POST") {
    
    $conn = ddxrxDBConnect();
    
    $version = get_version();
    $location_id = 1;
    
    $emailAddress = $_POST['emailAddress'];
	$emailAddress = ddxrxDBConnect()->real_escape_string($emailAddress);
    
    $first_name = $_POST['first_name'];
    $first_name = ddxrxDBConnect()->real_escape_string($first_name);
    
    $middle_name = $_POST['middle_name'];
    $middle_name = ddxrxDBConnect()->real_escape_string($middle_name);
    
    $last_name = $_POST['last_name'];
    $last_name = ddxrxDBConnect()->real_escape_string($last_name);
    
    $phone_number = $_POST['phone_number'];
    $phone_number = ddxrxDBConnect()->real_escape_string($phone_number);
    
    $occupation = $_POST['occupation'];
    $occupation = ddxrxDBConnect()->real_escape_string($occupation);
    
    $birthday = strtotime($_POST['birthday']);
    $birthday = date("Y-m-d", $birthday);
    $birthday = ddxrxDBConnect()->real_escape_string($birthday);
    
    $username = $_POST['username'];
    $username = strtolower($username);
    $username = ddxrxDBConnect()->real_escape_string($username);
    
    $usernameRules = '/^[a-zA-Z0-9_\-\.\@\/]*$/';
    $username_status = preg_match($usernameRules, $username) ? true : false;

    $password = $_POST['password'];
    $password = $conn->real_escape_string($password);
    $password = password_hash($password, PASSWORD_BCRYPT);
    
    $gender = $_POST['gender'];
    $gender = ddxrxDBConnect()->real_escape_string($gender);
    
    $location = $_POST['location'];
    $location = ddxrxDBConnect()->real_escape_string($location);
    
    if( $gender == 'f' ){ $genderdefinition = 'her'; }else{ $genderdefinition = 'his'; }
    
    $email_address = $_POST['email_address'];
    $email_address = strtolower($email_address);
    $email_address = ddxrxDBConnect()->real_escape_string($email_address);
    
    $epic_id = $_POST['guid'];
    $epic_id = ddxrxDBConnect()->real_escape_string($epic_id);
    
    $active = 1;
    $created_at = date("Y-m-d H:i:s");
    
    $c_ck = $_POST['c_ck'];
    $c_ck = ddxrxDBConnect()->real_escape_string($c_ck);
    
    $user_id = rand(1000,9999999);

    $sql = "SELECT * FROM all_users where username = '$username'";
    $result = mysqli_query(ddxrxDBConnect(), $sql);
    $row = mysqli_fetch_assoc($result);
    
    if( !isset($row['username']) && $username_status === true){
        
        $sql = "INSERT INTO all_users(`userid`, `groupid`, `username`, `password_new`, `user_type`, `email_address`, `location_id`, `is_active`, `created_at`) values('".$user_id."','".$version."','".$username."', '".$password."', '3', '".$email_address."', '".$location_id."', '".$active."', '".$created_at."');";
        $sql .= "INSERT INTO patients(`groupid`, `location_id`, `user_id`, `patient_fname`, `mname`, `patient_lname`, `patient_dob`, `email_id`, `patient_gender`, `epic_id`, `active`, `created_at`, `cell`, `occupation`, `location`) values('".$version."','".$location_id."', '".$user_id."', '".$first_name."', '".$middle_name."', '".$last_name."', '".$birthday."', '".$email_address."', '".$gender."', '".$epic_id."', '".$active."', '".$created_at."', '".$phone_number."', '".$occupation."', '".$location."')";
        
        
        if (mysqli_multi_query($conn, $sql)) {
            
            $new_patient_id = mysqli_insert_id($conn);
            
            $status_code = '200';
            $status_description = 'Everything is OK';
            $msg = 'success';
            $user_id = $new_patient_id;
            
            $fullname = $first_name.' '.$middle_name.' '.$last_name;
            
            // Send email notifications
            email_notification( $fullname, $email_address );
            
            // Create new messages for nurse and patient
            message_nurse($new_patient_id);
            
            activityLog( 'User Registration', 'A new patient named '.$first_name.' '.$last_name.' signed up for an account. '.$genderdefinition.' <br>username is '.$username.' <br>Phone Number: '.$phone_number.' <br>Email Address: '.$email_address);
        } else {
            $status_code = '500';
            $status_description = $sql . mysqli_error(ddxrxDBConnect());
            $msg = 'fail';
        }

        // Close connection
        mysqli_close(ddxrxDBConnect());

    }else{
        
        $status_code = '400';
        $status_description = 'Oppss.. Something went wrong';
        $msg = 'fail';
        
    }
    
    if($status_code == '200'){
        $username = $_POST['username'];
        $username = strtolower($username);
        
        $password = $_POST['password'];
    
        $login_status = patient_login($con, $username, $password, '3');
        
        
        if($login_status['success'] == true){
            $status_description = 'Successfully create new patient and also loged in.';
        }else{
            $status_description = 'Successfully create new patient but login failed. Please contact support.';
        }
    }
    
    if( !isset($user_id) && $user_id != '' ){
        $user_id = '0';
    }
    
    $result = [
        'status_code' => $status_code,
        'status_description' => $status_description, 
        'msg' => $msg,
        'user_id' => $user_id
        ];
    
        echo json_encode( $result );
}

function patient_login($con, $user_name, $password, $user_type = '3'){
    
    $version = get_version();
    
	$admin_name = $user_name;
	$admin_name = ddxrxDBConnect()->real_escape_string($admin_name);
	
    $admin_pass = $password;
    $admin_pass = ddxrxDBConnect()->real_escape_string($admin_pass);
    
    $user_type = ddxrxDBConnect()->real_escape_string($user_type);
    
    $remember = '';  
    
    $admin_query = "SELECT * FROM `all_users` INNER JOIN `patients` on all_users.userid = patients.user_id WHERE all_users.username='".$admin_name."' AND all_users.password='".md5($admin_pass)."' AND all_users.user_type='".$user_type."' AND all_users.groupid='".$version."'";

	$run_query = mysqli_query($con, $admin_query);
	$count = mysqli_num_rows($run_query);
	$data = mysqli_fetch_array($run_query);
    
	if($count==1) {
	    
		$_SESSION['payment_userid'] = $data['userid'];
		$_SESSION['payment_username'] = $data['username'];
		$_SESSION['payment_logged_user'] = 'UserLoggedEddm';
		$_SESSION['payment_stripe_subscription_isactive'] = 0;
		$_SESSION['payment_user_type'] = 3;
		
		$_SESSION['payment_patient_fname'] = $data['patient_fname'];
		$_SESSION['payment_patient_mname'] = $data['patient_mname'];
		$_SESSION['payment_patient_lname'] = $data['patient_lname'];
		
		if($data['user_type'] == '3') {
		    
			$_SESSION['payment_user_type'] = "patient";
			$_SESSION['payment_userType'] = "patient";
			
			activityLog( 'patient logged in', 'Username: '.$admin_name.'<br>Email Address: '.$data['email_address']. '<br>Phone Number: '.$data['cell'] );
			
			return ["success" => true, "msg" => 'Login successfully!', "user_id" => $data['userid'], "userType" => $data['user_type'] ];
		} 
		
	} else {
	    
		return ["success" => true, "msg" => 'Login successfully!', "user_id" => $data['userid'], "userType" => $data['user_type'] ];
	}

    // Close connection
    mysqli_close($con);

}

?>