<?php
/**
 * PointClickCare Integration Configuration
 * 
 * This file contains all credentials, API endpoints, and configuration
 * settings for the PCC OAuth integration.
 * 
 * SECURITY NOTE: Never commit actual production credentials to version control.
 * Use environment variables or a separate config file for production.
 */

// Prevent direct access
if (!defined('PCC_CONFIG_LOADED')) {
    define('PCC_CONFIG_LOADED', true);
}

// ========================================
// ENVIRONMENT SETTINGS
// ========================================

// Set to 'sandbox' for testing or 'production' for live
define('PCC_ENVIRONMENT', 'production');

// ========================================
// OAUTH CREDENTIALS
// ========================================

// Production Credentials (DO NOT SHARE PUBLICLY)
define('PCC_CUSTOMER_KEY', 'qE9EzBzi0GN9zcFeHRNXSeEZHJcXkOjm');
define('PCC_CUSTOMER_SECRET', 'fb2bI6PjyvsorBhz');

// Sandbox Testing Credentials
define('PCC_SANDBOX_USERNAME', 'robdoc5796.uiaccess');
define('PCC_SANDBOX_PASSWORD', 'VXK5dyk-ctr_rzn1akg');
define('PCC_SANDBOX_ORG_CODE', 'robdoc5796');
define('PCC_SANDBOX_ORG_UUID', '7df45aeb-aed0-4e4f-807c-8183ee708e65');

// ========================================
// API ENDPOINTS
// ========================================

// PCC Login URL
define('PCC_LOGIN_URL', 'https://login.pointclickcare.com/home/userLogin.xhtml');

// OAuth Authorization Endpoint (from official PCC documentation)
define('PCC_AUTHORIZE_URL', 'https://connect.pointclickcare.com/auth/login');

// OAuth Token Exchange Endpoint (from official PCC documentation)
define('PCC_TOKEN_URL', 'https://connect.pointclickcare.com/auth/token');

// PCC API Base URL (from official PCC documentation)
define('PCC_API_BASE_URL', 'https://connect.pointclickcare.com/api/public/preview1');

// User Info Endpoint (from official PCC documentation)
// Note: Uses /userinfo endpoint with orgUuid parameter
define('PCC_USER_INFO_URL', PCC_API_BASE_URL . '/orgs/{orgUuid}/userinfo');

// Organization Info Endpoint
define('PCC_ORG_INFO_URL', PCC_API_BASE_URL . '/orgs/{orgId}');


// ========================================
// CALLBACK URLS
// ========================================

// Determine the base URL dynamically
$protocol = isset($_SERVER['HTTPS']) && $_SERVER['HTTPS'] === 'on' ? 'https' : 'http';
$host = isset($_SERVER['HTTP_HOST']) ? $_SERVER['HTTP_HOST'] : 'localhost';
$base_url = $protocol . '://' . $host;

// OAuth Callback URL (where PCC redirects after authorization)
define('PCC_OAUTH_CALLBACK_URL', $base_url . '/pcc-app/oauth-callback.php');

// Success Redirect URL (where users go after successful login)
define('PCC_SUCCESS_REDIRECT_URL', $base_url . '/default.php');

// ========================================
// DATABASE SETTINGS
// ========================================

// Load main config if not already loaded
if (!defined('db_host')) {
    require_once(dirname(__FILE__) . '/../config.php');
}

// Database connection parameters (using existing DDxRx settings)
define('PCC_DB_HOST', defined('db_host') ? db_host : 'localhost');
define('PCC_DB_USERNAME', defined('db_user') ? db_user : 'root');
define('PCC_DB_PASSWORD', defined('db_pass') ? db_pass : '');
define('PCC_DB_NAME', defined('db_name') ? db_name : 'telemedicine');

// Default group ID for new users (as per instructions)
define('PCC_DEFAULT_GROUP_ID', '100001');

// Default location ID for new users
define('PCC_DEFAULT_LOCATION_ID', '1');

// ========================================
// PCC ROLE MAPPING
// ========================================

/**
 * Map PCC roles to DDxRx user types
 * 
 * DDxRx UserTypes:
 * 0 = Super Admin
 * 1 = Administrator
 * 2 = Physician
 * 3 = Patient
 * 4 = Nurse
 */
$PCC_ROLE_MAPPING = array(
    // Physicians
    'physician' => '2',
    'therapist' => '2',
    'dietician' => '2',
    
    // Nurses
    'registerednurse' => '4',
    'nursingassistant' => '4',
    'dirofnursing' => '4',
    'medadmin' => '4',
    
    // Administrators
    'facilitymanager' => '1',
    'itadmin' => '1',
    'intakecoordinator' => '1',
    'recmanager' => '1',
    'systemuser' => '1',
    
    // Patients/Test Users
    'testuser' => '3',
    
    // Default fallback (if role not found)
    'default' => '3'
);

// Make role mapping available globally
define('PCC_ROLE_MAPPING', serialize($PCC_ROLE_MAPPING));

// ========================================
// LOGGING SETTINGS
// ========================================

// Enable/disable logging
define('PCC_ENABLE_LOGGING', true);

// Log file path
define('PCC_LOG_FILE', __DIR__ . '/logs/pcc-integration.log');

// Log level (DEBUG, INFO, WARNING, ERROR)
define('PCC_LOG_LEVEL', 'DEBUG');

// ========================================
// SECURITY SETTINGS
// ========================================

// Session timeout (in seconds) - 2 hours
define('PCC_SESSION_TIMEOUT', 7200);

// Enable CSRF protection
define('PCC_ENABLE_CSRF', true);

// Password generation settings for new users
define('PCC_PASSWORD_LENGTH', 32);

// ========================================
// ORGANIZATION DETAILS
// ========================================

// Organization UUID (leave blank if not set, will be populated later)
define('PCC_ORG_UUID', '');

// Organization Name
define('PCC_ORG_NAME', '');

// ========================================
// HELPER FUNCTIONS
// ========================================

/**
 * Get PCC role mapping array
 * 
 * @return array Role mapping
 */
function pcc_get_role_mapping() {
    return unserialize(PCC_ROLE_MAPPING);
}

/**
 * Log a message to the PCC integration log file
 * 
 * @param string $message Log message
 * @param string $level Log level (DEBUG, INFO, WARNING, ERROR)
 * @return bool Success status
 */
function pcc_log($message, $level = 'INFO') {
    if (!PCC_ENABLE_LOGGING) {
        return false;
    }
    
    // Check if log directory exists
    $log_dir = dirname(PCC_LOG_FILE);
    if (!file_exists($log_dir)) {
        mkdir($log_dir, 0755, true);
    }
    
    $timestamp = date('Y-m-d H:i:s');
    $log_entry = "[{$timestamp}] [{$level}] {$message}" . PHP_EOL;
    
    return file_put_contents(PCC_LOG_FILE, $log_entry, FILE_APPEND) !== false;
}

/**
 * Get database connection for PCC integration
 * 
 * @return mysqli Database connection
 */
function pcc_db_connect() {
    $con = mysqli_connect(PCC_DB_HOST, PCC_DB_USERNAME, PCC_DB_PASSWORD, PCC_DB_NAME);
    
    if (!$con) {
        pcc_log('Database connection failed: ' . mysqli_connect_error(), 'ERROR');
        return false;
    }
    
    return $con;
}

/**
 * Generate a secure random password
 * 
 * @param int $length Password length
 * @return string Generated password
 */
function pcc_generate_password($length = 32) {
    $chars = 'abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789!@#$%^&*()';
    $password = '';
    $chars_length = strlen($chars);
    
    for ($i = 0; $i < $length; $i++) {
        $password .= $chars[rand(0, $chars_length - 1)];
    }
    
    return $password;
}

// ========================================
// INITIALIZATION
// ========================================

// Start session if not already started
if (session_status() == PHP_SESSION_NONE) {
    session_start();
}

// Log configuration load
pcc_log('PCC configuration loaded successfully', 'INFO');

?>
