<?php
/**
 * PCC Configuration Verification Script
 * Verifies that all OAuth and API endpoints are correctly configured
 */

require_once('pcc-config.php');

echo "<h2>PCC OAuth Configuration Verification</h2>\n";
echo "<p><strong>Environment:</strong> " . PCC_ENVIRONMENT . "</p>\n";

echo "<h3>OAuth Endpoints</h3>\n";
echo "<p><strong>Authorization URL:</strong> " . PCC_AUTHORIZE_URL . "</p>\n";
echo "<p><strong>Token URL:</strong> " . PCC_TOKEN_URL . "</p>\n";

echo "<h3>API Endpoints</h3>\n";
echo "<p><strong>API Base URL:</strong> " . PCC_API_BASE_URL . "</p>\n";
echo "<p><strong>User Info URL:</strong> " . PCC_USER_INFO_URL . "</p>\n";

echo "<h3>OAuth Configuration</h3>\n";
echo "<p><strong>Customer Key:</strong> " . substr(PCC_CUSTOMER_KEY, 0, 8) . "...</p>\n";
echo "<p><strong>Customer Secret:</strong> " . substr(PCC_CUSTOMER_SECRET, 0, 8) . "...</p>\n";

echo "<h3>Callback URLs</h3>\n";
echo "<p><strong>OAuth Callback:</strong> " . PCC_OAUTH_CALLBACK_URL . "</p>\n";
echo "<p><strong>Success Redirect:</strong> " . PCC_SUCCESS_REDIRECT_URL . "</p>\n";

echo "<h3>Database Configuration</h3>\n";
echo "<p><strong>Host:</strong> " . PCC_DB_HOST . "</p>\n";
echo "<p><strong>Username:</strong> " . PCC_DB_USERNAME . "</p>\n";
echo "<p><strong>Database:</strong> " . PCC_DB_NAME . "</p>\n";

echo "<h3>Test OAuth Initiation URL</h3>\n";
$test_state = 'test_' . uniqid();
$auth_params = array(
    'response_type' => 'code',
    'client_id' => PCC_CUSTOMER_KEY,
    'redirect_uri' => PCC_OAUTH_CALLBACK_URL,
    'state' => $test_state,
    'scope' => 'openid'
);
$test_url = PCC_AUTHORIZE_URL . '?' . http_build_query($auth_params);
echo "<p><strong>Full OAuth URL:</strong></p>\n";
echo "<p><code>" . htmlspecialchars($test_url) . "</code></p>\n";

echo "<h3>Configuration Status</h3>\n";
$issues = array();

// Check if URLs are accessible (basic format check)
if (!filter_var(PCC_AUTHORIZE_URL, FILTER_VALIDATE_URL)) {
    $issues[] = "Invalid Authorization URL format";
}
if (!filter_var(PCC_TOKEN_URL, FILTER_VALIDATE_URL)) {
    $issues[] = "Invalid Token URL format";
}
if (!filter_var(PCC_API_BASE_URL, FILTER_VALIDATE_URL)) {
    $issues[] = "Invalid API Base URL format";
}

// Check required constants
if (empty(PCC_CUSTOMER_KEY)) {
    $issues[] = "Customer Key is empty";
}
if (empty(PCC_CUSTOMER_SECRET)) {
    $issues[] = "Customer Secret is empty";
}

if (empty($issues)) {
    echo "<p style='color: green;'><strong>✓ Configuration appears valid</strong></p>\n";
} else {
    echo "<p style='color: red;'><strong>✗ Configuration issues found:</strong></p>\n";
    echo "<ul>\n";
    foreach ($issues as $issue) {
        echo "<li>" . htmlspecialchars($issue) . "</li>\n";
    }
    echo "</ul>\n";
}

echo "<h3>Corrected Endpoints (Based on Official Documentation)</h3>\n";
echo "<p>✓ Authorization: https://connect.pointclickcare.com/auth/login</p>\n";
echo "<p>✓ Token: https://connect.pointclickcare.com/auth/token</p>\n";
echo "<p>✓ API Base: https://connect.pointclickcare.com/api/public/preview1</p>\n";
echo "<p>✓ UserInfo: https://connect.pointclickcare.com/api/public/preview1/orgs/{orgUuid}/userinfo</p>\n";

?>