<?php

    // Start the session
    session_start();
    
    // Check if the session has expired and correct user type
    if(!isset($_SESSION['userid']) || !isset($_SESSION['userType'])) {
        header("Location: logout.php");
        die();
    }
    // elseif ($_SESSION['userType'] == 'patient') {
    //     header("Location: logout.php");
    //     die();
    // } elseif ($_SESSION['userType'] != 'nurse' && $_SESSION['userType'] != 'doctor') {
    //     header("Location: logout.php");
    //     die();
    // }
    
    // Include the functions file
    include('process/functions.php');

    $conn = ddxrxDBConnect();
    
    function parseHTMLPreview($content, $savedData = null) {
        $lines = explode("<br />", $content);
        $output = '';
        $counter = 0;

        // Prepare saved values if valid JSON
        $savedValues = array();
        if ($savedData !== null && is_string($savedData)) {
            $json = json_decode($savedData, true);
            if (json_last_error() === JSON_ERROR_NONE && is_array($json)) {
                foreach ($json as $item) {
                    if (isset($item['name'])) {
                        $savedValues[$item['name']] = $item;
                    }
                }
            }
        }

        // First pass: identify which sections have content
        $sectionsWithContent = array();
        $tempCounter = 0;
        $currentHeading = '';
        $currentSection = '';
        
        foreach ($lines as $line) {
            $line = trim($line);
            if ($line === '' || preg_match('/^(##)+$/', $line) || preg_match('/^(\*\*)+$/', $line)) {
                continue;
            }
            
            $lineStripped = strip_tags($line);
            
            if (strpos($lineStripped, '##') === 0) {
                $currentHeading = trim(str_replace('##', '', $lineStripped));
                $currentSection = '';
            }
            elseif (strpos($lineStripped, '**') === 0) {
                $currentSection = trim(str_replace('**', '', $lineStripped));
            }
            elseif (strpos($line, '()') !== false) {
                $inputName = 'text_' . $tempCounter;
                if (isset($savedValues[$inputName]) && $savedValues[$inputName]['type'] === 'text' && !empty($savedValues[$inputName]['value'])) {
                    if ($currentSection !== '') {
                        $sectionsWithContent[$currentHeading][$currentSection] = true;
                    } else {
                        $sectionsWithContent[$currentHeading]['_no_section_'] = true;
                    }
                }
                $tempCounter++;
            }
            else {
                $inputName = 'cb_' . $tempCounter;
                if (isset($savedValues[$inputName]) && $savedValues[$inputName]['type'] === 'checkbox' && $savedValues[$inputName]['value'] === 'on') {
                    if ($currentSection !== '') {
                        $sectionsWithContent[$currentHeading][$currentSection] = true;
                    } else {
                        $sectionsWithContent[$currentHeading]['_no_section_'] = true;
                    }
                }
                $tempCounter++;
            }
        }

        // Second pass: output only sections that have content
        $currentHeading = '';
        $currentSection = '';
        $headingOutput = false;
        $sectionOutput = false;
        
        foreach ($lines as $line) {
            $line = trim($line);
            if ($line === '' || preg_match('/^(##)+$/', $line) || preg_match('/^(\*\*)+$/', $line)) {
                continue;
            }
            
            $lineStripped = strip_tags($line);
            
            if (strpos($lineStripped, '##') === 0) {
                $currentHeading = trim(str_replace('##', '', $lineStripped));
                $currentSection = '';
                $headingOutput = false;
                $sectionOutput = false;
            }
            elseif (strpos($lineStripped, '**') === 0) {
                $currentSection = trim(str_replace('**', '', $lineStripped));
                $sectionOutput = false;
            }
            elseif (strpos($line, '()') !== false) {
                $parts = explode('()', $line);
                $before = isset($parts[0]) ? trim(strip_tags($parts[0])) : '';
                $after = isset($parts[1]) ? trim(strip_tags($parts[1])) : '';
                $inputName = 'text_' . $counter;
                
                if (isset($savedValues[$inputName]) && $savedValues[$inputName]['type'] === 'text' && !empty($savedValues[$inputName]['value'])) {
                    // Check if this content should be shown (either in a section or directly under heading)
                    $shouldShow = false;
                    if ($currentSection !== '') {
                        $shouldShow = isset($sectionsWithContent[$currentHeading][$currentSection]);
                    } else {
                        $shouldShow = isset($sectionsWithContent[$currentHeading]['_no_section_']);
                    }
                    
                    if ($shouldShow) {
                        // Output heading if not already output and has content
                        if (!$headingOutput && $currentHeading !== '' && isset($sectionsWithContent[$currentHeading])) {
                            $output .= '<h2>' . $currentHeading . '</h2>';
                            $headingOutput = true;
                        }
                        // Output section if not already output and we have a section with content
                        if (!$sectionOutput && $currentSection !== '' && isset($sectionsWithContent[$currentHeading][$currentSection])) {
                            $output .= '<div class="form-section">' . $currentSection . ':</div>';
                            $sectionOutput = true;
                        }
                        
                        $inputValue = htmlspecialchars($savedValues[$inputName]['value'], ENT_QUOTES);
                        $cleanedBefore = preg_replace('/\[[^\]]*\]/', '', $before, 1);
                        $output .= '<div class="item-view"><span class="material-symbols-outlined"> fiber_manual_record </span>' . $cleanedBefore . ': ' . $inputValue . ($after ? ' ' . $after : '') . '</div>';
                    }
                }
                $counter++;
            }
            else {
                $inputName = 'cb_' . $counter;
                
                if (isset($savedValues[$inputName]) && $savedValues[$inputName]['type'] === 'checkbox' && $savedValues[$inputName]['value'] === 'on') {
                    // Check if this content should be shown (either in a section or directly under heading)
                    $shouldShow = false;
                    if ($currentSection !== '') {
                        $shouldShow = isset($sectionsWithContent[$currentHeading][$currentSection]);
                    } else {
                        $shouldShow = isset($sectionsWithContent[$currentHeading]['_no_section_']);
                    }
                    
                    if ($shouldShow) {
                        // Output heading if not already output and has content
                        if (!$headingOutput && $currentHeading !== '' && isset($sectionsWithContent[$currentHeading])) {
                            $output .= '<h2>' . $currentHeading . '</h2>';
                            $headingOutput = true;
                        }
                        // Output section if not already output and we have a section with content
                        if (!$sectionOutput && $currentSection !== '' && isset($sectionsWithContent[$currentHeading][$currentSection])) {
                            $output .= '<div class="form-section">' . $currentSection . ':</div>';
                            $sectionOutput = true;
                        }
                        
                        $cleanedLine = preg_replace('/\[[^\]]*\]/', '', $line, 1);
                        $cleanedLine = preg_replace('/\s+/', ' ', trim($cleanedLine));
                        $output .= '<div class="item-view"><span class="material-symbols-outlined"> fiber_manual_record </span> ' . $cleanedLine . '</div>';
                    }
                }
                $counter++;
            }
        }

        return $output;
    }

    /* ----------------------------------------------------------------------- */
    // GET PATIENT AND WAITING ROOM DATA
    /* ----------------------------------------------------------------------- */
    if (isset($_GET['waiting_room_id'])) {

        // Validate the waiting_room_id parameter
        $waiting_room_id = intval($_GET['waiting_room_id']);

        // Prepare SQL to join waiting_room and patients tables
        $sql = "SELECT wr.*, p.* 
                FROM waiting_room wr
                JOIN patients p ON wr.patient_id = p.patient_id
                WHERE wr.waitingroom_id = ?";

        if ($stmt = $conn->prepare($sql)) {
            $stmt->bind_param("i", $waiting_room_id);
            $stmt->execute();
            $result = $stmt->get_result();
            $stmt->close();
        }

        // Prepare SQL to join waiting_room and decision_supports tables
        if ($row = $result->fetch_assoc()) {

            if( !empty($row['diagnosis_id']) ){
                $diagnosis_id = $row['diagnosis_id'];

                $diagnosis_id = json_decode($diagnosis_id);

                // Check if json_decode was successful and array is not empty
                if (is_array($diagnosis_id) && !empty($diagnosis_id)) {
                    $diagnosis_ids = implode(',', array_map('intval', $diagnosis_id));
                    $sql = "SELECT * FROM `decision_supports` WHERE `differential_diagnose_id` IN ($diagnosis_ids)";

                    if ($stmt = $conn->prepare($sql)) {
                        $stmt->execute();
                        $result_decision_supports = $stmt->get_result();
                        $stmt->close();
                    }
                } else {
                    // Initialize empty result if no valid diagnosis IDs
                    $result_decision_supports = null;
                }
            } else {
                // Initialize empty result if diagnosis_id is empty
                $result_decision_supports = null;
            }

        } else {
            // Initialize empty result if no waiting room data found
            $result_decision_supports = null;
            $row = array(); // Initialize empty row to prevent undefined variable errors
        }

    }

    /* ----------------------------------------------------------------------- */
    // CHIEF COMPLAINT LIST
    /* ----------------------------------------------------------------------- */
    $chief_complaints = '';
    if (!isset($row['chief_complaints']) || trim($row['chief_complaints']) === '') {
        $chief_complaints = '<i>Chief complaint is not available.</i>';
    } else {
        $chief_complaints_list = array_filter(array_map('trim', explode(';', $row['chief_complaints'])));
        if (empty($chief_complaints_list)) {
            $chief_complaints = '<div class="no-chief-complaint">Chief complaint is not available.</div>';
        } else {
            $chief_complaints = '<ul>';
            foreach ($chief_complaints_list as $complaint) {
                if (!empty($complaint)) {
                    $chief_complaints .= '<li><span class="material-symbols-outlined"> check_small </span>' . htmlspecialchars($complaint) . '</li>';
                }
            }
            $chief_complaints .= '</ul>';
        }
    }

    /* ----------------------------------------------------------------------- */
    // HISTORY OF PRESENT ILLNESS
    /* ----------------------------------------------------------------------- */
    $history_of_present_illness = '';
    if (!isset($row['chief_complaints']) || trim($row['chief_complaints']) === '') {
        $history_of_present_illness = '<i>History of present illness is not available.</i>';
    } else {
        $complaints_list = array_filter(array_map('trim', explode(';', $row['chief_complaints'])));
        $complaints_count = count($complaints_list);
        if ($complaints_count === 0) {
            $history_of_present_illness = '<i>History of present illness is not available.</i>';
        } elseif ($complaints_count === 1) {
            $history_of_present_illness = 'Patient presented with <u>' . htmlspecialchars($complaints_list[0]) . '</u>';
        } else {
            $last = array_pop($complaints_list);
            $underlined_items = array();
            foreach ($complaints_list as $item) {
                $underlined_items[] = '<u>' . htmlspecialchars($item) . '</u>';
            }
            $history_of_present_illness = 'Patient presented with ' . implode(', ', $underlined_items) . ' and <u>' . htmlspecialchars($last) . '</u>';
        }
    }

    /* ----------------------------------------------------------------------- */
    // POSITIVE SYMPTOMS
    /* ----------------------------------------------------------------------- */
    $having_symptoms = '';

    if (!empty($row['answers_per_diagnosis'])) {
        $answers_per_diagnosis = json_decode($row['answers_per_diagnosis'], true);
        
        if (is_array($answers_per_diagnosis)) {
            foreach ($answers_per_diagnosis as $diagnosis_id => $symptoms_data) {
                // Get diagnosis name from database
                $sql = "SELECT name FROM `differential_diagnoses` WHERE id = ?";
                if ($stmt = $conn->prepare($sql)) {
                    $stmt->bind_param("i", $diagnosis_id);
                    $stmt->execute();
                    $result_diagnosis = $stmt->get_result();
                    $diagnosis_row = $result_diagnosis->fetch_assoc();
                    $stmt->close();
                    
                    if ($diagnosis_row) {
                        $diagnosis_name = $diagnosis_row['name'];
                        $css_class = strtolower(str_replace(' ', '-', $diagnosis_name));
                        
                        // Process positive symptoms
                        if (isset($symptoms_data['positives']) && is_array($symptoms_data['positives'])) {
                            $positive_symptoms = array_filter(array_map('trim', $symptoms_data['positives']), function($item) {
                                return !empty($item);
                            });
                            
                            if (!empty($positive_symptoms)) {
                                $symptoms_count = count($positive_symptoms);
                                $symptoms_text = '';
                                
                                if ($symptoms_count === 1) {
                                    $symptoms_text = 'Patient complained of having <u>' . htmlspecialchars($positive_symptoms[0]) . '</u>';
                                } else {
                                    $positive_symptoms = array_values($positive_symptoms); // Re-index array
                                    $last = array_pop($positive_symptoms);
                                    $underlined_items = array();
                                    foreach ($positive_symptoms as $item) {
                                        $underlined_items[] = '<u>' . htmlspecialchars($item) . '</u>';
                                    }
                                    $symptoms_text = 'Patient complained of having ' . implode(', ', $underlined_items) . ' and <u>' . htmlspecialchars($last) . '</u>';
                                }
                                
                                $having_symptoms .= '
                                <div class="decision-group smt diagnosis-' . $css_class . '">
                                    <h1 class="dd-title small"><span class="material-symbols-outlined"> arrow_right </span>' . htmlspecialchars($diagnosis_name) . ':</h1>
                                    ' . $symptoms_text . '
                                </div>';
                            }
                        }
                    }
                }
            }
        }
    }
    
    if (empty($having_symptoms)) {
        $having_symptoms = '<i>Positive symptoms are not available.</i>';
    }



    /* ----------------------------------------------------------------------- */
    // NEGATIVE SYMPTOMS
    /* ----------------------------------------------------------------------- */
    $negative_symptoms = '';
    
    // Extract negative symptoms from all diagnosis IDs in answers_per_diagnosis JSON
    $all_negative_symptoms = array();
    
    if (!empty($row['answers_per_diagnosis'])) {
        $answers_per_diagnosis = json_decode($row['answers_per_diagnosis'], true);
        
        if (is_array($answers_per_diagnosis)) {
            foreach ($answers_per_diagnosis as $diagnosis_id => $symptoms_data) {
                if (isset($symptoms_data['negatives']) && is_array($symptoms_data['negatives'])) {
                    $negatives = $symptoms_data['negatives'];
                    // Filter out empty strings and trim whitespace
                    $filtered_negatives = array_filter(array_map('trim', $negatives), function($item) {
                        return !empty($item);
                    });
                    $all_negative_symptoms = array_merge($all_negative_symptoms, $filtered_negatives);
                }
            }
        }
    }
    
    // Remove duplicates and format the output
    $all_negative_symptoms = array_unique($all_negative_symptoms);
    $not_having_count = count($all_negative_symptoms);
    
    if ($not_having_count === 0) {
        $negative_symptoms = '<i>Negative symptoms are not available.</i>';
    } elseif ($not_having_count === 1) {
        $negative_symptoms = 'Patient denied having: <u>' . htmlspecialchars($all_negative_symptoms[0]) . '</u>';
    } else {
        $all_negative_symptoms = array_values($all_negative_symptoms); // Re-index array
        $last = array_pop($all_negative_symptoms);
        $underlined_items = array();
        foreach ($all_negative_symptoms as $item) {
            $underlined_items[] = '<u>' . htmlspecialchars($item) . '</u>';
        }
        $negative_symptoms = 'Patient denied having: ' . implode(', ', $underlined_items) . ' and <u>' . htmlspecialchars($last) . '</u>';
    }

    /* ----------------------------------------------------------------------- */
    // ADDITIONAL INFORMATION
    /* ----------------------------------------------------------------------- */
    $additional_information_value = '';
    $additional_information_output = '';
    if (!empty($row['saved_input'])) {
        $saved_inputs = json_decode($row['saved_input'], true);
        if (is_array($saved_inputs)) {
            foreach ($saved_inputs as $input) {
                if (isset($input['name']) && $input['name'] === 'additional_information') {
                    $additional_information_value = $input['value'];

                    $additional_information_output = '
                        <div class="decision-group smt additional-information">
                            <h1 class="dd-title small">Additional Information</h1>
                            <div class="item">
                                <label style="width: 100%;">
                                    <textarea name="additional_information" placeholder="Enter any additional information or notes here..." disabled>'.$additional_information_value.'</textarea>
                                </label>
                            </div>
                        </div>
                    ';

                    break;
                }
            }
        }
    }

    /* ----------------------------------------------------------------------- */
    // PYSICAL EXAM
    /* ----------------------------------------------------------------------- */
    $physical_exam = '';
    $physical_exam_output = '';
    if (!empty($row['saved_input'])) {
        $saved_inputs = json_decode($row['saved_input'], true);
        if (is_array($saved_inputs)) {
            foreach ($saved_inputs as $input) {
                if (isset($input['name']) && $input['name'] === 'physical_exam') {
                    $physical_exam = $input['value'];

                    $physical_exam_output = '
                        <div class="decision-group smt physical-exam">
                            <h1 class="dd-title small">Physical Exam</h1>
                            <div class="item">
                                <label style="width: 100%;">
                                    <textarea name="physical_exam" placeholder="Enter physical exam findings here..." disabled>'.$physical_exam.'</textarea>
                                </label>
                            </div>
                        </div>
                    ';

                    break;
                }
            }
        }
    }

    /* ----------------------------------------------------------------------- */
    // ADDITIONAL TREATMENT
    /* ----------------------------------------------------------------------- */
    $additional_treatment_value = '';
    $additional_treatment_output = '';
    if (!empty($row['saved_input'])) {
        $saved_inputs = json_decode($row['saved_input'], true);
        if (is_array($saved_inputs)) {
            foreach ($saved_inputs as $input) {
                if (isset($input['name']) && $input['name'] === 'additional_treatment') {
                    $additional_treatment_value = $input['value'];

                    $additional_treatment_output = '
                        <div class="decision-group smt additional-treatment">
                            <h1 class="dd-title small">Additional Treatment</h1>
                            <div class="item">
                                <label style="width: 100%;">
                                    <textarea name="additional_treatment" placeholder="Enter any additional treatment here..." disabled>'.$additional_treatment_value.'</textarea>
                                </label>
                            </div>
                        </div>
                    ';

                    break;
                }
            }
        }
    }

    $addendum_value = '';
    $addendum_date = '';
    $addendum_output = '';
    $addendum_found = false;
    
    if (!empty($row['saved_input'])) {
        $saved_inputs = json_decode($row['saved_input'], true);
        if (is_array($saved_inputs)) {
            foreach ($saved_inputs as $input) {
                if (isset($input['name']) && $input['name'] === 'addendum_text') {
                    $addendum_value = $input['value'];
                    $addendum_date = isset($input['date']) ? $input['date'] : '';
                    $addendum_found = true;
                    break;
                }
            }
        }
    }

    // Show the addendum section - either as saved content or as editable form
    if ($addendum_found && !empty($addendum_value)) {
        // Format the date for display
        $formatted_date = '';
        if (!empty($addendum_date)) {
            $formatted_date = '<div class="addendum-date"><small><em>Added on: ' . date('F j, Y \a\t g:i A', strtotime($addendum_date)) . '</em></small></div>';
        }
        
        // Show saved addendum content
        $addendum_output = '
            <div class="decision-group smt addendum">
                <h1 class="dd-title small">Addendum</h1>
                ' . $formatted_date . '
                <div class="item-view">
                    <span class="material-symbols-outlined"> fiber_manual_record </span>
                    ' . htmlspecialchars($addendum_value) . '
                </div>
            </div>
        ';
    } else {

        if( $_SESSION['userType'] == 'doctor' ){

            // Addendum version for physicians
            $addendum_output = '
                <div class="decision-group smt addendum">
                    <h1 class="dd-title small">Addendum</h1>
                    <p>Use this section to record any additional information or changes made after the original note was signed.</p>
                    <div class="item">
                        <label style="width: 100%;">
                            <textarea name="addendum_text" class="addendum_text" placeholder="Enter any additional information or changes made after the original note was signed...">'.$addendum_value.'</textarea>
                        </label>
                    </div>
                </div>

                <button type="submit" class="btn btn-primary save-addendum">Save Addendum</button>
            ';

        }elseif( $_SESSION['userType'] == 'nurse' ){
            
            // Addendum version for nurses
            $addendum_output = '
                <div class="decision-group smt addendum">
                    <h1 class="dd-title small">Addendum</h1>
                    <p>Use this section to record any additional information or changes made after the original note was signed.</p>
                    <div class="item">
                        <label style="width: 100%;">
                            <textarea name="addendum_text" class="addendum_text" placeholder="Enter any additional information or changes made after the original note was signed..." disabled>'.$addendum_value.'</textarea>
                        </label>
                    </div>
                </div>

                <div class="warning-notice"><span class="material-symbols-outlined">warning</span> <p>Addendum feature is only available for physicians</p></div>
                <button type="submit" class="btn btn-primary save-addendum" disabled>Save Addendum</button>
            ';

        }else{

            // Default case if user type is neither doctor nor nurse
            $addendum_output = '';

        }

    }

    /* ----------------------------------------------------------------------- */
    // ALL VITALS REVIEWED
    /* ----------------------------------------------------------------------- */
    $all_vitals_reviewed = '';
    if (!empty($row['saved_input'])) {
        $saved_inputs = json_decode($row['saved_input'], true);
        if (is_array($saved_inputs)) {
            foreach ($saved_inputs as $input) {
                if (isset($input['name']) && $input['name'] === 'all_vitals_reviewed') {
                    if ($input['value'] == true) {
                        $all_vitals_reviewed = '<div class="item"><label><span class="material-symbols-outlined"> check </span> <span>All vitals were reviewed and was found negative except the above in HPI.</span></label></div>';
                    } else {
                        $all_vitals_reviewed = '<div class="item"><label><span class="material-symbols-outlined"> close </span> <span>All vitals were reviewed and was found negative except the above in HPI.</span></label></div>';
                    }
                    break;
                }else{
                    $all_vitals_reviewed = '<div class="item"><label><span class="material-symbols-outlined"> close </span> <span>All vitals were reviewed and was found negative except the above in HPI.</span></label></div>';
                }
            }
        }
    }else{
        // Default case if saved_input is empty or not set
        $all_vitals_reviewed = '<div class="item"><label><span class="material-symbols-outlined"> check </span> <span>All vitals were reviewed and was found negative except the above in HPI.</span></label></div>';
    }

    /* ----------------------------------------------------------------------- */
    // ALL SYSTEMS REVIEWED
    /* ----------------------------------------------------------------------- */
    $all_system_reviewed = '';
    if (!empty($row['saved_input'])) {
        $saved_inputs = json_decode($row['saved_input'], true);
        if (is_array($saved_inputs)) {
            foreach ($saved_inputs as $input) {
                if (isset($input['name']) && $input['name'] === 'all_system_reviewed') {
                    if ($input['value'] == true) {
                        $all_system_reviewed = '<div class="item"><label><span class="material-symbols-outlined"> check </span> <span>All systems were reviewed and was found negative except the above in HPI.</span></label></div>';
                    } else {
                        $all_system_reviewed = '<div class="item"><label><span class="material-symbols-outlined"> close </span> <span>All systems were reviewed and was found negative except the above in HPI.</span></label></div>';
                    }
                    break;
                }else{
                    $all_system_reviewed = '<div class="item"><label><span class="material-symbols-outlined"> close </span> <span>All systems were reviewed and was found negative except the above in HPI.</span></label></div>';
                }
            }
        }
    }else{
        // Default case if saved_input is empty or not set
        $all_system_reviewed = '<div class="item"><label><span class="material-symbols-outlined"> check </span> <span>All systems were reviewed and was found negative except the above in HPI.</span></label></div>';
    }

    /* ----------------------------------------------------------------------- */
    // FAILED DIAGNOSIS
    /* ----------------------------------------------------------------------- */
    $failed_diagnosis = '';
    if (!empty($row['failed_diagnosis_id']) && $row['failed_diagnosis_id'] !== 'null') {
        $failed_diagnosis_array = json_decode($row['failed_diagnosis_id'], true);
        if (is_array($failed_diagnosis_array) && !empty($failed_diagnosis_array)) {
            $failed_diagnosis_ids = implode(',', array_map('intval', $failed_diagnosis_array));
            $sql = "SELECT name FROM `differential_diagnoses` WHERE id IN ($failed_diagnosis_ids)";
            
            if ($stmt = $conn->prepare($sql)) {
                $stmt->execute();
                $result = $stmt->get_result();
                $stmt->close();
                
                $failed_diagnosis_list = array();
                while ($row_failed = $result->fetch_assoc()) {
                    $failed_diagnosis_list[] = '<u>' . htmlspecialchars($row_failed['name']) . '</u>';
                }
                
                $failed_diagnosis_count = count($failed_diagnosis_list);
                if ($failed_diagnosis_count === 0) {
                    $failed_diagnosis_output = '';
                } elseif ($failed_diagnosis_count === 1) {
                    $failed_diagnosis = 'Patient less likely to have: ' . $failed_diagnosis_list[0];
                } else {
                    $last = array_pop($failed_diagnosis_list);
                    $failed_diagnosis = '
                        <div class="decision-group smt failed-diagnosis">
                            <h1 class="dd-title small"><span class="material-symbols-outlined warning">warning</span>Failed Diagnosis:</h1>
                            Patient less likely to have: ' . implode(', ', $failed_diagnosis_list) . ' and ' . $last.'
                        </div>';
                }
            }
        }
    }

    /* ----------------------------------------------------------------------- */
    // BASIC NOTE INFORMATION
    /* ----------------------------------------------------------------------- */
    $basicNoteInfo = '
        <div class="decision-group smt chief-complaint">
            <h1 class="dd-title">Chief Complaint:</h1>
            '.$chief_complaints.'
        </div>

        <div class="decision-group smt present-illness">
            <h1 class="dd-title">History of present illness:</h1>
            '.$history_of_present_illness.'
        </div>

        '.$having_symptoms.'

        '.$failed_diagnosis.'

        '.$additional_information_output.'

        <div class="decision-group smt review-of-system">
            <h1 class="dd-title small">Review of System:</h1>
            '.$all_system_reviewed.'
            '.$negative_symptoms.'
        </div>

        <div class="decision-group smt review-of-vitals">
            <h1 class="dd-title small">Vitals:</h1>
            '.$all_vitals_reviewed.'
        </div>

        '.$physical_exam_output.'

    ';

    /* ----------------------------------------------------------------------- */
    // AFTER THE NOTES OR FOOTER
    /* ----------------------------------------------------------------------- */
    $afterNote = $additional_treatment_output.$addendum_output;

    /* ----------------------------------------------------------------------- */
    // DECISION SUPPORT NOTES
    /* ----------------------------------------------------------------------- */
    $decisionSupportNotes = '';
    if( !empty($row['diagnosis_id']) && isset($result_decision_supports) && $result_decision_supports !== null ){

        while ($decision_row = $result_decision_supports->fetch_assoc()) {
            $decisionTitle = '<h1 class="dd-title">'.$decision_row['differential_diagnose'].'</h1>';
            $decisionSupportNotes .= '
                <div class="decision-group">'
                    .$decisionTitle.parseHTMLPreview($decision_row['decisions_edited'], $row['saved_input']).
                '</div>
            ';
        }

    } else {
        $decisionSupportNotes = 'Diagnosis not found.';
    }

    /* ----------------------------------------------------------------------- */
    // CHECK IF WAITING ROOM ITEM IS SIGNED(ONLY FOR NURSE OR DOCTOR)
    // If signed, redirect to view page
    // If not signed, show the note page
    /* ----------------------------------------------------------------------- */
    if( $_SESSION['userType'] == 'nurse' || $_SESSION['userType'] == 'doctor' ){

        if (isset($row['signed']) && $row['signed'] == "0") {
            // Encounter is already signed - redirect to view page
            header("Location: encounter-notes.php?waiting_room_id=" . $_GET['waiting_room_id']);
            exit();
        }

    }

?>
<html>
    <head><meta http-equiv="Content-Type" content="text/html; charset=utf-8">
        
        <meta name="viewport" content="width=device-width, initial-scale=1">
        
        <title>Encounter Notes</title>
        
        <link rel="stylesheet" href="https://maxcdn.bootstrapcdn.com/bootstrap/3.3.7/css/bootstrap.min.css">
        <link rel="stylesheet" href="https://fonts.googleapis.com/css2?family=Material+Symbols+Outlined:opsz,wght,FILL,GRAD@20..48,100..700,0..1,-50..200">
        <link rel="stylesheet" type="text/css" href="assets/css/reset.css">
        <link rel="stylesheet" type="text/css" href="assets/css/grid.css">
        <link rel="stylesheet" type="text/css" href="assets/css/style.css">
        <link rel="stylesheet" type="text/css" href="assets/css/dashboard_responsive.css">
        <link rel="stylesheet" type="text/css" href="assets/css/faq.css">
        <link rel="stylesheet" type="text/css" href="assets/css/vitals_history.css">
        <link rel="stylesheet" type="text/css" href="assets/css/encounter-notes-legacy.css">
        
        <script src="https://cdnjs.cloudflare.com/ajax/libs/jquery/3.7.1/jquery.min.js"></script>
        <script type="text/javascript" src="https://cdn.jsdelivr.net/npm/sweetalert2@9"></script>
        <script type="text/javascript" src="assets/js/encounter-notes.js"></script>
        
    </head>
    <body>

        <?php note_nav( $_GET['uid'] ); ?>

        <div class="container mt-30">
            <div class="col-md-12">
                <div class="row">
                
                    <div class="col-md-12">

                        <div class="note-wrapper">
                            <?php

                            if(isset($row) && !empty($row)) {
                                echo '
                                    <div class="user-info-bar">
                                        <ul>
                                            <li><img src="images/topbar/name.svg"> <span><strong>Name:</strong> '.$row['patient_name'].'</span></li>
                                            <li><img src="images/topbar/dob.svg"> <span><strong>Date of Birth:</strong> '.$row['patient_dob'].'</span></li>
                                            <li><img src="images/topbar/gender.svg"> <span><strong>Gender:</strong> '.((strtolower($row['patient_gender']) == 'm') ? 'Male' : ((strtolower($row['patient_gender']) == 'f') ? 'Female' : $row['patient_gender'])).'</span></li>
                                            <li><img src="images/topbar/mobile.svg"> <span><strong>Cell:</strong> '.$row['cell'].'</span></li>
                            
                                            <li class="right"><img src="images/topbar/calendar.svg"> <span><strong>Date of Encounter:</strong> '.date('Y-m-d', strtotime($row['created_at'])).'</span></li>
                                            <li class="right"><img src="images/topbar/login.svg"> <span><strong>Encounter ID:</strong> <i class="encounter_id">'.$_GET['waiting_room_id'].'</i></span></li>
                                        </ul>
                                        <div class="clear"></div>
                        
                                    </div>

                                    <form class="note-form" method="post" action="process/encounter-notes-process.php">

                                        <input type="hidden" value="'.$_GET['waiting_room_id'].'" class="waiting_room_id">

                                        <div class="note-content">
                                            <div class="parsed-form">
                                                '.$basicNoteInfo.'
                                                '.$decisionSupportNotes.'
                                                '.$afterNote.'
                                            </div>
                                        </div>
                                        
                                    </form>
                                ';

                            } else {
                                
                                echo 'Note not found.';

                            }
                            ?>

                        </div>

                    </div>

                </div>
            </div>
        </div>

        
        <?php
        // if logged in as patient show patient bottom nav else show provider bottom nav
        if( $_SESSION['userType'] == 'patient' ){
            bottom_nav();
        }elseif( $_SESSION['userType'] == 'nurse' || $_SESSION['userType'] == 'doctor' ){
            provider_bottom_nav();
        }
        ?>
        
    </body>
</html>