<?php
    ini_set('display_errors', 1);
    ini_set('display_startup_errors', 1);
    error_reporting(E_ALL);

    // Start the session
    session_start();

    // Check if the user is logged in, if not then redirect him to login page
    if((!isset($_SESSION['userid']) || !isset($_SESSION['userType'])) && ($_SESSION['userType'] != 'nurse' && $_SESSION['userType'] != 'doctor')) {
        header("Location: provider_login.php");
        die();
    }

    // Custom functions
    function RemoveBS($Str) {  
        $StrArr = STR_SPLIT($Str); $NewStr = '';
        FOREACH ($StrArr AS $Char) {    
          $CharNo = ORD($Char);
          IF ($CharNo == 163) { $NewStr .= $Char; CONTINUE; } // keep � 
          IF ($CharNo > 31 && $CharNo < 127) {
            $NewStr .= $Char;    
          }
        }  

        return $NewStr;
    }

    // Include the functions file
    include('process/functions.php');
    
    // Register Waiting Room ID
    $wid = $_GET['wID'];

    $waitingroomQuery = "Select * from waiting_room left join patients on waiting_room.patient_id = patients.patient_id where waitingroom_id =".$wid;
    $waitingroomResult = mysqli_query(ddxrxDBConnect(), $waitingroomQuery);
    $waitingroom = mysqli_fetch_array($waitingroomResult);
    
    // Register variables
    $negative_diagnosis_id = json_decode($waitingroom['failed_diagnosis_id']);
    $positive_diagnosis_id = json_decode($waitingroom['diagnosis_id']);
?>

<!DOCTYPE html>
<html>
    <head>
        <title>Progress Note - DDXRX</title>

        <link rel="stylesheet" type="text/css" href="assets/css/reset.css">
        <link rel="stylesheet" type="text/css" href="assets/css/grid.css">
        <link rel="stylesheet" type="text/css" href="assets/css/responsive.css">
        <link rel="stylesheet" type="text/css" href="assets/css/search-style-reports.css">
        <link rel="stylesheet" type="text/css" href="assets/css/single-notes-ai.css">
        
        <script src="https://ajax.googleapis.com/ajax/libs/jquery/3.4.1/jquery.min.js"></script>
        <script src="//cdn.jsdelivr.net/npm/sweetalert2@11"></script>
        
    </head>
    <body>
        
        <?php note_nav( $_GET['uid'] ); ?>
        
    	<div class="container">
    		<div class="col-md-12">
    		    
    		    <div class="edit-note-header">
    		        <h6>Preview Note</h6>
    		        
    		        <!-- <?php if( $waitingroom['signed'] == '1' ){ ?>
    		            <a href="notes-ai.php?id=<?php echo $_GET['uid']; ?>" class="go-back-button">Go Back</a>
    		        <?php }else{ ?>
    		            <a href="edit-ai-note.php?wID=<?php echo $_GET['wID']; ?>&uid=<?php echo $_GET['uid']; ?>" class="go-back-button">Go Back</a>
    		        <?php } ?> -->

                    <a href="notes-progress.php?id=<?php echo $_GET['uid']; ?>" class="go-back-button">Go Back</a>
    		        
    		    </div>
    		    
    			<div class="user-info-bar">
    				<ul>
        				<li><img src="images/topbar/name.svg"> <span><strong>Name:</strong> <?php echo $waitingroom['patient_fname'].' '.$waitingroom['patient_lname']; ?></span></li>
        				<li><img src="images/topbar/dob.svg"> <span><strong>Date of Birth:</strong> <?php echo $waitingroom['patient_dob']; ?></span></li>
        				<li><img src="images/topbar/gender.svg"> <span><strong>Gender:</strong> <?php if($waitingroom['patient_gender'] == 'M' || $waitingroom['patient_gender'] == 'm'){ echo 'Male'; }else{ echo 'Female'; } ?></span></li>
        				<li><img src="images/topbar/mobile.svg"> <span><strong>Cell:</strong> <?php echo $waitingroom['cell']; ?></span></li>
        
        				<li class="right"><img src="images/topbar/calendar.svg"> <span><strong>Date of Encounter:</strong> <?php echo date_format(date_create($waitingroom['checkin_time']),"M/d/Y"); ?></span></li>
        				<li class="right"><img src="images/topbar/login.svg"> <span><strong>Encounter ID:</strong> <i class="encounter_id"><?php echo $waitingroom['waitingroom_id']; ?></i></span></li>
    				</ul>
    				<div class="clear"></div>
    
    			</div>
    		</div>
    	</div>
        
        <div class="container optimized-container typography-entry">
            <div class="col-md-12">
                <div class="results-container provider">
                    <div class="chief_complaints">
                        <?php
                        if($waitingroom['chief_complaints'] != "") {
                        ?>
                            <h6>Chief Complaints:</h6>
                            <ul>
                                <?php
                                $chief_complaints = explode(";", $waitingroom['chief_complaints']);
                                $presentedString = "";
                                $count = 1;
                                $counter = count($chief_complaints);
                                foreach ($chief_complaints as $key => $value) {
                                    $count++;
                                    echo "<li> $value </li>";
                                    $presentedString .= $value;
                                    if ($count < $counter) {
                                        $presentedString .= ", ";
                                    } elseif ($count == $counter) {
                                        $presentedString .= " and ";
                                    }
                                }
                                ?>
                            </ul>
                
                            <h6>History of present illness:</h6>
                            <p>Patient presented with <?php echo $presentedString; ?></p>
                        <?php
                        } else {
                            echo "<center><h5>No patient data available!</h5></center>";
                            exit();
                        }
                        ?>
                    </div>
                    <div class="diagnosis_and_symptoms">
                        <?php
                        $answers_per_diagnosis = json_decode($waitingroom['answers_per_diagnosis']);
                        $all_diagnosis = new stdClass();
                        $denied = [];

                        foreach($answers_per_diagnosis as $diagnosis_id => $answers) {
                            // Fetch the diagnosis details from the database
                            $diagnosis_query = "SELECT * FROM differential_diagnoses WHERE id='" . $diagnosis_id . "' LIMIT 1";
                            $result_diagnosis_query = mysqli_query(ddxrxDBConnect(), $diagnosis_query);
                            $diagnosis = mysqli_fetch_array($result_diagnosis_query);
                            $all_diagnosis->$diagnosis_id = $diagnosis;

                            $diag = $all_diagnosis->$diagnosis_id;
                            echo "<h6>" . $diag['name'] . "</h6>";
                            echo "<p>Patient complained of having " . implode(", ", $answers->positives) . '</p>';
                            $denied = array_merge($denied, $answers->negatives);
                        }
                        ?>
                    </div>

                    <div class="checkbox-group">
                        <div class="review_of_system">
                            <h6>Review of System:</h6>
                            <p>Patient denied having : <i style="font-style: italic"><?php echo implode(", ", array_unique($denied)); ?></i></p>
                            <br/>
                            <?php
                            if(isset($_POST['review'])) {
                            ?>
                            <label>
                                <span>All system were reviewed and was found negative except the above in HPI.</span>
                            </label>
                            <?php
                            }
                            ?>
                        </div>
                        <div class="vitals">
                            <?php if(isset($_POST['vital'])) { ?>
                            <h6>Vitals</h6>
                            <label>
                                <div>
                                    <?php
                                    if($vitals != "") {
                                        $vitalArray = json_decode($vitals);
                                        foreach($vitalArray as $key => $value) {
                                            echo "<b class='vital-label'>".$vitalFieldLables->$key."</b> : ".$value."<br/>";
                                        }
                                    }
                                    ?>
                                </div>
                                <div class="clear"></div>
                            </label>
                            <?php
                            }
                            ?>
                        </div>

                    </div>
                    <?php
                    $negative_diagnosis_names = [];
                        
                    foreach($negative_diagnosis_id as $id) {
                        $diag = $all_diagnosis->$id;
                        $negative_diagnosis_names[] = $diag['name'];
                    }
                    if(sizeof($negative_diagnosis_names) > 0) {
                        echo "Patient less likely have ".implode(", ", $negative_diagnosis_names);
                        echo "<br/><br/>";   
                    }
                        
                    $i = 0;
                    $j = 0;
                    $return = "";
                    foreach($positive_diagnosis_id as $id) {
                        $i = $i + 1;
                        $decision_support_query = "SELECT * FROM `decision_supports` WHERE `differential_diagnose_id` = '$id' LIMIT 1";
                        $result_decision_support = mysqli_query(ddxrxDBConnect(), $decision_support_query);
                        $decision_support = mysqli_fetch_array($result_decision_support);

                        // echo $decision_support['decisions_edited'];
                        // echo $id."<br/>";

                        /*
                        $var = trim($decision_support['decisions_edited']);
                        $var = str_replace('</p>', '', $var);
                        $var = str_replace('<br /><br />', '<br />', $var);
                        $var = trim(html_entity_decode($var), " \t\n\r\0\x0B\xC2\xA0");
                        $var = RemoveBS($var);
                        $var = multiexplode(array("<br />", "<p>", "<br>"), $var);
                        $var = array_filter(array_map('trim', $var));
                        $diag = $all_diagnosis->$id;
                        $return .= '<div class="each_diagnosis"';
                        $return .= '<strong style="font-weight:700">' . $i . ' . ' . $diag['name'] . '</strong>';
                        foreach ($var as $key => $value) {
                        
                            $pos = strpos($value, "**");
                            $posh = strpos($value, "##");
                            if (($pos === false) and ($posh === false)) {
                                $j = $j + 1;
                                $reved = ucfirst(str_replace("()", $_POST["textfield_".$i."_".$key], "$value"));
                                if(isset($_POST['checkbox_'.$i.'_'.$key])) {
                                    $return .= '<label for="checkbox_'.$i.'_'.$key.'"><span class="inline weight-400">'.$reved.'</span></label>';
                                }
                            } else {
                                if ($posh !== false) {
                                    $value = str_replace('##', '', $value);
                
                                } else {
                                    $value = str_replace('**', '', $value);
                                    $j = $j + 1;
                                        
                                    $reved = ucfirst(str_replace("()", $_POST["textfield_".$i."_".$key], "$value"));
                                    $return .= '<label><span class="inline"><strong>'.$reved.'</strong></span></label>';
                                }
                            }
                        }

                        if($_POST['additional_treatment_'.$i]) {
                            $return .= '<div class="additional_treatment"><h6>Additional Treatment</h6>'.$_POST['additional_treatment_'.$i].'</div>';
                        }
                        $return .= "</div>";
                        */
                    }
                    
                    echo $return;

                    // Close the connection
                    ddxrxDBConnect()->close();
                    ?>
                    
        		</div>
            </div>
        </div>

    </body>
</html>
