<?php

// Start session
session_start();

// Set content type to JSON
header('Content-Type: application/json');

// Include necessary files
include('../process/functions.php');

// Check if user is logged in and has the correct user type
if(!isset($_SESSION['userType'])) {
    $output = array(
        'status' => false,
        'title' => 'error',
        'message' => 'User not logged in or invalid user type.'
    );
    echo json_encode($output);
    exit();
}

// Get the diagnosis ID and patient ID from the request
if(isset($_POST['user_id']) && isset($_POST['patient_id'])) {
    $user_id = $_POST['user_id'];
    $patient_id = $_POST['patient_id'];
} else {
    $output = array(
        'status' => false,
        'title' => 'error',
        'message' => 'Required parameters not provided.'
    );
    echo json_encode($output);
    exit();
}

// Function to create waiting room data
$waitingroom_data = create_waitingroom($user_id);
$waitingroom_data = json_decode($waitingroom_data, true);
$waitingroom_data['checkInTime'] = time();

// Check if waiting room data was created successfully
if($waitingroom_data) {
    $output = array(
        'status' => true,
        'title' => 'success',
        'message' => 'Waiting room data created successfully.',
        'data' => $waitingroom_data
    );
} else {
    $output = array(
        'status' => false,
        'title' => 'error',
        'message' => 'Failed to create waiting room data.'
    );
}

// Return the output as JSON
echo json_encode($output);