<?php

header("Content-Type: application/json");

include('functions.php');

function generateRandomString($length = 10) {
    
    //$characters = '0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ';
    $characters = '0123456789';
    
    $charactersLength = strlen($characters);
    $randomString = '';
    for ($i = 0; $i < $length; $i++) {
        $randomString .= $characters[rand(0, $charactersLength - 1)];
    }
    return $randomString;
}

if( isset($_POST) ){
    
    $dbConnection = ddxrxDBConnect();
    
    $video_call_id = generateRandomString(20);
    
    $owner_id = $dbConnection->real_escape_string($_POST['owner_id']);
    $meetingTitle = $dbConnection->real_escape_string($_POST['meetingTitle']);
    $selectDate = $dbConnection->real_escape_string($_POST['selectDate']);
    $selectTime = $dbConnection->real_escape_string($_POST['selectTime']);
    $selectPeriod = $dbConnection->real_escape_string($_POST['selectPeriod']);
    
    $durationHour = $dbConnection->real_escape_string($_POST['durationHour']);
    $durationMinute = $dbConnection->real_escape_string($_POST['durationMinute']);
    
    date_default_timezone_set('UTC');
    $date = new DateTime($durationHour.":".$durationMinute);
    $duration = $date->format('H:i:s');
    
    $timezone = $_POST['timezone'];
    $epoch_time = strtotime($selectDate.' '.$selectTime.$selectPeriod.' '.$timezone);
    $epoch_time = $dbConnection->real_escape_string($epoch_time);
    
    $attendeeList = $_POST['attendeeList'];
    
    $meetingNotes = $dbConnection->real_escape_string($_POST['meeetingNotes']);
    
    
    /* ---------------------------------------------------- */
    /* INSERT MEETING DETAILS IN DATABASE */
    /* ---------------------------------------------------- */
    $sql_meeting = "INSERT INTO vc_meeting (video_call_id, meeting_name, duration, meeting_notes, scheduled_at, timezone, epoch_time) VALUES ('$video_call_id','$meetingTitle', '$duration', '$meetingNotes', '$selectDate', '$timezone', '$epoch_time')";
    
    if ($dbConnection->query($sql_meeting) === TRUE) {
        
        $output = array(
            'result' => true,
            'icon' => 'success',
            'title' => 'Meeting Schedule Created',
            'text' => 'The meeting you created has successfully been created.',
        );
        
    } else {
        
        $output = array(
            'result' => false,
            'icon' => 'warning',
            'title' => 'Unexpected Error',
            'text' => 'Sorry for the inconvenience there was an unexpected error that occured.'
        );
        
    }
    
    /* ---------------------------------------------------- */
    /* INSERT ATTENDEE DATA IN DATABASE */
    /* ---------------------------------------------------- */
    
    // Get ID of from the newly created meeting
    $last_id = $dbConnection->insert_id;
    
    // Decode the JSON string
    $attendeeList = json_decode($attendeeList);
    
    // Iterate the object into individual SQL queries
    $total_array = count($attendeeList);
    
    $test = array();
    
    for( $x = 0; $x < $total_array; $x++ ){
        
        $contact_type = $attendeeList[$x]->contact_type;
        $contact_source = $attendeeList[$x]->contact_source;
        $contactUserType = $attendeeList[$x]->contactUserType;
        
        $sql_attendees .= "INSERT INTO vc_meeting_attendee (`meeting_id`, `type`, `source`) VALUES ('$last_id', '$contact_type', '$contact_source');";
        
        
        if( $contact_type == 'email' ){
            
            // Send Email
            $date = date('M d Y h:i T', $epoch_time);
            $videocall_link = 'https://development.ddxrx.net/videocall_stream.php?room_name='.$video_call_id;
            $options = array(
                'send_to' => $contact_source,
                'subject' => 'DDXRX Scheduled Meeting',
                'message' => 'You are invited to join the meeting at '.$date.' .Please use this video call link: '.$videocall_link,
            );
            
            send_email($options);
            
        }elseif( $contact_type == 'phone' ){
            
            // Send SMS
            $date = date('M d Y h:i T', $epoch_time);
            $videocall_link = 'https://development.ddxrx.net/videocall_stream.php?room_name='.$video_call_id;
            $message = 'You are invited to join the meeting at '.$date.' .Please use this video call link: '.$videocall_link;
            
            send_sms($contact_source, $message);
            
        }elseif( $contact_type == 'user_id' ){
            
            if( $contactUserType == '2' ){
                $user_type = 'physician';
            }elseif( $contactUserType == '3' ){
                $user_type = 'patient';
            }elseif( $contactUserType == '4' ){
                $user_type = 'nurse';
            }
            
            $user_data = get_attendee_details( $contact_source, $user_type );
            $email_source = $user_data['user_data']['email'];
            
            // Send Email
            $date = date('M d Y h:i T', $epoch_time);
            $videocall_link = 'https://development.ddxrx.net/videocall_stream.php?room_name='.$video_call_id;
            $options = array(
                'send_to' => $email_source,
                'subject' => 'DDXRX Scheduled Meeting',
                'message' => 'You are invited to join the meeting at '.$date.' .Please use this video call link: '.$videocall_link,
            );
            
            send_email($options);
            
        }
        
    }
    
    // Manually add owner ID as attendee
    $sql_attendees .= "INSERT INTO vc_meeting_attendee (`meeting_id`, `type`, `source`) VALUES ('$last_id', 'user_id', '$owner_id');";
    
    $dbConnection->multi_query($sql_attendees);
    
    // Close Connection
    $dbConnection->close();
    
}else{
    
    $output = array(
        'result' => false,
        'icon' => 'error',
        'title' => 'Empty Fields',
        'text' => 'Our system detected an empty field and resulted into an error.',
    );
    
}

echo json_encode($output);

?>