<?php

include('../functions.php');

// Set header as JSON
header('Content-Type: application/json');

// Connect to database
$conn = ddxrxDBConnect('telemedicine');

$sender_id = mysqli_real_escape_string($conn, $_POST['sender_id']);
$room_id = mysqli_real_escape_string($conn, $_POST['room_id']);
$sent_date = mysqli_real_escape_string($conn, $_POST['sent_date']);
$sender_name = mysqli_real_escape_string($conn, $_POST['sender_name']);
$msg = mysqli_real_escape_string($conn, $_POST['msg']);

// function containsVideoChatUrl($msg) {
//     $pattern = "/https?:\/\/chat\.ddxrx\.com\/video-chat\.php\?room_name=\d+/";
//     return preg_match($pattern, $msg) === 1;
// }
function containsVideoChatUrl($msg) {
    $patterns = [
        "/https?:\/\/chat\.ddxrx\.com\/video-chat\.php\?room_name=\d+/",
        "/https?:\/\/development\.ddxrx\.net\/start_videocall\.php\?patient=\d+&username=\d+&room_name=\d+&callid=\d+/"
    ];

    foreach ($patterns as $pattern) {
        if (preg_match($pattern, $msg) === 1) {
            return true;
        }
    }

    return false;
}

if( containsVideoChatUrl($msg) == true ){
    $msg_type = 'videocall';
}else{
    $msg_type = 'text';
}

$sql = "INSERT INTO messages (sender_id, room_id, sent_date, sender_name, msg, msg_type) VALUES ('$sender_id', '$room_id', '$sent_date', '$sender_name', '$msg', '$msg_type')";

if ($conn->query($sql) === true) {
    $output = array(
        'status_code' => '200',
        'result' => true,
        'text' => 'Message Saved',
        'sql' => $sql
    );
} else {
    $output = array(
        'status_code' => '400',
        'result' => false,
        'text' => 'Failed to save message',
        'sql' => $sql,
        'error' => $conn->error
    );
}

// Close the database connection
$conn->close();

// Show Output
echo json_encode($output);

?>