<?php
    ob_start();
    session_start();
    
    include('process/functions.php');
    include ('includes/database_include.php');
    include ('analytics.php');

    if(!isset($_SESSION['userid']) || !isset($_SESSION['userType'])) {
        header("Location: ios-launch.php");
        die();
    }
    
    // echo '<pre>';
    // print_r($_SESSION);
    // exit();
    
    $patient_id = null;
    if(isset($_SESSION['userid']) && isset($_SESSION['patient_id'])) {
        $patient_id = $_SESSION['userid'];
    } else if($_SESSION['userType']!="patient" && isset($_GET['id']) ) {
        $patient_id = $_GET['id'];
    }
    
    $user_id = $_SESSION['userid'];
    //$sql = "SELECT * FROM patients WHERE patients.user_id = '$user_id'LIMIT 1;";
    $sql = "select patients.user_id, patients.patient_fname, patients.mname, patients.patient_lname, patients.patient_gender, patients.epic_id, patients.ssn, patients.cell, patients.profilepicture, patients.patient_dob, all_users.email_address, all_users.is_verified_email	, all_users.username FROM patients INNER JOIN all_users ON patients.user_id = all_users.userid WHERE patients.user_id = '$user_id'";
    $result = mysqli_query($con, $sql);
    $user = mysqli_fetch_assoc($result);

    // echo '<pre>';
    // print_r($user);
    // exit();
    
?>

<!DOCTYPE html>
<html>
<head><meta http-equiv="Content-Type" content="text/html; charset=utf-8">
	
	<!-- Global site tag (gtag.js) - Google Analytics -->
    <script async src="https://www.googletagmanager.com/gtag/js?id=UA-148409281-5"></script>
    <script>
      window.dataLayer = window.dataLayer || [];
      function gtag(){dataLayer.push(arguments);}
      gtag('js', new Date());
    
      gtag('config', 'UA-148409281-5');
    </script>

	
	<title>AI Based Health Care - DDxRx.com</title>
	<meta name="viewport" content="width=device-width, initial-scale=1">
	
    <?php if( basename($_SERVER['REQUEST_URI']) == 'ios-launch.php' ){ include('header-ios-launch.php'); } ?>
    <?php if( basename($_SERVER['REQUEST_URI']) == 'search_dd.php' ){ include('header-search-dd.php'); } ?>

	<link rel="stylesheet" type="text/css" href="assets/css/reset.css">
	<link rel="stylesheet" type="text/css" href="assets/css/grid.css">
	<link rel="stylesheet" type="text/css" href="assets/css/main-menu.css">
	<link rel="stylesheet" type="text/css" href="assets/css/slicknav.css">
	<link rel="stylesheet" type="text/css" href="assets/css/jquery.fancybox.min.css">
	<link rel="stylesheet" type="text/css" href="assets/css/easy-autocomplete.min.css">
	<link rel="stylesheet" type="text/css" href="assets/css/easy-autocomplete.themes.min.css">
	<!--<link rel="stylesheet" type="text/css" href="assets/css/sweetalert2.min.css">-->
	<link rel="stylesheet" type="text/css" href="assets/css/login-selector.css">
	<link rel="stylesheet" type="text/css" href="assets/css/style.css">
	<link rel="stylesheet" type="text/css" href="assets/css/responsive.css">
	<link rel="stylesheet" type="text/css" href="assets/css/mobile.css">
	<link rel="stylesheet" type="text/css" href="assets/css/top-bar.css">
	<link rel="stylesheet" type="text/css" href="assets/css/faq.css">
    
    <style type="text/css">
        .required-field{
            -webkit-box-shadow: 0 0 0 5px #FFA8A8!important;
            box-shadow: 0 0 0 5px #FFA8A8!important;
        }
    
	  	@import url("https://fonts.googleapis.com/css?family=Open+Sans");

		/* Styles */
		* {
		  margin: 0;
		  padding: 0;
		}

		/*body {*/
		/*  font-family: "Open Sans";*/
		/*  font-size: 14px;*/
		/*}*/

		/*.container {*/
		/*  width: 500px;*/
		/*  margin: 25px auto;*/
		/*}*/


		form label,
		form button {
		  border: 0;
		  margin-bottom: 3px;
		  display: block;
		  width: 100%;
		}


		form .error {
		  color: #ff0000;
		  text-align: left !important;
		}

	</style>
    
	<script type="text/javascript" src="assets/js/jquery.min.js"></script>

	<!--<script src="https://ajax.googleapis.com/ajax/libs/jquery/3.4.1/jquery.min.js"></script>-->

	<script src="https://cdnjs.cloudflare.com/ajax/libs/jquery-validate/1.19.1/jquery.validate.min.js"></script>
	<script src="https://cdn.jsdelivr.net/jquery.validation/1.16.0/additional-methods.min.js"></script>


	<script type="text/javascript" src="assets/js/base64converter.js"></script>
	<script type="text/javascript" src="assets/js/jquery.waypoints.min.js"></script>
	<script type="text/javascript" src="assets/js/jquery.slicknav.js"></script>
	<script type="text/javascript" src="https://cdn.jsdelivr.net/npm/sweetalert2@10"></script>
	<script type="text/javascript" src="assets/js/jquery.fancybox.min.js"></script>
	<script type="text/javascript" src="assets/js/jquery-ui.min.js"></script>
	<script type="text/javascript" src="assets/js/jquery.easy-autocomplete.min.js"></script>
	<script type="text/javascript" src="assets/js/admin.js"></script>
	<script type="text/javascript" src="assets/js/init.js"></script>
	<script type="text/javascript" src="assets/js/mobile.js"></script>
	<script type="text/javascript" src="assets/js/save_profile.js"></script>
	<script type="text/javascript" src="assets/js/faq.js"></script>
	<script type="text/javascript" src="assets/js/phone-call.js"></script>
    
    <script type="text/javascript">
    function googleTranslateElementInit() {
        new google.translate.TranslateElement({pageLanguage: 'en', 
        layout:     google.translate.TranslateElement.InlineLayout.VERTICAL,
        autoDisplay: false, 
        includedLanguages: ''}, 'google_translate_element');}
    </script>
    <script type="text/javascript" src="https://translate.google.com/translate_a/element.js?cb=googleTranslateElementInit"></script>
    
    
</head>
<body class="user-profile" data-user-id="<?php echo $patient_id; ?>">
    
    <div class="loading-screen"></div>
    
    <?php top_nav(); ?>
    
    <div class="profile-container">

        <?php include('profile-heading.php'); ?>


        <div class="container">
            <div class="col-md-12">
                <div class="profile-inner">
                    
                    <!-- Form Container -->
                    <div class="form-container">
                        
                        
                        
                        <!-- Navigation Menu -->
                        <div class="accountNav">
                            <a href="profile.php" class="active">Account</a>
                            <a href="billing.php">Billing</a>
                            <!--<a href="invoice.php">Invoice</a>-->
                            <a href="subscription_2.php">Subscriptions</a>
                            <div class="clear"></div>
                        </div>
                        <!-- Navigation Menu -->
                        
                        <div class="row">
                            
                            <div class="col-md-12">
                                <h1 class="header">Account Settings <a href="#" class="edit account-settings">Edit</a></h1>
                            </div>
                            
                            <div class="user-data-container editor account-settings">
                                <form action="#" method="post" class="" name="profile_form" id="profile_form">
                                    <input type="hidden" class="profile_form_name" name="form_name" value="profile_form" />
                                    
                                    <div class="col-md-4">
                                        <label>
                                            <span>First Name</span>
                                            <input type="text" class="textbox patient_fname" name="patient_fname" value="<?php echo $user['patient_fname']; ?>" placeholder="Enter your given first name">
                                        </label>
                                    </div>
        
                                    <div class="col-md-4">
                                        <label>
                                            <span>Middle Name</span>
                                            <input type="text" class="textbox mname" name="patient_mname" value="<?php echo $user['mname']; ?>" placeholder="Enter Middle name">
                                        </label>
                                    </div>
        
                                    <div class="col-md-4">
                                        <label>
                                            <span>Last Name</span>
                                            <input type="text" class="textbox patient_lname" name="patient_lname" value="<?php echo $user['patient_lname']; ?>" placeholder="Enter Last Name">
                                        </label>
                                    </div>
        
                                    <div class="col-md-4">
                                        <label>
                                            <span>Gender</span>
                                            <input type="text" class="textbox patient_gender" name="patient_gender" value="<?php if( $user['patient_gender'] == 'm' ){ echo 'Male'; }elseif( $user['patient_gender'] == 'f' ){ echo 'Female'; } ?>" placeholder="Gender">
                                        </label>
                                    </div>
        
                                    <div class="col-md-4">
                                        <label>
                                            <span>Date of Birth</span>
                                            <input type="date" class="textbox patient_dob" name="patient_dob" value="<?php echo $user['patient_dob']; ?>" placeholder="Ex. June/01/1988">
                                        </label>
                                    </div>
        
                                    <div class="col-md-4">
                                        <label>
                                            <span>Social Security Number ( Optional )</span>
                                            <input type="text" class="textbox ssn" name="patient_ssn" value="<?php echo $user['ssn']; ?>" placeholder="### ## ####">
                                        </label>
                                    </div>
                                    
                                    <div class="clear"></div>
                                    
                                    <div class="col-md-12">
                                        <input type="submit" value="Save" data-role="none" class="button">
                                        <input type="submit" value="Cancel" data-role="none" class="button cancel">
                                    </div>
                                </form>
                                
                            </div>
                            
                            <div class="user-data-container static account-settings show">
                                <div class="col-md-4">
                                    <label>
                                        <span>First Name</span>
                                        <p class="patient_fname_view"><?php echo $user['patient_fname']; ?></p>
                                    </label>
                                </div>
    
                                <div class="col-md-4">
                                    <label>
                                        <span>Middle Name</span>
                                        <p class="patient_name_view"><?php echo $user['mname']; ?></p>
                                    </label>
                                </div>
    
                                <div class="col-md-4">
                                    <label>
                                        <span>Last Name</span>
                                        <p class="patient_lname_view"><?php echo $user['patient_lname']; ?></p>
                                    </label>
                                </div>
                                
                                <div class="clear"></div>
                                
                                <div class="col-md-4">
                                    <label>
                                        <span>Gender</span>
                                        <p class="patient_gender_view"><?php echo ($user['patient_gender']=='m') ? 'Male' : (($user['patient_gender']=='f') ? 'Female' : ''); ?></p>
                                    </label>
                                </div>
    
                                <div class="col-md-4">
                                    <label>
                                        <span>Date of Birth</span>
                                        <p class="patient_dob_view"><?php echo date('F d, Y', strtotime($user['patient_dob'])); ?></p>
                                    </label>
                                </div>
    
                                <div class="col-md-4">
                                    <label>
                                        <span>Social Security Number ( Optional )</span>
                                        <p class="patient_ssn_view"><?php echo !empty($user['ssn']) ? $user['ssn'] : 'Not Available'; ?></p>
                                    </label>
                                </div>
                            </div>
                            
                            
                            
                            <div class="clear"></div>
                            <div style="width: 100%; height: 30px;"></div>
                            
                            
                            
                            <div class="col-md-12">
                                <h1 class="header">Contact Information <a href="#" class="edit account-contact">Edit</a></h1>
                            </div>
                            
                            <div class="user-data-container editor account-contact">
                                <form action="#" method="post" class="" name="contact_form" id="contact_form">
                                    
                                    <input type="hidden" class="contact_form_name" name="form_name" value="contact_form" />
                                    
                                    <div class="col-md-4">
                                        <label>
                                            <span>Mobile Phone</span>
                                            <input type="text" class="textbox cell" name="cell" value="<?php echo $user['cell']; ?>" placeholder="(###) ### ####">
                                        </label>
                                    </div>
        
                                    <div class="col-md-4">
                                        <label>
                                            <span>Email Address</span>
                                            <input type="text" class="textbox email_id" name="email_address" value="<?php echo $user['email_address']; ?>" placeholder="Email Address">
                                        </label>
                                    </div>
                                    
                                    <div class="clear"></div>
                                    
                                    <div class="col-md-12">
                                        <input type="submit" value="Save" data-role="none" class="button">
                                        <input type="submit" value="Cancel" data-role="none" class="button cancel">
                                    </div>
                                </form>
                                
                            </div>
                            
                            <div class="user-data-container static account-contact show">
                                <div class="col-md-4">
                                    <label>
                                        <span>Mobile Phone</span>
                                        <p class="cell_view"><?php echo $user['cell']; ?></p>
                                    </label>
                                </div>
    
                                <div class="col-md-4">
                                    <label>
                                        <span>Email Address</span>
                                        <p class="email_address_view verification <?php echo $user['is_verified_email'] == 1 ? 'verified' : 'unverified'; ?> "><?php echo $user['email_address']; ?></p>
                                        <!-- To make this icon unverified just remove the "Verified class" -->
                                    </label>
                                </div>
                            </div>



                            <div class="clear"></div>
                            <div style="width: 100%; height: 30px;"></div>
                            
                            
                            
                            <div class="col-md-12">
                                <h1 class="header">Security Options <a href="#" class="edit account-security">Edit</a></h1>
                            </div>
                            
                            <div class="user-data-container editor account-security">
                                <form action="#" method="post" class="" name="security_form" id="security_form">
                                    
                                    <input type="hidden" class="security_form_name" name="form_name" value="security_form" />
                                    
                                    <div class="col-md-4">
                                        <label>
                                            <span>Username</span>
                                            <input type="text" class="textbox" name="" value="<?php echo $_SESSION['username']; ?>" style="cursor: not-allowed;" disabled>
                                        </label>
                                    </div>
        
                                    <div class="col-md-4">
                                        <label>
                                            <span>Password</span>
                                            <input type="password" class="textbox password" name="password" value="">
                                        </label>
                                    </div>
                                    
                                    <div class="col-md-4">
                                        <label>
                                            <span>Repeat Password</span>
                                            <input type="password" class="textbox repeat-password" name="repeat_password" value="">
                                        </label>
                                    </div>
                                    
                                    <div class="clear"></div>
                                    
                                    <div class="col-md-12">
                                        <input type="submit" value="Save" data-role="none" class="button">
                                        <input type="submit" value="Cancel" data-role="none" class="button cancel">
                                    </div>
                                </form>
                                
                            </div>
                            
                            <div class="user-data-container static account-security show">
                                <div class="col-md-4">
                                    <label>
                                        <span>Username</span>
                                        <p><?php echo $user['username'] ?></p>
                                    </label>
                                </div>
    
                                <div class="col-md-4">
                                    <label>
                                        <span>Password</span>
                                        <p>************</p>
                                    </label>
                                </div>
                            </div>


                        </div>
                    </div>
                    <!-- Form Container -->

                    <div class="clear"></div>
                </div>
            </div>
        </div>
    </div>

<?php //include('footer.php'); ?>
</body>

<script>
//     jQuery.validator.setDefaults({
// 	  debug: true,
// 	  success: "valid"
// 	});
	
	
	$.validator.addMethod("hasUppercase", function(value, element) {
		if (this.optional(element)) {
			return true;
		}
	    return /[A-Z]/.test(value);
	}, "Your password must be at least 1 capital (uppercase) letter");

	$.validator.addMethod("hasLowercase", function(value, element) {
		if (this.optional(element)) {
			return true;
		}
	    return /[a-z]/.test(value);
	}, "Your password must be at least 1 capital (lowercase) letter");

	$.validator.addMethod("hasNumber", function(value, element) {
		if (this.optional(element)) {
			return true;
		}
	    return /[0-9]/.test(value);
	}, "Your password must be at least 1 (number) letter");
	
	function dateformat (date_val='', format = ''){
	    let formated_date = '';
	    if(date_val != '' && date_val !=undefined){
	        const dob = new Date(date_val);
	        
	        const months = ['January', 'February', 'March', 'April', 'May', 'June', 'July', 'August', 'September', 'October', 'November', 'December'];
	        
	        let date = dob.getDate();
	        let month = dob.getMonth();
	        let year = dob.getFullYear();
	        
	        if(parseInt(date) > 0 && parseInt(month) > 0 && parseInt(year) > 0 ){
	            formated_date = months[month] + ' ' + date + ', ' + year;
	        }
	    }
	    
	    return formated_date;
	}
</script>

<script>
	  // Wait for the DOM to be ready
	$(function() {
	  $("form[name='profile_form']").validate({
	    // Specify validation rules
	    rules: {
			
			patient_fname: {
		        required: true,
		        normalizer: function(value) {
		          return $.trim(value);
		        },
			},
			patient_mname: {
				required: true
			},
			patient_lname: {
				required: true
			},
			patient_gender: {
				required: true
			},
			patient_dob: {
				required: true
			},
			patient_ssn: {
				required: true
			}
			
	    },
	    // Specify validation error messages
	    messages: {
	      
	    },
	    // Make sure the form is submitted to the destination defined
	    // in the "action" attribute of the form when valid
	    submitHandler: function(form) {
	   //   form.submit();
	        
            var patient_id = $('body').data('user-id');
            var patient_fname = $('.patient_fname').val();
            var mname = $('.mname').val();
            var patient_lname = $('.patient_lname').val();
            var patient_gender = $('.patient_gender').val();
            var patient_dob = $('.patient_dob').val();
            var ssn = $('.ssn').val();
            var cell = $('.cell').val();
            var email_id = $('.email_id').val();
            var password = $('.password').val();
            var profile_form_name = $('.profile_form_name').val();
            
            $.ajax({
        		type: 'POST',
        		url: 'process/save_profile.php',
            
        		data: {
        		    patient_id:patient_id,
        		    patient_fname:patient_fname,
        		    mname:mname,
        		    patient_lname:patient_lname,
        		    patient_gender:patient_gender,
        		    patient_dob:patient_dob,
        		    ssn:ssn,
        		    cell:cell,
        		    email_id:email_id,
        		    password:password,
        		    form_name: profile_form_name
        		},
        
        		beforeSend: function() {
        		    // Do Something
        		},
        		
        	  	success: function(response) {
        			
        			if( response == 'success' ){
        			    
        			    $('.patient_fname_view').text(patient_fname);
        			    $('.patient_mname_view').text(mname);
        			    $('.patient_lname_view').text(patient_lname);
        			    $('.ssn_view').text(ssn);
        			    $('.patient_dob_view').text(dateformat(patient_dob));
        			    $('.patient_gender_view').text(patient_gender);
        			 
            			Swal.fire({
            				  type: 'success',
            				  title: 'Profile Saved',
            				  text: 'Your profile has been saved successfully.'
            			});
            			
            			$('.user-data-container.editor.account-settings').removeClass('show');
                    	$('.user-data-container.static.account-settings').addClass('show');
        			
        			}else{
        			    
        			    Swal.fire({
            				  type: 'error',
            				  title: 'Error',
            				  text: 'Opps Something went wrong! Please try again.'
            			});
        			}
        		}
        	});
	    }
	  });
	  
	  $("form[name='contact_form']").validate({
	    // Specify validation rules
	    rules: {
			
			cell: {
		        required: true,
		        normalizer: function(value) {
		          return $.trim(value);
		        },
			},
			email_address: {
				required: true
			}
			
	    },
	    
	    submitHandler: function(form) {
	        
            var patient_id = $('body').data('user-id');
            
            var cell = $('.cell').val();
            var email_id = $('.email_id').val();
            var contact_form_name = $('.contact_form_name').val();
            
            if(cell != '' && email_id != '' ){
                $.ajax({
            		type: 'POST',
            		url: 'process/save_profile.php',
                
            		data: {
            		    patient_id:patient_id,
            		    cell:cell,
            		    email_id:email_id, 
            		    form_name: contact_form_name
            		},
            
            		beforeSend: function() {
            		    // Do Something
            		},
            		
            	  	success: function(response) {
            			
            			if( response == 'success' ){
            			    
            			    $('.cell_view').text(cell);
            			    $('.email_address_view').text(email_id);
            			 
                			Swal.fire({
                				  type: 'success',
                				  title: 'Profile Saved',
                				  text: 'Your profile contact information has been saved successfully updated.'
                			});
                			
                			$('.user-data-container.editor.account-contact').removeClass('show');
                    	    $('.user-data-container.static.account-contact').addClass('show');
            			
            			}else{
            			    
            			    Swal.fire({
                				  type: 'error',
                				  title: 'Error',
                				  text: 'Opps Something went wrong! Please try again.'
                			});
            			}
            		}
            	});
            }else{
                if( cell === '' ){ $('.cell').addClass('required-field'); }
                if( email_id === '' ){ $('.email_id').addClass('required-field'); }
                
                Swal.fire({
        	        type: 'error',
        			title: 'Empty Fields',
        			text: 'Please fill up all the text fields before saving, all fields marked in red cannot be empty.'
        		}); 
            }
	    }
	  });
	  
	  $("form[name='security_form']").validate({
	    // Specify validation rules
	    rules: {
	        
			password: {
		        required: true,
		        hasUppercase: true,
	    		hasLowercase: true,
	    		hasNumber: true,
		        minlength: 6,
		        maxlength: 40,
		        // Using the normalizer to trim the value of the element
		        // before validating it.
		        //
		        // The value of `this` inside the `normalizer` is the corresponding
		        // DOMElement. In this example, `this` references the `password` element.
		        normalizer: function(value) {
		          return $.trim(value);
		        }
			},
			repeat_password: {
				required: true,
				equalTo: '.password'
			}
			
	    },
	    
	    submitHandler: function(form) {
	        
            var patient_id = $('body').data('user-id');
            
            var password = $('.password').val();
            var repeat_password = $('.repeat-password').val();
            var security_form_name = $('.security_form_name').val();
            
            $.ajax({
        		type: 'POST',
        		url: 'process/save_profile.php',
            
        		data: {
        		    patient_id:patient_id,
        		    password:password, 
        		    form_name: security_form_name
        		},
        
        		beforeSend: function() {
        		    // Do Something
        		},
        		
        	  	success: function(response) {
        			
        			if( response == 'success' ){
        			 
            			Swal.fire({
            				  type: 'success',
            				  title: 'Profile Saved',
            				  text: 'Your profile password has been saved successfully updated.'
            			});
            			
            			$('.user-data-container.editor.account-security').removeClass('show');
                	    $('.user-data-container.static.account-security').addClass('show');
        			
        			}else{
        			    
        			    Swal.fire({
            				  type: 'error',
            				  title: 'Error',
            				  text: 'Opps Something went wrong! Please try again.'
            			});
        			}
        		}
        	});
	    }
	  });
	});
</script>

</html>