<?php

    session_start();

    function generateRandomString($length = 10) {
    
        //$characters = '0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ';
        $characters = '0123456789';
            
        $charactersLength = strlen($characters);
        $randomString = '';
        for ($i = 0; $i < $length; $i++) {
            $randomString .= $characters[rand(0, $charactersLength - 1)];
        }
        return $randomString;
    }
        
    if( isset($_SESSION["username"]) ){
            
        $username = $_SESSION["username"];
        
    }else{
        
        if( isset($_GET['username']) ){
            $username = $_GET['username'];
        }else{
            $username = 'User_'.generateRandomString('5');
        }
        
    }
        
?>

<!DOCTYPE html>
<html>
<head>
    
	<title>Doctor Ai - Video Call</title>
	<meta http-equiv="Content-Type" content="text/html; charset=utf-8">
	<meta name="viewport" content="width=device-width, initial-scale=1">
    
    <link rel="stylesheet" type="text/css" href="assets/css/reset.css">
    <link rel="stylesheet" type="text/css" href="assets/css/videocall.css">
    
    <script src="https://cdnjs.cloudflare.com/ajax/libs/jquery/3.6.0/jquery.min.js"></script>
    <script src="assets/js/video_call.js"></script>
    
</head>
<body data-meeting-id="<?php echo $_GET['room_name']; ?>">
    
    <script src='https://clinicians.space/external_api.js'></script>
    <section id="main-content">
        <section class="wrapper">
            <div class="row">
                <div id="meeting"></div>
            </div>
        </section>
    </section>
    <script>
    $(document).ready(function() {
        const screenHeight = jQuery(window).height();
        const domain = 'clinicians.space';
        const options = {
            roomName: '<?php echo $_GET['room_name']; ?>',
            //height: 700,
            height: screenHeight,
            parentNode: document.querySelector('#meeting'),
            userInfo: {
                displayName: '<?php echo $username; ?>'
            },
                 configOverwrite: {
                 disableNS: true
            }
        };
        const api = new JitsiMeetExternalAPI(domain, options);
        
        api.on('videoConferenceJoined', (user) => {
            console.log('videoConferenceJoined');
            console.log(user);
        });
        
    });
    </script> 
    
</body>
</html>





















