<?php

/*
if the answer is related, use past medical history ( xxx api), surgical history (xxx api),
socail history (xxx api) medication list  (xx api) and allergy list (xxx api) to deliver the most appropriate answer based on the above data.  
*/

error_reporting(0);
session_start();

include('process/functions.php');

if(!isset($_SESSION['userid']) || !isset($_SESSION['userType'])) {
    header("Location: provider_login.php");
    die();
}   
?>

<!DOCTYPE html>
<html class="ui-mobile">
    <head>
        <meta http-equiv="Content-Type" content="text/html; charset=utf-8">
        <title>DDXRX - Smart Analysis</title>
            
        <meta name="viewport" content="width=device-width, initial-scale=1.0">
            
        <script type="text/javascript" src="https://cdnjs.cloudflare.com/ajax/libs/jquery/3.7.0/jquery.min.js"></script>
        <script type="module" src="https://unpkg.com/ionicons@7.1.0/dist/ionicons/ionicons.esm.js"></script>
        <script nomodule src="https://unpkg.com/ionicons@7.1.0/dist/ionicons/ionicons.js"></script>
        <script type="text/javascript" src="assets/js/jquery.nicescroll.min.js"></script>
        <script type="text/javascript" src="assets/js/smart-analysis.js"></script>
    
        <link rel="stylesheet" type="text/css" href="assets/css/reset.css">
        <link rel="stylesheet" type="text/css" href="assets/css/grid.css">
        <link rel="stylesheet" type="text/css" href="assets/css/main-menu.css">
        <link rel="stylesheet" type="text/css" href="assets/css/style.css">
    
        <link rel="stylesheet" type="text/css" href="assets/css/patient-records.css">
        <link rel="stylesheet" type="text/css" href="assets/css/general-ui.css">
        <link rel="stylesheet" type="text/css" href="assets/css/mobile.css">
        <link rel="stylesheet" type="text/css" href="assets/css/faq.css">
        <link rel="stylesheet" type="text/css" href="assets/css/smart-analysis.css">
            
    </head>
    <body data-user-id="<?php echo $_SESSION['userid']; ?>" data-patient-name="<?php echo $_SESSION['current_patient']['patient_name']; ?>">

        <div class="container optimized-container pb-20">
            <div class="col-md-12">
    
                <div class="form-container">
    
                    <div class="record-navigation-menu">
                        <?php include('emr_navigation.php'); ?>
                        <div class="clear"></div>
                    </div>
                        
                    <div class="tab-content-container card">
                        <div class="row">
    
    	                    <div class="col-xs-12"><h1 class="h1">Smart Analysis</h1></div>
    
    	                    <div class="col-xs-12">
                                <ul class="message-list" id="message-list">

                                    <?php
                                    $user_id = $_SESSION['userid'];
                                    $sql = "SELECT * FROM `smart_analysis` WHERE `user_id` = '$user_id'";
                                    $result = ddxrxDBConnect()->query($sql);
                                    
                                    if ($result->num_rows > 0) {
                                        // output data of each row
                                        while($row = $result->fetch_assoc()) {

                                            if( $row['msg_type'] == 'bot' ){
                                                $image = 'chat-ai-avatar.png';
                                            }else{
                                                $image = 'chat-user-avatar.png';
                                            }

                                            if( $row['msg_type'] == 'bot' ){
                                                $name = "<span>ddxrx AI</span>";
                                            }else{
                                                $name = "<span>".$_SESSION['current_patient']['patient_name']."</span>";
                                            }

                                            echo '<li class="'.$row["msg_type"].'"><img src="assets/images/'.$image.'" class="avatar"><div class="desc"><div class="inner">'.$name.$row["msg_text"].'</div></div><div class="clear"></div></li>';
                                        }
                                    } else {
                                        echo '<li class="bot"><img src="assets/images/chat-ai-avatar.png" class="avatar"><div class="desc"><div class="inner">No message history yet. Ask any question to get started!</div></div><div class="clear"></div></li>';
                                    }
                                    ddxrxDBConnect()->close();
                                    ?>

                                    

                                </ul>
                            </div>
    
                        </div>
                    </div>
    
                </div>
    
            </div>
        </div>

        <div class="container">
            <div class="col-md-12">
                <div class="messageFormContainer">

                    <form method="post" action="" id="dataForm" class="dataForm">
                        <input type="text" id="requestData" class="textbox" placeholder="Type To Start Writing...">
                        <div class="btnContainer"><ion-icon name="arrow-redo-outline"></ion-icon></div>
                        <img src="assets/images/loading.svg" class="loadingIcon">
                    </form>

                </div>
            </div>
        </div>
                        	
            
        <?php
                
            if( $_SESSION['userType'] == 'nurse' ){
                    
                provider_bottom_nav();
                    
            }elseif( $_SESSION['userType'] == 'doctor' ){
                    
                physician_bottom_nav();
                    
            }else{
                    
                bottom_nav();
                    
            }
        ?>
        
    </body>
</html>