<!DOCTYPE html>
<html>
<head>
	<title>DDXRX - Teams</title>
	
	<link rel="stylesheet" type="text/css" href="../assets/css/reset.css">
	<link rel="stylesheet" type="text/css" href="../assets/css/grid.css">
	<link rel="stylesheet" type="text/css" href="//cdn.datatables.net/1.10.21/css/jquery.dataTables.min.css">
	<link rel="stylesheet" type="text/css" href="../assets/css/teams.css">
	
	<script type="text/javascript" src="https://ajax.googleapis.com/ajax/libs/jquery/3.4.1/jquery.min.js"></script>
	<script type="text/javascript" src="assets/js/sweetalert2.min.js"></script>
	<script type="text/javascript" src="//cdn.datatables.net/1.10.21/js/jquery.dataTables.min.js"></script>
	
	<script>
	    $(document).ready( function () {
	        
	        var tempData = '<select><option>Team A1</option><option>Team A2</option><option>Team A3</option><option>Team B1</option><option>Team B2</option><option>Team B3</option><option>Team C1</option><option>Team C2</option><option>Team C3</option></select>';
	        
	        // Init Data Table
            $('#main-table').DataTable();
            
            var sidebarHeight = $(window).height();
            $('.sidebar').css( 'height',sidebarHeight );
            
            // Search Box
            $(".search-bar").on("change paste keyup", function() {
                
                var qryStr = $(".search-bar").val();
                
                $.get("../process/search-teams.php?search_qry="+qryStr, function(data, status){
                    
                    if( data.result == 'true' ){
                        if( qryStr.length >= 3 ){
                            
                            // Reset result
                            $('.search-result-list ul').html('');
                            
                            let result = data.items;
            			    for (let item of result) {
            			      			
            			      	console.log( item.patient_fname+' '+item.patient_lname );
            			      	$('.search-result-list ul').append( '<li data-fname="'+item.patient_fname+'" data-lname="'+item.patient_lname+'" data-dob="'+item.patient_dob+'" data-patient-id="'+item.patient_id+'" ><span class="item">'+item.patient_fname+' '+item.patient_lname+'</span> <a href="javascript:;" class="button">Add</a></li>' );
            			      	
            			    }
            			    
            			    $('.search-result-list').show();
                            
                        }
                    }
                    
                });
                
            });
            
            // Close Search Result List
            $('html').click(function(){
                $('.search-result-list').hide(); 
            });
            
            // Add user to list
            $('body').on('click', '.search-result-list li a.button', function() {
                
                var fname = $(this).parent().attr('data-fname');
                var lname = $(this).parent().attr('data-lname');
                var dob = $(this).parent().attr('data-dob');
                var patient_id = $(this).parent().attr('data-patient-id');
                
                $('#main-table tbody').append('<tr><td>'+patient_id+'</td><td>'+fname+'</td><td>'+lname+'</td><td>'+dob+'</td><td>'+tempData+'</td></tr>');
                $('.search-bar').val('');
                $('.search-result-list').hide();
                
            });
            
        });
        
	</script>
	
</head>
<body>
    
    
    
    <!-- Sidebar -->
    <div class="sidebar">
        <div class="padded">
            
            <ul class="nav">
                <li><a href="#">Patients</a></li>
                <li><a href="#">Nurse</a></li>
                <li><a href="#">Physicians</a></li>
                <li><a href="#">Manage Teams</a></li>
                <li><a href="#">Logout</a></li>
            </ul>
            
        </div>
    </div>
    <!-- Sidebar -->
    
    <!-- Content -->
    <div class="content-container">
        <div class="padded">
            
            <!-- Search Container -->
            <div class="search-container">
                <input type="text" placeholder="Enter Patient Name" class="search-bar">
                <button class="search-btn">Search</button>
                <div class="search-result-list">
                    
                    <ul>
                        <!--
                        <li><span class="item">Jonathan Cabato</span> <a href="javascript:;" class="button">Add</a></li>
                        <li><span class="item">Azad Kabir</span> <a href="javascript:;" class="button">Add</a></li>
                        <li><span class="item">Vinit Akarekar</span> <a href="javascript:;" class="button">Add</a></li>
                        <li><span class="item">Ritesh Rsengar</span> <a href="javascript:;" class="button">Add</a></li>
                        -->
                    </ul>
                    
                </div>
            </div>
            <!-- Search Container -->
            
    
            <table id="main-table">
                    
                    <thead>
                        <tr>
                            <td>Patient ID</td>
                            <td>First Name</td>
                            <td>Last Name</td>
                            <td>Date of Birth</td>
                            <td>Team</td>
                        </tr>
                    </thead>
                    
                    <tbody>
                        <tr>
                            <td>2</td>
                            <td>Jonathan</td>
                            <td>Cabato</td>
                            <td>June/01/1988</td>
                            <td><select><option>Team A1</option><option>Team A2</option><option>Team A3</option><option>Team B1</option><option>Team B2</option><option>Team B3</option><option>Team C1</option><option>Team C2</option><option>Team C3</option></select></td>
                        </tr>
                        
                        <tr>
                            <td>3</td>
                            <td>Azad</td>
                            <td>Kabir</td>
                            <td>September/25/1960</td>
                            <td><select><option>Team A1</option><option>Team A2</option><option>Team A3</option><option>Team B1</option><option>Team B2</option><option>Team B3</option><option>Team C1</option><option>Team C2</option><option>Team C3</option></select></td>
                        </tr>
                        
                        <tr>
                            <td>118</td>
                            <td>Ritesh</td>
                            <td>Sengar</td>
                            <td>January/16/1990</td>
                            <td><select><option>Team A1</option><option>Team A2</option><option>Team A3</option><option>Team B1</option><option>Team B2</option><option>Team B3</option><option>Team C1</option><option>Team C2</option><option>Team C3</option></select></td>
                        </tr>
                    </tbody>
                    
                </table>
            <div class="clear"></div>
        
        </div>
    </div>
    
</body>
</html>