<?php
// Create a new instance of Mobile_Detect
$detect = new Mobile_Detect;
?>

<!-- Sidebar -->
<div class="sidebar">
    <div class="inner">

        <div class="nav">
            <a href="javascript:;" class="active sidebar-link msg">Messages</a>
            <a href="javascript:;" class="sidebar-link contact-list">Contacts</a>
            <div class="clear"></div>
        </div>

        <!-- Chat List -->
        <div class="thread-list messages active">

            <ul class="patient-thread-list">
            <li class="label">Messages</li>
            <?php
                $conn = ddxrxDBConnect('telemedicine');
                $userid = $session['userid'];
                $groupID = $session['group_id'];
                //$sql = "SELECT * FROM `rooms` WHERE group_id = '$groupID' ORDER BY msg_date ASC";
                $sql = "SELECT r.* FROM `rooms` r INNER JOIN (SELECT room_id, MIN(id) as min_id FROM `rooms` WHERE group_id = '$groupID' GROUP BY room_id) grouped_rooms ON r.room_id = grouped_rooms.room_id AND r.id = grouped_rooms.min_id WHERE r.group_id = '$groupID' ORDER BY r.last_update DESC;";
                $result = $conn->query($sql);
                            
                if ($result->num_rows > 0) {
                    while($row = $result->fetch_assoc()) {
                        
                        if( $row['status'] == 'unread' ){
                            $status = '<ion-icon name="alert-circle" class="unreadIcon"></ion-icon>';
                        }else{
                            $status = '';
                        }
                        
                        echo '
                            <li class="thread-item" data-user-id="'.$row['room_owner'].'" id="user_id_'.$row['room_owner'].'">
                                <a href="javascript:;" data-user-id="'.$row['room_owner'].'" data-name="'.$row['room_name'].'">
                                    <span class="ion-container">
                                    <ion-icon name="person-circle-outline"></ion-icon>
                                    '.$status.'
                                    </span>
                                    <span>'.$row['room_name'].'</span>
                                </a>
                                <div class="clear"></div>
                            </li>
                        ';
                    }
                }else{

                    echo '<p>No messages yet.</p>';

                }

                $conn->close();
                
            ?>
            </ul>

        </div>
        <!-- Chat List -->

        <!-- Contact List -->
        <div class="thread-list contacts">
            
            <div class="contact-search-container">
                <ion-icon name="search"></ion-icon>
                <input type="text" placeholder="Search Contact List" class="search searchBox">
            </div>
            
            <!-- Default Contact List -->
            <div class="default-contact-list">
                <ul class="patient-contact-list">
                <li class="label">Patients</li>
                <?php
                    $conn = ddxrxDBConnect('telemedicine');
                    $groupID = $session['group_id'];
                    $sql = "SELECT * FROM `all_users` INNER JOIN `patients` ON all_users.userid = patients.user_id WHERE all_users.groupid = '$groupID' LIMIT 30,15";
                    $result = $conn->query($sql);
                                
                    if ($result->num_rows > 0) {
                        while($row = $result->fetch_assoc()) {
                            echo '
                                <li class="thread-item">
                                    <a href="javascript:;" data-user-id="'.$row['user_id'].'" data-name="'.$row['patient_fname'].' '.$row['patient_lname'].'">
                                        <ion-icon name="person-circle-outline"></ion-icon>
                                        <span>'.$row['patient_fname'].' '.$row['patient_lname'].'</span>
                                    </a>
                                    <div class="clear"></div>
                                </li>
                            ';
                        }
                    }

                    $conn->close();
                    
                ?>
                </ul>
                <a href="javascript:;" class="load_patients" data-page="1">Load More</a>
                
                <!--
                <ul>
                <li class="label mt">Physician</li>
                <?php
                    /*
                    $conn = ddxrxDBConnect('telemedicine');
                    $groupID = $session['group_id'];
                    $sql = "SELECT * FROM `all_users` INNER JOIN `physician` ON all_users.userid = physician.user_id WHERE all_users.groupid = '$groupID' LIMIT 5";
                    $result = $conn->query($sql);
                    
                    if ($result->num_rows > 0) {
                        while($row = $result->fetch_assoc()) {
                            echo '
                                <li class="thread-item">
                                    <a href="javascript:;" data-user-id="'.$row['user_id'].'" data-name="'.$row['physician_fname'].' '.$row['physician_lname'].'">
                                        <ion-icon name="person-circle-outline"></ion-icon>
                                        <span>'.$row['physician_fname'].' '.$row['physician_lname'].'</span>
                                    </a>
                                    <div class="clear"></div>
                                </li>
                            ';
                        }
                    }

                    $conn->close();
                    */
                ?>
                </ul>
                -->
                
                <!--
                <ul>
                <li class="label mt">Nurse</li>
                <?php
                    /*
                    $conn = ddxrxDBConnect('telemedicine');
                    $sql = "SELECT * FROM `all_users` INNER JOIN `nurse` ON all_users.userid = nurse.user_id WHERE all_users.groupid = '$groupID' LIMIT 5";
                    $result = $conn->query($sql);

                    if ($result->num_rows > 0) {
                        while($row = $result->fetch_assoc()) {
                            echo '
                                <li class="thread-item">
                                    <a href="javascript:;" data-user-id="'.$row['user_id'].'" data-name="'.$row['nurse_fname'].' '.$row['nurse_lname'].'">
                                        <ion-icon name="person-circle-outline"></ion-icon>
                                        <span>'.$row['nurse_fname'].' '.$row['nurse_lname'].'</span>
                                    </a>
                                    <div class="clear"></div>
                                </li>
                            ';
                        }
                    }

                    $conn->close();
                    */
                ?>
                </ul>
                -->
            </div>
            <!-- Default Contact List -->

            <!-- Search Contact List -->
            <div class="search-result-contact-list" style="display: none">
                <ul class="search-contact-list"></ul>
            </div>
            <!-- Search Contact List -->

        </div>
        <!-- Contact List -->

    </div>
</div>
<!-- Sidebar -->

<!-- Chat Wrapper -->
<div class="chat-wrapper">
    
    <?php if( !$detect->isMobile() ){ ?>
        <!-- Init chat message -->
        <div class="chat-init-container">
            <div class="inner">
                <img src="assets/images/chat-empty.png" class="illustration">
                <h1>Welcome to your chat hub! <span>Ready to connect?</span></h1>
                <p>Choose a patient thread to begin your dialogue,<br>
                whether you're following up on past conversations or starting fresh.</p>
            </div>
        </div>
        <!-- Init chat message -->
    <?php } ?>

    <!-- Chat Header -->
    <div class="chat-header">
        <ion-icon name="person-circle-outline"></ion-icon>
        <div class="desc">
            <h6 class="name"></h6>
            <p class="status">Offline</p>
        </div>

        <div class="chat-tools">
            <ul>
                <li><a href="javascript:;" class="videocall-btn"><ion-icon name="videocam-outline"></ion-icon></a></li>
            </ul>
        </div>

    </div>
    <!-- Chat Header -->

    <!-- Chat List -->
    <ul id="messages" class="message-list provider" data-sender-id="<?php echo $session['userid']; ?>" data-sender-name="<?php echo $session['first_name'] .' '. $session['last_name']; ?>" data-group="0" data-has-room="" data-user-type="<?php echo $session['user_type']; ?>" data-version="<?php echo $session['group_id']; ?>">
    <?php
        //$sql = "SELECT * FROM `messages` WHERE room_id = '3' ORDER BY `messages`.`id` ASC LIMIT 50";
        $sql = "SELECT * FROM(SELECT * FROM `messages` WHERE `room_id` = '0' ORDER BY `id` DESC LIMIT 50) AS sub ORDER BY id ASC;";

        $result = ddxrxDBConnect('telemedicine')->query($sql);

        if ($result) {
            if ($result->num_rows > 0) {
                while ($row = $result->fetch_assoc()) {
                    echo '<li class="chatItem"><ion-icon name="person-circle-outline"></ion-icon><div class="content"><h6 class="username">' . $row['sender_name'] . '</h6><div class="messageContainer">' . $row['msg'] . '</div><div class="time-lapsed" data-time="' . $row['sent_date'] . '">...</div></div><div class="clear"></div></li>';
                }
            } else {
                echo '<li class="chatItem"><div class="systemContent info">No chat history yet. Write message and send.</div></li>';
            }

            $result->free_result();
            ddxrxDBConnect('telemedicine')->close();
            
        } else {
            echo "Query execution failed.";
        }
    ?>
    </ul>
    <!-- Chat List -->

    <!-- Chat Form -->
    <div class="form-container-alt">
        <form action="/" method="POST" id="chatForm">

            <!-- Nav Menu Icon -->
            <div class="nav-menu-icon">
                <div class="nav-menu">
                    <span><ion-icon name="menu-sharp"></ion-icon></span>
                </div>
            </div>
            <!-- Nav Menu Icon -->

            <div class="msgForm">
                <p id="typing"></p>
                <!-- <input class="msgInput" id="txt" autocomplete="off" autofocus="on" oninput="isTyping()" placeholder="Type your message here..."> -->
                <input class="msgInput" id="txt" autocomplete="off" autofocus="on" placeholder="Type your message here...">
                <button class="msgButton">Send Message</button>
            </div>

        </form>
    </div>
    <!-- Chat Form -->

</div>
<!-- Chat Wrapper -->

<!-- Navigation Menu -->
<div class="navigation-container">

    <ion-icon name="close-circle-outline" class="close-nav-btn"></ion-icon>

    <div class="inner">
        <ul>
            <li><a href="javascript:;" class="nav-link msg">Messages</a></li>
            <li><a href="javascript:;" class="nav-link contact-list">Contact List</a></li>
            <li><a href="logout.php" class="nav-link logout">Logout</a></li>
        </ul>
    </div>
</div>
<!-- Navigation Menu -->

<!-- Video call list -->
<div class="vc-list-container">
    <div class="videocall-list">
        <div class="searchBar">
            <input type="text" name="search" class="search" placeholder="Search...">
        </div>
        <div class="inner">
            <ul class="vc-call-list"></ul>
        </div>
    </div>
</div>
<!-- Video call list -->