$(document).ready(function(){

    $('.rpm-popup-container .popup-widget .closePopup').click(function(){
        $('.rpm-popup-container').fadeOut();
    });

    $('body').on('click', '.rpm-btn', function() {

        var patient_id = $(this).data('patient-id');

        var btntype = '';
        if( $(this).hasClass("delete") ){
            btntype = 'delete';
        }else{
            btntype = 'edit';
        }

        if( btntype == 'delete' ){

            Swal.fire({
                title: "Are you sure?",
                text: "You won't be able to revert this!",
                icon: "warning",
                showCancelButton: true,
                confirmButtonColor: "#3085d6",
                cancelButtonColor: "#d33",
                confirmButtonText: "Yes, delete it!"
            }).then((result) => {
                if (result.isConfirmed) {
                    
                    $.ajax({
                        url: 'process/rpm-delete.php',
                        type: 'POST',
                        data: {
                            patient_id: patient_id
                        },
                        success: function(data) {
                            
                            $( '#patient_'+patient_id ).remove();
                            Swal.fire({
                                title: 'IMEI Deleted',
                                text: 'The imei number was successfully deleted',
                                icon: 'success',
                            })
        
                        },
                        error: function(data) {
                            
                            Swal.fire({
                                title: 'Oops...',
                                text: 'Something went wrong!',
                                icon: 'error',
                            })
        
                        }
                    });

                }
            });

        }else if( btntype = 'edit' ){

            var currentIMEI = $('#patient_'+patient_id+'_imei').html();
            var imei = $('.rpm-popup-container .popup-widget .textbox').val();

            $('.rpm-popup-container').css('display','flex');

            $('.rpm-popup-container .popup-widget .textbox').val(currentIMEI);

            $('.rpm-popup-container').attr('data-patient-id',patient_id);

        }

    });

    $('.rpm-popup-container .popup-widget .btn-submit-rpm').click(function(){

        var patient_id = $(this).parent().parent().data('patient-id');
        var imei = $('.rpm-popup-container .popup-widget .textbox').val();

        $.ajax({
            url: 'process/rpm-edit.php',
            type: 'POST',
            data: {
                patient_id: patient_id,
                imei: imei
            },
            success: function(data) {
                
                $('.rpm-popup-container').hide();
                $( '#patient_'+patient_id+'_imei' ).html(imei);

                Swal.fire({
                    title: 'Updated',
                    text: 'The imei number was successfully updated',
                    icon: 'success',
                });

            },
            error: function(data) {
                
                Swal.fire({
                    title: 'Oops...',
                    text: 'Something went wrong!',
                    icon: 'error',
                });

            }
        });

    });

});