<?php
session_start();  
if(!isset($_SESSION['name']) || $_SESSION['user_type'] != "admin") {
    header("Location: login.php");
}
?>
<!DOCTYPE html>
<html>
<head>
  <meta charset="utf-8">
  <meta http-equiv="X-UA-Compatible" content="IE=edge">
  <title>Provider - DDxRx Admin Panel | Dashboard</title>

    <!-- JQuery CDN -->
    <script src="https://ajax.googleapis.com/ajax/libs/jquery/3.3.1/jquery.min.js"></script>

    <!-- Scripts -->
    <script type="text/javascript" src="dist/js/physician-script.js"></script>

  <!-- Tell the browser to be responsive to screen width -->
  <meta content="width=device-width, initial-scale=1, maximum-scale=1, user-scalable=no" name="viewport">
  <!-- Bootstrap 3.3.7 -->
  <link rel="stylesheet" href="bower_components/bootstrap/dist/css/bootstrap.min.css">
  <!-- Font Awesome -->
  <link rel="stylesheet" href="bower_components/font-awesome/css/font-awesome.min.css">
  <!-- Ionicons -->
  <link rel="stylesheet" href="bower_components/Ionicons/css/ionicons.min.css">
  <!-- Theme style -->
  <link rel="stylesheet" href="dist/css/AdminLTE.min.css">
  <!-- AdminLTE Skins. Choose a skin from the css/skins
       folder instead of downloading all of them to reduce the load. -->
  <link rel="stylesheet" href="dist/css/skins/_all-skins.min.css">
  <!-- Morris chart -->
  <link rel="stylesheet" href="bower_components/morris.js/morris.css">
  <!-- jvectormap -->
  <link rel="stylesheet" href="bower_components/jvectormap/jquery-jvectormap.css">
  <!-- Date Picker -->
  <link rel="stylesheet" href="bower_components/bootstrap-datepicker/dist/css/bootstrap-datepicker.min.css">
  <!-- Daterange picker -->
  <link rel="stylesheet" href="bower_components/bootstrap-daterangepicker/daterangepicker.css">
  <!-- bootstrap wysihtml5 - text editor -->
  <link rel="stylesheet" href="plugins/bootstrap-wysihtml5/bootstrap3-wysihtml5.min.css">

  <!-- HTML5 Shim and Respond.js IE8 support of HTML5 elements and media queries -->
  <!-- WARNING: Respond.js doesn't work if you view the page via file:// -->
  <!--[if lt IE 9]>
  <script src="https://oss.maxcdn.com/html5shiv/3.7.3/html5shiv.min.js"></script>
  <script src="https://oss.maxcdn.com/respond/1.4.2/respond.min.js"></script>
  <![endif]-->

  <!-- Google Font -->
  <link rel="stylesheet" href="https://fonts.googleapis.com/css?family=Source+Sans+Pro:300,400,600,700,300italic,400italic,600italic">
  
  <script type="text/javascript" src="../assets/js/jquery.min.js"></script>
  <script type="text/javascript" src="https://cdn.jsdelivr.net/npm/sweetalert2@9"></script>
  <script type="text/javascript">
    $(document).ready(function() {
        
        $(".form-control.username").on("change paste keyup", function(e) {
            var username = $(this).val();
            $.get("checkProvider.php?username="+username, function(data, status){
                
                if( data.rstatus == 'exist' ){
                    $('.add-physician').attr("disabled", true);
                    $('#username-error').show();
                    $('.preventOverlay').show();
                }else{
                    $('#username-error').hide();
                    $('.add-physician').removeAttr("disabled");
                    $('.preventOverlay').hide();
                }
                
            });
        });
        
        $('body').on('click', '.preventOverlay', function() {
            Swal.fire({
                icon: 'error',
                title: 'Username already exist',
                text: 'Sorry but the username you are trying to use is already taken.',
            });
        });
        
    });
  </script>
  
  <style>
      .preventOverlay{
          position: absolute;
          top:0px;
          left: 0px;
          width: 100%;
          height: 50px;
          background: rgba(255,255,255, 0);
          z-index: 999;
          display: none;
          cursor: not-allowed;
      }
      
    .text-error {
	    color: #ff0000;
	    text-align: left !important;
	}
	
	form .error {
	  color: #ff0000;
	  text-align: left !important;
	}

    .label-text{
        font-weight: 500;
        position: relative;
        top:-2px;
        margin-left: 3px;
        margin-right: 10px;
    }
  </style>
  
</head>

<body class="hold-transition skin-blue sidebar-mini">
<div class="wrapper">
  <?php
    include('includes/header.php');
    include('includes/sidebar.php');
  ?>

  <!-- Content Wrapper. Contains page content -->
  <div class="content-wrapper">
    <!-- Content Header (Page header) -->
    <section class="content-header">
      <h1>
        Add new provider
        <small>Providers</small>
      </h1>
      <ol class="breadcrumb">
        <li><a href="#"><i class="fa fa-dashboard"></i> Home</a></li>
        <li class="active">Add Provider</li>
      </ol>
    </section>
    <!-- Main content -->
    <section class="content">
        <!-- Small boxes (Stat box) -->
        <div class="row">
            <div class="col-md-12">
                <div class="box box-primary">
                    <!-- <form method="POST" action="addProvider.php" name="new_provider_form"> -->
                    <form method="POST" action="process/add_physician.php" id="new_provider_form" name="new_provider_form">
                        <div class="container-fluid">
                            <br>
                            Login Details
                            <hr>
                            <div class="row form-group">
                                <div class="col-md-2">
                                    <label>Username:</label>
                                </div>
                                
                                <div class="col-md-4">
                                    <input type="text" name="username" id="username" minlength="5" class="form-control username" required>
                                    <label id="username-error" class="text-error" for="username" style="display: none;">Username is not available.</label>
                                </div>
                                
                                <div class="col-md-2">
                                    <label>Password:</label>
                                </div>
                                <div class="col-md-4">
                                    <input type="password" name="password" class="form-control" minlength="5" required>
                                </div>
                            </div>
                            
                            Personal Details
                            <hr>
                            <div class="row form-group">
                                <div class="col-md-2">
                                    <label>First Name:</label>
                                </div>
                                
                                <div class="col-md-4">
                                    <input type="text" name="fname" class="form-control" required>
                                </div>
                                
                                <div class="col-md-2">
                                    <label>Last Name:</label>
                                </div>
                                
                                <div class="col-md-4">
                                    <input type="text" name="lname" class="form-control" required>
                                </div>
                            </div>
                            
                            <div class="row form-group">
                                <div class="col-md-2">
                                    <label>Date of Birth:</label>
                                </div>
                                
                                <div class="col-md-4">
                                    <input type="date" name="dob" class="form-control" required>
                                </div>
                                
                                <div class="col-md-2">
                                    <label>Gender:</label>
                                </div>
                                
                                <div class="col-md-4">
                                    <select class="form-control" name="gender" required>
                                        <option value="male">Male</option>
                                        <option value="female">Female</option>
                                    </select>
                                </div>
                            </div>
                            
                            <div class="row form-group">
                                <div class="col-md-2">
                                    <label>Degree:</label>
                                </div>
                                
                                <div class="col-md-4">
                                    <select class="form-control" name="degree" required>
                                        <option value="">Select..</option>
                                        <option value="MD">M.D.</option>
                                        <option value="DO">DO</option>
                                        <option value="NP">NP</option>
                                        <option value="PA">PA</option>
                                    </select>
                                </div>
                                
                                <div class="col-md-2">
                                    <label>Speciality:</label>
                                </div>
                                
                                <div class="col-md-4">
                                    <input type="text" name="speciality" class="form-control" required>
                                </div>
                            </div>
                            
                            <div class="row form-group">
                                <div class="col-md-2">
                                    <label>Cell Number:</label>
                                </div>
                                
                                <div class="col-md-4">
                                    <!--<input type="text" name="country_code" class="form-control" style="width: 10%; float: left; border-right: 0px; outline: none" placeholder="+63">-->
                                    <input type="number" name="cell_number" class="form-control" required>
                                </div>
                                
                                <div class="col-md-2">
                                    <label>Email:</label>
                                </div>
                                
                                <div class="col-md-4">
                                    <input type="email" name="physician_email" class="form-control" placeholder="physician@email.com" required>
                                </div>
                            </div>

                            <!-- Video Training -->
                            <!-- <div class="row form-group">

                                <div class="col-md-2">
                                    <label>Select Video Training:</label>
                                </div>

                                <div class="col-md-10">
                                    
                                    <label style="position: relative">
                                        <input type="checkbox" name="video_set" value="video_set_1">
                                        <span class="label-text">Clinical Assist Email Pitch</span>
                                    </label>

                                    <label style="position: relative">
                                        <input type="checkbox" name="video_set" value="video_set_2">
                                        <span class="label-text">Clinical Assist for Hospital</span>
                                    </label>

                                    <label style="position: relative">
                                        <input type="checkbox" name="video_set" value="video_set_3">
                                        <span class="label-text">Clinical Assist Introduction</span>
                                    </label>

                                    <label style="position: relative">
                                        <input type="checkbox" name="video_set" value="video_set_4">
                                        <span class="label-text">Clinical Assist Medical Disclaimer</span>
                                    </label>

                                    <label style="position: relative">
                                        <input type="checkbox" name="video_set" value="video_set_5">
                                        <span class="label-text">Clinical Assist Primary Care</span>
                                    </label>

                                    <label style="position: relative">
                                        <input type="checkbox" name="video_set" value="video_set_6">
                                        <span class="label-text">Clinical Assist Fall Alert</span>
                                    </label>

                                    <label style="position: relative">
                                        <input type="checkbox" name="video_set" value="video_set_7">
                                        <span class="label-text">Clinical Assist Urgent Care Clinics</span>
                                    </label>

                                    <label style="position: relative">
                                        <input type="checkbox" name="video_set" value="video_set_8">
                                        <span class="label-text">Clinic Owner RPM Training</span>
                                    </label>

                                    <label style="position: relative">
                                        <input type="checkbox" name="video_set" value="video_set_9">
                                        <span class="label-text">Doctor Ai Introduction</span>
                                    </label>

                                    <label style="position: relative">
                                        <input type="checkbox" name="video_set" value="video_set_10">
                                        <span class="label-text">Doctor Ai RPM Onboarding</span>
                                    </label>

                                    <label style="position: relative">
                                        <input type="checkbox" name="video_set" value="video_set_11">
                                        <span class="label-text">Doctor Ai RPM Phone Call Training</span>
                                    </label>

                                    <label style="position: relative">
                                        <input type="checkbox" name="video_set" value="video_set_12">
                                        <span class="label-text">Doctor Ai RPM Pitch</span>
                                    </label>

                                    <label style="position: relative">
                                        <input type="checkbox" name="video_set" value="video_set_13">
                                        <span class="label-text">Doctor Ai RPM</span>
                                    </label>

                                    <label style="position: relative">
                                        <input type="checkbox" name="video_set" value="video_set_14">
                                        <span class="label-text">RPM Engagement Rules</span>
                                    </label>
                                </div>

                            </div> -->
                            <!-- End Video Training -->
                            
                            <div class="row form-group">
                                <div class="col-md-4 col-md-offset-4">
                                    <div class="preventOverlay"></div>
                                    <button class="btn btn-primary col-md-12 add-physician">Add Provider</button>
                                </div>
                            </div>

                        </div>
                    </form>
                </div>
            </div>
        </div>
      <!-- /.row -->
    </section>
    <!-- /.content -->
  </div>
  <!-- /.content-wrapper -->
  <footer class="main-footer">
    <div class="pull-right hidden-xs">
      <b>Version</b> 2.4.0
    </div>
    <strong>Copyright &copy; 2014-2016 <a href="https://adminlte.io">Almsaeed Studio</a>.</strong> All rights
    reserved.
  </footer>
  <!-- Add the sidebar's background. This div must be placed
       immediately after the control sidebar -->
  <div class="control-sidebar-bg"></div>
</div>
<!-- ./wrapper -->

<!-- jQuery 3 -->
<script src="bower_components/jquery/dist/jquery.min.js"></script>


<script src="https://cdnjs.cloudflare.com/ajax/libs/jquery-validate/1.19.1/jquery.validate.min.js"></script>
<!--<script src="https://cdn.jsdelivr.net/jquery.validation/1.16.0/additional-methods.min.js"></script>-->

<!-- jQuery UI 1.11.4 -->
<script src="bower_components/jquery-ui/jquery-ui.min.js"></script>
<!-- Resolve conflict in jQuery UI tooltip with Bootstrap tooltip -->
<script>
  $.widget.bridge('uibutton', $.ui.button);
</script>
<!-- Bootstrap 3.3.7 -->
<script src="bower_components/bootstrap/dist/js/bootstrap.min.js"></script>
<!-- Morris.js charts -->
<script src="bower_components/raphael/raphael.min.js"></script>
<script src="bower_components/morris.js/morris.min.js"></script>
<!-- Sparkline -->
<script src="bower_components/jquery-sparkline/dist/jquery.sparkline.min.js"></script>
<!-- jvectormap -->
<script src="plugins/jvectormap/jquery-jvectormap-1.2.2.min.js"></script>
<script src="plugins/jvectormap/jquery-jvectormap-world-mill-en.js"></script>
<!-- jQuery Knob Chart -->
<script src="bower_components/jquery-knob/dist/jquery.knob.min.js"></script>
<!-- daterangepicker -->
<script src="bower_components/moment/min/moment.min.js"></script>
<script src="bower_components/bootstrap-daterangepicker/daterangepicker.js"></script>
<!-- datepicker -->
<script src="bower_components/bootstrap-datepicker/dist/js/bootstrap-datepicker.min.js"></script>
<!-- Bootstrap WYSIHTML5 -->
<script src="plugins/bootstrap-wysihtml5/bootstrap3-wysihtml5.all.min.js"></script>
<!-- Slimscroll -->
<script src="bower_components/jquery-slimscroll/jquery.slimscroll.min.js"></script>
<!-- FastClick -->
<script src="bower_components/fastclick/lib/fastclick.js"></script>
<!-- AdminLTE App -->
<script src="dist/js/adminlte.min.js"></script>
<!-- AdminLTE dashboard demo (This is only for demo purposes) -->
<script src="dist/js/pages/dashboard.js"></script>
<!-- AdminLTE for demo purposes -->
<script src="dist/js/demo.js"></script>

</body>
</html>
