<?php

// Set header to JSON
header('Content-Type: application/json');

// Check if the user has sent the patient_id
if (!isset($_POST['patient_id'])) {
    $output = array(
        'status' => false,
        'title' => 'Error',
        'text' => 'Patient ID not provided',
        'icon' => 'error'
    );
    echo json_encode($output);
    exit();
}

// Include the database connection file
include('../../process/functions.php');

// Set Database Connection
$conn = ddxrxDBConnect();

// Get the patient ID
$patient_id = $_POST['patient_id'];

// Get other details of the patient
$firstname = $_POST['patient_fname'];
$lastname = $_POST['patient_lname'];
$email = $_POST['email_address'];
$dob = $_POST['patient_dob'];
$cell = $_POST['cell'];

// Set password variable
if (isset($_POST['password'])) {
    $password = $_POST['password'];
    $password = ddxrxDBConnect()->real_escape_string($password);
    $password = password_hash($password, PASSWORD_BCRYPT);
} else {
    $password = '';
}

// Check if other details are empty
if (empty($patient_id) || empty($firstname) || empty($lastname) || empty($email) || empty($dob) || empty($cell)) {

    // Show which field is empty in a variable

    $output = array(
        'status' => false,
        'title' => 'Error',
        'text' => 'Please fill in all the fields',
        'icon' => 'error',
        //'field' => empty($patient_id) ? 'patient_id' : (empty($firstname) ? 'patient_fname' : (empty($lastname) ? 'patient_lname' : (empty($email) ? 'email_address' : (empty($username) ? 'username' : (empty($dob) ? 'patient_dob' : (empty($cell) ? 'cell' : ''))))))
    );
    echo json_encode($output);
    exit();
}

// Edit the patient record
// Multiple queries to update the patient record and all_users
if (!empty($password)) {
    // Update with password
    $sql = "UPDATE patients JOIN all_users ON patients.user_id = all_users.userid SET patients.patient_fname = '$firstname', patients.patient_lname = '$lastname', all_users.email_address = '$email', patients.patient_dob = '$dob', patients.cell = '$cell', all_users.email_address = '$email', all_users.password_new = '$password' WHERE patients.user_id = '$patient_id';";

} else {
    // Update without password
    $sql = "UPDATE `patients` SET `patient_fname` = '$firstname', `patient_lname` = '$lastname', `email_address` = '$email', `patient_dob` = '$dob', `cell` = '$cell' WHERE `user_id` = '$patient_id'";
}

// Execute the query
if ($conn->query($sql) === TRUE) {
    $output = array(
        'status' => true,
        'title' => 'Success',
        'text' => 'Patient record updated successfully',
        'icon' => 'success'
    );
} else {
    $output = array(
        'status' => false,
        'title' => 'Error',
        'text' => 'Failed to update patient record',
        'icon' => 'error'
    );
}

echo json_encode($output);
exit();