<?php

// Send JSON response
header('Content-Type: application/json');

// Include the functions file
include('../../process/functions.php');

$userID = $_POST['userID'];
$first_name = $_POST['first_name'];
$last_name = $_POST['last_name'];
$is_https = (isset($_SERVER['HTTPS']) && $_SERVER['HTTPS'] === 'on') ? 'https://' : 'http://';

//$path = $is_https.get_version('url').'/profile-images/';
$path = $is_https.get_version('url').'/ddxrx-main/profile-images/';
//$path = 'https://c44c-104-245-38-248.ngrok-free.app/ddxrx-main/profile-images/';

// Check if the file is uploaded successfully
if ($_FILES['file']['error'] === UPLOAD_ERR_OK) {

    $file = $_FILES['file'];
  
    // Check if the uploaded file is an image
    $imageTypes = ['image/jpeg', 'image/png'];
    if (in_array($file['type'], $imageTypes)) {

        // Generate a random filename
        $extension = pathinfo($file['name'], PATHINFO_EXTENSION);
        $filename = generateRandomString() . '.' . $extension;
        $destination = '../../profile-images/' . $filename;
        $vector_img = $path.$filename;

        // Move the uploaded file to the destination folder
        if (move_uploaded_file($file['tmp_name'], $destination)) {

            // Register the filename in the database
            $registered = registerFilenameInDatabase($userID, $first_name, $last_name, $filename, $vector_img);
          
            if ($registered) {
                // Return JSON response with success status and additional parameters
                $response = [
                    'success' => true,
                    'filename' => $filename,
                    'file_path' => $path,
                    'message' => 'Image uploaded and registered successfully.',
                ];
            } else {
                $response = [
                    'success' => false,
                    'message' => 'Failed to register the filename in the database.'
                ];
            }

        } else {

            $response = [
                'success' => false,
                'message' => 'Failed to move the uploaded file.'
            ];

        }

    } else {

        $response = [
            'success' => false,
            'message' => 'Invalid file format. Only JPEG and PNG images are allowed.'
        ];

    }

} else {

    $response = [
        'success' => false,
        'message' => 'Failed to upload the file.'
    ];

}


echo json_encode($response);

// Generate a random string for the filename
function generateRandomString($length = 10) {

    $characters = '0123456789abcdefghijklmnopqrstuvwxyz';

    $randomString = '';

    for ($i = 0; $i < $length; $i++) {
        $randomString .= $characters[rand(0, strlen($characters) - 1)];
    }

    return $randomString;

}

function profileExist( $userID ){

    /*
    False = User not found in database
    True = User found in database
    */

    if( !empty($userID) ){

        $sql = "SELECT * FROM `user_profile` WHERE `user_id` = '$userID' LIMIT 1";
        $result = ddxrxDBConnect()->query($sql);

        // Associative array
        $row = $result -> fetch_assoc();

        if (empty($row)) {
            $output = false;
        } else {
            $output = true;
        }

        // Free result set
        $result -> free_result();

        ddxrxDBConnect()->close();

    }else{

        $output = null;

    }

    return $output;

}

function userVerificationID($userID){

        $sql = "SELECT * FROM `all_users` WHERE `userid` = '$userID' LIMIT 1";
        $result = ddxrxDBConnect()->query($sql);

        // Associative array
        $row = $result -> fetch_assoc();

        // Free result set
        $result -> free_result();

        ddxrxDBConnect()->close();

        return $row['unique_id'];

}

// Function to register the filename in the database
function registerFilenameInDatabase($userID, $first_name, $last_name, $filename, $image) {

    // Convert image into vector
    $converted_img = convertToVector($image);
    $vector_img = $converted_img->vector;
    $userVerificationID = userVerificationID($userID);

    if( profileExist($userID) == false ){
        $sql = "INSERT INTO `user_profile` (user_id, image_url, vector_img) VALUES ('$userID', '$filename', '$vector_img');";
        $sql .= "INSERT INTO `users_info` (verification_id, first_name, last_name, picture_features_vector) VALUES ('$userVerificationID', '$first_name', '$last_name', '$vector_img')";
    }else{
        $sql = "UPDATE `user_profile` SET `user_id` = '$userID', `image_url` = '$filename', `vector_img` = '$vector_img' WHERE `user_id` = '$userID';";
        $sql .= "UPDATE `users_info` SET `picture_features_vector` = '$vector_img' WHERE `verification_id` = '$userVerificationID'";
    }

    if (ddxrxDBConnect()->multi_query($sql) === TRUE) {

        $output = true;

    } else {
        
        $output = false;

    }

    ddxrxDBConnect()->close();
    return $output; // Replace this with your database logic

}

function convertToVector($image = null){
    
    if( !empty($image) ){
        
        // Target API URL Endpoint
        $url = 'http://44.193.55.67';

        // Data
        $data = array(
            "img_path" => $image
        );

        // Create a new cURL resource
        $ch = curl_init($url);
        
        $payload = json_encode($data);
        
        // Attach encoded JSON string to the POST fields
        curl_setopt($ch, CURLOPT_POSTFIELDS, $payload);
        
        // Set the header
        if( isset($token) ){
            curl_setopt($ch, CURLOPT_HTTPHEADER, array(
                'Content-Type:application/json',
                'Authorization:'.$token
            ));
        }else{
            curl_setopt($ch, CURLOPT_HTTPHEADER, array('Content-Type:application/json'));
        }
        
        // Return response instead of outputting
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        
        // Execute the POST request
        $api_result = curl_exec($ch);
        
        // Close cURL resource
        curl_close($ch);
        
        $api_result = json_decode($api_result);
        $result = $api_result;
        
        return $result;
        
    }else{

        $output = array(
            'result' => 'error'
        );

        return json_encode($output);

    }

}