<?php
session_start();  
if(!isset($_SESSION['name']) || $_SESSION['user_type']!="admin") {
    header("Location: login.php");
}

// Include Functions File
include("../process/functions.php");

?>
<!DOCTYPE html>
<html>
<head>
  <meta charset="utf-8">
  <meta http-equiv="X-UA-Compatible" content="IE=edge">
  <title>DDxRx Admin Panel | List of RPM Patients</title>
  <!-- Tell the browser to be responsive to screen width -->
  <meta content="width=device-width, initial-scale=1, maximum-scale=1, user-scalable=no" name="viewport">

  <!-- Bootstrap 3.3.7 -->
  <link rel="stylesheet" href="bower_components/bootstrap/dist/css/bootstrap.min.css">

  <!-- Font Awesome -->
  <link rel="stylesheet" href="bower_components/font-awesome/css/font-awesome.min.css">

  <!-- Ionicons -->
  <link rel="stylesheet" href="bower_components/Ionicons/css/ionicons.min.css">

  <!-- Theme style -->
  <link rel="stylesheet" href="dist/css/AdminLTE.min.css">

  <!-- AdminLTE Skins. Choose a skin from the css/skins
       folder instead of downloading all of them to reduce the load. -->
  <link rel="stylesheet" href="dist/css/skins/_all-skins.min.css">

  <!-- Morris chart -->
  <link rel="stylesheet" href="bower_components/morris.js/morris.css">

  <!-- jvectormap -->
  <link rel="stylesheet" href="bower_components/jvectormap/jquery-jvectormap.css">
  
  <!-- Date Picker -->
  <link rel="stylesheet" href="bower_components/bootstrap-datepicker/dist/css/bootstrap-datepicker.min.css">

  <!-- Daterange picker -->
  <link rel="stylesheet" href="bower_components/bootstrap-daterangepicker/daterangepicker.css">

  <!-- bootstrap wysihtml5 - text editor -->
  <link rel="stylesheet" href="plugins/bootstrap-wysihtml5/bootstrap3-wysihtml5.min.css">

  <!-- HTML5 Shim and Respond.js IE8 support of HTML5 elements and media queries -->
  <!-- WARNING: Respond.js doesn't work if you view the page via file:// -->
  <!--[if lt IE 9]>
  <script src="https://oss.maxcdn.com/html5shiv/3.7.3/html5shiv.min.js"></script>
  <script src="https://oss.maxcdn.com/respond/1.4.2/respond.min.js"></script>
  <![endif]-->

  <link rel="stylesheet" href="dist/css/rpm.css">

  <!-- Google Font -->
  <link rel="stylesheet" href="https://fonts.googleapis.com/css?family=Source+Sans+Pro:300,400,600,700,300italic,400italic,600italic">
</head>
<body class="hold-transition skin-blue sidebar-mini">
<div class="wrapper">
  <?php
    include('includes/header.php');
    include('includes/sidebar.php');
  ?>

  <!-- Popup -->
  <div class="rpm-popup-container">
    <div class="popup-widget">
      <i class="fa fa-times-circle closePopup" aria-hidden="true"></i>
      <h5 class="rpm-form-title">Update IMEI Number</h5>
      <label>
        <span>IMEI Number</span>
        <input type="text" class="textbox" value="" placeholder="Enter Patient's IMEI No.">
      </label>
      <input type="submit" class="btn-submit-rpm" value="Update">
    </div>
  </div>
  <!-- Popup -->

  <!-- Content Wrapper. Contains page content -->
  <div class="content-wrapper">
    <!-- Content Header (Page header) -->
    <section class="content-header">
      <h1>List of RPM Patients</h1>
      <ol class="breadcrumb">
        <li><a href="#"><i class="fa fa-dashboard"></i> Home</a></li>
        <li class="active">Nurses</li>
      </ol>
    </section>

    <!-- Main content -->
    <section class="content">
      <!-- Small boxes (Stat box) -->
          <div class="box">
            <div class="box-header">
              <h3 class="box-title"></h3>
            </div>
            <!-- /.box-header -->
            <div class="box-body">
              <table id="example1" class="table table-bordered table-striped">
                <thead>
                    <tr>
                        <th>Last Name</th>
                        <th>First Name</th>
                        <th>Date of Birth</th>
                        <th>Account Status</th>
                        <th>RPM Device</th>
                        <th>IMEI No.</th>
                        <th>Action</th>
                    </tr>
                </thead>
                <tbody>
                    <?php
                    $version = get_version();
                    $sql = "SELECT * FROM patients JOIN cardiowell_users ON patients.patient_id = cardiowell_users.patient_id WHERE patients.groupid = '$version';";
                    $result = ddxrxDBConnect()->query($sql);

                    if ($result->num_rows > 0):
                        while($row = $result->fetch_assoc()):

                            if( $row['active'] == '1' ){
                                $account_status = 'Active';
                            }else{
                                $account_status = 'Action Required';
                            }
                            
                            if( empty($row['imei']) ){
                              $add_status = 'enabled';
                            }else{
                              $add_status = 'disabled';
                            }

                            if( empty($row['imei']) ){
                              $edit_status = 'disabled';
                            }else{
                              $edit_status = 'enabled';
                            }

                            if( empty($row['imei']) ){
                              $imei = 'Not Enrolled';
                            }else{
                              $imei = $row['imei'];
                            }

                            echo '
                            <tr id="patient_'.$row['patient_id'].'" data-patient-id="'.$row['patient_id'].'">
                                <td>'.$row['patient_lname'].'</td>
                                <td>'.$row['patient_fname'].'</td>
                                <td>'.$row['patient_dob'].'</td>
                                <td>'.$account_status.'</td>
                                <td>'.$row['type'].'</td>
                                <td id="patient_'.$row['patient_id'].'_imei">'.$imei.'</td>
                                <td>
                                  <div class="rpm-btn-group">
                                    <a href="#" class="rpm-btn edit '.$edit_status.'" data-patient-id="'.$row['patient_id'].'"><i class="fa fa-pencil" aria-hidden="true"></i></i></a>
                                    <a href="#" class="rpm-btn delete" data-patient-id="'.$row['patient_id'].'"><i class="fa fa-trash" aria-hidden="true"></i></a>
                                  </div>
                                </td>
                            </tr>
                            ';

                        endwhile;
                    else:

                        echo "0 results";

                    endif;
                    ?>

                    <?php ddxrxDBConnect()->close(); ?>
                </tbody>
              </table>
            </div>
            <!-- /.box-body -->
          </div>
          <!-- /.box -->
      <!-- /.row -->
    </section>
    <!-- /.content -->
  </div>
  <!-- /.content-wrapper -->
  <footer class="main-footer">
    <div class="pull-right hidden-xs">
      <b>Version</b> 2.4.0
    </div>
    <strong>Copyright &copy; 2014-2016 <a href="https://adminlte.io">Almsaeed Studio</a>.</strong> All rights
    reserved.
  </footer>
  <!-- Add the sidebar's background. This div must be placed
       immediately after the control sidebar -->
  <div class="control-sidebar-bg"></div>
</div>
<!-- ./wrapper -->

<!-- jQuery 3 -->
<script src="bower_components/jquery/dist/jquery.min.js"></script>
<!-- jQuery UI 1.11.4 -->
<script src="bower_components/jquery-ui/jquery-ui.min.js"></script>
<!-- Resolve conflict in jQuery UI tooltip with Bootstrap tooltip -->
<script>
  $.widget.bridge('uibutton', $.ui.button);
</script>
<!-- Bootstrap 3.3.7 -->
<script src="bower_components/bootstrap/dist/js/bootstrap.min.js"></script>
<!-- DataTables -->
<script src="bower_components/datatables.net/js/jquery.dataTables.min.js"></script>
<script src="bower_components/datatables.net-bs/js/dataTables.bootstrap.min.js"></script>
<!-- Morris.js charts -->
<script src="bower_components/raphael/raphael.min.js"></script>
<script src="bower_components/morris.js/morris.min.js"></script>
<!-- Sparkline -->
<script src="bower_components/jquery-sparkline/dist/jquery.sparkline.min.js"></script>
<!-- jvectormap -->
<script src="plugins/jvectormap/jquery-jvectormap-1.2.2.min.js"></script>
<script src="plugins/jvectormap/jquery-jvectormap-world-mill-en.js"></script>
<!-- jQuery Knob Chart -->
<script src="bower_components/jquery-knob/dist/jquery.knob.min.js"></script>
<!-- daterangepicker -->
<script src="bower_components/moment/min/moment.min.js"></script>
<script src="bower_components/bootstrap-daterangepicker/daterangepicker.js"></script>
<!-- datepicker -->
<script src="bower_components/bootstrap-datepicker/dist/js/bootstrap-datepicker.min.js"></script>
<!-- Bootstrap WYSIHTML5 -->
<script src="plugins/bootstrap-wysihtml5/bootstrap3-wysihtml5.all.min.js"></script>
<!-- Slimscroll -->
<script src="bower_components/jquery-slimscroll/jquery.slimscroll.min.js"></script>
<!-- FastClick -->
<script src="bower_components/fastclick/lib/fastclick.js"></script>
<!-- AdminLTE App -->
<script src="dist/js/adminlte.min.js"></script>
<!-- AdminLTE dashboard demo (This is only for demo purposes) -->
<script src="dist/js/pages/dashboard.js"></script>

<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>

<!-- AdminLTE for demo purposes -->
<script src="dist/js/demo.js"></script>
<script src="main.js"></script>
<script>
  $(function () {
    $('#example1').DataTable();
  })
</script>
<script src="dist/js/rpm.js"></script>
</body>
</html>
