<?php

// Set JSON header
header('Content-Type: application/json');

session_start();

$inputOtp = $_POST['otp'];

if (isset($_SESSION['otp'], $_SESSION['otp_expiry']) && time() <= $_SESSION['otp_expiry']) {
    if ($inputOtp == $_SESSION['otp']) {
        // OTP is valid, create login session
        $_SESSION['user_name'] = $_SESSION['user_data']['user_name'];
        $_SESSION['full_name'] = $_SESSION['user_data']['full_name'];
        $_SESSION['user_id'] = $_SESSION['user_data']['id'];
        $_SESSION['email'] = $_SESSION['user_data']['email'];
        $_SESSION['access_type'] = $_SESSION['user_data']['type'];

        $output = array(
            'result' => true,
            'title' => 'Login Successful',
            'message' => 'OTP verified. Login successful.',
            'icon' => 'success'
        );

        // Clear OTP data
        unset($_SESSION['otp'], $_SESSION['otp_expiry'], $_SESSION['user_data']);

    } else {
        $output = array(
            'result' => false,
            'title' => 'Invalid OTP',
            'message' => 'Invalid OTP. Please try again.',
            'icon' => 'error'
        );
    }
} else {
    $output = array(
        'result' => false,
        'title' => 'OTP Expired',
        'message' => 'OTP expired. Please login again.',
        'icon' => 'error'
    );
}

echo json_encode($output);
?>