<?php

// Set JSON header
header('Content-Type: application/json');

// Include function file
include('../process/functions.php');

function check_adt_exist($room_no){

    // Check if  record already exists
    $sql = "SELECT * FROM `adt` WHERE `room_no` = '$room_no'";

    $result = mysqli_query(ddxrxDBConnect(), $sql);
    $row = mysqli_fetch_assoc($result);

    if( mysqli_num_rows($result) > 0 ){
        return true;
    }else{
        return false;
    }

    // Free result set
    mysqli_free_result($result);

    // Close the database connection
    mysqli_close(ddxrxDBConnect());

}

// Recieve JSON data
$data = json_decode(file_get_contents('php://input'), true);

if( !empty($data) ){

    $visit_id = $data['parameters']['visit_id'];
    $room_no = $data['parameters']['room_no'];
    $mrn = $data['parameters']['mrn'];
    $first_name = $data['parameters']['first_name'];
    $middle_name = $data['parameters']['middle_name'];
    $last_name = $data['parameters']['last_name'];
    $dob = $data['parameters']['dob'];
    $street = $data['parameters']['street'];
    $city = $data['parameters']['city'];
    $state = $data['parameters']['state'];
    $zip = $data['parameters']['zip'];
    $phone = $data['parameters']['phone'];
    $diag_1 = $data['parameters']['diag_1'];
    $diag_2 = $data['parameters']['diag_2'];
    $diag_3 = $data['parameters']['diag_3'];
    $diag_4 = $data['parameters']['diag_4'];
    $diag_5 = $data['parameters']['diag_5'];

    if( !empty($data) && $data['entry_type'] == 'edit' ){
        
        $sql = "UPDATE `adt` SET `room_no` = '$room_no', `mrn` = '$mrn', `first_name` = '$first_name', `middle_name` = '$middle_name', `last_name` = '$last_name', `dob` = '$dob', `street` = '$street', `city` = '$city', `state` = '$state', `zip` = '$zip', `phone` = '$phone' WHERE room_no = '$room_no'";
        
        if (mysqli_query(ddxrxDBConnect(), $sql)) {

            $output = array(
                'status_code' => '200',
                'status' => 'success',
                'title' => 'Saved Successfully',
                'message' => 'The patient has been saved successfully.',
                'data' => array(
                    'visit_id' => $visit_id,
                    'room_no' => $room_no,
                    'mrn' => $mrn,
                    'first_name' => $first_name,
                    'middle_name' => $middle_name,
                    'last_name' => $last_name,
                    'dob' => $dob,
                    'street' => $street,
                    'city' => $city,
                    'state' => $state,
                    'zip' => $zip,
                    'phone' => $phone,
                    'diag_1' => $diag_1,
                    'diag_2' => $diag_2,
                    'diag_3' => $diag_3,
                    'diag_4' => $diag_4,
                    'diag_5' => $diag_5
                )
            );

            // Get patient info
            $patientInfo = adt_get_patient( $first_name, $last_name);

            // Send video call link to kafka
            $sendAdtKafka = array(
                'userid' => $patientInfo['user_id'],
                'username' => $patientInfo['username'],
            );

            $adt_values = array(
                'visit_id' => $visit_id,
                'room_no' => $room_no,
                'mrn' => $mrn,
                'first_name' => $first_name,
                'middle_name' => $middle_name,
                'last_name' => $last_name,
                'dob' => $dob,
                'street' => $street,
                'city' => $city,
                'state' => $state,
                'zip' => $zip,
                'phone' => $phone,
                'diag_1' => $diag_1,
                'diag_2' => $diag_2,
                'diag_3' => $diag_3,
                'diag_4' => $diag_4,
                'diag_5' => $diag_5
            );
            sendAdtKafka( $sendAdtKafka, $adt_values );
            
        } else {
            
            $output = array(
                'status_code' => '500',
                'status' => 'error',
                'title' => 'Internal Server Error',
                'message' => 'Opps! Something went wrong in our backend. Please try again later.'
            );
            
        }
        
        // Close the database connection
        mysqli_close(ddxrxDBConnect());
        
    }elseif( !empty($data) && $data['entry_type'] == 'new' ){

        if( check_adt_exist( $room_no ) == true ){

            $output = array(
                'status_code' => '422',
                'status' => 'error',
                'title' => 'Already Exists',
                'message' => 'The patient already exists, do you want to overwrite?.'
            );

        }else{

            // Save new record
            $sql = "INSERT INTO `adt` (`visit_id`, `room_no`, `mrn`, `first_name`, `middle_name`, `last_name`, `dob`, `street`, `city`, `state`, `zip`, `phone`, `diag_1`, `diag_2`, `diag_3`, `diag_4`, `diag_5`) VALUES ('$visit_id', '$room_no', '$mrn', '$first_name', '$middle_name', '$last_name', '$dob', '$street', '$city', '$state', '$zip', '$phone', '$diag_1', '$diag_2', '$diag_3', '$diag_4', '$diag_5')";

            if (mysqli_query(ddxrxDBConnect(), $sql)) {

                $output = array(
                    'status_code' => '200',
                    'status' => 'success',
                    'title' => 'Saved Successfully',
                    'message' => 'The patient has been added successfully.',
                    'data' => array(
                        'visit_id' => $visit_id,
                        'room_no' => $room_no,
                        'mrn' => $mrn,
                        'first_name' => $first_name,
                        'middle_name' => $middle_name,
                        'last_name' => $last_name,
                        'dob' => $dob,
                        'street' => $street,
                        'city' => $city,
                        'state' => $state,
                        'zip' => $zip,
                        'phone' => $phone,
                        'diag_1' => $diag_1,
                        'diag_2' => $diag_2,
                        'diag_3' => $diag_3,
                        'diag_4' => $diag_4,
                        'diag_5' => $diag_5,
                    )
                );

                // Get patient info
                $patientInfo = adt_get_patient( $first_name, $last_name);

                // Send video call link to kafka
                $sendAdtKafka = array(
                    'userid' => $patientInfo['user_id'],
                    'username' => $patientInfo['username'],
                );

                $adt_values = array(
                    'visit_id' => $visit_id,
                    'room_no' => $room_no,
                    'mrn' => $mrn,
                    'first_name' => $first_name,
                    'middle_name' => $middle_name,
                    'last_name' => $last_name,
                    'dob' => $dob,
                    'street' => $street,
                    'city' => $city,
                    'state' => $state,
                    'zip' => $zip,
                    'phone' => $phone,
                    'diag_1' => $diag_1,
                    'diag_2' => $diag_2,
                    'diag_3' => $diag_3,
                    'diag_4' => $diag_4,
                    'diag_5' => $diag_5,
                );
                sendAdtKafka( $sendAdtKafka, $adt_values );

            } else {

                $output = array(
                    'status_code' => '500',
                    'status' => 'error',
                    'title' => 'Internal Server Error',
                    'message' => 'Opps! Something went wrong in our backend. Please try again later.'
                );

            }

        }

    }else{
        
            $output = array(
                'status_code' => '400',
                'status' => 'error',
                'title' => 'Missing Parameters',
                'message' => 'Missing parameters, please try again.'
            );

    }

}

// Output JSON
echo json_encode($output);

?>