<?php
date_default_timezone_set('America/Chicago');

header('Content-type: application/json');
header('Access-Control-Allow-Origin: *');

include('../process/functions.php');

ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

$checkin_time = date("Y-m-d H:i:s");
$checkin_time_epoch = time();

if(isset($_POST['url']) && $_POST['url'] != '') {
    $url = $_POST['url'];
} else {
    $url = get_version('url');
}

if(isset($_POST['username']) && $_POST['username'] != '' && isset($_POST['password']) && $_POST['password'] != '') {
    $version = get_version();
    $username = $_POST['username'];
    $raw_password = $_POST['password'];  // Keep raw password for verification

    // Modified SQL query - removed password check
    $sql = "SELECT * FROM `all_users` 
            LEFT JOIN physician ON all_users.userid = physician.user_id 
            WHERE all_users.username = '$username' 
            AND all_users.groupid = '$version' 
            AND `user_type` = '2' 
            LIMIT 1";

    $result = ddxrxDBConnect()->query($sql);
    $row = $result->fetch_assoc();

    if(isset($row['username']) && $row['username'] != '') {
        $password_valid = false;
        
        // New password verification logic
        if ($row['password_new'] != 'not_set') {
            if (password_verify($raw_password, $row['password_new'])) {
                $password_valid = true;
            }
        } else {
            if (md5($raw_password) === $row['password']) {
                $password_valid = true;
            }
        }

        if (!$password_valid) {
            $authresult = array(
                'result' => false,
                'result_type' => 'auth_error',
                'desc' => 'Authentication failed, username and password do not match.'
            );
            echo json_encode($authresult);
            exit();
        }

        // Continue with successful login
        $currentUrl = $_SERVER['HTTP_HOST'];
        $user_id = $row['userid'];
        $currentTime = time();
        $expireTime = time() + 31536000;
        $authKey = md5($row['password'] . $expireTime);

        $sqlins = "INSERT INTO app_login (user_id, auth_key, auth_time, validity) 
                   VALUES ('$user_id', '$authKey', '$currentTime', '$expireTime')";

        if (ddxrxDBConnect()->query($sqlins) === TRUE) {
            deleteinstant($user_id);
            $waitingroom = '0';
            $guid = md5($checkin_time . $row['userid']);
            $waitingroom_parameter = '&idKey=' . $guid . '&checkInTime=' . $checkin_time_epoch . '&waitingroom_id=' . $waitingroom;
            $fullname = $row['physician_fname'] . ' ' . $row['physician_lname'];

            $authresult = array(
                'result' => true,
                'result_type' => 'success',
                'desc' => 'Username and password have been authenticated',
                'auth_key'  => $authKey,
                'user_id'   => $row['userid'],
                'unique_id' => $row['unique_id'],
                'username'  => $row['username'],
                'fullname' => $fullname,
                'fname'  => $row['physician_fname'],
                'lname'  => $row['physician_lname'],
                'group_id'  => $row['groupid'],
                'user_type'  => $row['user_type'],
                'redirect_url' => 'https://' . $url . '/app-redirector.php?auth_key=' . $authKey . '&user_id=' . $row['userid'] . '&username=' . $row['username'] . '&user_type=' . $row['user_type'] . '&password=' . $raw_password . '&email=' . $row['email_address'] . '&is_verified_email=' . $row['is_verified_email'] . '&version=' . $version . $waitingroom_parameter,
                'text' => 'Hi, Your wish is my command, how may I help you?'
            );
        } else {
            $authresult = array(
                'result' => false,
                'result_type' => 'server_error',
                'desc' => 'Internal server error, please contact the administrators.'
            );
        }
    } else {
        $authresult = array(
            'result' => false,
            'result_type' => 'auth_error',
            'desc' => 'Authentication failed, username not found.'
        );
    }

    $result->free_result();
    ddxrxDBConnect()->close();
} else {
    $authresult = array(
        'result' => false,
        'result_type' => 'empty_field',
        'desc'  => 'Username and Password field cannot be empty'
    );
}

echo json_encode($authresult);
?>