<?php

/*
200 - Everything is OK
201 - Created Successfully
202 - Accepted
204 - No Content
301 - Moved Permanently
400 - Bad Request
401 - Unauthorized
404 - Not Found
500 - Internal Server Error
*/

// Set Content to json
header('Content-Type: application/json');

include('../process/functions.php');

try {
    
    $data = json_decode(file_get_contents('php://input'), true);

    // Check if 'patient_id' is set in the incoming data
    if (!isset($data['patient_id'])) {
        throw new Exception("Invalid input: 'patient_id' is missing.");
    }

    $patient_id = $data['patient_id'];

    $sql = "SELECT * FROM bot_text WHERE patient_id = '$patient_id' ORDER BY created_at DESC LIMIT 1";
    $result = ddxrxDBConnect()->query($sql);

    if ($result === false) {
        throw new Exception("Database query failed: " . ddxrxDBConnect()->error);
    }

    if ($result->num_rows > 0) {
        while ($row = $result->fetch_assoc()) {
            $resultJson = array(
                'result' => true,
                'bot_text_id' => $row['bot_text_id'],
                'user_id' => $row['user_id'],
                'patient_id' => $row['patient_id'],
                'text_data' => str_replace("$", " and", $row['text_data']),
                'created_at' => $row['created_at'],
            );

            $bot_text_id = $row['bot_text_id'];
        }
    } else {
        $resultJson = array(
            'result' => false,
            'description' => 'No data found.'
        );
    }

} catch (Exception $e) {

    $resultJson = array(
        'result' => false,
        'error' => 'An error occurred: ' . $e->getMessage()
    );

}

ddxrxDBConnect()->close();

echo json_encode($resultJson);

?>