<?php

header('Content-type: application/json');
header('Access-Control-Allow-Origin: *');

include('../process/functions.php');

ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

try{

    $data = json_decode(file_get_contents('php://input'), true);
    $output = '';

    if( isset($data['patient_id']) && $data['patient_id'] != '' && isset($data['type']) && $data['type'] != '' && isset($data['text']) && $data['text'] != '' && isset($data['question_id']) && $data['question_id'] != '' ){
        
        $patient_id = $data['patient_id'];
        $type = $data['type'];
        $text = $data['text'];
        $question_id = $data['question_id'];
        
        if( isset($data['speech']) && $data['speech'] != '' ){
            $speech = $data['speech'];
        }else{
            $speech = '';
        }
        
        if( isset($data['question_id']) && $data['question_id'] != '' ){
            $question_id = $data['question_id'];
        }else{
            $question_id = '';
        }
        
        
        $sql = "DELETE FROM speech_to_text WHERE user_id = $patient_id;";
        
        if( $type == 'type_14' ){
            
            $temp_arr = array();
            $options = array();
            $real_patient_id = getpatientInfo($patient_id, 'patient_id');
            
            $sqldiagnosisData = "SELECT * FROM medical WHERE patient_id = '$real_patient_id' AND status = 'approved'";
            $result = ddxrxDBConnect()->query($sqldiagnosisData);
            
            if ($result->num_rows > 0) {
                
                while($row = $result->fetch_assoc()) {
                    
                    array_push($temp_arr, $row['diagnosis']);

                }
                
                $options = array(
                    'result' => true,
                    'diagnosis' => $temp_arr
                );
                
            } else {
                
                $insertSql = "INSERT INTO `multi_answer`(`question_id`, `question`, `user_id`, `status`, `type`) VALUES ('NA', 'NA', '$patient_id', 'NA', 'NA')";
                ddxrxDBConnect()->query($insertSql);
                
                $options = array(
                    'result' => false
                );
                
            }
            
            ddxrxDBConnect()->close();
            
            $options = json_encode($options);
            
            $sql .= "INSERT INTO speech_to_text (`user_id`, `type`, `text`, `options`, `question_id`) VALUES ('$patient_id', '$type', '$text', '$options', '$question_id')";
            
        }else{
            
            $sql .= "INSERT INTO speech_to_text (`user_id`, `type`, `text`, `question_id`) VALUES ('$patient_id', '$type', '$text', '$question_id')";
            
        }
        
        if (ddxrxDBConnect()->multi_query($sql) === TRUE) {
            
            if( $type == 'type_1' ){
                
                deleteinstant($patient_id);
                sleep(2);
                
                $output = array(
                    'result' => true,
                    'status_code' => '201',
                    'user_id' => $patient_id,
                    'type' => $type,
                    'text'  => $text,
                    'speech' => $speech,
                    'question_id' => $question_id
                );
            
            }elseif( $type == 'type_2' ){
                
                $output = array(
                    'result' => true,
                    'status_code' => '201',
                    'user_id' => $patient_id,
                    'type' => $type,
                    'text'  => $text,
                    'speech' => $speech,
                    'question_id' => $question_id
                );
                
            }elseif( $type == 'type_3' ){
                
                // Type 3
                // It chooses which question to mark as yes
                // Using the question_id
                
                $output = array(
                    'result' => true,
                    'status_code' => '201',
                    'user_id' => $patient_id,
                    'type' => $type,
                    'text'  => $text,
                    'speech' => $speech,
                    'question_id' => $question_id,
                    'seperator' => 'diagnose'
                );
                
            }elseif( $type == 'type_4' ){
                
                deleteinstant($patient_id);
                
                $output = array(
                    'result' => true,
                    'status_code' => '201',
                    'user_id' => $patient_id,
                    'type' => $type
                );
                
            }elseif( $type == 'type_5' ){
                
                deleteinstant($patient_id);
                
                $output = array(
                    'result' => true,
                    'status_code' => '201',
                    'user_id' => $patient_id,
                    'type' => $type,
                    'text'  => $text,
                    'speech' => $speech,
                    'question_id' => $question_id,
                    'seperator' => 'diagnose'
                );
                
            }elseif( $type == 'type_6' ){
                
                $output = array(
                    'result' => true,
                    'status_code' => '201',
                    'user_id' => $patient_id,
                    'type' => $type,
                    'text'  => $text,
                    'speech' => $speech,
                    'question_id' => $question_id,
                    'seperator' => 'diagnose'
                );
                
            }elseif( $type == 'type_7' ){
                
                // This is for the ddx_reports.php
                // When you send symptoms and it finds a match
                // It will create a type 7 result
                
                $output = array(
                    'result' => true,
                    'status_code' => '201',
                    'user_id' => $patient_id,
                    'type' => $type,
                    'text'  => $text,
                    'speech' => $speech,
                    'question_id' => $question_id,
                    'seperator' => 'diagnose',
                );
                
            }elseif( $type == 'type_8' ){
                
                // This is for the ddx_reports.php
                // When you proceed with treatment
                // It will create a type 8 result
                
                $output = array(
                    'result' => true,
                    'status_code' => '201',
                    'user_id' => $patient_id,
                    'type' => $type,
                    'text'  => $text,
                    'speech' => $speech,
                    'question_id' => $question_id,
                    'seperator' => 'diagnose'
                );
                
            }elseif( $type == 'type_9' ){
                
                $output = array(
                    'result' => true,
                    'status_code' => '201',
                    'user_id' => $patient_id,
                    'type' => $type,
                    'text'  => $text,
                    'speech' => $speech,
                    'question_id' => $question_id,
                    'seperator' => 'diagnose'
                );
                
            }elseif( $type == 'type_10' ){
                
                // This is for the ddx_reports.php
                // When you proceed with treatment
                // It will create a type 8 result
                
                $output = array(
                    'result' => true,
                    'status_code' => '201',
                    'user_id' => $patient_id,
                    'type' => $type,
                    'text'  => $text,
                    'speech' => $speech,
                    'question_id' => $question_id,
                    'seperator' => 'diagnose'
                );
                
            }elseif( $type == 'type_11' ){
                
                // This is for the ddx_reports.php
                // When you proceed with treatment
                // It will create a type 8 result
                
                $output = array(
                    'result' => true,
                    'status_code' => '201',
                    'user_id' => $patient_id,
                    'type' => $type,
                    'text'  => $text,
                    'speech' => $speech,
                    'question_id' => $question_id,
                    'seperator' => 'diagnose'
                );
                
            }elseif( $type == 'type_12' ){
                
                // This is for chat-bot page
                // It refreshes the page and deletes some data in the database
                
                deleteinstant($patient_id);
                    
                $output = array(
                    'result' => true,
                    'status_code' => '201',
                    'user_id' => $patient_id,
                    'type' => $type,
                    'text'  => $text,
                    'speech' => $speech,
                    'question_id' => $question_id,
                    'seperator' => 'diagnose'
                );
            
            # Skip Type 13 it is being used somewhere else(Location)
            
            }elseif( $type == 'type_14' ){
                
                deleteinstant($patient_id);
                    
                $output = array(
                    'result' => true,
                    'status_code' => '201',
                    'user_id' => $patient_id,
                    'type' => $type,
                    'text'  => $text,
                    'speech' => $speech,
                    'question_id' => $question_id,
                    'seperator' => 'diagnose',
                    'options' => $options
                );
                
            }elseif( $type == 'type_15' ){
                
                deleteinstant($patient_id);
                    
                $output = array(
                    'result' => true,
                    'status_code' => '201',
                    'user_id' => $patient_id,
                    'type' => $type,
                    'text'  => $text,
                    'speech' => $speech,
                    'question_id' => $question_id,
                    'seperator' => 'diagnose'
                );
                
            }
        
        }else{
            
        $output = array(
                'result' => false,
                'status_code' => '500',
                'message' => 'Internal server error, something went wrong with the database',
            );
            
        }
        
        ddxrxDBConnect()->close();
        
    }else{
        
        $output = array(
            'result' => false,
            'status_code' => '422',
            'message' => 'Either the variables are missing or you used an incorrect parameter.'
        );
        
    }

} catch (Exception $e) {

    $output = array(
        'result' => false,
        'status_code' => '500',
        'message' => 'An error occurred: ' . $e->getMessage()
    );

}

echo json_encode($output);

?>
