<?php

header('Content-type: application/json');
include('../process/functions.php');

// Recieves data as a JSON
$reciever_data = json_decode(file_get_contents('php://input'), true);

// Get patient ID from JSON data
$patient_id = isset($reciever_data['patient_id']) ? $reciever_data['patient_id'] : null;

// Get type
$types = isset($reciever_data['types']) ? $reciever_data['types'] : null;

try{

	if( isset($patient_id) ){
		
		$sql = "SELECT * FROM alert_response WHERE user_id = '$patient_id' AND type = '$types' ORDER BY id DESC LIMIT 1";
		$result = ddxrxDBConnect()->query($sql);
		
		$row = $result -> fetch_assoc();
		
		if( isset($row['id']) ){
				
			$recordId = $row[id];
				
			$data = array(
				'content' => $row['content'],
				'yes_content' => $row['yes_content'],
				'no_content' => $row['no_content'],
				'type' => $row['type'],
				'created_at' => $row['created_at']
			);
		
			$output = array(
				'result' => false,
				'status_code' => '200',
				'response' => 'success',
				'message' => 'Request successful.',
				'data' => $data
			);
		
		} else {
		
			$output = array(
				'result' => false,
				'status_code' => '204',
				'response' => 'failed',
				'message' => 'Request successful, but no data available.',
				'data' => 'Returned Empty'
			);
		
		}

	}else{
		
		$output = array(
			'result' => false,
			'status_code' => '422',
			'result_desc' => 'Please send the required parameters',
		);
		
	}

} catch (Exception $e) {

    $output = array(
        'result' => false,
        'status_code' => '500',
        'message' => 'An error occurred: ' . $e->getMessage()
    );

}

echo json_encode($output);

ddxrxDBConnect()->close();

?>