$(document).ready(function(){
    
    // Set 
    sessionStorage.setItem("botAnswered", "");
    sessionStorage.setItem("type_result", "");
    
    //localStorage.setItem("symptoms", "");
    localStorage.setItem("entity", "");
    
    // Declare variable
    var inputSymptoms = [];
    var multipleAnswers = [];
    var multipleAnswers_raw = [];
    
    /*
    * Function to get the cookie by name
    */
    function getCookie(name) {
        var CookieValue;
        var nameEQ = name + "=";
        var ca = document.cookie.split(';');
        for(var i=0;i < ca.length;i++) {
            var c = ca[i];
            while (c.charAt(0)==' ') c = c.substring(1,c.length);
            if (c.indexOf(nameEQ) == 0){
                CookieValue = unescape(c.substring(nameEQ.length,c.length));
                CookieValue = CookieValue.replace('+',' ');
                return CookieValue;
            }
        }
        return null;
    }
    
    // Send sweet alert response
    function sendSweetAlertResponse( content, yes_content, no_content, alertType, userid ){
        
        $.ajax({
            type: "POST",
            url: 'process/sendsweetalertresponse.php',
            
            data:{
                userid:userid,
                content: content,
                yes_content: yes_content,
                no_content: no_content,
                alertType: alertType
            },
            
            success: function(data){
                // Do something
            }
        
        });
        
    }
    
    // Function to remove duplicate from array
    function remove_arrayDuplicate(arr){
        var tmp = [];
        for(var i = 0; i < arr.length; i++){
            if(tmp.indexOf(arr[i]) == -1){
            tmp.push(arr[i]);
            }
        }
        return tmp;
    }
    
    // Enter key function
    $.fn.pressEnter = function(fn) {  
  
        return this.each(function() {  
            $(this).bind('enterPress', fn);
            $(this).keyup(function(e){
                if(e.keyCode == 13)
                {
                  $(this).trigger("enterPress");
                }
            })
        });  
     };
    
    // function text to speech
    function text_to_speech(text){
        
        var sendData = {
            "text" : text,
        };
            
        $.ajax({
            type: "POST",
            //url: 'https://ddfe8a349a1f.ngrok.io',
                    
            data: JSON.stringify(sendData),
            contentType: "application/json; charset=utf-8",
            dataType: "json",
                                
            beforeSend: function() {},
            success: function(data){},               
            failure: function(errMsg) {}
        
        });
        
    }
    
    function sendQuestions(){
        var questions = [];
        var questionFinal;
        var questions_list = $('.option_symptoms .inner ul').html();
            
        if( questions_list == '' || questions_list == ' ' ){
                
            // Question is empty
                
        }else{
                
            if (questions === undefined || questions.length == 0) {
                
                $(".option_symptoms .inner ul li .overlay").each(function(){
                        
                    //$(this).text();
                    questions.push([ $(this).text(), $(this).attr('id'), $('body').data('user_id') ]);
                    
                });
                
                //questions.push([ 'None of the above', '0', $('body').data('user_id') ]);
                
                $.ajax({
                    type: "POST",
                    url: 'process/send_multi_answer.php',
                    data: JSON.stringify(questions),
                    contentType: "application/json; charset=utf-8",
                    dataType: "json",
                                        
                    beforeSend: function() {},
                    success: function(data){},               
                    failure: function(errMsg) {}
                
                });
                
                
            }
                
        }
    }
    
    // Function to forward symptoms to search_dd.php
    function forward_search(){
        
        Swal.fire({
            icon: 'success',
            title: 'Fetching Results',
            text: 'Please wait while we transfer you to the results page.',
        });
        
        $('.bot-reaction').removeClass('idle');
        $('.bot-reaction').addClass('thinking');
        $('.response-container h1').addClass('thinking');
        $('.response-container h1').html('Please wait...');
                        
        $('.form-container').hide();
        $('.common-symptoms').hide();
        $('.option_symptoms').hide();
        $('.error-report').hide();
        $('.front-social-media').hide();
        
        var text = '';
        symptoms_list = localStorage.getItem("symptoms");
        
        if( inputSymptoms.length == '1' ){
            inputSymptoms.push("Nothing else");
        }
        inputSymptoms = remove_arrayDuplicate(inputSymptoms);
        
        var i, len, text;
        for (i = 0, len = inputSymptoms.length; i < len; i++) {
            if( inputSymptoms[i] === undefined ){
                
            }else{
                $('#formddX').append('<input type="hidden" name="symptoms['+i+']" value="'+inputSymptoms[i]+'">');
            }

        }
        
        //window.location.replace('search_dd.php'+text);
        //alert('search_dd.php'+text);
        $('#formddX').append('<input type="submit" id="submitbotsearch">');
        $('#submitbotsearch').click();
        
    }
    
    // Function to ask mmore symptoms
    function prompt_more_symptoms(){
        
        var user_id = $('body').data('user_id');
        
        if( inputSymptoms.length >= 2 ){
                
                sendSweetAlertResponse( 'Do you want to add more symptoms, please answer yes or no.', 'yes', 'no', 'type_6', user_id );
                
                // Convert text to speech
                text_to_speech('Do you want to add more symptoms? Please answer yes or no.');
                
                Swal.fire({
                    title: 'Success',
                    text: "Do you want to add more symptoms, please answer yes or no.",
                    icon: 'warning',
                    showCancelButton: true,
                    confirmButtonColor: '#e74c3c',
                    cancelButtonColor: '#2ecc71',
                    confirmButtonText: 'No',
                    cancelButtonText: 'Yes',
                    allowOutsideClick: false,

                }).then((result) => {
                    if (result.value) {
                        // Convert text to speech
                        text_to_speech('Please wait while we transfer you to the results page.');
                        forward_search();
                    }
                });
        }
        
    }
    
    // Auto Redirect/Submit
    function auto_submit(){
        
        // Regular Submit
        if( inputSymptoms.length >= 999 ){
            
            Swal.fire({
                title: 'Success',
                text: "Let's narrow down diagnostic options.",
                icon: 'success',
                showCancelButton: false,
                confirmButtonText: 'Show Results',
                allowOutsideClick: false
            }).then((result) => {
                if (result.value) {
                    
                    // Hide Elements
                    $('#google_translate_element').remove();
                    $('.bot-avatar').remove();
                    $('.container').remove();
                    // Submit to reports page
                    forward_search();
                    
                }
            });
            
            //console.log( inputSymptoms );
            
        }
        
        
        // Follow up auto submit
        var arrstring = inputSymptoms.toString();
        var ArrSearchResult = arrstring.search('follow-up') !== -1;
        if( ArrSearchResult == true ){
            
            Swal.fire({
                title: 'Success',
                text: "We will forward you with the results",
                icon: 'success',
                showCancelButton: false,
                confirmButtonText: 'Show Results',
                allowOutsideClick: false
            }).then((result) => {
                if (result.value) {
                    
                    // Hide Elements
                    $('#google_translate_element').remove();
                    $('.bot-avatar').remove();
                    $('.container').remove();
                    // Submit to reports page
                    forward_search();
                    
                }
            });
            
        }
        
    }
    
    
    
    // Function to send symptoms
    function sendSymptoms(){
        
        var patient_id = $('body').data('patient-id');
        var user_id = '1';
        var userInput = $('.search_phrase').val();
        var entity = localStorage.getItem("entity");
        
        var sendData = {
            "user_id" : patient_id,
            "question" : userInput,
            "entity" : entity
        };
        
        const isEmpty = Object.values(sendData).every(x => (x === null || x === ''));
        
        if(isEmpty == false){
            $.ajax({
                type: "POST",
                //url: 'https://ddxrx.ai',
                //url: 'process/ddxrx.ai.php',
                url: 'process/api-data.php?target=ddxrx_ai',
                data: JSON.stringify(sendData),
                contentType: "application/json; charset=utf-8",
                headers: {"Authorization": getCookie('access_token')},
                dataType: "json",
                
                beforeSend: function() {
                    
                    $('.response-container h1').text('Thinking . . .');
                    $('.response-container h1').addClass('thinking');
                    
                    $('.bot-reaction').removeClass('idle');
                    $('.bot-reaction').addClass('thinking'); 
                    $('.form-container .textbox').addClass('thinking');
                    $('.common-symptoms h6').addClass('thinking');
                    
                },
    
                success: function(data){
                    
                    sessionStorage.setItem("type_result", data.type);
                    
                    // Remove Tap to speak section
                    $('.tapToSpeak').hide();
                    $('.common-symptoms').hide();
                    
                    /**
                     * Temporary commented this part for later after vipul and ritesh made the decision
                     * we remove this or continue using
                    */
                    
                    if( data.call === 'unmatch' ){
                        sendText(data.text, 'unmatched');
                    }else{
                        sendText(data.text);
                    }
                    
                    //sendText(data.text);
                    
                    // Type 5
                    if( data.response == 'success' && data.type == 'type5' ){
                        
                        // Register a session
                        // This is to indicate if the questions have been answered or not
                        sessionStorage.setItem("botAnswered", "no");
                        sessionStorage.setItem("lastAnswered","q_1");
                        
                        // Variable for counter
                        var counter = 0;
                        
                        if( data.symptoms !== undefined ){
                                    
                            var i;
                            for( i = 0; i < data.symptoms.length; ++i ){
                                inputSymptoms.push( data.symptoms[i] );
                            }
                                    
                        }else{
                                    
                            // Add data to array
                            inputSymptoms.push( data.symptoms );
                                    
                        }
                        
                        // Auto Search
                        auto_submit();
                        
                        $('.response-container h1').text(data.text);
                        $('.response-container h6').text(' ');
                        $('.bot-reaction').removeClass('thinking');
                        $('.bot-reaction').addClass('idle');
                        $('.response-container h1').removeClass('thinking');
                        $('.form-container .textbox').removeClass('thinking');
                        $('.common-symptoms h6').removeClass('thinking');
                        $('.textbox.search_phrase').val('');
                            
                        // Set The Entity Value In storage
                        localStorage.setItem("entity", data.symptoms);
                            
                        if("symptoms_data" in data){ // Check if the object key exists(Sometimes it exists sometimes it doesn't depending on the API)
                            $('.option_symptoms ol').html(''); // Reset the symptom option container  
                            $('.option_symptoms ul').html(''); // Reset the symptom option container
                            $('.option_symptoms').fadeIn(); // Show the symptoms option container
                            
                            let result = data.symptoms_data;
                			for (let user_options of result) {
                    			// Iterate Counter
                    			counter++;
                    	        $('.option_symptoms ul').append('<li class="enabled otheroptions"><div class="overlay q_'+counter+'" id="q_'+counter+'">'+user_options.option.question+'</div>'+user_options.option.question+'</li>');
                	        }
                	        
                	        // Hide Search Form
                		    $('.form-container').hide();
                        }else{
                            
                            prompt_more_symptoms();
                            $('.common-symptoms').show();
                            
                        }
                            
                        // Only show none of the above where there are options
                        if("symptoms_data" in data){
                            if( data.symptoms_data.length > 0 ){
                                $('.option_symptoms ul').append('<li class="enabled noneoftheabove"><div class="overlay">Nothing Else</div>None of the above</li>');
                            }
                        }
                        
                        $('.option_symptoms a.send_mult_ans').removeClass('hide');
                        $('.option_symptoms a.send_mult_ans_type8').addClass('hide');
                	    
                	    // Bot Speech: Instruction
                        var plainText = $('.response-container h1').html();
                        text_to_speech(plainText);
                	    
                	    // Bot Speech: Tell Users to answer question
                        $(".option_symptoms ul li .overlay").each(function(i){
                            
                            var getQuestion = $(this).html();
                            
                            setTimeout(function(){
                                text_to_speech( getQuestion + ", Please answer if yes or no" );
                            },500 + ( i * 15000 ));
                            
                        });
                	    
                	    sendQuestions();
                	    
                    }
                    
                    // Type 6
                    if( data.response == 'success' && data.type == 'type6' ){
                        
                        $('.response-container h1').text(data.text);
                        $('.response-container h6').text(' ');
                        $('.bot-reaction').removeClass('thinking');
                        $('.bot-reaction').addClass('idle');
                        $('.response-container h1').removeClass('thinking');
                        $('.form-container .textbox').removeClass('thinking');
                        $('.common-symptoms h6').removeClass('thinking');
                        $('.textbox.search_phrase').val('');
                        $('.form-container').hide();
                        
                        $('.front-social-media').hide();
                        $('.common-symptoms').hide();
                        $('.option_symptoms').hide();
                        $('.button-container').remove();
                        $('.response-container').append('<div class="button-container"><a href="'+data.link+'">Click Here</a></div>');
                        
                    }
                    
                    // Type 7
                    if( data.response == 'success' && data.type == 'type7' ){
                        
                        $('.response-container h1').text(data.text);
                        $('.response-container h6').text(' ');
                        $('.bot-reaction').removeClass('thinking');
                        $('.bot-reaction').addClass('idle');
                        $('.response-container h1').removeClass('thinking');
                        $('.form-container .textbox').removeClass('thinking');
                        $('.common-symptoms h6').removeClass('thinking');
                        $('.textbox.search_phrase').val('');
                        $('.form-container').hide();
                        
                        $('.button-container').hide();
                        $('.error-report').show();
                    	$('.error-report ul').html('');
                        
                        let result = data.symptoms_data;
                		for (let user_options of result) {
                    	    
                    	    if("link" in user_options){
                    	        var optionLink = user_options.link;
                    	        var cssclass = 'none';
                    	    }else{
                    	        var optionLink = 'javascript:;';
                    	        var cssclass = 'back-to-main';
                    	    }
                    	    
                    	    $('.error-report ul').append('<li><a href="'+optionLink+'" class="'+cssclass+'">'+user_options.option.question+'</a></li>');
                    	    
                	    }
                    
                    }
                    
                    // Type 8
                    if( data.response == 'success' && data.type == 'type8' ){
                        
                        if( data.symptoms !== undefined || data.symptoms.length !== 0 ){
                            
                            var i;
                            for( i = 0; i < data.symptoms.length; ++i ){
                                inputSymptoms.push( data.symptoms[i] );
                            }

                        }else{
                            // Add data to array
                            if( data.symptoms !== undefined ){
                                inputSymptoms.push( data.symptoms );
                            }
                        }
                        
                        $('.response-container h1').text(data.text);
                        $('.response-container h6').text(' ');
                        $('.bot-reaction').removeClass('thinking');
                        $('.bot-reaction').addClass('idle');
                        $('.response-container h1').removeClass('thinking');
                        $('.form-container .textbox').removeClass('thinking');
                        $('.common-symptoms h6').removeClass('thinking');
                        $('.textbox.search_phrase').val('');
                            
                        // Set The Entity Value In storage
                        localStorage.setItem("entity", data.symptoms);
                        
                        // Add class "autosubmit" to indicate that this
                        $('.option_symptoms').addClass('autosubmit');
                        
                        if("symptoms_data" in data){ // Check if the object key exists(Sometimes it exists sometimes it doesn't depending on the API)
                            $('.option_symptoms ol').html(''); // Reset the symptom option container  
                            $('.option_symptoms ul').html(''); // Reset the symptom option container
                            $('.option_symptoms').fadeIn(); // Show the symptoms option container
                            
                            var counter = 0;
                            
                            let result = data.symptoms_data;
                			for (let user_options of result) {
                    			//console.log( user_options.option.Question );
                    	        //$('.option_symptoms ul').append('<li class="enabled"><div class="overlay">'+user_options.option.question+'</div>'+user_options.option.question+'</li>');
                    	        counter++;
                                $('.option_symptoms ul').append('<li class="enabled"><div class="overlay q_'+counter+'" id="q_'+counter+'">'+user_options.option.question+'</div>'+user_options.option.question+'</li>');
                	        }
                	        
                	        // Hide Search Form
                		    $('.form-container').hide();
                        }
                            
                        // Only show none of the above where there are options
                        if("symptoms_data" in data){
                            if( data.symptoms_data.length > 0 ){
                                $('.option_symptoms ul').append('<li class="enabled noneoftheabove"><div class="overlay">Nothing Else</div>None of the above</li>');
                            }
                        }
                        
                        $('.option_symptoms a.send_mult_ans_type8').removeClass('hide');
                        $('.option_symptoms a.send_mult_ans').addClass('hide');
                        
                        sendQuestions();
                        
                    }
                    
                    // Tap to speak bug fix, it forces the tap to speak to show up when it recognizes screen 1 provided by the API
                    if( data.screen != undefined && data.screen == '1' ){
                        $('.tapToSpeak').show();
                    }
                    
                },
                
                failure: function(errMsg) {
                    
                    $('.response-container h1').text('I am malfunctioning! Try again later.');
                    $('.bot-reaction').removeClass('thinking');
                    $('.bot-reaction').addClass('angry');
    
                }
                
            });
        }
        
        
    }
    
    // Function to send
    function sendText( sendTextData, action = 'single' ){
        
        var patient_id = $('body').data('patient-id');
        var user_id = $('body').data('user_id');
        var text_data = sendTextData;
        
        if( action === 'single' || action === '' ){
            actionData = 'multiple';
        }else{
           actionData = action; 
        }
        
        $.ajax({
            type: "POST",
            url: 'process/sendText.php',
            
            data:{
                patient_id: patient_id,
                user_id: user_id,
                text_data: text_data,
                actionData:actionData
            },
            
            success: function(data){
            }
        
        });
        
    }
    
    // Initial Welcome Message: Text to speech
    var plainText = $('.response-container h1').html();
    text_to_speech(plainText);
    
    // Search Result Click
    $('body').on('click', '.ac_results li', function() {
        $('.textbox').val( $(this).text() );
        sendSymptoms();
    });
    
    // Common Symptoms
    $('body').on('click', '.common-symptoms a', function() {
        var symptom = $(this).attr('data-symptoms');
        $('.textbox.search_phrase').val(symptom);
        sendSymptoms();
    });
    
    // Refresh Button
    $('body').on('click', '.form-container .button.refresh', function() {
        //location.reload();
        $('.form-container .textbox').val('');
        refreshBot();
    });
    
    // Send Symptoms
    $('body').on('click', '.form-container .button.send', function() {
        sendSymptoms();
    });
    
    
    /* ==================================================== */
    // Multi Options 
    /* ==================================================== */
    $('body').on('click', '.option_symptoms li .overlay', function() {
        
        multipleAnswers = '';
        multipleAnswers_raw = [];
        
        if( $(this).parent().hasClass('checked') === true ){
            
            $(this).parent().removeClass('checked');
            
        }else{
            
            $(this).parent().addClass('checked');
            
        }
        
        $(".option_symptoms li.checked").each(function(i){
            
            var separator = '';
            
            if( $(".option_symptoms li.checked").last().index() == i ){
                separator = '';
            }else{
                separator = '$';
            }
            
            multipleAnswers = multipleAnswers+$('.overlay',this).text()+separator;
            multipleAnswers_raw.push( $(this).text() );
            
        });
        
    });
    
    // Auto Submit on option select
    $('body').on('click', '.option_symptoms.autosubmit li .overlay', function() {
        
        // Click button dynamically
        $('.send_mult_ans_type8').click();
        
        // Remove autosubmit class
        $('.option_symptoms').removeClass('autosubmit');
        
    });
    
    $('body').on('click', '.send_mult_ans', function() {
        
        if( multipleAnswers !== '' ){
            
            var user_id = $('body').data('patient-id');
            var sendData;
            var url;
            
            if( sessionStorage.getItem("type_result") == 'type8' ){

                url = 'process/api-data.php?target=ddxrx_ai';
                
                sendData = {
                    "entity": "",
                    "question" : multipleAnswers,
                    "user_id" : user_id
                };
                
            }else{
                
                url = 'process/api-data.php?target=ddxrx_ai&parameter=questionSearch';
                
                sendData = {
                    "user_id" : user_id,
                    "question" : multipleAnswers
                };
                
            }
            
            $.ajax({
                type: "POST",
                url: url,
                data: JSON.stringify(sendData),
                headers: {"Authorization": getCookie('access_token')},
                contentType: "application/json; charset=utf-8",
                dataType: "json",
                        
                beforeSend: function() {
                    $('.response-container h1').text('Thinking . . .');
                    $('.response-container h1').addClass('thinking');
                    $('.bot-reaction').removeClass('idle');
                    $('.bot-reaction').addClass('thinking');
                    $('.form-container .textbox').addClass('thinking');
                    $('.common-symptoms h6').addClass('thinking');
                    
                    $('.option_symptoms').fadeOut();
                    $('.option_symptoms ul').html('');
                },
            
                success: function(data){
                    
                    console.log( data.text );
                    sendText(data.text);
                    
                    setTimeout(function(){
                        
                        // Show Tap Button
                        $('.tapToSpeak').show();
                        $('.common-symptoms').show();
                        
                        // Display Response
                        $('.response-container h1').text(data.text);
                        
                        // Find and replace $ sign to , comma from response
                        var i;
                        for (i = 0; i < 10; i++) {
                            var text = $('.response-container h1').text();
                            $('.response-container h1').text(text.replace('$', ' + '));
                        }
                        
                        //$('.response-container h6').text(data.symptoms);
                        $('.bot-reaction').removeClass('thinking');
                        $('.bot-reaction').addClass('idle');
                        $('.response-container h1').removeClass('thinking');
                        $('.form-container .textbox').removeClass('thinking');
                        $('.common-symptoms h6').removeClass('thinking');
                        $('.textbox.search_phrase').val('');
                        
                        // Add data to array
                        var i;
                        for( i = 0; i < data.symptoms.length; ++i ){
                            inputSymptoms.push( data.symptoms[i] );
                        }
                        
                        // Set The Entity Value In storage
                        localStorage.setItem("entity", data.symptoms);
                        
                        //localStorage.setItem("symptoms", inputSymptoms);
                        
                        // Auto Search
                        auto_submit();
                        
                        // Ask more search
                        prompt_more_symptoms();
                        
                        //console.log( inputSymptoms );
                        
                        $('.form-container').show();
                        
                    }, 1000);
                    
                },
                        
                failure: function(errMsg) {
            
                }
            });
            
        }else{
            
            Swal.fire({
                icon: 'error',
                title: 'Error...',
                text: 'Answer cannot be empty, please choose atleast one to proceed',
            });
            
        }
        
    });
    
    $('body').on('click', '.send_mult_ans_type8', function() {
        
        console.log(multipleAnswers);
        
        if( multipleAnswers !== '' ){
            
            if( multipleAnswers.includes("$") ){
                inputSymptoms.push( multipleAnswers.split("$")[0] );
            }
            
            var patient_id = $('body').data('patient-id');
            
            var sendData = {
                "question" : multipleAnswers,
                "user_id" : patient_id,
                "entity" : ""
            };
            
            $.ajax({
                type: "POST",
                //url: 'https://ddxrx.ai',
                //url: 'process/ddxrx.ai.php',
                url: 'process/api-data.php?target=ddxrx_ai',
                headers: {"Authorization": getCookie('access_token')},
                data: JSON.stringify(sendData),
                contentType: "application/json; charset=utf-8",
                dataType: "json",
                        
                beforeSend: function() {
                    
                    $('.response-container h1').text('Thinking . . .');
                    $('.response-container h1').addClass('thinking');
                    $('.bot-reaction').removeClass('idle');
                    $('.bot-reaction').addClass('thinking');
                    $('.form-container .textbox').addClass('thinking');
                    $('.common-symptoms h6').addClass('thinking');
                    
                    $('.option_symptoms').fadeOut();
                    $('.option_symptoms ul').html('');
                    
                },
            
                success: function(data){
                    
                    setTimeout(function(){
                        
                        // Display Response
                        $('.response-container h1').text(data.text);
                        
                        // Find and replace $ sign to , comma from response
                        var i;
                        for (i = 0; i < 10; i++) {
                            var text = $('.response-container h1').text();
                            $('.response-container h1').text(text.replace('$', ' + '));
                        }
                        
                        //$('.response-container h6').text(data.symptoms);
                        $('.bot-reaction').removeClass('thinking');
                        $('.bot-reaction').addClass('idle');
                        $('.response-container h1').removeClass('thinking');
                        $('.form-container .textbox').removeClass('thinking');
                        $('.common-symptoms h6').removeClass('thinking');
                        $('.textbox.search_phrase').val('');
                        
                        // Set The Entity Value In storage
                        localStorage.setItem("entity", data.symptoms);
                        
                        if("symptoms_data" in data){ // Check if the object key exists(Sometimes it exists sometimes it doesn't depending on the API)
                            $('.option_symptoms ol').html(''); // Reset the symptom option container  
                            $('.option_symptoms ul').html(''); // Reset the symptom option container
                            $('.option_symptoms').fadeIn(); // Show the symptoms option container
                            
                            let result = data.symptoms_data;
                			for (let user_options of result) {
                    			//console.log( user_options.option.Question );
                    	        $('.option_symptoms ul').append('<li class="enabled"><div class="overlay">'+user_options.option.question+'</div>'+user_options.option.question+'</li>');
                	        }
                	        
                	        // Hide Search Form
                		    $('.form-container').hide();
                        }
                            
                        // Only show none of the above where there are options
                        if("symptoms_data" in data){
                            if( data.symptoms_data.length > 0 ){
                                $('.option_symptoms ul').append('<li class="enabled noneoftheabove"><div class="overlay">Nothing Else</div>None of the above</li>');
                            }
                        }
                        
                        $('.option_symptoms a.send_mult_ans').removeClass('hide');
                        $('.option_symptoms a.send_mult_ans_type8').addClass('hide');
                        
                        // Auto Search
                        auto_submit();
                        
                        // Ask more search
                        prompt_more_symptoms();
                        
                        if( data.type == 'type5' && data.action == 'hide_search' ){
                            $('.form-container').hide();
                        }else{
                            $('.form-container').show();
                        }
                        
                        
                    }, 1000);
                    
                },
                        
                failure: function(errMsg) {
            
                }
            });
            
        }else{
            
            Swal.fire({
                icon: 'error',
                title: 'Error...',
                text: 'Answer cannot be empty, please choose atleast one to proceed',
            })
            
        }
        
    });
    
    // None of the above got clicked
    $('body').on('click', '.option_symptoms li.none-of-above.enabled', function() {
        
        $('.response-container h1').html('Please enter a new symptom');
        $('.option_symptoms').hide();
        $('.form-container').show();
    
    });
    
    
    /* ==================================================== */
    /* Navigation Menu */
    /* ==================================================== */
    $('body').on('click', '.nav-menu.open', function() {
        
        $('.wrapper').addClass('blur');
        $('#particles-js').addClass('blur');
        $('.nav-container').addClass('show');
        
        $('.nav-menu.open').addClass('close');
        $('.nav-menu.open').removeClass('open');
        
    });
    
    $('body').on('click', '.nav-menu.close', function() {
        
        $('.wrapper').removeClass('blur');
        $('#particles-js').removeClass('blur');
        $('.nav-container').removeClass('show');
        
        $('.nav-menu.close').addClass('open');
        $('.nav-menu.close').removeClass('close');
        
    });
    
    
    
    // Refresh Bot
    function refreshBot(){
        
        $('.response-container h1').html('How may I help you?');
        
        localStorage.setItem("entity", "");
    
        // Declare variable
        inputSymptoms = [];
        multipleAnswers = [];
        multipleAnswers_raw = [];
        
        text = '';
        symptoms_list = localStorage.getItem("symptoms");
        
        arrstring = inputSymptoms.toString();
        ArrSearchResult = arrstring.search('follow-up') !== -1;
        symptom = $(this).attr('data-symptoms');
        
        user_id = '1';
        userInput = $('.search_phrase').val();
        entity = localStorage.getItem("entity");
                
        sendData = '';
        
        text = '';
        i = '';
        separator = '';
        sendData = '';
        
        
        Swal.fire({
            icon: 'info',
            title: 'Bot Refreshed',
            text: "Bot's memory has been refreshed",
        });
        
    }
    
    // Menu Bar Height
    var NavHeight = $('.menu-bar').outerHeight();
    NavHeight = NavHeight+100;
    $('.menu-bar-spacer').css("height", NavHeight);
    
    
    // Back Button
    $('body').on('click', '.back-to-main', function() {
        
        $('.error-report').hide();
        $('.form-container').show();
        $('.common-symptoms').show();
        
    });
    
    
    // Auto Search Bot from APP
    var autosearch = $('body').data('auto-search');

    if( autosearch == true ){
        $('body').attr('data-auto-search','false');
        $('.form-container .button.send').click();
    }
    
    // Enter key pressed
    $('.symptoms_search_box').pressEnter(function(){
        $('.button.send').click();
    });
    
    // Check for changes every second
    setInterval(function(){

        var user_id = $('body').data('user_id');
        
        $.ajax({
    		type: 'POST',
    		url: 'process/check_speech.php',
    		data: {
    			user_id:user_id,
    		},
    		
    		beforeSend: function(){
    		    // Do something
    		},
    			
    		success: function(response){
    	        
    	        if( response.result == true ){
    	            
    	            if( response.type == 'type_1' ){
    	            
        	            $('.search_phrase').val( response.text );
        	            $('.button.send').click();
    	            
    	            }else if( response.type == 'type_2' ){
    	                
    	                var question = response.question_id;
    	                
    	                if( response.text == 'yes' || response.text == 'Yes' || response.text == 'YES' ){
    	                    if( $('#'+question).parent().hasClass("checked") == false ){
    	                        $('#'+question).click();
    	                    }
    	                }
    	                
    	                if( response.text == 'no' || response.text == 'No' || response.text == 'NO' ){
    	                    if( $('#'+question).parent().hasClass("checked") == true ){
    	                        $('#'+question).click();
    	                    }
    	                }
    	                
    	                //$('#'+question).click();
    	                
    	            }else if( response.type == 'type_4' ){
    	                
    	                $('.send_ans.send_mult_ans').click();
    	                
    	            }else if( response.type == 'type_6' ){
    	                
    	                if( response.text == 'yes' || response.text == 'Yes' || response.text == 'YES' ){
    	                    $('.swal2-cancel').click();
    	                }else if( response.text == 'no' || response.text == 'No' || response.text == 'NO' ){
    	                    $('.swal2-confirm').click();
    	                }
    	                
    	            }else if( response.type == 'type_12' ){

    	                window.location.replace("chat-bot.php");
    	                
    	            }else if( response.type == 'type_14' ){
                        
                        var newOptions = JSON.parse( response.options );
                        
    	                if( newOptions.result == true ){
    	                    
    	                    for( var i = 0; i<newOptions.diagnosis.length; i++ ){
    	                        
    	                        $('#formddX').append('<input type="hidden" name="symptoms['+i+']" value="'+newOptions.diagnosis[i]+'">');
    	                        
    	                    }
    	                    
    	                    $('#formddX').attr('action', 'ddx_reports_followup.php')
    	                    $('#formddX').append('<input type="hidden" name="symptoms['+i+']" value="Follow-up Visit">');
    	                    $('#formddX').submit();
    	                }
    	                
    	            }
    	            
    	        }
    	        
    		},
    		
    		fail: function(response){
    		    // Do something
    		},
    		
    	});
        
    }, 1000);
    
    /* ================================================== */
    // Send signal to installer once every 10 seconds
    // to indicate that the page is still active
    /* ================================================== */
    // setInterval(function(){
        
    //     var user_id = $('body').data('user_id');
    //     var fname = $('body').data('fname');
    //     var today = new Date();
        
    //     var payload = {
    //         message:{
    //             CustomerId: user_id,
    //             CustomerName: fname,
		  //      IsBroadCastMessage: "False",
		  //      MessageContent: {
		  //          status: "open",
    //     			created_at: today
		  //      },
		  //      MessageType: "PhpHealthCheck",
    //         },
    //         response:"true"
    //     };
        
    //     var output = JSON.stringify(payload);
        
    //     $.ajax({
    // 		type: 'POST',
    // 		url: 'https://ddxrx.ai/broker',
    // 		data: JSON.stringify(payload),
    //         contentType: "application/json; charset=utf-8",
    //         dataType: "json",
    // 		beforeSend: function(){
    // 		    // Do something
    // 		},
    			
    // 		success: function(response){
    //             // Do something
    // 		},
    		
    // 		fail: function(response){
    // 		    // Do something
    // 		},
    		
    // 	});
        
    // }, 10000);
    
    // Tap to speak
    $('body').on('click', '.tapToSpeak', function() {
	        
	    // Change Text to "Listening"
	    $('.tapToSpeak h1').html('Listening...');
	        
        if (window.hasOwnProperty('webkitSpeechRecognition')) {
        
            var recognition = new webkitSpeechRecognition();
        
            recognition.continuous = false;
            recognition.interimResults = false;
        
            recognition.lang = "en-US";
            recognition.start();
        
            recognition.onresult = function (e) {
                $('.tapToSpeak h1').html('Tap to speak');
                $('.tapToSpeak').hide();
                $('.search_phrase').val(e.results[0][0].transcript);
                //$('.button.send').click();
                //$('.form-container .button.send').touchstart();
                sendSymptoms();
                recognition.stop();
            };
        
            recognition.onerror = function (e) {
                recognition.stop();
            }
        }
            
	});
	
	
	// Disable none of the above when other symptoms are selected
	// noneoftheabove | otheroptions
	$('body').on('click', '.option_symptoms ul li.noneoftheabove', function() {
	    $('.option_symptoms ul li.otheroptions').removeClass('checked');
	    $('.option_symptoms ul li').css( 'opacity', '0.5' );
	    $('.option_symptoms ul li.noneoftheabove').css( 'opacity', '1' );
	});
	
	$('body').on('click', '.option_symptoms ul li.otheroptions', function() {
	    $('.option_symptoms ul li.noneoftheabove').removeClass('checked');
	    $('.option_symptoms ul li').css( 'opacity', '0.5' );
	    $('.option_symptoms ul li.otheroptions').css( 'opacity', '1' );
	});
	
	
	// None of the above: Bring back tap to speak button
	$('body').on('click', '.none-of-above', function() {
        $('.tapToSpeak').show();
        $('.common-symptoms').show();
	});
    
    document.onkeydown = function(e) {
        switch(e.which) {
            case 37: // left
            break;
    
            case 38: // up
            break;
    
            case 39: // right
            break;
    
            case 40: // down
            console.log('Data: ' + inputSymptoms);
    
            default: return; // exit this handler for other keys
        }
    };


    /* ------------------------------------------------------ */
    // AJAX Symptoms Search
    /* ------------------------------------------------------ */
    $('.search_phrase').on('input', function() {

        var inputValue = $(this).val();

        if( inputValue != '' ){

        // AJAX request
        $.ajax({
            type: 'POST',
            url: 'process/search-symptoms.php', // Replace with your server endpoint
            data:{
                search_qry: inputValue
            },
            success: function(response) {

                if ( response.result == true ) {

                    // Show the UI
                    $('.search-result-container').show();

                    // Reset Results before showing new one
                    $('.search-result-container ul').html('');

                    for (var i = 0; i < response.items.length; i++) {

                        var item = response.items[i];

                        console.log( item.symptom_name );

                        $('.search-result-container ul').append('<li>'+item.symptom_name+'</li>');

                    }
                }

            },
            error: function(error) {
                // Handle the error response here
                console.log('AJAX request failed');
                console.log('Error: ', error);
            }
        });

        }else{
            $('.search-result-container').hide();
        }
    });

    // Insert selected search result values
    $('.search-result-container').on('click', 'li', function() {

        // Store selected value in a variable
        var selectedResultItem = $(this).html();

        // Hide search result
        $('.search-result-container').hide();

        // Reset Values
        $('.search_phrase').val('');

        // Insert Values
        $('.search_phrase').val(selectedResultItem);

        // Click search button
        $('.button-group .button.send').click();

    });
    
});
