$(document).ready(function () {

    // Variables
    var groupID = $("#messages").attr('data-version');
    var group = $("#messages").attr('data-group');
    var username = $("#messages").attr('data-sender-name');

    // Function to save chat
    function save_msg(sender_id, room_id, sender_name, msg) {

        var sent_date = Date.now();

        $.ajax({
            url: '../process/save_chat.php',
            data: {
                'sender_id': sender_id,
                'room_id': room_id,
                'sent_date': sent_date,
                'sender_name': sender_name,
                'msg': msg
            },
            type: 'POST',
            success: function success(response) {
                // Response here
            },

        });

    }

    // Update Room
    function update_room(room_id, room_owner, room_name, participant_id, user_type) {

        var last_update = Date.now();
        var roomStatus = $('#messages').attr('data-has-room');

        $.ajax({
            url: '../process/update_room.php',
            data: {
                'room_id': room_id,
                'room_owner': room_owner,
                'last_update': last_update,
                'participant_id': participant_id,
                'roomStatus': roomStatus,
                'room_name': room_name,
                'user_type': user_type
            },
            type: 'POST',
            success: function success(response) {
                // Response here
            },
        });

    }

    // Update thread
    function update_msg_thread(group_id) {

        $.ajax({
            url: '../process/update_thread.php',
            data: {
                'group_id': group_id,
            },
            type: 'POST',
            success: function success(response) {

                $('.patient-thread-list').html(response);

            },
        });

    }

    // Video Call Button
    // $('.videocall-btn').click(function () {

    //     function generateVCID() {
    //         return Math.floor(Math.random() * 9000000000) + 1;
    //     }

    //     // Get domain name
    //     //var domainName = window.location.hostname;
    //     var domainName = 'https://chat.ddxrx.com';

    //     // Generate the video call link
    //     var vc_id = generateVCID();
    //     var stream_link = domainName + '/video-chat.php?room_name=' + vc_id;

    //     // Insert video link in textarea
    //     let userMsg = $('#txt').val(stream_link);

    //     // Send the message
    //     $('.msgButton').click();

    // });

    // Remove chat empty illustration
    $('body').on('click', '.sidebar .thread-list li a', function () {

        $('.chat-init-container').remove();

    });

    if (username && group) {

        var socket = io.connect(
            //'https://clinician.club/chat',
            'http://localhost:3006',
            {
                transports: ['polling'],
                query: {
                    "username": username,
                    "groupName": group
                }
            }
        );

        var group_Data = {
            emit: true,
            username: username,
            groupName: group
        };

        var threadID = 'threadID_' + groupID

        console.log(group_Data);

        // Add user to group
        socket.emit('addToGroup', group_Data);

        // Add user to thread
        socket.emit('addToThread', threadID);

        // Display message to chat list
        socket.on('updatechat', function (data) {

            if (data.groupName == group && data && typeof data.joined_message !== "undefined") {

                // Scroll to bottom of chat
                scrollToBottomChat();

                // Join Sound
                chat_sound('notification');

                // Show system message
                $('#messages').append('<li class="chatItem">' + data.joined_message + '</li>');

            }

        });

        socket.on('notify_chat_to_admin', function (data) {

            // Get group ID
            var group = $("#messages").attr('data-group');

            if (data && data.groupName == group) {

                const regex = /video-chat\.php/;

                const match = regex.exec(data.messages);

                if (match) {

                    // True
                    var message = '<iframe src="' + data.messages + '"></iframe>';

                } else {

                    // False
                    var message = data.messages;

                }

                // Scroll to bottom of chat
                scrollToBottomChat();

                // Play Chat Sound
                if (username !== data.username) {
                    chat_sound('chat-2');
                }

                // Show chat message
                $('#messages').append('<li class="chatItem"><ion-icon name="person-circle-outline"></ion-icon><div class="content"><h6 class="username">' + data.username + '</h6><div class="messageContainer">' + message + '</div><div class="time-lapsed" data-time="' + data.current_date + '">' + timeSince(data.current_date) + '</div></div><div class="clear"></div></li>');

                // Reset input field
                $('#txt').val('');

                // Change Room Status
                $('#messages').attr('data-has-room', 'yes');

            }
        });

        $('#chatForm').submit(function (e) {

            // prevents page reloading
            e.preventDefault();

            // Get Current Date
            const current_date = Date.now();

            // Get message from input field
            let userMsg = $('#txt').val();

            // User Details
            let sender_id = $('#messages').attr('data-sender-id');
            var participant_id = $('#messages').attr('data-sender-id');
            var groupID = $('#messages').attr('data-group');
            var room_id = $('#messages').attr('data-group');
            var room_owner = $('#messages').attr('data-group');
            var sender_name = $('#messages').attr('data-sender-name');
            var roomStatus = $('#messages').attr('data-has-room');
            var roomName = $('#messages').attr('data-name');
            var user_type = $('#messages').attr('data-user-type');

            // Check if message is not empty
            if (userMsg != "") {

                // Emit/Send message to server
                socket.emit('live_chat_message',
                    {
                        "sender_id": sender_id,
                        "messages": userMsg,
                        "username": sender_name,
                        "groupName": groupID,
                        "roomStatus": roomStatus,
                        "roomName": roomName,
                        "current_date": current_date
                    }
                );

                // Emit/Send message to server to update
                socket.emit('update_thread', threadID);

                // Function to save chat
                save_msg(sender_id, room_id, sender_name, userMsg);

                // Update Room
                update_room(room_id, room_owner, roomName, participant_id, user_type);

                return false;

                // Else prevent users from sending empty messages
            } else {

                return false;

            }

        });

        var timeout;

        // Remove typing status
        function timeoutFunction() {
            typing = false;
            socket.emit(
                'typing',
                {
                    "username": username,
                    "groupName": group,
                    "status": false
                }
            );
        }

        // Add typing status when user is typing
        function isTyping() {
            typing = true;

            socket.emit(
                'typing',
                {
                    "username": username,
                    "groupName": group,
                    "status": true
                }
            );

            clearTimeout(timeout);

            timeout = setTimeout(timeoutFunction, 2000);

        }

        socket.on('typing', function (data) {

            // Remove previous typing status
            $('#typing').html("");

            // Display typing status
            if (data && data.groupName == group && data.username != username && data.status == true) {
                $('#typing').html('<i>' + data.username + ' is typing....</i>');
            }

        });

        // Update Message Thread
        socket.on('notify_thread', function (data) {
            if (data == threadID) {

                const regex = /^threadID_/;
                const version_id = data.replace(regex, "");

                update_msg_thread(version_id);


            }
        });

    }

});