$.validator.addMethod(
    "hasUppercase",
    function (value, element) {
        if (this.optional(element)) {
            return true;
        }
        return /[A-Z]/.test(value);
    },
    "Your password must be at least 1 capital (uppercase) letter"
);

$.validator.addMethod(
    "hasLowercase",
    function (value, element) {
        if (this.optional(element)) {
            return true;
        }
        return /[a-z]/.test(value);
    },
    "Your password must be at least 1 capital (lowercase) letter"
);

$.validator.addMethod(
    "hasNumber",
    function (value, element) {
        if (this.optional(element)) {
            return true;
        }
        return /[0-9]/.test(value);
    },
    "Your password must be at least 1 (number) letter"
);

function sendResetData( dataKey, dataEmail, dataPassword ){
    
    $.ajax({
        type: "POST",
        url: 'process/reset_password_patient.php',
            
        data:{
            dataKey: dataKey,
            dataEmail: dataEmail,
            dataPassword: dataPassword
        },
            
        success: function(data){
            
            if( data.response_result === true ){
                
                Swal.fire({
                    title: data.title,
                    text: data.desc,
                    icon: data.icon,
                    allowOutsideClick: false,
                    showCancelButton: false,
                    confirmButtonColor: '#3085d6',
                    cancelButtonColor: '#d33',
                    confirmButtonText: 'Login'
                }).then((result) => {
                    if (result.isConfirmed) {
                        window.location.replace("patient_login.php");
                    }
                });
                
            }else if( data.response_result === false ){
                
                Swal.fire({
                    title: data.title,
                    text: data.desc,
                    icon: data.icon,
                    allowOutsideClick: false,
                    showCancelButton: false,
                    confirmButtonColor: '#3085d6',
                    cancelButtonColor: '#d33',
                    confirmButtonText: 'Request Link'
                }).then((result) => {
                    if (result.isConfirmed) {
                        window.location.replace("forgot_password.php");
                    }
                });
                 
            }
            
        }
        
    });
    
}

// Wait for the DOM to be ready
$(document).ready(function(){
    // Initialize form validation on the reset_form form.
    // It has the name attribute "reset_form"
    $("form[name='reset_form']").validate({
        // Specify validation rules
        rules: {
            // The key name on the left side is the name attribute
            // of an input field. Validation rules are defined
            // on the right side
            new_password: {
                required: true,
                hasUppercase: true,
                hasLowercase: true,
                hasNumber: true,
                minlength: 6,
                maxlength: 40,
                // Using the normalizer to trim the value of the element
                // before validating it.
                //
                // The value of `this` inside the `normalizer` is the corresponding
                // DOMElement. In this example, `this` references the `new_password` element.
                normalizer: function (value) {
                    return $.trim(value);
                },
            },
            new_password_confirm: {
                required: true,
                equalTo: "#new_password",
            },
            email_address: {
                required: true,
            },
        },
        // Specify validation error messages
        messages: {
            new_password: {
                required: "Please provide a password",
                minlength: "Your password must be at least 6 characters long",
            },

            new_password_confirm: {
                equalTo: "The Confirm Password is not matched with the New Password Field.",
            },
        },
        // Make sure the form is submitted to the destination defined
        // in the "action" attribute of the form when valid
        submitHandler: function (form) {
            
            var thePassword = $('#new_password').val();
            var theKey = $('body').data('key');
            var theEmail = $('body').data('email');
            
            sendResetData( theKey, theEmail, thePassword );
            
        },
    });
});
