$(document).ready(function(){

    function save_analysis( user_id, msg_type, msg_txt ){

        $.ajax({
            url: 'process/save_analysis.php',
            method: 'POST',
            data: {
                user_id : user_id,
                msg_type : msg_type,
                msg_txt : msg_txt
            },
            success: function(responseData) {
                console.log('Message saved');
            },
        });

    }

    // Initialize Nice Scroll For Sidebar
    $(".message-list").niceScroll({
        autohidemode: "leave",
        cursorcolor: "#8ec1f5",
        cursorborder: "none"
    });

    // Scroll to bottom of chat when page is loaded
    function scrollToBottomChat(){
        var element = document.getElementById("message-list");
        var chatHeight = element.scrollHeight;
        $('#message-list').animate({ scrollTop: chatHeight }, 100);
    }

    // Send button
    $('.btnContainer').click(function(){
        $(".dataForm").submit();
    });

    // Attach the submit event handler to the form.
    $(".dataForm").submit(function(e) {

        // Prevent the form from submitting.
        e.preventDefault();

        var requestData = $('#requestData').val();
        var user_id = $('body').data('user-id');
        var patient_name = $('body').data('patient-name');

        if( requestData != '' ){

            $.ajax({
                url: 'http://103.147.56.103/',
                method: 'POST',
                data: requestData,
                beforeSend: function() {
                    
                    // Disable the input field
                    $('#requestData').prop('disabled', true);

                    // Reset the form
                    $('#requestData').val('');

                    // Show loading Icon
                    $('.loadingIcon').show();

                    // Hide button
                    $('.btnContainer').hide();

                    // Append the user message
                    $('.message-list').append('<li class="user"><img src="assets/images/chat-user-avatar.png" class="avatar"><div class="desc"><div class="inner"><span>'+patient_name+'</span>'+requestData+'</div></div><div class="clear"></div></li>');
                    
                    // Scroll to bottom
                    scrollToBottomChat();

                },
                success: function(responseData) {

                    // Enable input field
                    $('#requestData').prop('disabled', false);

                    // Show button
                    $('.btnContainer').show();

                    // Hide loading Icon
                    $('.loadingIcon').hide();

                    // Append the result
                    $('.message-list').append('<li class="bot"><img src="assets/images/chat-ai-avatar.png" class="avatar"><div class="desc"><div class="inner"><span>ddxrx AI</span>'+responseData+'</div></div><div class="clear"></div></li>');

                    // Scroll to bottom
                    scrollToBottomChat();

                    // Save "user" message to database
                    save_analysis( user_id, 'user', requestData );

                    // Save "bot" message to database
                    save_analysis( user_id, 'bot', responseData );

                },
                error: function(jqXHR, textStatus, errorThrown) {
                    console.error('Error:', errorThrown);
                }
            });

        }

    });

});