<?php
    
    date_default_timezone_set('America/Chicago');
    
    session_start();
    if (!isset($_SESSION['userType']) || ($_SESSION['userType'] != 'doctor' && $_SESSION['userType'] != 'nurse')) {
        header("Location: provider_login.php");
        die();
    }
    
    include('process/functions.php');
    include('includes/database_include.php');
    
    
?>

<!DOCTYPE html>
<html>
<head>
    <meta http-equiv="Content-Type" content="text/html; charset=utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    
	<title>Billing Codes</title>
	
	<link rel="stylesheet" type="text/css" href="assets/css/reset.css">
    <link rel="stylesheet" type="text/css" href="assets/css/grid.css">
    <link rel="stylesheet" type="text/css" href="assets/css/vitals_history.css">
    <link rel="stylesheet" type="text/css" href="assets/css/dashboard_responsive.css">
	<link rel="stylesheet" type="text/css" href="https://cdn.datatables.net/1.10.20/css/jquery.dataTables.min.css">
    <link rel="stylesheet" type="text/css" href="//cdn.datatables.net/2.0.4/css/dataTables.dataTables.min.css">
	
	<script src="https://ajax.googleapis.com/ajax/libs/jquery/3.3.1/jquery.min.js"></script>
	<script type="text/javascript" src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
    <script type="text/javascript" src="https://kit.fontawesome.com/e424c30ea6.js" crossorigin="anonymous"></script>
    <script type="text/javascript" src="//cdn.datatables.net/2.0.5/js/dataTables.min.js"></script>
	<script type="text/javascript" src="assets/js/vitals_history.js"></script>
    <script type="text/javascript" src="assets/js/billing-code.js"></script>
	
</head>
<body data-user-type="<?php echo $_SESSION['user_type']; ?>" <?php if( $_SESSION['user_type'] == 'nurse' ){ echo 'data-nurse-id="'.$_SESSION['userid'].'"'; } ?> <?php if( $_SESSION['user_type'] == 'doctor' ){ echo 'data-physician-id="'.$_SESSION['userid'].'"'; } ?>>
    
    <!-- Manual Timer Popup -->
    <div class="manual-timer-popup" data-patient-id="">
        <div class="manual-timer-form">
            <div class="inner">
                
                <a href="javascript:;" class="close">Close</a>
                
                <h4>Add manual timer</h4>
                
                <label>
                    <span>How much time?</span>
                    <div class="timerEntry">
                        <input type="number" class="textbox timerEntry min" max="10" placeholder="MM" value="1"><div class="dot">:</div>
                        <div class="clear"></div>
                    </div>
                    <div class="timerEntry"><input type="number" max="60" class="textbox timerEntry sec" placeholder="SS" value="0"></div>
                    <div class="clear"></div>
                </label>
                
                <a href="javascript:;" class="btn">Submit</a>
                
                <div class="clear"></div>
            </div>
        </div>
    </div>
    <!-- Manual Timer Popup -->
    
    <!-- Header -->
    <div class="header">
        <div class="container">
            <div class="col-md-12">
                <div class="patient-info">
                    <h3 class="tabtitle">Billing Dashboard</h3>
                    <div class="clear"></div>
                </div>
            </div>
        </div>
        
        <div class="menu-container">
            
            <div class="container">
            <div class="filter-container">
                <form method="POST">
                    <!-- Month -->
                    <select name="month" class="filterSelect month">
                        <?php
                        $cur_month = intval(date('n'));
                        for ($x = 1; $x <= 12; $x++) {
                            $cur_month_select = '';

                            if (isset($_POST['month']) && $x == $_POST['month']) {
                                $cur_month_select = 'selected';
                            } elseif ($x == $cur_month && !isset($_POST['month'])) {
                                $cur_month_select = 'selected';
                            }

                            switch ($x) {
                                case 1:
                                    $display_date = "January";
                                    break;
                                case 2:
                                    $display_date = "February";
                                    break;
                                case 3:
                                    $display_date = "March";
                                    break;
                                case 4:
                                    $display_date = "April";
                                    break;
                                case 5:
                                    $display_date = "May";
                                    break;
                                case 6:
                                    $display_date = "June";
                                    break;
                                case 7:
                                    $display_date = "July";
                                    break;
                                case 8:
                                    $display_date = "August";
                                    break;
                                case 9:
                                    $display_date = "September";
                                    break;
                                case 10:
                                    $display_date = "October";
                                    break;
                                case 11:
                                    $display_date = "November";
                                    break;
                                case 12:
                                    $display_date = "December";
                                    break;
                            }
                        ?>
                            <option value="<?php echo $x; ?>" <?php echo $cur_month_select; ?>><?php echo $display_date; ?></option>
                        <?php } ?>
                    </select>
                    <!-- Month -->
                    
                    <!-- Year -->
                    <select name="year" class="filterSelect year">
                    <?php
                    $cur_year = intval(date('Y'));
                    for( $y = 2014; $y <= $cur_year; $y++ ){
                        
                        if( $y == $_POST['year'] ){
                            $cur_year_select = 'selected';
                        }else if( $y == $cur_year && !isset($_POST['year']) ){
                            $cur_year_select = 'selected';
                        }else{
                            $cur_year_select = '';
                        }
                    ?>
                    
                        <option value="<?php echo $y; ?>" <?php echo $cur_year_select; ?>><?php echo $y; ?></option>
                        
                    <?php } ?>
                    </select>
                    <!-- Year -->
                    
                    <input type="submit" value="Filter" class="filterBtn">
                </form>
                
            </div>
            
            <?php
                if( $_SESSION['user_type'] == 'nurse' ){
                    include('nurse_dashboard_nav.php');
                }elseif( $_SESSION['user_type'] == 'physician' || $_SESSION['user_type'] == 'doctor' ){
                    include('physician_dashboard_nav.php');
                }
            ?>
            <div class="clear"></div>
            </div>
        </div>
        
    </div>
    <!-- Header -->
    
    <div class="container">
        <div class="col-md-12">
            <div class="TableContainer">
                <table id="myTable">
                	<thead>
                        <tr>
                            <td>Last Name</td>
                            <td>First Name</td>
                            <td>Gender</td>
                            <td>Date of Birth</td>
                            <td title="First measurement date" style="min-width: 120px;">99453 <i class="fa-solid fa-circle-info"></i></td> <!-- Enrollment Date(Optional and should be blank) !-->
                            <td title="Total number of measurement per month"><div class="cellInfo">99454 <i class="fa-solid fa-circle-info"></i></div></td> <!-- Total number of measurement per month -->
                            <td title="Number of days measured per month"><div class="cellInfo">99454 <i class="fa-solid fa-circle-info"></i></div></td> <!-- Number of days they measured per month -->
                            <td title="Measured consultation time">99457 <i class="fa-solid fa-circle-info"></i></td> <!-- the date they become 20 minutes of consultion -->
                            <td title="Accumulated excess time">99458 <i class="fa-solid fa-circle-info"></i></td> <!-- 40 minutes additional -->
                            <td style="min-width: 130px;">Actions</td>
                        </tr>
                    </thead>
                    <tbody></tbody>
                </table>
                
                <div class="table-controls">
                    <!-- <?php if( isset($_POST['month']) && isset($_POST['year']) ){ ?>
                        <a href="process/export-billing-code.php?month=<?php echo $_POST['month']; ?>&year=<?php echo $_POST['year']; ?>" target="_blank" style="background: #2ecc71; color: #FFFFFF; padding: 10px; padding-left: 15px; padding-right: 15px; border-radius: 3px; font-weight: 600; display: inline-block; margin-top: 20px; text-decoration: none">Export</a>
                    <?php }else{ ?>
                        <a href="process/export-billing-code.php" target="_blank" style="background: #2ecc71; color: #FFFFFF; padding: 10px; padding-left: 15px; padding-right: 15px; border-radius: 3px; font-weight: 600; display: inline-block; margin-top: 20px; text-decoration: none">Export</a>
                    <?php } ?> -->
                    
                    <?php
                    if( isset($_POST['month']) && $_POST['year'] ){
                        $month = $_POST['month'];
                        $year = $_POST['year'];
                    }else{
                        $month = intval(date("n"));
                        $year = intval(date("Y"));
                    }
                    ?>
                    <a href="billing-pdf.php?groupid=<?php echo get_version(); ?>&month=<?php echo $month; ?>&year=<?php echo $year; ?>" target="_blank" style="background: #2ecc71; color: #FFFFFF; padding: 10px; padding-left: 15px; padding-right: 15px; border-radius: 3px; font-weight: 600; display: inline-block; margin-top: 20px; text-decoration: none">Print Report</a>
                
                </div>
                
            </div>
        </div>
    </div>
    
    <?php
        if( $_SESSION['user_type'] == 'nurse' ){
            provider_bottom_nav();
        }elseif( $_SESSION['user_type'] == 'physician' || $_SESSION['user_type'] == 'doctor' ){
            physician_bottom_nav();
        }
    ?>
    
</body>
</html>