jQuery(document).ready(function($){
    
    /* =================================================================== */
    // Functions
    /* =================================================================== */

    // Create Room
    function create_room( chat_room, user_id ){

        $.ajax({
            type: 'POST',
            url: '../chat/process/create_room.php',
            data: {
                chat_room:chat_room,
                user_id:user_id
            },
            beforeSend: function() {
                // Do something
            },
            success: function(response) {

                $('.chat-widget .chat-box').fadeIn();

                //console.log(response);

            },
            fail: function(response){
                 // Do something
                 alert('failed');
            }
        });

    }


    // Get Conversation
    function get_conversation( chat_room, user_id ){

        $.ajax({
            type: 'POST',
            url: '../chat/process/get_conversation.php',
            data: {
                chat_room:chat_room,
                user_id:user_id
            },
            beforeSend: function() {
                // Do something
            },
            success: function(response) {

                if( response == 'false' ){

                    // Append Conversation List
                    $('.chat-widget .chat-box .chat-list').html('<li class="new"><p>No recent conversation, type below to start a new one and a nurse will assist you.</p></li>');
                    //console.log(response);

                }else{

                    // Append Conversation List
                    $('.chat-widget .chat-box .chat-list').html(response);
                    //$('.chat-list-container').animate({ scrollTop: $('.chat-list-container')[0].scrollHeight}, 500);
                    
                    // Play Sound when message recieve
                    //var audioUrl = 'https://freesound.org/data/previews/172/172490_3192597-lq.mp3';
                    //var audio = new Audio(audioUrl); // define your audio
                    //audio.play();
                    
                }

            },
            fail: function(response){
                 // Do something
                 alert('failed');
            }
        });

    }


    // Update Room and get latest conversation
    function update_room(){

        $.ajax({
            type: 'POST',
            url: '../chat/process/update_room.php',

            beforeSend: function() {
                // Do something
            },
            success: function(response) {

                // Append Conversation List
                $('.chat-widget .chat-box .chat-room').html(response);
                //console.log('results: '+response);

            },
            fail: function(response){
                 // Do something
                 alert('failed');
            }
        });

    }
    
    // Update Room Status to read
    function update_room_status_read( chat_room ){

        $.ajax({
            type: 'POST',
            url: '../chat/process/msg_status_read.php',
            data: {
                chat_room:chat_room,
            },

            beforeSend: function() {
                // Do something
            },
            success: function(response) {

            },
            fail: function(response){
                 // Do something
                 alert('failed');
            }
        });

    }



    /* =================================================================== */
    // Hide the textarea and button by default
    /* =================================================================== */
    $('.chat-widget .chat-room .send-message').hide();
    $('.chat-widget .chat-room .textarea').hide();

    /* =================================================================== */
    // Hide the chatbox by default
    /* =================================================================== */
    $('.chat-widget .chat-box').hide();

    /* =================================================================== */
    // Show the chatbox
    /* =================================================================== */
    $('.chat-icon').click(function(e){
		$('.chat-widget .chat-box').fadeIn();
        update_room();
	});
	
	/* =================================================================== */
	// Close Chatbox
	/* =================================================================== */
	$('.chat-widget .close-chat').click(function(e){
		$('.chat-widget .chat-box').fadeOut();
	});
	
	/* =================================================================== */
	// Send Message
	/* =================================================================== */
	$('.send-message').click(function(e){

	    var msg = $('.chat-widget .chat-box .textarea').val();
        var user_id = $('.chat-list-container ul').data('user-id');
        var chat_room = $('.chat-list-container ul').data('user-id');
	   
	    if( msg != '' ){

            $.ajax({
                type: 'POST',
                url: '../chat/process/send_message_nurse.php',
                data: {
                    chat_room:chat_room,
                    user_id:user_id,
                    msg:msg
                },
                beforeSend: function() {
                    // Do something
                },
                success: function(response) {

                    if( response == 'true' ){

                        $('.chat-widget .chat-box .chat-list').append('<li><span>July 23,2019 01:28 PM</span><strong>Nurse</strong><p>'+msg+'</p></li>');
                        $('.chat-widget .chat-box .textarea').val('');
                        //$('.chat-list-container').animate({ scrollTop: $('.chat-list-container')[0].scrollHeight}, 500);

                    }else{

                        $('.chat-widget .chat-box .chat-list').append('<li class="new" style="color:#FF0033"><p>Something went wrong please try again.</p></li>');

                    }

                },
                fail: function(response){
                     // Do something
                     alert('failed');
                }
            });
	    }
	   
	});

	/* =================================================================== */
	// Check if chat room exist
	/* =================================================================== */
	$('.chat-icon').click(function(e){

		var user_id = $('body').data('user-id');
		var chat_room = $('body').data('user-id');

		$.ajax({
            type: 'POST',
            url: '../chat/process/check_room.php',
            data: {
                user_id:user_id,
                chat_room:chat_room
            },
            beforeSend: function() {
                // Do something
            },
            success: function(response) {

            	if( response == 'true' ){
            		get_conversation( chat_room, user_id );
                    $('.chat-widget .chat-box').fadeIn();
            	}else if( response == 'false' ){
            		create_room( chat_room, user_id );
            	}

            },
            fail: function(response){
                 // Do something
                 alert('failed');
            }
        });

	});


    /* =================================================================== */
    // Open Single Message
    /* =================================================================== */
    $('.chat-widget').on('click', '.chat_room_single', function() {

        var user_id = $(this).data('user-id');

        // CHange class
        get_conversation( user_id, user_id );
        
        $('.chat-list-container ul').removeClass('chat-room');
        $('.chat-list-container ul').addClass('chat-list');

        $('.chat-list-container ul').data('user-id', user_id);

        $('.send-message').removeClass('hide');
        $('.textarea').removeClass('hide');
        
        $('.back-to-list').removeClass('hide');
        
        $('.selectbox').removeClass('hide');
        
        // Assign Chat Room ID
        $('.chat-list-container').attr('data-room-id', user_id);
        $('.selectbox').attr('id', user_id);
        
        
        //$('.chat-list-container').animate({ scrollTop: $('.chat-list-container')[0].scrollHeight}, 500);
        
        update_room_status_read(user_id);

    });
    
    /* =================================================================== */
    // Go back to chat room list
    /* =================================================================== */
    $('.chat-widget').on('click', '.back-to-list', function() {
        
        $('.chat-list').html('');
        
        update_room();
        
        $('.back-to-list').addClass('hide');
        
        $('.chat-list-container ul').addClass('chat-room');
        $('.chat-list-container ul').removeClass('chat-list');
        
        $('.send-message').addClass('hide');
        $('.textarea').addClass('hide');
        $('.selectbox').addClass('hide');
        
    });
    
    
    /* =================================================================== */
    // Assign Doctor
    /* =================================================================== */
    $('.chat-box .selectbox').change(function(){
        
        var doctor_id = $(this).find(':selected').val();
        var doctor_name = $(this).find(':selected').text();
        //var chat_room_id = $('.chat-list-container').data('room-id');
        var chat_room_id = $(this).attr('id');
        
        $.ajax({
            type: 'POST',
            url: '../chat/process/assign_doctor.php',
            data: {
                doctor_id:doctor_id,
                doctor_name:doctor_name,
                chat_room_id:chat_room_id
            },
            beforeSend: function() {
                // Do something
            },
            success: function(response) {
                $('.chat-list').append('<li><p>You have successfully transfered the patient to '+doctor_name+'</p></li>');
                $(".chat-box .selectbox").prop("selectedIndex", 0);
                console.log(chat_room_id);
            },
            fail: function(response){
                 // Do something
                 alert('failed');
            }
        });
        
    });
    
    
    /* =================================================================== */
    // Update Inbox every 5 seconds
    /* =================================================================== */
    setInterval(function(){
        update_room();
    }, 50000000);

    /* =================================================================== */
    // Update Message every 5 seconds
    /* =================================================================== */
    setInterval(function(){
        var user_id = $('.chat-list-container ul').data('user-id');
        var chat_room = $('.chat-list-container ul').data('user-id');
        get_conversation( chat_room, user_id );
        //console.log('Database updated'); 
    }, 5000);
    
});