$(document).ready(function(){
    
    var group = $("#messages").attr('data-group');
    var username = $("#messages").attr('data-sender-name');
    
    if(username && group) {
        
        var socket = io.connect(
            'https://clinician.club',
            //'http://209.208.27.109:3006',
            {
                transports : [ 'polling' ],
                query : {
                    "username":username,
                    "groupName":group
                }
            }
        );

        var group_Data ={
            username:username,
            groupName:group
        };

        console.log(group_Data);

        // Add user to group
        socket.emit('addToGroup', group_Data);
        
        // Display message to chat list
        socket.on('updatechat', function(data) {

            if(data.groupName==group && data && typeof data.joined_message !== "undefined") {
                
                // Scroll to bottom of chat
                scrollToBottomChat();

                // Join Sound
                chat_sound('notification');

                // Show system message
                $('#messages').append('<li class="chatItem">'+data.joined_message+'</li>');

            }

        });

        socket.on('notify_chat_to_admin', function(data) {

            // Get group ID
            var group = $("#messages").attr('data-group');

            if( data && data.groupName == group ){
                
                // Scroll to bottom of chat
                scrollToBottomChat();

                // Play Chat Sound
                if( username !== data.username ){
                    chat_sound('chat-2');
                }

                // Show chat message
                $('#messages').append('<li class="chatItem"><ion-icon name="person-circle-outline"></ion-icon><div class="content"><h6 class="username">'+data.username+'</h6><div class="messageContainer">'+ data.messages+'</div><div class="time-lapsed" data-time="'+data.current_date+'">'+timeSince(data.current_date)+'</div></div><div class="clear"></div></li>');
                
                // Reset input field
                $('#txt').val('');

                // Change Room Status
                $('#messages').attr('data-has-room', 'yes');

            }
        });

        $('#chatForm').submit(function(e) {

            // prevents page reloading
            e.preventDefault();

            // Get Current Date
            const current_date = Date.now();

            // Get message from input field
            let userMsg = $('#txt').val();

            // User Details
            let sender_id = $('#messages').attr('data-sender-id');
            var groupID = $('#messages').attr('data-group');
            var sender_name = $('#messages').attr('data-sender-name');
            var roomStatus = $('#messages').attr('data-has-room');
            var roomName = $('#messages').attr('data-name');

            // Check if message is not empty
            if(userMsg != ""){

                // Emit/Send message to server
                socket.emit(
                    'live_chat_message',
                    {
                        "sender_id":sender_id,
                        "messages":userMsg,
                        "username":sender_name,
                        "groupName":groupID,
                        "roomStatus":roomStatus,
                        "roomName" : roomName,
                        "current_date":current_date
                    }
                );

                return false;
            
            // Else prevent users from sending empty messages
            }else{
                
                return false;

            }

        });

        var timeout;

        // Remove typing status
        function timeoutFunction() {
            typing = false;
            socket.emit(
                'typing',
                {
                    "username":username,
                    "groupName":group,
                    "status":false
                }
            );
        }
        
        // Add typing status when user is typing
        function isTyping() {
            typing = true;

            socket.emit(
                'typing',
                {
                    "username":username,
                    "groupName":group,
                    "status":true
                }
            );

            clearTimeout(timeout);

            timeout = setTimeout(timeoutFunction, 2000);

        }

        socket.on('typing', function(data) {

            // Remove previous typing status
            $('#typing').html("");
            
            // Display typing status
            if(data && data.groupName == group && data.username !=username && data.status==true){
                $('#typing').html('<i>' + data.username + ' is typing....</i>');
            }

        });

    }

});