<?php
    session_start();
    
    if(!isset($_SESSION['userid']) || !isset($_SESSION['userType'])) {
        header("Location: provider_login.php");
        die();
    }
    if($_SESSION['userType'] != 'nurse' && $_SESSION['userType'] != 'doctor') {
        header("Location: view_record.php");
        die();
    }

    include('process/functions.php');
    
    $version = get_version();
    $patientsResult = mysqli_query(ddxrxDBConnect(), "SELECT * FROM patients WHERE user_id != 0 AND active = 1 AND groupid = '$version' ORDER BY patient_id DESC");
    
?>
<!DOCTYPE html>
<html>
    <head>
        <meta http-equiv="Content-Type" content="text/html; charset=utf-8">
        <title>Create Meeting - DDXRX</title>
        
        <link rel="stylesheet" type="text/css" href="assets/css/reset.css">
        <link rel="stylesheet" type="text/css" href="assets/css/grid.css">
        <link rel="stylesheet" type="text/css" href="assets/css/responsive.css">
        <link rel="stylesheet" type="text/css" href="assets/css/top-bar.css">
        <link rel="stylesheet" type="text/css" href="assets/css/videocall.css">
        
        <script src="https://ajax.googleapis.com/ajax/libs/jquery/3.3.1/jquery.min.js"></script>
        <script src="//cdn.jsdelivr.net/npm/sweetalert2@11"></script>
        <script src="https://unpkg.com/ionicons@5.5.2/dist/ionicons/ionicons.esm.js" type="module"></script>
        <script src="https://unpkg.com/ionicons@5.5.2/dist/ionicons/ionicons.js" nomodule></script>
        <script src="assets/js/meeting.js"></script>
        
    </head>
    <body class="nooverflow" data-user-id="<?php echo $_SESSION['userid']; ?>">
    
        <div class="container optimized-container videocallwrapper">
            <div class="col-md-12">
                <div class="row">
                    
                    <?php include('nav/nav_videocall.php'); ?>
                    
                    <div class="meeting-form-container">
                        <form action="create-meeting.php" method="POST" class="create-meeting-form">
                        
                            <a href="videocall-meetings.php" class="btn_go_back">Cancel & Back</a>
                        
                            <div class="form-container">
                                <div class="inner">
                                    
                                    <!-- Meeting Title -->
                                    <label>
                                        <span>Meeting Name</span>
                                        <input type="text" class="textbox meetingTitle" placeholder="Eg. Meeting with team">
                                    </label>
                                    <!-- Meeting Title -->
                                    
                                    <!-- Date Group -->
                                    <div class="date-group">
                                        <div class="date item">
                                            <label>
                                                <span>Date</span>
                                                <input type="date" class="textbox selectDate">
                                            </label>
                                        </div>
                                        
                                        <div class="time item">
                                            <label>
                                                <span>Time</span>
                                                <select class="selectbox selectTime">
                                                    <option value="">Select Time</option>
                                                    <option value="1:00">1:00</option>
                                                    <option value="1:30">1:30</option>
                                                    <option value="2:00">2:00</option>
                                                    <option value="2:30">2:30</option>
                                                    <option value="3:00">3:00</option>
                                                    <option value="3:30">3:30</option>
                                                    <option value="4:00">4:00</option>
                                                    <option value="4:30">4:30</option>
                                                    <option value="5:00">5:00</option>
                                                    <option value="5:30">5:30</option>
                                                    <option value="6:00">6:00</option>
                                                    <option value="6:30">6:30</option>
                                                    <option value="7:00">7:00</option>
                                                    <option value="7:30">7:30</option>
                                                    <option value="8:00">8:00</option>
                                                    <option value="8:30">8:30</option>
                                                    <option value="9:00">9:00</option>
                                                    <option value="9:30">9:30</option>
                                                    <option value="10:00">10:00</option>
                                                    <option value="10:30">10:30</option>
                                                    <option value="11:00">11:00</option>
                                                    <option value="11:30">11:30</option>
                                                    <option value="12:00">12:00</option>
                                                    <option value="12:30">12:30</option>
                                                </select>
                                            </label>
                                        </div>
                                        
                                        <div class="period item">
                                            <label>
                                                <span>Period</span>
                                                <select class="selectbox selectPeriod">
                                                    <option value="">Select period</option>
                                                    <option value="AM">AM</option>
                                                    <option value="PM">PM</option>
                                                </select>
                                            </label>
                                        </div>
                                        
                                        <div class="clear"></div>
                                    </div>
                                    <!-- Date Group -->
                                    
                                    <div class="row">
                                    
                                    <!-- Duration -->
                                    <div class="col-md-3">
                                        <label>
                                            <span>Duration</span>
                                            <select class="selectbox durationHour">
                                                <option value="">Hour</option>
                                                <option value="1">1</option>
                                                <option value="2">2</option>
                                                <option value="3">3</option>
                                                <option value="4">4</option>
                                                <option value="5">5</option>
                                                <option value="6">6</option>
                                                <option value="7">7</option>
                                                <option value="8">8</option>
                                                <option value="9">9</option>
                                                <option value="10">10</option>
                                                <option value="11">11</option>
                                                <option value="12">12</option>
                                                <option value="13">13</option>
                                                <option value="14">14</option>
                                                <option value="15">15</option>
                                                <option value="16">16</option>
                                                <option value="17">17</option>
                                                <option value="18">18</option>
                                                <option value="19">19</option>
                                                <option value="20">20</option>
                                                <option value="21">21</option>
                                                <option value="22">22</option>
                                                <option value="23">23</option>
                                                <option value="24">24</option>
                                            </select>
                                        </label>
                                    </div>
                                    <!-- Duration -->
                                    
                                    <!-- Minute -->
                                    <div class="col-md-3">
                                        <label>
                                            <span>&nbsp;</span>
                                            <select class="selectbox durationMinute">
                                                <option value="">Minutes</option>
                                                <option value="0">0</option>
                                                <option value="15">15</option>
                                                <option value="30">30</option>
                                                <option value="45">45</option>
                                            </select>
                                        </label>
                                    </div>
                                    <!-- Minute -->
                                    
                                    </div>
                                    
                                    <!-- Time Zone -->
                                    <label>
                                        <span>Timezone</span>
                                        <select class="selectbox timezone">
                                            <option value="">Select Timezone</option>
                                            <!--<option data-time-zone-id="1" data-gmt-adjustment="GMT-12:00" data-use-daylight="0" value="-12">(GMT-12:00) International Date Line West</option>-->
                                        	<!--<option data-time-zone-id="2" data-gmt-adjustment="GMT-11:00" data-use-daylight="0" value="-11">(GMT-11:00) Midway Island, Samoa</option>-->
                                        	<!--<option data-time-zone-id="3" data-gmt-adjustment="GMT-10:00" data-use-daylight="0" value="-10">(GMT-10:00) Hawaii</option>-->
                                        	<!--<option data-time-zone-id="4" data-gmt-adjustment="GMT-09:00" data-use-daylight="1" value="-9">(GMT-09:00) Alaska</option>-->
                                        	<!--<option data-time-zone-id="5" data-gmt-adjustment="GMT-08:00" data-use-daylight="1" value="-8">(GMT-08:00) Pacific Time (US & Canada)</option>-->
                                        	<!--<option data-time-zone-id="6" data-gmt-adjustment="GMT-08:00" data-use-daylight="1" value="-8">(GMT-08:00) Tijuana, Baja California</option>-->
                                        	<!--<option data-time-zone-id="7" data-gmt-adjustment="GMT-07:00" data-use-daylight="0" value="-7">(GMT-07:00) Arizona</option>-->
                                        	<!--<option data-time-zone-id="8" data-gmt-adjustment="GMT-07:00" data-use-daylight="1" value="-7">(GMT-07:00) Chihuahua, La Paz, Mazatlan</option>-->
                                        	<!--<option data-time-zone-id="9" data-gmt-adjustment="GMT-07:00" data-use-daylight="1" value="-7">(GMT-07:00) Mountain Time (US & Canada)</option>-->
                                        	<!--<option data-time-zone-id="10" data-gmt-adjustment="GMT-06:00" data-use-daylight="0" value="-6">(GMT-06:00) Central America</option>-->
                                        	<!--<option data-time-zone-id="11" data-gmt-adjustment="GMT-06:00" data-use-daylight="1" value="-6">(GMT-06:00) Central Time (US & Canada)</option>-->
                                        	<!--<option data-time-zone-id="12" data-gmt-adjustment="GMT-06:00" data-use-daylight="1" value="-6">(GMT-06:00) Guadalajara, Mexico City, Monterrey</option>-->
                                        	<!--<option data-time-zone-id="13" data-gmt-adjustment="GMT-06:00" data-use-daylight="0" value="-6">(GMT-06:00) Saskatchewan</option>-->
                                        	<!--<option data-time-zone-id="14" data-gmt-adjustment="GMT-05:00" data-use-daylight="0" value="-5">(GMT-05:00) Bogota, Lima, Quito, Rio Branco</option>-->
                                        	<!--<option data-time-zone-id="15" data-gmt-adjustment="GMT-05:00" data-use-daylight="1" value="-5">(GMT-05:00) Eastern Time (US & Canada)</option>-->
                                        	<!--<option data-time-zone-id="16" data-gmt-adjustment="GMT-05:00" data-use-daylight="1" value="-5">(GMT-05:00) Indiana (East)</option>-->
                                        	<!--<option data-time-zone-id="17" data-gmt-adjustment="GMT-04:00" data-use-daylight="1" value="-4">(GMT-04:00) Atlantic Time (Canada)</option>-->
                                        	<!--<option data-time-zone-id="18" data-gmt-adjustment="GMT-04:00" data-use-daylight="0" value="-4">(GMT-04:00) Caracas, La Paz</option>-->
                                        	<!--<option data-time-zone-id="19" data-gmt-adjustment="GMT-04:00" data-use-daylight="0" value="-4">(GMT-04:00) Manaus</option>-->
                                        	<!--<option data-time-zone-id="20" data-gmt-adjustment="GMT-04:00" data-use-daylight="1" value="-4">(GMT-04:00) Santiago</option>-->
                                        	<!--<option data-time-zone-id="21" data-gmt-adjustment="GMT-03:30" data-use-daylight="1" value="-3.5">(GMT-03:30) Newfoundland</option>-->
                                        	<!--<option data-time-zone-id="22" data-gmt-adjustment="GMT-03:00" data-use-daylight="1" value="-3">(GMT-03:00) Brasilia</option>-->
                                        	<!--<option data-time-zone-id="23" data-gmt-adjustment="GMT-03:00" data-use-daylight="0" value="-3">(GMT-03:00) Buenos Aires, Georgetown</option>-->
                                        	<!--<option data-time-zone-id="24" data-gmt-adjustment="GMT-03:00" data-use-daylight="1" value="-3">(GMT-03:00) Greenland</option>-->
                                        	<!--<option data-time-zone-id="25" data-gmt-adjustment="GMT-03:00" data-use-daylight="1" value="-3">(GMT-03:00) Montevideo</option>-->
                                        	<!--<option data-time-zone-id="26" data-gmt-adjustment="GMT-02:00" data-use-daylight="1" value="-2">(GMT-02:00) Mid-Atlantic</option>-->
                                        	<!--<option data-time-zone-id="27" data-gmt-adjustment="GMT-01:00" data-use-daylight="0" value="-1">(GMT-01:00) Cape Verde Is.</option>-->
                                        	<!--<option data-time-zone-id="28" data-gmt-adjustment="GMT-01:00" data-use-daylight="1" value="-1">(GMT-01:00) Azores</option>-->
                                        	<!--<option data-time-zone-id="29" data-gmt-adjustment="GMT+00:00" data-use-daylight="0" value="0">(GMT+00:00) Casablanca, Monrovia, Reykjavik</option>-->
                                        	<!--<option data-time-zone-id="30" data-gmt-adjustment="GMT+00:00" data-use-daylight="1" value="0">(GMT+00:00) Greenwich Mean Time : Dublin, Edinburgh, Lisbon, London</option>-->
                                        	<!--<option data-time-zone-id="31" data-gmt-adjustment="GMT+01:00" data-use-daylight="1" value="1">(GMT+01:00) Amsterdam, Berlin, Bern, Rome, Stockholm, Vienna</option>-->
                                        	<!--<option data-time-zone-id="32" data-gmt-adjustment="GMT+01:00" data-use-daylight="1" value="1">(GMT+01:00) Belgrade, Bratislava, Budapest, Ljubljana, Prague</option>-->
                                        	<!--<option data-time-zone-id="33" data-gmt-adjustment="GMT+01:00" data-use-daylight="1" value="1">(GMT+01:00) Brussels, Copenhagen, Madrid, Paris</option>-->
                                        	<!--<option data-time-zone-id="34" data-gmt-adjustment="GMT+01:00" data-use-daylight="1" value="1">(GMT+01:00) Sarajevo, Skopje, Warsaw, Zagreb</option>-->
                                        	<!--<option data-time-zone-id="35" data-gmt-adjustment="GMT+01:00" data-use-daylight="1" value="1">(GMT+01:00) West Central Africa</option>-->
                                        	<!--<option data-time-zone-id="36" data-gmt-adjustment="GMT+02:00" data-use-daylight="1" value="2">(GMT+02:00) Amman</option>-->
                                        	<!--<option data-time-zone-id="37" data-gmt-adjustment="GMT+02:00" data-use-daylight="1" value="2">(GMT+02:00) Athens, Bucharest, Istanbul</option>-->
                                        	<!--<option data-time-zone-id="38" data-gmt-adjustment="GMT+02:00" data-use-daylight="1" value="2">(GMT+02:00) Beirut</option>-->
                                        	<!--<option data-time-zone-id="39" data-gmt-adjustment="GMT+02:00" data-use-daylight="1" value="2">(GMT+02:00) Cairo</option>-->
                                        	<!--<option data-time-zone-id="40" data-gmt-adjustment="GMT+02:00" data-use-daylight="0" value="2">(GMT+02:00) Harare, Pretoria</option>-->
                                        	<!--<option data-time-zone-id="41" data-gmt-adjustment="GMT+02:00" data-use-daylight="1" value="2">(GMT+02:00) Helsinki, Kyiv, Riga, Sofia, Tallinn, Vilnius</option>-->
                                        	<!--<option data-time-zone-id="42" data-gmt-adjustment="GMT+02:00" data-use-daylight="1" value="2">(GMT+02:00) Jerusalem</option>-->
                                        	<!--<option data-time-zone-id="43" data-gmt-adjustment="GMT+02:00" data-use-daylight="1" value="2">(GMT+02:00) Minsk</option>-->
                                        	<!--<option data-time-zone-id="44" data-gmt-adjustment="GMT+02:00" data-use-daylight="1" value="2">(GMT+02:00) Windhoek</option>-->
                                        	<!--<option data-time-zone-id="45" data-gmt-adjustment="GMT+03:00" data-use-daylight="0" value="3">(GMT+03:00) Kuwait, Riyadh, Baghdad</option>-->
                                        	<!--<option data-time-zone-id="46" data-gmt-adjustment="GMT+03:00" data-use-daylight="1" value="3">(GMT+03:00) Moscow, St. Petersburg, Volgograd</option>-->
                                        	<!--<option data-time-zone-id="47" data-gmt-adjustment="GMT+03:00" data-use-daylight="0" value="3">(GMT+03:00) Nairobi</option>-->
                                        	<!--<option data-time-zone-id="48" data-gmt-adjustment="GMT+03:00" data-use-daylight="0" value="3">(GMT+03:00) Tbilisi</option>-->
                                        	<!--<option data-time-zone-id="49" data-gmt-adjustment="GMT+03:30" data-use-daylight="1" value="3.5">(GMT+03:30) Tehran</option>-->
                                        	<!--<option data-time-zone-id="50" data-gmt-adjustment="GMT+04:00" data-use-daylight="0" value="4">(GMT+04:00) Abu Dhabi, Muscat</option>-->
                                        	<!--<option data-time-zone-id="51" data-gmt-adjustment="GMT+04:00" data-use-daylight="1" value="4">(GMT+04:00) Baku</option>-->
                                        	<!--<option data-time-zone-id="52" data-gmt-adjustment="GMT+04:00" data-use-daylight="1" value="4">(GMT+04:00) Yerevan</option>-->
                                        	<!--<option data-time-zone-id="53" data-gmt-adjustment="GMT+04:30" data-use-daylight="0" value="4.5">(GMT+04:30) Kabul</option>-->
                                        	<!--<option data-time-zone-id="54" data-gmt-adjustment="GMT+05:00" data-use-daylight="1" value="5">(GMT+05:00) Yekaterinburg</option>-->
                                        	<!--<option data-time-zone-id="55" data-gmt-adjustment="GMT+05:00" data-use-daylight="0" value="5">(GMT+05:00) Islamabad, Karachi, Tashkent</option>-->
                                        	<!--<option data-time-zone-id="56" data-gmt-adjustment="GMT+05:30" data-use-daylight="0" value="5.5">(GMT+05:30) Sri Jayawardenapura</option>-->
                                        	<!--<option data-time-zone-id="57" data-gmt-adjustment="GMT+05:30" data-use-daylight="0" value="5.5">(GMT+05:30) Chennai, Kolkata, Mumbai, New Delhi</option>-->
                                        	<!--<option data-time-zone-id="58" data-gmt-adjustment="GMT+05:45" data-use-daylight="0" value="5.75">(GMT+05:45) Kathmandu</option>-->
                                        	<!--<option data-time-zone-id="59" data-gmt-adjustment="GMT+06:00" data-use-daylight="1" value="6">(GMT+06:00) Almaty, Novosibirsk</option>-->
                                        	<!--<option data-time-zone-id="60" data-gmt-adjustment="GMT+06:00" data-use-daylight="0" value="6">(GMT+06:00) Astana, Dhaka</option>-->
                                        	<!--<option data-time-zone-id="61" data-gmt-adjustment="GMT+06:30" data-use-daylight="0" value="6.5">(GMT+06:30) Yangon (Rangoon)</option>-->
                                        	<!--<option data-time-zone-id="62" data-gmt-adjustment="GMT+07:00" data-use-daylight="0" value="7">(GMT+07:00) Bangkok, Hanoi, Jakarta</option>-->
                                        	<!--<option data-time-zone-id="63" data-gmt-adjustment="GMT+07:00" data-use-daylight="1" value="7">(GMT+07:00) Krasnoyarsk</option>-->
                                        	<!--<option data-time-zone-id="64" data-gmt-adjustment="GMT+08:00" data-use-daylight="0" value="8">(GMT+08:00) Beijing, Chongqing, Hong Kong, Urumqi</option>-->
                                        	<!--<option data-time-zone-id="65" data-gmt-adjustment="GMT+08:00" data-use-daylight="0" value="8">(GMT+08:00) Kuala Lumpur, Singapore</option>-->
                                        	<!--<option data-time-zone-id="66" data-gmt-adjustment="GMT+08:00" data-use-daylight="0" value="8">(GMT+08:00) Irkutsk, Ulaan Bataar</option>-->
                                        	<!--<option data-time-zone-id="67" data-gmt-adjustment="GMT+08:00" data-use-daylight="0" value="8">(GMT+08:00) Perth</option>-->
                                        	<!--<option data-time-zone-id="68" data-gmt-adjustment="GMT+08:00" data-use-daylight="0" value="8">(GMT+08:00) Taipei</option>-->
                                        	<!--<option data-time-zone-id="69" data-gmt-adjustment="GMT+09:00" data-use-daylight="0" value="9">(GMT+09:00) Osaka, Sapporo, Tokyo</option>-->
                                        	<!--<option data-time-zone-id="70" data-gmt-adjustment="GMT+09:00" data-use-daylight="0" value="9">(GMT+09:00) Seoul</option>-->
                                        	<!--<option data-time-zone-id="71" data-gmt-adjustment="GMT+09:00" data-use-daylight="1" value="9">(GMT+09:00) Yakutsk</option>-->
                                        	<!--<option data-time-zone-id="72" data-gmt-adjustment="GMT+09:30" data-use-daylight="0" value="9.5">(GMT+09:30) Adelaide</option>-->
                                        	<!--<option data-time-zone-id="73" data-gmt-adjustment="GMT+09:30" data-use-daylight="0" value="9.5">(GMT+09:30) Darwin</option>-->
                                        	<!--<option data-time-zone-id="74" data-gmt-adjustment="GMT+10:00" data-use-daylight="0" value="10">(GMT+10:00) Brisbane</option>-->
                                        	<!--<option data-time-zone-id="75" data-gmt-adjustment="GMT+10:00" data-use-daylight="1" value="10">(GMT+10:00) Canberra, Melbourne, Sydney</option>-->
                                        	<!--<option data-time-zone-id="76" data-gmt-adjustment="GMT+10:00" data-use-daylight="1" value="10">(GMT+10:00) Hobart</option>-->
                                        	<!--<option data-time-zone-id="77" data-gmt-adjustment="GMT+10:00" data-use-daylight="0" value="10">(GMT+10:00) Guam, Port Moresby</option>-->
                                        	<!--<option data-time-zone-id="78" data-gmt-adjustment="GMT+10:00" data-use-daylight="1" value="10">(GMT+10:00) Vladivostok</option>-->
                                        	<!--<option data-time-zone-id="79" data-gmt-adjustment="GMT+11:00" data-use-daylight="1" value="11">(GMT+11:00) Magadan, Solomon Is., New Caledonia</option>-->
                                        	<!--<option data-time-zone-id="80" data-gmt-adjustment="GMT+12:00" data-use-daylight="1" value="12">(GMT+12:00) Auckland, Wellington</option>-->
                                        	<!--<option data-time-zone-id="81" data-gmt-adjustment="GMT+12:00" data-use-daylight="0" value="12">(GMT+12:00) Fiji, Kamchatka, Marshall Is.</option>-->
                                        	<!--<option data-time-zone-id="82" data-gmt-adjustment="GMT+13:00" data-use-daylight="0" value="13">(GMT+13:00) Nuku'alofa</option>-->
                                        	<option value="Etc/GMT+12">(GMT-12:00) International Date Line West</option>
                                            <option value="Pacific/Midway">(GMT-11:00) Midway Island, Samoa</option>
                                            <option value="Pacific/Honolulu">(GMT-10:00) Hawaii</option>
                                            <option value="US/Alaska">(GMT-09:00) Alaska</option>
                                            <option value="America/Los_Angeles">(GMT-08:00) Pacific Time (US & Canada)</option>
                                            <option value="America/Tijuana">(GMT-08:00) Tijuana, Baja California</option>
                                            <option value="US/Arizona">(GMT-07:00) Arizona</option>
                                            <option value="America/Chihuahua">(GMT-07:00) Chihuahua, La Paz, Mazatlan</option>
                                            <option value="US/Mountain">(GMT-07:00) Mountain Time (US & Canada)</option>
                                            <option value="America/Managua">(GMT-06:00) Central America</option>
                                            <option value="US/Central">(GMT-06:00) Central Time (US & Canada)</option>
                                            <option value="America/Mexico_City">(GMT-06:00) Guadalajara, Mexico City, Monterrey</option>
                                            <option value="Canada/Saskatchewan">(GMT-06:00) Saskatchewan</option>
                                            <option value="America/Bogota">(GMT-05:00) Bogota, Lima, Quito, Rio Branco</option>
                                            <option value="US/Eastern">(GMT-05:00) Eastern Time (US & Canada)</option>
                                            <option value="US/East-Indiana">(GMT-05:00) Indiana (East)</option>
                                            <option value="Canada/Atlantic">(GMT-04:00) Atlantic Time (Canada)</option>
                                            <option value="America/Caracas">(GMT-04:00) Caracas, La Paz</option>
                                            <option value="America/Manaus">(GMT-04:00) Manaus</option>
                                            <option value="America/Santiago">(GMT-04:00) Santiago</option>
                                            <option value="Canada/Newfoundland">(GMT-03:30) Newfoundland</option>
                                            <option value="America/Sao_Paulo">(GMT-03:00) Brasilia</option>
                                            <option value="America/Argentina/Buenos_Aires">(GMT-03:00) Buenos Aires, Georgetown</option>
                                            <option value="America/Godthab">(GMT-03:00) Greenland</option>
                                            <option value="America/Montevideo">(GMT-03:00) Montevideo</option>
                                            <option value="America/Noronha">(GMT-02:00) Mid-Atlantic</option>
                                            <option value="Atlantic/Cape_Verde">(GMT-01:00) Cape Verde Is.</option>
                                            <option value="Atlantic/Azores">(GMT-01:00) Azores</option>
                                            <option value="Africa/Casablanca">(GMT+00:00) Casablanca, Monrovia, Reykjavik</option>
                                            <option value="Etc/Greenwich">(GMT+00:00) Greenwich Mean Time : Dublin, Edinburgh, Lisbon, London</option>
                                            <option value="Europe/Amsterdam">(GMT+01:00) Amsterdam, Berlin, Bern, Rome, Stockholm, Vienna</option>
                                            <option value="Europe/Belgrade">(GMT+01:00) Belgrade, Bratislava, Budapest, Ljubljana, Prague</option>
                                            <option value="Europe/Brussels">(GMT+01:00) Brussels, Copenhagen, Madrid, Paris</option>
                                            <option value="Europe/Sarajevo">(GMT+01:00) Sarajevo, Skopje, Warsaw, Zagreb</option>
                                            <option value="Africa/Lagos">(GMT+01:00) West Central Africa</option>
                                            <option value="Asia/Amman">(GMT+02:00) Amman</option>
                                            <option value="Europe/Athens">(GMT+02:00) Athens, Bucharest, Istanbul</option>
                                            <option value="Asia/Beirut">(GMT+02:00) Beirut</option>
                                            <option value="Africa/Cairo">(GMT+02:00) Cairo</option>
                                            <option value="Africa/Harare">(GMT+02:00) Harare, Pretoria</option>
                                            <option value="Europe/Helsinki">(GMT+02:00) Helsinki, Kyiv, Riga, Sofia, Tallinn, Vilnius</option>
                                            <option value="Asia/Jerusalem">(GMT+02:00) Jerusalem</option>
                                            <option value="Europe/Minsk">(GMT+02:00) Minsk</option>
                                            <option value="Africa/Windhoek">(GMT+02:00) Windhoek</option>
                                            <option value="Asia/Kuwait">(GMT+03:00) Kuwait, Riyadh, Baghdad</option>
                                            <option value="Europe/Moscow">(GMT+03:00) Moscow, St. Petersburg, Volgograd</option>
                                            <option value="Africa/Nairobi">(GMT+03:00) Nairobi</option>
                                            <option value="Asia/Tbilisi">(GMT+03:00) Tbilisi</option>
                                            <option value="Asia/Tehran">(GMT+03:30) Tehran</option>
                                            <option value="Asia/Muscat">(GMT+04:00) Abu Dhabi, Muscat</option>
                                            <option value="Asia/Baku">(GMT+04:00) Baku</option>
                                            <option value="Asia/Yerevan">(GMT+04:00) Yerevan</option>
                                            <option value="Asia/Kabul">(GMT+04:30) Kabul</option>
                                            <option value="Asia/Yekaterinburg">(GMT+05:00) Yekaterinburg</option>
                                            <option value="Asia/Karachi">(GMT+05:00) Islamabad, Karachi, Tashkent</option>
                                            <option value="Asia/Calcutta">(GMT+05:30) Chennai, Kolkata, Mumbai, New Delhi</option>
                                            <option value="Asia/Calcutta">(GMT+05:30) Sri Jayawardenapura</option>
                                            <option value="Asia/Katmandu">(GMT+05:45) Kathmandu</option>
                                            <option value="Asia/Almaty">(GMT+06:00) Almaty, Novosibirsk</option>
                                            <option value="Asia/Dhaka">(GMT+06:00) Astana, Dhaka</option>
                                            <option value="Asia/Rangoon">(GMT+06:30) Yangon (Rangoon)</option>
                                            <option value="Asia/Bangkok">(GMT+07:00) Bangkok, Hanoi, Jakarta</option>
                                            <option value="Asia/Krasnoyarsk">(GMT+07:00) Krasnoyarsk</option>
                                            <option value="Asia/Hong_Kong">(GMT+08:00) Beijing, Chongqing, Hong Kong, Urumqi</option>
                                            <option value="Asia/Kuala_Lumpur">(GMT+08:00) Kuala Lumpur, Singapore</option>
                                            <option value="Asia/Irkutsk">(GMT+08:00) Irkutsk, Ulaan Bataar</option>
                                            <option value="Australia/Perth">(GMT+08:00) Perth</option>
                                            <option value="Asia/Taipei">(GMT+08:00) Taipei</option>
                                            <option value="Asia/Tokyo">(GMT+09:00) Osaka, Sapporo, Tokyo</option>
                                            <option value="Asia/Seoul">(GMT+09:00) Seoul</option>
                                            <option value="Asia/Yakutsk">(GMT+09:00) Yakutsk</option>
                                            <option value="Australia/Adelaide">(GMT+09:30) Adelaide</option>
                                            <option value="Australia/Darwin">(GMT+09:30) Darwin</option>
                                            <option value="Australia/Brisbane">(GMT+10:00) Brisbane</option>
                                            <option value="Australia/Canberra">(GMT+10:00) Canberra, Melbourne, Sydney</option>
                                            <option value="Australia/Hobart">(GMT+10:00) Hobart</option>
                                            <option value="Pacific/Guam">(GMT+10:00) Guam, Port Moresby</option>
                                            <option value="Asia/Vladivostok">(GMT+10:00) Vladivostok</option>
                                            <option value="Asia/Magadan">(GMT+11:00) Magadan, Solomon Is., New Caledonia</option>
                                            <option value="Pacific/Auckland">(GMT+12:00) Auckland, Wellington</option>
                                            <option value="Pacific/Fiji">(GMT+12:00) Fiji, Kamchatka, Marshall Is.</option>
                                            <option value="Pacific/Tongatapu">(GMT+13:00) Nuku'alofa</option>
                                        </select>
                                    </label>
                                    <!-- Time Zone -->
                                    
                                    <!-- Attendee -->
                                    <label>
                                        <span>Attendee/s</span>
                                        <div class="selectsearch">
                                            
                                            <div class="searchBox-group">
                                                <input type="text" class="searchBox users" placeholder="Search Patient or Physician Name">
                                                <a href="javascript:;" class="close"><ion-icon name="close-circle-outline"></ion-icon></a>
                                                <a href="javascript:;" class="option-link add-custom-attendee">Add Custom Attendee</a>
                                            </div>
                                            
                                            <div class="attendeeOption-group">
                                                <label>
                                                    <select class="selectbox isoCode">
                                                        <option value="+93">AF</option>
                                                        <option value="+355">AL</option>
                                                        <option value="+213">DZ</option>
                                                        <option value="+1684">AS</option>
                                                        <option value="+376">AD</option>
                                                        <option value="+244">AO</option>
                                                        <option value="+1264">AI</option>
                                                        <option value="+0">AQ</option>
                                                        <option value="+1268">AG</option>
                                                        <option value="+54">AR</option>
                                                        <option value="+374">AM</option>
                                                        <option value="+297">AW</option>
                                                        <option value="+61">AU</option>
                                                        <option value="+43">AT</option>
                                                        <option value="+994">AZ</option>
                                                        <option value="+1242">BS</option>
                                                        <option value="+973">BH</option>
                                                        <option value="+880">BD</option>
                                                        <option value="+1246">BB</option>
                                                        <option value="+375">BY</option>
                                                        <option value="+32">BE</option>
                                                        <option value="+501">BZ</option>
                                                        <option value="+229">BJ</option>
                                                        <option value="+1441">BM</option>
                                                        <option value="+975">BT</option>
                                                        <option value="+591">BO</option>
                                                        <option value="+387">BA</option>
                                                        <option value="+267">BW</option>
                                                        <option value="+0">BV</option>
                                                        <option value="+55">BR</option>
                                                        <option value="+246">IO</option>
                                                        <option value="+673">BN</option>
                                                        <option value="+359">BG</option>
                                                        <option value="+226">BF</option>
                                                        <option value="+257">BI</option>
                                                        <option value="+855">KH</option>
                                                        <option value="+237">CM</option>
                                                        <option value="+1">CA</option>
                                                        <option value="+238">CV</option>
                                                        <option value="+1345">KY</option>
                                                        <option value="+236">CF</option>
                                                        <option value="+235">TD</option>
                                                        <option value="+56">CL</option>
                                                        <option value="+86">CN</option>
                                                        <option value="+61">CX</option>
                                                        <option value="+672">CC</option>
                                                        <option value="+57">CO</option>
                                                        <option value="+269">KM</option>
                                                        <option value="+242">CG</option>
                                                        <option value="+242">CD</option>
                                                        <option value="+682">CK</option>
                                                        <option value="+506">CR</option>
                                                        <option value="+225">CI</option>
                                                        <option value="+385">HR</option>
                                                        <option value="+53">CU</option>
                                                        <option value="+357">CY</option>
                                                        <option value="+420">CZ</option>
                                                        <option value="+45">DK</option>
                                                        <option value="+253">DJ</option>
                                                        <option value="+1767">DM</option>
                                                        <option value="+1809">DO</option>
                                                        <option value="+670">TP</option>
                                                        <option value="+593">EC</option>
                                                        <option value="+20">EG</option>
                                                        <option value="+503">SV</option>
                                                        <option value="+240">GQ</option>
                                                        <option value="+291">ER</option>
                                                        <option value="+372">EE</option>
                                                        <option value="+251">ET</option>
                                                        <option value="+61">XA</option>
                                                        <option value="+500">FK</option>
                                                        <option value="+298">FO</option>
                                                        <option value="+679">FJ</option>
                                                        <option value="+358">FI</option>
                                                        <option value="+33">FR</option>
                                                        <option value="+594">GF</option>
                                                        <option value="+689">PF</option>
                                                        <option value="+0">TF</option>
                                                        <option value="+241">GA</option>
                                                        <option value="+220">GM</option>
                                                        <option value="+995">GE</option>
                                                        <option value="+49">DE</option>
                                                        <option value="+233">GH</option>
                                                        <option value="+350">GI</option>
                                                        <option value="+30">GR</option>
                                                        <option value="+299">GL</option>
                                                        <option value="+1473">GD</option>
                                                        <option value="+590">GP</option>
                                                        <option value="+1671">GU</option>
                                                        <option value="+502">GT</option>
                                                        <option value="+44">XU</option>
                                                        <option value="+224">GN</option>
                                                        <option value="+245">GW</option>
                                                        <option value="+592">GY</option>
                                                        <option value="+509">HT</option>
                                                        <option value="+0">HM</option>
                                                        <option value="+504">HN</option>
                                                        <option value="+852">HK</option>
                                                        <option value="+36">HU</option>
                                                        <option value="+354">IS</option>
                                                        <option value="+91">IN</option>
                                                        <option value="+62">ID</option>
                                                        <option value="+98">IR</option>
                                                        <option value="+964">IQ</option>
                                                        <option value="+353">IE</option>
                                                        <option value="+972">IL</option>
                                                        <option value="+39">IT</option>
                                                        <option value="+1876">JM</option>
                                                        <option value="+81">JP</option>
                                                        <option value="+44">XJ</option>
                                                        <option value="+962">JO</option>
                                                        <option value="+7">KZ</option>
                                                        <option value="+254">KE</option>
                                                        <option value="+686">KI</option>
                                                        <option value="+850">KP</option>
                                                        <option value="+82">KR</option>
                                                        <option value="+965">KW</option>
                                                        <option value="+996">KG</option>
                                                        <option value="+856">LA</option>
                                                        <option value="+371">LV</option>
                                                        <option value="+961">LB</option>
                                                        <option value="+266">LS</option>
                                                        <option value="+231">LR</option>
                                                        <option value="+218">LY</option>
                                                        <option value="+423">LI</option>
                                                        <option value="+370">LT</option>
                                                        <option value="+352">LU</option>
                                                        <option value="+853">MO</option>
                                                        <option value="+389">MK</option>
                                                        <option value="+261">MG</option>
                                                        <option value="+265">MW</option>
                                                        <option value="+60">MY</option>
                                                        <option value="+960">MV</option>
                                                        <option value="+223">ML</option>
                                                        <option value="+356">MT</option>
                                                        <option value="+44">XM</option>
                                                        <option value="+692">MH</option>
                                                        <option value="+596">MQ</option>
                                                        <option value="+222">MR</option>
                                                        <option value="+230">MU</option>
                                                        <option value="+269">YT</option>
                                                        <option value="+52">MX</option>
                                                        <option value="+691">FM</option>
                                                        <option value="+373">MD</option>
                                                        <option value="+377">MC</option>
                                                        <option value="+976">MN</option>
                                                        <option value="+1664">MS</option>
                                                        <option value="+212">MA</option>
                                                        <option value="+258">MZ</option>
                                                        <option value="+95">MM</option>
                                                        <option value="+264">NA</option>
                                                        <option value="+674">NR</option>
                                                        <option value="+977">NP</option>
                                                        <option value="+599">AN</option>
                                                        <option value="+31">NL</option>
                                                        <option value="+687">NC</option>
                                                        <option value="+64">NZ</option>
                                                        <option value="+505">NI</option>
                                                        <option value="+227">NE</option>
                                                        <option value="+234">NG</option>
                                                        <option value="+683">NU</option>
                                                        <option value="+672">NF</option>
                                                        <option value="+1670">MP</option>
                                                        <option value="+47">NO</option>
                                                        <option value="+968">OM</option>
                                                        <option value="+92">PK</option>
                                                        <option value="+680">PW</option>
                                                        <option value="+970">PS</option>
                                                        <option value="+507">PA</option>
                                                        <option value="+675">PG</option>
                                                        <option value="+595">PY</option>
                                                        <option value="+51">PE</option>
                                                        <option value="+63">PH</option>
                                                        <option value="+0">PN</option>
                                                        <option value="+48">PL</option>
                                                        <option value="+351">PT</option>
                                                        <option value="+1787">PR</option>
                                                        <option value="+974">QA</option>
                                                        <option value="+262">RE</option>
                                                        <option value="+40">RO</option>
                                                        <option value="+70">RU</option>
                                                        <option value="+250">RW</option>
                                                        <option value="+290">SH</option>
                                                        <option value="+1869">KN</option>
                                                        <option value="+1758">LC</option>
                                                        <option value="+508">PM</option>
                                                        <option value="+1784">VC</option>
                                                        <option value="+684">WS</option>
                                                        <option value="+378">SM</option>
                                                        <option value="+239">ST</option>
                                                        <option value="+966">SA</option>
                                                        <option value="+221">SN</option>
                                                        <option value="+381">RS</option>
                                                        <option value="+248">SC</option>
                                                        <option value="+232">SL</option>
                                                        <option value="+65">SG</option>
                                                        <option value="+421">SK</option>
                                                        <option value="+386">SI</option>
                                                        <option value="+44">XG</option>
                                                        <option value="+677">SB</option>
                                                        <option value="+252">SO</option>
                                                        <option value="+27">ZA</option>
                                                        <option value="+0">GS</option>
                                                        <option value="+211">SS</option>
                                                        <option value="+34">ES</option>
                                                        <option value="+94">LK</option>
                                                        <option value="+249">SD</option>
                                                        <option value="+597">SR</option>
                                                        <option value="+47">SJ</option>
                                                        <option value="+268">SZ</option>
                                                        <option value="+46">SE</option>
                                                        <option value="+41">CH</option>
                                                        <option value="+963">SY</option>
                                                        <option value="+886">TW</option>
                                                        <option value="+992">TJ</option>
                                                        <option value="+255">TZ</option>
                                                        <option value="+66">TH</option>
                                                        <option value="+228">TG</option>
                                                        <option value="+690">TK</option>
                                                        <option value="+676">TO</option>
                                                        <option value="+1868">TT</option>
                                                        <option value="+216">TN</option>
                                                        <option value="+90">TR</option>
                                                        <option value="+7370">TM</option>
                                                        <option value="+1649">TC</option>
                                                        <option value="+688">TV</option>
                                                        <option value="+256">UG</option>
                                                        <option value="+380">UA</option>
                                                        <option value="+971">AE</option>
                                                        <option value="+44">GB</option>
                                                        <option value="+1" selected>US</option>
                                                        <option value="+1">UM</option>
                                                        <option value="+598">UY</option>
                                                        <option value="+998">UZ</option>
                                                        <option value="+678">VU</option>
                                                        <option value="+39">VA</option>
                                                        <option value="+58">VE</option>
                                                        <option value="+84">VN</option>
                                                        <option value="+1284">VG</option>
                                                        <option value="+1340">VI</option>
                                                        <option value="+681">WF</option>
                                                        <option value="+212">EH</option>
                                                        <option value="+967">YE</option>
                                                        <option value="+38">YU</option>
                                                        <option value="+260">ZM</option>
                                                        <option value="+263">ZW</option>
                                                    </select>
                                                </label>
                                                
                                                <label>
                                                    <ion-icon name="call-outline"></ion-icon>
                                                    <input type="number" class="add-textbox phone" placeholder="Enter Phone">
                                                </label>
                                                
                                                <span class="or">OR</span>
                                                    
                                                <label>
                                                    <ion-icon name="mail-outline"></ion-icon>
                                                    <input type="text" class="add-textbox email" placeholder="Enter Email">
                                                </label>
                                                <a href="javascript:;" class="add">Add to list</a>
                                                <div><a href="javascript:;" class="option-link switch-to-search">Switch to search</a></div>
                                            </div>
                                            
                                            <ul class="search-result">
                                                <li class="label">Physicians</li>
                                                <li class="item">Brendan Salgado</li>
                                                <li class="item">Naseem Hooper</li>
                                                <li class="item">Kristian Edmonds</li>
                                                <li class="item">Ellise Magana</li>
                                                <li class="item">Rania Whittaker</li>
                                                <li class="item">Gruffydd Hastings</li>
                                                <li class="item">Joyce Webb</li>
                                                <li class="item">Rebekka Walter</li>
                                                <li class="item">Tymon Ayala</li>
                                                <li class="item">Pascal Keller</li>
                                                
                                                <li class="label">Patients</li>
                                                <li class="item">Sheila Mclellan</li>
                                                <li class="item">Faraz Dean</li>
                                                <li class="item">Misha Meyers</li>
                                                <li class="item">Nazia Figueroa</li>
                                                <li class="item">Milton Zuniga</li>
                                                <li class="item">Maximillian Moyer</li>
                                                <li class="item">Philip Barlow</li>
                                                <li class="item">Estelle Parrish</li>
                                                <li class="item">Priya Barry</li>
                                                <li class="item">Taylor Churchill</li>
                                                <li class="item">Homer Holman</li>
                                                <li class="item">Etta Morales</li>
                                                <li class="item">Szymon Gilbert</li>
                                                <li class="item">Manon Deleon</li>
                                                <li class="item">Kaira Bob</li>
                                                <li class="item">Lilly-Grace Bates</li>
                                                <li class="item">Selena Fox</li>
                                                <li class="item">Reilly O'Ryan</li>
                                                <li class="item">Cienna Gallagher</li>
                                                <li class="item">Taliah Ramsay</li>
                                            </ul>
                                            <div class="placeholder"></div>
                                        </div>
                                    </label>
                                    <!-- Attendee -->
                                    
                                    <!-- Meeting Notes -->
                                    <label>
                                        <span>Meeting Notes</span>
                                        <textarea class="textarea meeetingNotes" cols="100"></textarea>
                                    </label>
                                    <!-- Meeting Notes -->
                                    
                                    <!-- Submit Button -->
                                    <input type="submit" class="btn_create_meeting" value="Create Meeting">
                                    <!-- Submit Button -->
                                    
                                </div>
                            </div>
                        
                            <div class="reccuring">
                                <label>
                                    <span>Recurring Meeting</span>
                                    <p>Is this repeating on daily, weekly of monthly basis?</p>
                                    <img src="assets/images/switch-off.svg" class="rec-toggle off" data-reccuring-meeting="off">
                                </label>
                                
                                <div class="row reccuring_meeting">
                                    
                                    <div class="col-md-12 recurrence">
                                        <label>
                                            <span>Recurrence</span>
                                            <select class="selectbox select-recurrence">
                                                <option value="daily" selected>Daily</option>
                                                <option value="weekly">Weekly</option>
                                                <option value="monthly">Monthly</option>
                                            </select>
                                        </label>
                                    </div>
                                    
                                    <div class="clear"></div>
                                    
                                    <!-- Weekly -->
                                    <div class="rec_group weekly">
                                        <div class="col-md-12">
                                            <label>
                                                <span>Weekly Occurrence on</span>
                                            </label>
                                            
                                            <div>
                                                <strong><input type="checkbox" name="weekly_occurance" value="mon">Mon</strong>
                                                <strong><input type="checkbox" name="weekly_occurance" value="tue">Tue</strong>
                                                <strong><input type="checkbox" name="weekly_occurance" value="Wed">Wed</strong>
                                                <strong><input type="checkbox" name="weekly_occurance" value="Thu">Thu</strong>
                                                <strong><input type="checkbox" name="weekly_occurance" value="Fri">Fri</strong>
                                                <strong><input type="checkbox" name="weekly_occurance" value="Sat">Sat</strong>
                                                <strong><input type="checkbox" name="weekly_occurance" value="Sun">Sun</strong>
                                            </div>
                                        </div>
                                    </div>
                                    <!-- Weekly -->
                                    
                                    <!-- Monthly -->
                                    <div class="col-md-12">
                                        <div class="rec_group monthly">
                                            <label>
                                                <span>Which day of the month?</span>
                                                <select class="selectbox">
                                                    <option>Select day</option>
                                                    <?php
                                                    for( $x = 1; $x <= 30; $x++ ){
                                                        echo '<option>'.$x.'</option>';
                                                    }
                                                    ?>
                                                </select>
                                            </label>
                                        </div>
                                    </div>
                                    <!-- Monthly -->
                                    
                                    
                                </div>
                        </div>
                        
                        
                            <div class="clear"></div>
                        
                        </form>
                    </div>
                </div>
            </div>
        </div>

        <?php
            if( $_SESSION['user_type'] == 'nurse' ){
                provider_bottom_nav();
            }elseif( $_SESSION['user_type'] == 'physician' || $_SESSION['user_type'] == 'doctor' ){
                physician_bottom_nav();
            }
        ?>

    </body>
</html>
