<!DOCTYPE html>
<html>
<head>
	<title>Doctor AI</title>
	
	<meta name="viewport" content="width=device-width, initial-scale=1">
	
	<link rel="stylesheet" type="text/css" href="assets/css/reset.css">
	<link rel="stylesheet" type="text/css" href="assets/css/grid.css">
	<link rel="stylesheet" type="text/css" href="assets/css/select2.min.css">
	<link rel="stylesheet" type="text/css" href="assets/css/default.css">
	
	<script type="text/javascript" src="assets/js/jquery.min.js"></script>
	<script type="text/javascript" src="assets/js/select2.full.min.js"></script>
	
	<script type="text/javascript">
	    
	    $(document).ready(function() {
	   
	        // Initialize Select2 Dropdown
            $('.selectBox').select2({
                width: "100%",
            });
            
            
            
            
            
            $(document).on('change','.selectBox',function(){
                
                if( $('.version').val() == 'default' ){
                    $('.loginTypeContainer').hide();
                }else{
                    $('.loginTypeContainer').show();
                }
                
                if( $('.version').val() != 'default' && $('.logintype').val() != 'default' ){
                    $('.select_version').show();
                    $('.select_version').addClass('enabled');
                    $('.select_version').removeClass('disabled');
                }else{
                    $('.select_version').hide();
                    $('.select_version').addClass('disabled');
                    $('.select_version').removeClass('enabled');
                }
                
            });
            
            // Redirect to clinic
            $('body').on('click', '.select_version.enabled', function() {
                window.location.replace( $('.version').val() + $('.logintype').val() );
            });
            
        });
	    
	</script>
	
</head>
<body>
    
    <div class="main-wrapper">
        <div class="inner-wrapper">
        
            <div class="header-container">
                <div class="container">
                    <div class="col-md-12">
                        <img src="assets/images/logo.png" class="logo">
                    </div>
                    <div class="clear"></div>
                </div>
            </div>
            
            <div class="content-container">
                <div class="container">
                    <div class="inner">
                        
                        <div class="col-md-12">
                            
                            <h6 class="label">Select Action</h6>
                            <select class="selectBox version" name="state">
                                <option value="default">Select Version</option>
                                <option value="https://bd.ddxrx.com/">Bangladesh Version</option>
                                <option value="https://patient.ddxrx.com/">US Version</option>
                            </select>
                            
                            <div class="loginTypeContainer" style="display:none">
                                <div style="width: 100%; height: 10px;"></div>
                                <select class="selectBox logintype" name="state">
                                    <option value="default">Select User</option>
                                    <option value="patient_login.php">Patient</option>
                                    <option value="provider_login.php">Provider</option>
                                </select>
                            </div>
                            
                            <input type="submit" class="button select_version disabled" value="Next" style="margin-top: 10px; display: none">
                            
                        </div>
                    
                        <div class="clear"></div>
                    </div>
                </div>
            </div>
        
        </div>
    </div>
    
</body>
</html>