<?php

session_start();

// Include the functions file
include('process/functions.php');

// Check if the session has expired
checkSessionTimeout();

if( !isset($_SESSION['userType']) ){

    header("Location: logout.php");
    die();

}

if( isset($_GET['patient_id']) && isset($_GET['uid']) ){

    $patient_id = $_GET['patient_id'];
    $uid = $_GET['uid'];
    $linkParameters = "&patient_id=".$patient_id."&uid=".$uid."&id=".$patient_id;

}else{

    $patient_id = $_SESSION['patient_id'];
    $uid = $_SESSION['userid'];
    $linkParameters = "";

}

    // Get the patient details
    $sql = "SELECT * FROM patients WHERE patient_id = '$patient_id' LIMIT 1";
    $result = mysqli_query(ddxrxDBConnect(), $sql) or die('SQL Error :: '.mysqli_error());
    $user = mysqli_fetch_assoc($result);

    // Get the signed orders with provider details (either physician or nurse)
    $sql_signed_orders = "SELECT signed_order.*, 
               COALESCE(physician.user_id, nurse.user_id) AS provider_id,
               COALESCE(physician.physician_fname, nurse.nurse_fname) AS provider_fname,
               COALESCE(physician.physician_lname, nurse.nurse_lname) AS provider_lname
        FROM signed_order
        LEFT JOIN physician ON signed_order.provider_id = physician.user_id
        LEFT JOIN nurse ON signed_order.provider_id = nurse.user_id
        WHERE signed_order.patient_id = '$patient_id' order by signed_order.id desc";
    
    $result_signed_orders = mysqli_query(ddxrxDBConnect(), $sql_signed_orders) or die('SQL Error :: '.mysqli_error());
    $signed_orders = [];
    while ($row = mysqli_fetch_assoc($result_signed_orders)) {
        $signed_orders[] = $row;
    }

    // Close the connection
    ddxrxDBConnect()->close();

?>
    
    <!DOCTYPE html>
    <html  class="ui-mobile">
        <head><meta http-equiv="Content-Type" content="text/html; charset=utf-8">
            <title>DDXRX - Type Order</title>
            
            <meta name="viewport" content="width=device-width, initial-scale=1.0">
            
            <script type="text/javascript" src="assets/js/jquery-3.3.1.min.js"></script>
            <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
            <script type="text/javascript" src="assets/js/jquery.jqscribble.js"></script>
            <script type="text/javascript" src="assets/js/pencil.js"></script>
            <script type="text/javascript" src="assets/js/mobile.js"></script>
            <script type="text/javascript" src="assets/js/jquery.jqscribble.js"></script>
            <script type="text/javascript" src="assets/js/jquery-liveedit.js"></script>
    
            <link rel="stylesheet" type="text/css" href="assets/css/reset.css">
            <link rel="stylesheet" type="text/css" href="assets/css/grid.css">
            <link rel="stylesheet" type="text/css" href="assets/css/style.css">
            <link rel="stylesheet" type="text/css" href="assets/css/responsive.css">
            <link rel="stylesheet" type="text/css" href="assets/css/patient-records.css">
            <link rel="stylesheet" type="text/css" href="assets/css/mobile.css">
            <link rel="stylesheet" type="text/css" href="assets/css/faq.css">
            <link rel="stylesheet" type="text/css" href="assets/css/jquery-liveedit.css">
            
            <style>
                body{
                    top: 0px!important;
                }
                .goog-te-banner-frame.skiptranslate {
                    display: none !important;
                }
                #goog-gt-tt{
                    display:none!important;
                }
                #google_translate_element{
                    position: fixed; left:20px; top: 20px; z-index: 9999999;
                }
            </style>
            
            <script type="text/javascript">
            function googleTranslateElementInit() {
                new google.translate.TranslateElement({pageLanguage: 'en', 
                layout:     google.translate.TranslateElement.InlineLayout.VERTICAL,
                autoDisplay: false, 
                includedLanguages: ''}, 'google_translate_element');}
            </script>
            <script type="text/javascript" src="https://translate.google.com/translate_a/element.js?cb=googleTranslateElementInit"></script>
            
        </head>
        <body data-user-id="<?php echo $patient_id; ?>">
            
            <div class="loading-screen"></div>
            
            <div id="google_translate_element"></div>
            
            <?php include('dashboard_menu.php'); ?>
    
            <div class="container pb-100 optimized-container"<?php if( isset($_GET['patient_id']) ){ echo ' data-user="'.$_GET['patient_id'].'"'; } ?>>
                <div class="col-md-12">
                    <div id="toPrint">
                        <div class="form-container">
    
                            <div class="record-navigation-menu">
                                <?php include('emr_navigation.php'); ?>
                            </div>
                            
                            <div class="tab-content-container no-border">
                                
                                <div class="signed-orders">
                                    <div class="order-list">
                                        <?php
                                        if (!empty($signed_orders)) {
                                            foreach ($signed_orders as $order) {

                                                if (!empty($order['written_order'])) {
                                                    $order_type = 'Hand Order';
                                                } else {
                                                    $order_type = 'Typed Order';
                                                }

                                                echo '<div class="item">';
                                                    echo '<div class="order-details">';
                                                        echo '<div><strong>Provider:</strong> ' . $order['provider_fname'] . ' ' . $order['provider_lname'] . '</div>';
                                                        echo '<div><strong>Order Type:</strong> ' . $order_type . '</div>';
                                                        echo '<div><strong>Issued On:</strong> ' . $order['sign_date'] . '</div>';
                                                    echo '</div>';
                                                    echo '<a href="view-order.php?order_id='.$order['id'].$linkParameters.'" class="view-order">View Order</a>';
                                                echo '</div>';
                                            }
                                        } else {
                                            echo '<div>No signed orders found for this user.</div>';
                                        }
                                        ?>
                                    </div>
                                </div>
                                    
                            </div>
    
                        </div>
                    </div>
                </div>
                <div class="clear"></div>
            </div>
    
            <?php
            	if( $_SESSION['userType'] == 'nurse' ){
            		provider_bottom_nav();
            	}elseif( $_SESSION['userType'] == 'doctor' ){
            		physician_bottom_nav();
            	}else{
            		bottom_nav();
            	}
            ?>
    
        </body>
    </html>