<?php
session_start();

// Include the functions file
include('process/functions.php');

if(!isset($_SESSION['userid']) || !isset($_SESSION['userType'])) {
    header("Location: login.php");
    die();
}

// Get session of patient is logged in and $_get['uid'] if not logged in
if( $_SESSION['userType'] == 'patient' && isset($_SESSION['userid']) ){
    $userid = $_SESSION['userid'];
} else{
    $userid = $_GET['uid'];
}

?>

    <!DOCTYPE html>
    <html class="ui-mobile">
        <head><meta http-equiv="Content-Type" content="text/html; charset=utf-8">
            <title>Photo Upload - DDXRX</title>
            
            <meta name="viewport" content="width=device-width, initial-scale=1.0">
            
            <script type="text/javascript" src="assets/js/jquery-3.3.1.min.js"></script>
            <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
            <script type="text/javascript" src="assets/js/faq.js"></script>
            <script src="https://cdn.jsdelivr.net/npm/@fancyapps/ui@5.0/dist/fancybox/fancybox.umd.js"></script>
    
            <link rel="stylesheet" type="text/css" href="assets/css/reset.css">
            <link rel="stylesheet" type="text/css" href="assets/css/grid.css">
            <link rel="stylesheet" type="text/css" href="assets/css/style.css">
    
            <link rel="stylesheet" type="text/css" href="assets/css/patient-records.css?v=1.2">
            <link rel="stylesheet" type="text/css" href="assets/css/general-ui.css">
            <link rel="stylesheet" type="text/css" href="assets/css/mobile.css">
            <link rel="stylesheet" type="text/css" href="assets/css/faq.css">
            <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/@fancyapps/ui@5.0/dist/fancybox/fancybox.css">
            

        </head>
        <body data-patient-id="<?php if( !empty($row) ){ echo $row['patient_id']; } ?>" data-user-id="<?php if( !empty($row) ){ echo $row['user_id']; } ?>" class="user-profile">
    
            <div class="container optimized-container pb-100">
                <div class="col-md-12">
    
                    <div class="form-container">
    
                        <div class="record-navigation-menu">
                            <?php include('emr_navigation.php'); ?>
                        </div>
                        
                        <div class="tab-content-container card">
                        	<div class="row">

                                <?php if( $_SESSION['userType'] == 'patient' ){ ?>
                                    <div class="col-xs-12">
                                        <div class="title-bar">
                                            <div class="desc">
                                                <h1 class="h1">Photo Upload</h1>
                                                <p class="desc">Upload a Photo of Your Symptom (Rash, Lump, Bruise, etc.)</p>
                                            </div>
                                        </div>
                                    </div>

                                    <div class="col-xs-12">
                                        <div class="upload-form-container">
                                            <form id="upload-form" method="post" enctype="multipart/form-data">
                                                <div class="hidden">
                                                    <input type="hidden" name="user_id" value="<?php echo $_SESSION['userid']; ?>">
                                                    <input type="file" name="file" id="file" accept="image/*" required>
                                                    <input type="submit" name="submit" id="submit" value="Upload">
                                                </div>

                                                <div class="desc">
                                                    <h6>Choose a file to upload</h6>
                                                    <p>JPEG, PNG, and GIF files are accepted. Maximum file size is 5MB.</p>
                                                    <a href="#" id="file-upload-button" class="browse">Browse Photo</a>
                                                </div>

                                                <div id="upload-status"></div>
                                                <div id="upload-progress" style="display:none;">
                                                    <div id="progress-bar" style="width:0%; background-color: #4caf50; height: 5px;"></div>
                                                </div>
                                            </form>
                                        </div>
                                    </div>
                                <?php }else{ ?>
                                    <div class="col-xs-12">
                                        <div class="title-bar bordered">
                                            <div class="desc">
                                                <h1 class="h1"><?php echo getpatientInfo($userid, 'patient_fname') . " " . getpatientInfo($userid, 'patient_lname'); ?>'s Photo Upload</h1>
                                                <p class="desc">Photos uploaded by this patient.</p>
                                            </div>
                                        </div>
                                    </div>
                                <?php } ?>

                                <!-- Gallery Section -->
                                <div class="col-xs-12">
                                    <div class="gallery-container">
                                        <?php
                                            $conn = ddxrxDBConnect();
                                            $stmt = $conn->prepare("SELECT * FROM `uploaded_photos` WHERE `user_id` = ? ORDER BY `date` DESC");
                                            $stmt->bind_param("i", $userid);
                                            $stmt->execute();
                                            $result = $stmt->get_result();

                                            if ($result->num_rows > 0) {
                                                echo '<div id="gallery">';
                                                    while ($row = $result->fetch_assoc()) {
                                                        echo '<div class="uploaded-photo">';
                                                            echo '<a href="photo-uploads/' . htmlspecialchars($row['image_name']) . '" data-fancybox="gallery" data-caption="'.htmlspecialchars($row['image_name']).'"><img src="photo-uploads/' . htmlspecialchars($row['image_name']) . '" class="uploaded-image" alt="Uploaded Photo"></a>';
                                                        echo '</div>';
                                                    }
                                                echo '</div>';
                                            } else {
                                                echo '<div id="gallery" class="no-photos">';
                                                    if( $_SESSION['userType'] == 'patient' ){
                                                        echo '<p class="no-photos-message">No photos uploaded yet. Start by uploading a photo above.</p>';
                                                    }else{
                                                        echo '<p class="no-photos-message">No photos uploaded by this patient.</p>';
                                                    }
                                                echo '</div>';
                                            }

                                            $stmt->close();
                                        ?>
                                    </div>
                                <!-- Gallery Section -->
    
                        	</div>
                        </div>
    
                    </div>
    
                </div>
            </div>
                        	
            
            <?php
            if( $_SESSION['userType'] == 'nurse' ){
                provider_bottom_nav();
            }elseif( $_SESSION['userType'] == 'doctor' ){
                physician_bottom_nav();
            }else{
                bottom_nav();
            }
            ?>

            <script>
                $(document).ready(function () {

                    // Initialize Fancybox
                    Fancybox.bind("[data-fancybox]");

                    $('#file-upload-button').on('click', function (e) {
                        e.preventDefault();
                        $('#file').click();
                    });

                    $('#file').on('change', function () {
                        const fileName = $(this).val().split('\\').pop();
                        Swal.fire({
                            title: 'Uploading...',
                            text: `Uploading ${fileName}`,
                            allowOutsideClick: false,
                            didOpen: () => {
                                Swal.showLoading();
                            }
                        });

                        $('#upload-form').submit();
                    });

                    $('#upload-form').on('submit', function (e) {
                        e.preventDefault();

                        const formData = new FormData(this);

                        // Show the progress bar
                        $('#upload-progress').show();
                        $('#progress-bar').css('width', '0%');

                        $.ajax({
                            url: 'process/photo-upload.php',
                            type: 'POST',
                            data: formData,
                            contentType: false,
                            processData: false,
                            xhr: function () {
                                const xhr = new window.XMLHttpRequest();
                                xhr.upload.addEventListener('progress', function (e) {
                                    if (e.lengthComputable) {
                                        const percentComplete = (e.loaded / e.total) * 100;
                                        $('#progress-bar').css('width', percentComplete + '%');
                                    }
                                }, false);
                                return xhr;
                            },
                            success: function (response) {
                                Swal.close();

                                if (response.result) {
                                    Swal.fire({
                                        icon: response.icon,
                                        title: response.title,
                                        text: response.message
                                    });

                                    // Append the uploaded photo with data-fancybox="gallery"
                                    const photoContainer = $('<div class="uploaded-photo"></div>');
                                    const photoLink = $('<a>')
                                        .attr('href', `photo-uploads/${response.image_name}`)
                                        .attr('data-fancybox', 'gallery')
                                        .attr('data-caption', response.image_name);
                                    const photo = $('<img>')
                                        .attr('src', `photo-uploads/${response.image_name}`)
                                        .addClass('uploaded-image');
                                    photoLink.append(photo);
                                    photoContainer.append(photoLink);
                                    $('.tab-content-container .gallery-container #gallery').prepend(photoContainer).removeClass('no-photos');
                                    $('.no-photos-message').remove(); // Remove the no photos message if it exists
                                } else {
                                    Swal.fire({
                                        icon: response.icon,
                                        title: response.title,
                                        text: response.message
                                    });
                                }

                                // Hide the progress bar
                                $('#upload-progress').hide();
                            },
                            error: function () {
                                Swal.close();
                                Swal.fire({
                                    icon: 'error',
                                    title: 'Upload Failed',
                                    text: 'An error occurred while uploading the file.'
                                });

                                // Hide the progress bar
                                $('#upload-progress').hide();
                            }
                        });
                    });
                });
            </script>

        </body>
    </html>