<?php
    ini_set('display_errors', 1);
    ini_set('display_startup_errors', 1);
    error_reporting(E_ALL);

    session_start();
    if((!isset($_SESSION['userid']) || !isset($_SESSION['userType'])) && ($_SESSION['userType'] != 'nurse' && $_SESSION['userType'] != 'doctor')) {
        header("Location: provider_login.php");
        die();
    }
    date_default_timezone_set('America/Chicago');

    function RemoveBS($Str) {  
        $StrArr = STR_SPLIT($Str); $NewStr = '';
        FOREACH ($StrArr AS $Char) {    
          $CharNo = ORD($Char);
          IF ($CharNo == 163) { $NewStr .= $Char; CONTINUE; } // keep � 
          IF ($CharNo > 31 && $CharNo < 127) {
            $NewStr .= $Char;    
          }
        }  

        return $NewStr;
    }

    function multiexplode ($delimiters,$string) {

        $ready = str_replace($delimiters, $delimiters[0], $string);
        $launch = explode($delimiters[0], $ready);
        return  $launch;
    }
    // include ('includes/database_include.php');
   // include('includes/functions.php');
    include('process/functions.php');
    
    $vitalFieldLables = new StdClass();
    $vitalFieldLables->systolicBP = 'Systolic BP';
    $vitalFieldLables->diastolicBP = 'Diastolic BP';
    $vitalFieldLables->heartRate = 'Heart Rate';
    $vitalFieldLables->respRate = 'Respiratory Rate';
    $vitalFieldLables->pulseOX = 'Pulse Ox';
    $vitalFieldLables->temp = 'Temperature';
    
    $wid = $_GET['wID'];
    $_SESSION['wID']=$wid;
    
    $waitingroomQuery = "Select * from waiting_room left join patients on waiting_room.patient_id = patients.patient_id where waitingroom_id =".$wid;
    $waitingroomResult = mysqli_query(ddxrxDBConnect(), $waitingroomQuery);
    $waitingroom = mysqli_fetch_array($waitingroomResult);
    
    // print_r($waitingroom);
    $_SESSION['dd_id']=$_GET['wID'];
    $_SESSION['ss'] = $waitingroom['symptoms'];
    $_SESSION['havingz'] = $waitingroom['havingz'];
    $_SESSION['denied'] = $waitingroom['denied'];
    $isAddendumSigned = $waitingroom['addendum_signed'] == 1;
$addendumText = htmlspecialchars($waitingroom['addendum']);
    
    $vitals = $waitingroom['vital_json'];
    $positive_diagnosis_id = json_decode($waitingroom['diagnosis_id']);
    $negative_diagnosis_id = json_decode($waitingroom['failed_diagnosis_id']);
    
    if($waitingroom['answers_per_diagnosis'] != "") {
        
        $answers_per_diagnosis = json_decode($waitingroom['answers_per_diagnosis']);
        $all_diagnosis = new stdClass();
        
        foreach($answers_per_diagnosis as $diagnosis_id => $answers) {
            $diagnosis_query = "Select * from differential_diagnoses where id='". $diagnosis_id ."' limit 1";
            $result_diagnosis_query = mysqli_query(ddxrxDBConnect(), $diagnosis_query);
            $diagnosis = mysqli_fetch_array($result_diagnosis_query);
            $all_diagnosis->$diagnosis_id = $diagnosis;
        }
        
    }
    
?>

<!DOCTYPE html>
<html>
    <head>
        <title>Artificial Intelligence Software for Medicine: DDxRx Software</title>

        <?php // include ('header_tag_m.php');?>
        
        <!--
        <link rel="stylesheet" href="https://code.jquery.com/mobile/1.2.0/jquery.mobile-1.2.0.min.css">
        <link rel="stylesheet" href="css/jquery.autocomplete.css" type="text/css">
        -->

        <link rel="stylesheet" type="text/css" href="assets/css/reset.css">
        <link rel="stylesheet" type="text/css" href="assets/css/grid.css">
        <link rel="stylesheet" type="text/css" href="assets/css/style.css">
        <link rel="stylesheet" type="text/css" href="assets/css/responsive.css"> 
        <link rel="stylesheet" type="text/css" href="assets/css/search-style-reports.css">
        <link rel="stylesheet" type="text/css" href="assets/css/single-notes-ai.css">
        
        <script src="https://ajax.googleapis.com/ajax/libs/jquery/3.4.1/jquery.min.js"></script>
        <script src="//cdn.jsdelivr.net/npm/sweetalert2@11"></script>
        <script type="text/javascript" src="assets/js/ddx_reports_ui.js"></script>
        
        <style>
            #submit{ display: none!important; }
            .vital-label {
                display:inline !important;
                /*padding-left:30px;*/
            }
            .check-box {
                margin-top: 5px;
            }
            .inline strong {
                color:#111111;
                font-weight:700 !important;
            }
            .weight-400 {
                font-weight:400 !important;
            }
            .results-container {
                margin-top: 10px;
                position: relative;
                /*line-height: 1.5em;*/
            }
            .additional_treatment {
                font-weight:500;
                margin-top: 40px;
            }
            .each_diagnosis {
                border-top:2px solid #ccc;
                padding-top: 15px;
            }
            
            body{
                top: 0px!important;
            }
            .goog-te-banner-frame.skiptranslate {
                display: none !important;
            }
            #goog-gt-tt{
                display:none!important;
            }
            #google_translate_element{
                position: fixed; left:20px; top: 20px; z-index: 9999999;
            }
        </style>
        
        <script>
            jQuery(document).ready(function($){
                $('#submit').remove();
                $('.ui-grid-a').css("margin-top", "50px");
            });
            
            $(document).ready(function() {
                
                // Save Note
                $("#save_note").click(function() {
                    
                    var data = '<?php echo json_encode($_POST); ?>';
                    var waitingroom_id = '<?php echo $wid; ?>';
                    
                    $.ajax({
                        url: 'save_search_entry.php',
                        data: {
                            'saveNoteSelection': true,
                            'waitingroom_id': waitingroom_id,
                            'note_data': data,
                        },
                        type: 'POST',
                        dataType: 'json',
                        success: function success(msg) {
                            if(msg.success) {
                                
                                Swal.fire({
                                    icon: 'success',
                                    title: 'Note saved successfully',
                                });
                                
                                window.location.replace("notes-ai.php?id=<?php echo $_GET['uid']; ?>");
                				
                            }
                        },
                        error: function error(msg) {
                            // console.log('error');
                        },
                    });
                    
                });
                
                $("#save_and_sign").click(function() {
                    
                    var data = '<?php echo json_encode($_POST); ?>';
                    var waitingroom_id = '<?php echo $wid; ?>';
                    
                    Swal.fire({
                        title: 'Sign this note?',
                        text: "Once the note have been signed You won't be able to edit this note again.",
                        icon: 'warning',
                        showCancelButton: true,
                        confirmButtonColor: '#3085d6',
                        cancelButtonColor: '#d33',
                        confirmButtonText: 'Yes, sign it!',
                        allowOutsideClick: false,
                    }).then((result) => {
                        
                        if (result.isConfirmed) {
                            
                            $.ajax({
                                url: 'save_search_entry.php?signed=true',
                                data: {
                                    'saveNoteSelection': true,
                                    'waitingroom_id': waitingroom_id,
                                    'note_data': data,
                                },
                                type: 'POST',
                                dataType: 'json',
                                success: function success(msg) {
                                    if(msg.success) {
                        				
                        				// Swal.fire({
                            //                 title: "Note Signed successfully",
                            //                 text: "Click the back button to go back viewing the notes.",
                            //                 icon: "success",
                            //                 showCancelButton: false,
                            //                 confirmButtonColor: '#3085d6',
                            //                 cancelButtonColor: '#d33',
                            //                 confirmButtonText: 'Back',
                            //                 allowOutsideClick: false,
                            //             }).then((result) => {
                            //                 if (result.isConfirmed) {
                                                
                            //                     // Redirect
                            //                     window.location.replace("notes-ai.php?id=<?php echo $_GET['uid']; ?>");
                                                
                            //                 }
                            //             });
                            
                                        Swal.fire({
                                            icon: 'success',
                                            title: 'Note saved successfully',
                                        });
                        				
                        				window.location.replace("notes-ai.php?id=<?php echo $_GET['uid']; ?>");
                        				
                                    }
                                },
                                error: function error(msg) {
                                    // console.log('error');
                                },
                            });
                            
                        }
                        
                    });
                    
                    
                    
                });
                
            });
        </script>
        
        <script type="text/javascript">
        function googleTranslateElementInit() {
            new google.translate.TranslateElement({pageLanguage: 'en', 
            layout:     google.translate.TranslateElement.InlineLayout.SIMPLE,
            autoDisplay: false, 
            includedLanguages: ''}, 'google_translate_element');}
        </script>
        <script type="text/javascript" src="https://translate.google.com/translate_a/element.js?cb=googleTranslateElementInit"></script>
        
    </head>
    <body>
        
        <?php note_nav( $_GET['uid'] ); ?>
        
    	<div class="container">
    		<div class="col-md-12">
    		    
    		    <div class="edit-note-header">
    		        <h6>Progress Note</h6>
    		       
    		        <?php if( $waitingroom['signed'] == '1' ){ ?>
    		            <!--<a href="notes-ai.php?id=<?php echo $_GET['uid']; ?>" class="go-back-button">Go Back</a>-->
    		        <?php }else{ ?>
    		            <!--<a href="edit-ai-note.php?wID=<?php echo $_GET['wID']; ?>&uid=<?php echo $_GET['uid']; ?>" class="go-back-button">Go Back</a>-->
    		        <?php } ?>
    		        
    		    </div>
    		    
    			<div class="user-info-bar">
    				<ul>
        				<li><img src="images/topbar/name.svg"> <span><strong>Name:</strong> <?php echo $waitingroom['patient_fname'].' '.$waitingroom['patient_lname']; ?></span></li>
        				<li><img src="images/topbar/dob.svg"> <span><strong>Date of Birth:</strong> <?php echo $waitingroom['patient_dob']; ?></span></li>
        				<li><img src="images/topbar/gender.svg"> <span><strong>Gender:</strong> <?php if($waitingroom['patient_gender'] == 'M' || $waitingroom['patient_gender'] == 'm'){ echo 'Male'; }else{ echo 'Female'; } ?></span></li>
        				<li><img src="images/topbar/mobile.svg"> <span><strong>Cell:</strong> <?php echo $waitingroom['cell']; ?></span></li>
        
        				<li class="right"><img src="images/topbar/calendar.svg"> <span><strong>Date of Encounter:</strong> <?php echo date_format(date_create($waitingroom['checkin_time']),"M/d/Y"); ?></span></li>
        				<li class="right"><img src="images/topbar/login.svg"> <span><strong>Encounter ID:</strong> <i class="encounter_id"><?php echo $waitingroom['waitingroom_id']; ?></i></span></li>
    				</ul>
    				<div class="clear"></div>
    
    			</div>
    		</div>
    	</div>
        
        <div class="container optimized-container typography-entry">
            <div class="col-md-12">
                <div class="results-container provider">
                    <div class="chief_complaints">
                        <?php
                        if($waitingroom['chief_complaints'] != "") {
                        ?>
                            <h6>Chief Complaints:</h6>
                            <ul>
                                <?php
                                $chief_complaints = explode(";", $waitingroom['chief_complaints']);
                                $presentedString = "";
                                $count = 1;
                                $counter = count($chief_complaints);
                                foreach ($chief_complaints as $key => $value) {
                                    $count++;
                                    echo "<li> $value </li>";
                                    $presentedString .= $value;
                                    if ($count < $counter) {
                                        $presentedString .= ", ";
                                    } elseif ($count == $counter) {
                                        $presentedString .= " and ";
                                    }
                                }
                                ?>
                            </ul>
                
                            <h6>History of present illness:</h6>
                            <p>Patient presented with <?php echo $presentedString; ?></p>
                        <?php
                        } else {
                            echo "<center><h5>No patient data available!</h5></center>";
                            exit();
                        }
                        ?>
                    </div>
                    <div class="diagnosis_and_symptoms">
                        <?php
                        $denied = [];
                        foreach($answers_per_diagnosis as $diagnosis_id => $answers) {
                            $diag = $all_diagnosis->$diagnosis_id;
                            echo "<h6>".$diag['name']."</h6>";
                            echo "Patient complained of having ".implode(", ", $answers->positives);
                            $denied = array_merge($denied, $answers->negatives);
                        }
                        ?>
                    </div>
                    <?php if(isset($_POST['additional_info'])){?>
                    <div class="additional_info">
                        <label>
                            <h6>Additional Information</h6>
                            <?php echo $_POST['additional_info']; ?>
                        </label>
                    </div>
                    <?php } ?>
                    <div class="checkbox-group">
                        <div class="review_of_system">
                            <h6>Review of System:</h6>
                            Patient denied having : <?php echo implode(", ", array_unique($denied)); ?>
                            <br/>
                            <?php
                            if(isset($_POST['review'])) {
                            ?>
                            <label>
                                <span>All system were reviewed and was found negative except the above in HPI.</span>
                            </label>
                            <?php
                            }
                            ?>
                        </div>
                        <div class="vitals">
                            <?php if(isset($_POST['vital'])) { ?>
                            <h6>Vitals</h6>
                            <label>
                                <div>
                                    <?php
                                    if($vitals != "") {
                                        $vitalArray = json_decode($vitals);
                                        foreach($vitalArray as $key => $value) {
                                            echo "<b class='vital-label'>".$vitalFieldLables->$key."</b> : ".$value."<br/>";
                                        }
                                    }
                                    ?>
                                </div>
                                <div class="clear"></div>
                            </label>
                            <?php
                            }
                            ?>
                        </div>
                        <div class="physical_exam">
                            <?php
                            if(isset($_POST['physical_exam'])) {
                            ?>
                            <h6>Physical Exam:</h6>
                            <label>
                                <strong>General:</strong>
                                &nbsp; Well-developed well-nourished Male/Female in  no apparent distress.
                                <br />
                                <strong>HEENT:</strong>
                                Normocephalic and atraumatic oral mucosa moist, PERRLA, EOMI
                                <br />
                                <strong>Neck:</strong>
                                &nbsp; Supple without JVD.&nbsp; no lymphadenopathy.
                                <br />
                                <strong>Cardiovascular:</strong>
                                S1 and S2,
                                <br />
                                <strong>Respiratory:</strong>
                                Clear to auscultation bilaterally no wheezes or rhonchi
                                <br />
                                <strong>Abdomen:</strong>
                                Soft,nontender,non  distended,bowel sounds positive all 4 quadrants
                                <br />
                                <strong>Extremities:</strong>
                                No edema, no cyanosis or clubbing.&nbsp; Distal  pulses 2+ and symmetric
                                <br />
                                <strong>Neurology:</strong>
                                &nbsp; No focal neurological deficit.&nbsp; Patient moving all 4 extremities
                                <br />
                                <strong>Psych:</strong>
                                &nbsp; Patient alert oriented, mood and effect  appropriate
                                <br />
                                <strong>Skin:</strong>
                                &nbsp; There are no lesions no rashes.&nbsp;
                                <br />
                                <strong>Musculoskeletal:</strong>
                                &nbsp; Range of motion intact
                                <div class="clear"></div>
                            </label>
                            <?php
                            }
                            ?>
                        </div>
                    </div>
                    <?php
                        $negative_diagnosis_names = [];
                        
                        foreach($negative_diagnosis_id as $id) {
                            $diag = $all_diagnosis->$id;
                            $negative_diagnosis_names[] = $diag['name'];
                        }
                        if(sizeof($negative_diagnosis_names) > 0) {
                            echo "Patient less likely have ".implode(", ", $negative_diagnosis_names);
                            echo "<br/><br/>";   
                        }
                        
                        $i = 0;
                        $j = 0;
                        $return = "";
                        foreach($positive_diagnosis_id as $id) {
                            $i = $i + 1;
                          
                            $decision_support_query = "Select * from decision_supports where differential_diagnose_id='".$id."' limit 1";
                            $result_decision_support = mysqli_query(ddxrxDBConnect(), $decision_support_query);
                            $decision_support = mysqli_fetch_array($result_decision_support);
                            $decisions_edited = isset($decision_support['decisions_edited']) ? $decision_support['decisions_edited'] : '';
                            $var = trim($decisions_edited);
                            $var = str_replace('</p>', '', $var);
                            $var = str_replace('<br /><br />', '<br />', $var);
                            $var = trim(html_entity_decode($var), " \t\n\r\0\x0B\xC2\xA0");
                            $var = RemoveBS($var);
                            $var = multiexplode(array("<br />", "<p>", "<br>"), $var);
                            $var = array_filter(array_map('trim', $var));
                            $diag = $all_diagnosis->$id;
                            $return .= '<div class="each_diagnosis"';
                            $return .= '<strong style="font-weight:700">' . $i . ' . ' . $diag['name'] . '</strong>';
                            foreach ($var as $key => $value) {
                        
                                $pos = strpos($value, "**");
                                $posh = strpos($value, "##");
                                if (($pos === false) and ($posh === false)) {
                                    $j = $j + 1;
                                    $field_key = "textfield_{$i}_{$key}";
                                    $input_value = isset($_POST[$field_key]) ? $_POST[$field_key] : '';
                                    $reved = ucfirst(str_replace("()", htmlspecialchars($input_value), "$value"));
                                    $reved = preg_replace('/\[[^\]]*\]/', '', $reved);
    
                                    // $reved = ucfirst(str_replace("()", $_POST["textfield_".$i."_".$key], "$value"));
                                    if(isset($_POST['checkbox_'.$i.'_'.$key])) {
                                        $return .= '<label for="checkbox_'.$i.'_'.$key.'">
                                                        <span class="inline weight-400">'.$reved.'</span>
                                                    </label>';
                                    }
                                } else {
                                    if ($posh !== false) {
                                        $value = str_replace('##', '', $value);
                                        // $return .= ucfirst(RemoveBS($value)) . "<br/>";
                
                                    } else {
                                        $value = str_replace('**', '', $value);
                                        $j = $j + 1;
                                        
                                        $field_key = "textfield_{$i}_{$key}";
                                        $input_value = isset($_POST[$field_key]) ? $_POST[$field_key] : '';
                                        $reved = ucfirst(str_replace("()", htmlspecialchars($input_value), "$value"));
                                        $reved = preg_replace('/\[[^\]]*\]/', '', $reved);
                                        //$reved = ucfirst(str_replace("()", $_POST["textfield_".$i."_".$key], "$value"));
                                        $return .= '<label>
                                                        <span class="inline"><strong>'.$reved.'</strong></span>
                                                    </label>';
                                    }
                                }
                            }
                            if(isset($_POST['additional_treatment_'.$i])) {
                                $return .= '<div class="additional_treatment"><h6>Additional Treatment</h6><br>'.$_POST['additional_treatment_'.$i].'</div>';
                            }
                            $return .= "</div>";
                        }

                        echo $return;

                        // Close the connection
                        ddxrxDBConnect()->close();
                    ?>
                    
                    <div id="addendum_container" style="margin-top: 20px; <?php echo $isAddendumSigned ? '' : 'display:none;'; ?>">
                    <h6>Addendum</h6>
                    <textarea 
                        id="addendum_textarea" 
                        name="addendum_textarea" 
                        rows="8" 
                        style="width: 100%; padding: 10px;"
                        <?php echo $isAddendumSigned ? 'readonly' : ''; ?>
                    ><?php echo $addendumText; ?></textarea>

                    <br><br>

                    <?php if ($isAddendumSigned): ?>
                        <button class="button large rounded gray" style="width:auto!important;" disabled>Signed</button>
                    <?php else: ?>
                        <div style="text-align: right;">
                            <a href="javascript:;" id="sign_addendum" class="button large rounded solid green" style="display:inline-block!important; width:auto!important;">Sign</a>
                        </div>

                    <?php endif; ?>
                </div>

                <?php if (!$isAddendumSigned): ?>
             <a href="javascript:;" id="add_addendum" class="button large rounded solid blue" style="display:inline-block!important; width:auto!important;">Addendum</a>
                <?php endif; ?>


                    <?php if( $waitingroom['signed'] != '1' ){ ?>
                    
                        <!-- <a href="javascript:;" id="save_note" class="button large rounded solid blue" style="display:inline-block!important; width:auto!important;">Save</a>
                        <a href="edit-ai-note.php?wID=<?php echo $_GET['wID']; ?>&uid=<?php echo $_GET['uid']; ?>" id="edit_note" class="button large rounded solid blue" style="display:inline-block!important; width:auto!important;">Addendum</a>
                        <a href="javascript:;" id="save_and_sign" class="button large rounded solid blue" style="display:inline-block!important; width:auto!important;">Sign</a> -->
                    
                    <?php } ?>
                    
        		</div>
            </div>
        </div>
<script>
$(document).ready(function() {
    <?php if (!$isAddendumSigned): ?>

    // Show textarea and prefill if empty
    $('#add_addendum').click(function() {
        if ($('#addendum_container').is(':visible')) return;

        let currentText = $('#addendum_textarea').val().trim();

        if (currentText === '') {
            let now = new Date();
            let dateTimeStr = now.toLocaleString();
            let initialText = dateTimeStr + "\n------------------------\n";
            $('#addendum_textarea').val(initialText);
        }

        $('#addendum_container').slideDown();
    });

    $('#sign_addendum').click(function() {
        let addendumText = $('#addendum_textarea').val().trim();

        if (addendumText === '') {
            Swal.fire({
                icon: 'warning',
                title: 'Addendum cannot be empty.',
            });
            return;
        }

        $.ajax({
            url: 'save_search_entry.php',
            type: 'POST',
            dataType: 'json',
            data: {
                saveAddendum: true,
                waitingroom_id: '<?php echo $wid; ?>',
                addendum_text: addendumText
            },
            success: function(msg) {
                if (msg.success) {
                    Swal.fire({
                        icon: 'success',
                        title: 'Addendum signed successfully',
                    }).then(() => {
                        location.reload();
                    });
                } else {
                    Swal.fire({
                        icon: 'error',
                        title: 'Failed to save addendum',
                    });
                }
            }
        });
    });

    <?php endif; ?>
});
</script>


    </body>
</html>