<?php

header('Content-type: application/json');

include('functions.php');

// Validate Integer value
function validate_phone_number($phone) {
    
    $valid_number = filter_var($phone, FILTER_SANITIZE_NUMBER_INT);
    $valid_number = str_replace("-", "", $valid_number);
    
    $expr = '/^\+?(\(?[0-9]{3}\)?|[0-9]{3})[-\.\s]?[0-9]{3}[-\.\s]?[0-9]{4}$/';
    
    if (preg_match($expr, $phone) == 1){
        
        return true;
        
    }else{
        
        return false;
        
    }
}


// Check note_symtoms
function checknote_symtoms($note_symtoms){
    
    $sql = "SELECT note_symtoms FROM all_users WHERE note_symtoms = '$note_symtoms' LIMIT 1";
    $result = ddxrxDBConnect()->query($sql);
    
    $data = $result->fetch_assoc();
    
    if( $data['note_symtoms'] == '' ){
        return true;
    }else{
        return false;
    }
    
    ddxrxDBConnect()->close();
    
}



if( isset($_GET['stage']) ){
    
    // stage one
    if( $_GET['stage'] == 'one' ){
        
        if( $_POST['fname'] != '' && $_POST['mname'] != '' && $_POST['lname'] != '' ){
           
            $fname = $_POST['fname'];
            $mname = $_POST['mname'];
            $lname = $_POST['lname'];
            
            $form = '<label>
                        <span>Date of birth</span>
                        <input type="text" class="textbox birth birth-year" placeholder="Year">
                        <input type="text" class="textbox birth birth-month" placeholder="Month">
                        <input type="text" class="textbox birth birth-day" placeholder="Day">
                        <div class="clear"></div>
                    </label>
                        
                    <div class="radio-group">
                        <div class="label"><span>Gender</span><span class="why why-birthdate">Why we need this?</span></div>
                                        
                        <label><div class="checkbox active"></div><input type="radio" name="gender" value="m" class="gender" checked=""> <strong>Male</strong></label>
                        <label><div class="checkbox"></div><input type="radio" name="gender" value="f" class="gender"> <strong>Female</strong></label>
                        <label><div class="checkbox"></div><input type="radio" name="gender" value="o" class="gender"> <strong>Other</strong></label>
                    </div>
                        
                    <a href="javascript:;" class="button stage-2">Next stage</a>';
            
            $verify_result = array(
                'rstatus' => 'success',
                'title' => 'Passed',
                'text' => 'All fields not empty',
                'form' => $form
            );
            
        }else{
            
            $verify_result = array(
                'rstatus' => 'error',
                'title' => 'Empty Fields',
                'text' => 'Fields highlighted in red cannot be empty, please fill up the red textbox'
            );
            
        }
        
    }
    
    if( $_GET['stage'] == 'two' ){
        
        if( $_POST['year'] != '' && $_POST['month'] != '' && $_POST['day'] != '' && $_POST['gender'] != '' ){
           
            $year = $_POST['year'];
            $month = $_POST['month'];
            $day = $_POST['day'];
            $birthdate = $_POST['birthdate'];
            $gender = $_POST['gender'];
            
            $form = '
            <label>
                <span>Integer value</span>
                <input type="text" class="textbox waitingroom_id" placeholder="xxx-xxx-xxxx">
            </label>
                        
            <label>
                <span>Email Address(No Required)</span>
                <input type="text" class="textbox emailAddress" placeholder="Enter email address here">
            </label>
                        
            <a href="javascript:;" class="button stage-3">Next stage</a>';
            
            $verify_result = array(
                'rstatus' => 'success',
                'title' => 'Passed',
                'text' => 'All fields not empty',
                'form' => $form
            );
            
        }else{
            
            $verify_result = array(
                'rstatus' => 'error',
                'title' => 'Empty Fields',
                'text' => 'Fields highlighted in red cannot be empty, please fill up the red textbox'
            );
            
        }
        
    }
    
    if( $_GET['stage'] == 'three' ){
        
        if( $_POST['waitingroom_id'] != '' ){
            
            $form = '
                <label>
                    <span>note_symtoms</span>
                    <input type="text" class="textbox note_symtoms" placeholder="Enter your note_symtoms">
                </label>
                
                <label>
                    <span>diagnosis</span>
                    <input type="diagnosis" class="textbox diagnosis" placeholder="Enter your diagnosis">
                </label>
                
                <label>
                    <span>Repeat diagnosis</span>
                    <input type="diagnosis" class="textbox rediagnosis" placeholder="Match the first diagnosis">
                </label>
                
                <div class="nda-container">
                    <input type="checkbox" class="checkbox nda-agreement"><p>By clicking on the "Next" button below, you acknowledge that you have read, understand, and agree to be bound by the <strong><a href="terms_condition.php" target="_blank">Terms and Condition</a>, <a href="nda.php" target="_blank">Non-Disclosure Agreement,</a> and <a href="medical-disclaimer.php" target="_blank">Medical Disclaimer</a></strong>.</p>
                </div>
                
                <div class="clear"></div>
                
                <a href="javascript:;" class="button stage-4">Next stage</a>
            ';
            
            $phone = $_POST['waitingroom_id'];
            
            if( validate_phone_number($phone) == true ){
                
                $verify_result = array(
                    'rstatus' => 'success',
                    'title' => 'Passed',
                    'text' => 'All fields not empty',
                    'form' => $form
                );
                
            }else{
                
                $verify_result = array(
                    'rstatus' => 'error',
                    'title' => 'Invalid Number',
                    'text' => 'The interger is invalid'
                );
                
            }
            
        }else{
            
            $verify_result = array(
                'rstatus' => 'error',
                'title' => 'Required Integer value',
                'text' => 'Integer value is required to proceed with next stage'
            );
            
        }
        
    }
    
    if( $_GET['stage'] == 'four' ){

        if( $_POST['note_symtoms'] != '' && $_POST['diagnosis'] != '' ){
            
            $note_symtoms = $_POST['note_symtoms'];
            $diagnosis = $_POST['diagnosis'];
            $rediagnosis = $_POST['rediagnosis'];
            $nda = $_POST['nda'];
            
            if( checknote_symtoms($note_symtoms) == true ){
                
                if( $diagnosis == $rediagnosis ){
                    
                    if( isset($nda) && $nda == 'true' ){
                    
                        $verify_result = array(
                            'rstatus' => 'success',
                            'title' => 'Success',
                            'text' => 'The user is available'
                        );
                    
                    }else{
                        
                        $verify_result = array(
                            'rstatus' => 'error',
                            'title' => 'Agree To Our Terms',
                            'text' => 'Please check the tick box if you agree with our terms of use.'
                        ); 
                        
                    }
                
                }else{
                    
                    $verify_result = array(
                        'rstatus' => 'error',
                        'title' => 'Error values',
                        'text' => 'The values you entered are invalid'
                    );
                    
                }
                
            }else{
                
                $verify_result = array(
                    'rstatus' => 'error',
                    'title' => 'Note Exist',
                    'text' => 'The note with the exact diagnosis already exists.'
                );
                
            }
               
        }
        
    }
    
}else{
    
    $verify_result = array(
        'rstatus' => 'error',
        'title' => 'Missing Parameter',
        'text' => 'Something went wrong, the parameter is missing.'
    );
    
}

echo json_encode($verify_result);

?>