<?php

// Enable error reporting
// error_reporting(E_ALL);
// ini_set('display_errors', 1);

// Include the functions file
include('functions.php');

// Output the header as JSON
header('Content-Type: application/json');

if( isset($_POST['user_id']) ){

    // Get input as POST data
    $user_id = $_POST['user_id'];

    // Create function to get the confidence level
    function getConfidence($user_id) {

        $sql = "SELECT * FROM confidence WHERE userid = '$user_id'";
        $result = ddxrxDBConnect()->query($sql);

        // Close the connection
        ddxrxDBConnect()->close();

        if ($result->num_rows > 0) {
            while($row = $result->fetch_assoc()) {
                return $row['confidence_lvl'];
            }
        } else {
            return false;
        }

    }

    // Create a function to check database if user exists in the confidence table
    function checkUser($user_id) {

        $sql = "SELECT * FROM confidence WHERE userid = '$user_id'";
        $result = ddxrxDBConnect()->query($sql);

        // Close the connection
        ddxrxDBConnect()->close();

        if ($result->num_rows > 0) {
            return true;
        } else {
            return false;
        }

    }

    // Create function to delete user from confidence table
    function deleteUser($user_id) {

        $sql = "DELETE FROM confidence WHERE userid = '$user_id'";

        // Close the connection
        ddxrxDBConnect()->close();

        if (ddxrxDBConnect()->query($sql) === TRUE) {
            return true;
        } else {
            return false;
        }

    }

    // Create function to get patient info from user ID
    function showPatientInfo($user_id) {

        $sql = "SELECT * FROM `all_users` INNER JOIN patients ON all_users.userid = patients.user_id WHERE all_users.userid = '$user_id'";
        $result = ddxrxDBConnect()->query($sql);

        // Close the connection
        ddxrxDBConnect()->close();

        if ($result->num_rows > 0) {
            while($row = $result->fetch_assoc()) {
                return $row;
            }
        } else {
            
            $row = array(
                'patient_fname' => 'Unknown',
                'patient_lname' => 'Unknown',
            );

            return $row;

        }

    }

    $patient_info = showPatientInfo($user_id);

    // Store the confidence level in a variable
    $confidence = getConfidence($user_id);

    // Check if user exists in the confidence table
    if (checkUser($user_id) === true) {

        // If user exists, delete user from confidence table
        if (deleteUser($user_id) === true) {

            $output = array(
                'response' => true,
                'msg' => 'User exists & got deleted successfully.',
                'confidence_lvl' => $confidence,
                'patient_name' => $patient_info['patient_fname'] . ' ' . $patient_info['patient_lname'],
            );

        } else {

            $output = array(
                'response' => false,
                'msg' => 'User exists but could not be deleted.'
            );

        }

    } else {

        $output = array(
            'response' => false,
            'msg' => 'User does not exist.'
        );

    }

} else {

    $output = array(
        'response' => false,
        'msg' => 'User ID not set.'
    );

}

// Display the output
echo json_encode($output);

?>