<?php
    session_start();

    // Sleep for 10 seconds to simulate processing delay
    // sleep(10);

    // Set content type to JSON first, before any output
    header('Content-Type: application/json');
    
    $sessionUserID = $_SESSION['userid'];
    $userType = $_SESSION['userType'];
    
    // Redirect if not logged in properly
    if(!isset($sessionUserID) || !isset($userType)) {
        echo json_encode(array('success' => false, 'error' => 'Authentication required'));
        die();
    }

    // Include functions and database connection
    include('functions.php');
    
    global $callarray;
    $callarray = array();
    
    // Get user id from patient ID
    function get_user_id($patient_id){
        $sql = "SELECT `all_users`.`userid` FROM `all_users` INNER JOIN `patients` ON `all_users`.`userid` = `patients`.`user_id` WHERE `patients`.`patient_id` = '$patient_id'";
        $result = ddxrxDBConnect()->query($sql);
        $row = $result->fetch_assoc();
        return isset($row['userid']) ? $row['userid'] : null;
    }
    
    $version = get_version();
    
    $vitals = array();
    $vitals[] = array('fieldName' => 'systolic', 'fieldLable' => 'Systolic BP', 'min' => 90, 'max' => 200);
    $vitals[] = array('fieldName' => 'diastolic', 'fieldLable' => 'Diastolic BP', 'min' => 50, 'max' => 100);
    $vitals[] = array('fieldName' => 'heartrate', 'fieldLable' => 'Heart Rate', 'min' => 50, 'max' => 100);
    $vitals[] = array('fieldName' => 'respiratory', 'fieldLable' => 'Respiratory Rate', 'min' => 10, 'max' => 22);
    $vitals[] = array('fieldName' => 'pulseox', 'fieldLable' => 'Pulse Ox', 'min' => 88, 'max' => 100);
    $vitals[] = array('fieldName' => 'temp', 'fieldLable' => 'Temperature', 'min' => 95, 'max' => 99);
    $vitals[] = array('fieldName' => 'glucose', 'fieldLable' => 'Temperature', 'min' => 90, 'max' => 300);
    
    // Get filter from POST data
    $filter = isset($_POST['filter']) ? $_POST['filter'] : 'confirmed'; // Default to 'confirmed' to match active button
    
    // Set time interval based on user type
    $time_interval = ($userType == 'doctor') ? '48 HOUR' : '7 DAY';
    
    // Build filter condition
    $filter_condition = "";
    if($filter == 'confirmed') {
        $filter_condition = " AND wr.`chief_complaints` IS NOT NULL";
    } elseif($filter == 'waiting') {
        $filter_condition = " AND wr.`chief_complaints` IS NULL";
    }
    // For 'all' filter, no additional condition needed
    
    // Unified query structure - same for both nurse and physician
    $query = "SELECT wr.*, vh.systolic, vh.diastolic, vh.heartrate, vh.respiratory, vh.pulseox, vh.temp, vh.glucose 
              FROM `waiting_room` wr 
              LEFT JOIN (SELECT `patient_id`, MAX(date_added) AS `MaxDate` FROM `vitals_history` GROUP BY `patient_id`) AS `max_dates` 
                  ON wr.`patient_id` = max_dates.`patient_id` 
              LEFT JOIN `vitals_history` vh 
                  ON max_dates.`patient_id` = vh.`patient_id` AND max_dates.`MaxDate` = vh.`date_added` 
              WHERE wr.`checkin_time` >= (NOW() - INTERVAL $time_interval) AND wr.`groupid` = '$version'" 
              . $filter_condition . " 
              ORDER BY wr.`checkin_time` DESC";

    $patients = array();
    $connection = ddxrxDBConnect();
    
    $result = mysqli_query($connection, $query);
    
    if (mysqli_num_rows($result) > 0) {
        while($data = mysqli_fetch_assoc($result)) {
            
            // Get patient details
            $pid = $data['patient_id'];
            $p_query = "SELECT patient_dob, cell FROM patients WHERE patient_id='".$pid."' ";
            $run_p_query = mysqli_query($connection, $p_query);
            $patient_details = mysqli_fetch_array($run_p_query);
            
            // Handle case where patient details might not be found
            if ($patient_details) {
                $DOB = $patient_details['patient_dob'];
                $phoneNumber = isset($patient_details['cell']) ? $patient_details['cell'] : '';
                $today = date("Y-m-d");
                $diff = date_diff(date_create($DOB), date_create($today));
                $age = $diff->format('%y');
            } else {
                $phoneNumber = '';
                $age = 'N/A';
            }
            
            // Calculate acuity using nurse logic for both user types
            $diagnosis = $data['diagnosis'];
            $acuity = 0;
            $is_SEPSIS = 0;

            if (!empty($diagnosis)) {
                $acuity = 2;

                $sepsis_diseases = array("pneumonia","urinary tract infection (UTI)", "bacteraemia", "meningitis", "influenza", "bronchitis", "asthma", "chronic obstructive pulmonary disease", "appendicitis", "diverticulitis", "cellulitis", "orchitis", "pelvic inflammatory disease", "Pyelonephritis","Viral Syndrome","sinusitis","HIV","Ebola","Infectious Mononucleosis","Dengue Fever","Strep Throat","Pharyngitis","Cerebral abscess","Endocarditis","Osteomyelitis","Diverticulitis","Tuberculosis","Lyme Disease","Fungal Infection","Billiary tract infection","C. Difficile Colitis","Liver abscess","Sepsis","Pelvic Inflammatory Disease (PID)","Typhoid Fever","Septic Arthritis");

                foreach ($sepsis_diseases as $key => $item) {
                    if (stripos($diagnosis, $item) !== false) {
                        $is_SEPSIS = 1;
                        $acuity = 3;
                    }
                }

                if(strpos($diagnosis,"Myocardial Ischemia") || strpos($diagnosis,"Seizure") || strpos($diagnosis,"Cerebrovascular accident")) {
                    $acuity = 3;
                }
                    
                if(strpos($diagnosis,"Appendicitis") || strpos($diagnosis,"Cholecystitis") || strpos($diagnosis,"Subaracnoid Hemohhrage")
                    || strpos($diagnosis,"Cerebrovascular accident (CVA)") || strpos($diagnosis,"Meningitis" )) {
                    $acuity = 4;
                }
                for ($x = 0; $x < count($vitals); $x++) {
                    $vitalField = $vitals[$x]['fieldName'];
                    if (isset($data[$vitalField]) && $data[$vitalField] != 0) {
                        if ($data[$vitalField] < $vitals[$x]['min'] || $data[$vitalField] > $vitals[$x]['max']) {
                            $acuity++;
                        }
                    }
                }                                
            }

            // Calculate status
            if($acuity != "" && ((int) $acuity >= 4)) {
                $inOut = "Inpatient";
                if($is_SEPSIS == 1) $inOut .= " (Sepsis)";
                $statusClass = "text-danger";
            } else if($acuity != "" && ((int) $acuity == 3)) {
                $inOut = "Undecided";
                $statusClass = "text-muted";
            } else {
                $inOut = "Outpatient";
                $statusClass = "text-success";
            }
            
            // Calculate wait time
            $rawtime = $data['checkin_time'];
            $sqlTime = "SELECT FLOOR((UNIX_TIMESTAMP(NOW()) - UNIX_TIMESTAMP(checkin_time))/86400) as day, FLOOR((UNIX_TIMESTAMP(NOW()) - UNIX_TIMESTAMP(checkin_time))/3600)%24 as hour, FLOOR((UNIX_TIMESTAMP(NOW()) - UNIX_TIMESTAMP(checkin_time))/60)%60 as minute FROM `waiting_room` WHERE checkin_time = '$rawtime'";
            $resultTime = $connection->query($sqlTime);
            $rowTime = $resultTime->fetch_assoc();
            
            // Handle negative values by setting to 0
            $dayValue = max(0, intval($rowTime['day']));
            $hourValue = max(0, intval($rowTime['hour']));
            $minuteValue = max(0, intval($rowTime['minute']));
            
            $days = str_pad($dayValue, 2, '0', STR_PAD_LEFT);
            $hours = str_pad($hourValue, 2, '0', STR_PAD_LEFT);
            $minutes = str_pad($minuteValue, 2, '0', STR_PAD_LEFT);
            
            // Get physicians list
            $physicians = array();
            $version = get_version();
            $users = "SELECT physician.physician_fname, physician.physician_lname, physician.id FROM all_users join physician on physician.user_id = all_users.userid where user_type = 2 and location_id =1 and physician.groupid = '$version'";
            $users_query = mysqli_query($connection, $users);
            while($row = mysqli_fetch_array($users_query)) {
                $physicians[] = array(
                    'id' => $row['id'],
                    'name' => "Dr. ".$row['physician_fname']." ".$row['physician_lname'],
                    'selected' => ($data['physician_id'] != 0 && $data['physician_id'] == $row['id'])
                );
            }
            
            // Build patient object
            $patient = array(
                'waitingroom_guid' => isset($data['waitingroom_guid']) ? $data['waitingroom_guid'] : '',
                'waitingroom_id' => isset($data['waitingroom_id']) ? $data['waitingroom_id'] : '',
                'patient_id' => isset($data['patient_id']) ? $data['patient_id'] : '',
                'patient_name' => ucwords(isset($data['patient_name']) ? $data['patient_name'] : ''),
                'phone' => $phoneNumber,
                'age' => $age . ' yrs',
                'is_returning_patient' => ($data['is_returning_patient'] == 1),
                'diagnosis' => $data['diagnosis'] != "" ? $data['diagnosis'] : ($data['symptoms'] == "" ? "Awaiting chief complaint" : "No diagnosis matched"),
                'symptoms' => $data['symptoms'] != "" ? $data['symptoms'] : "Awaiting symptoms",
                'symptom_photo' => isset($data['symptom_photo']) ? $data['symptom_photo'] : '',
                'is_sepsis' => $is_SEPSIS,
                'is_sirs' => isset($data['is_SIRS']) ? $data['is_SIRS'] : 0,
                'acuity' => $acuity != "" ? $acuity : 0,
                'status' => $inOut,
                'status_class' => $statusClass,
                'wait_time' => array(
                    'days' => $days,
                    'hours' => $hours,
                    'minutes' => $minutes,
                    'formatted' => $days . " : " . $hours . " : " . $minutes,
                    'checkin_time' => isset($data['checkin_time']) ? $data['checkin_time'] : ''
                ),
                'physicians' => $physicians,
                'assigned_physician_id' => isset($data['physician_id']) ? $data['physician_id'] : null,
                'user_id' => get_user_id($data['patient_id']),
                'vitals' => array(
                    'systolic' => isset($data['systolic']) ? $data['systolic'] : null,
                    'diastolic' => isset($data['diastolic']) ? $data['diastolic'] : null,
                    'heartrate' => isset($data['heartrate']) ? $data['heartrate'] : null,
                    'respiratory' => isset($data['respiratory']) ? $data['respiratory'] : null,
                    'pulseox' => isset($data['pulseox']) ? $data['pulseox'] : null,
                    'temp' => isset($data['temp']) ? $data['temp'] : null,
                    'glucose' => isset($data['glucose']) ? $data['glucose'] : null
                )
            );
            
            $patients[] = $patient;
        }
    } else {
        // No patients found
        $patients = array();
    }
    
    // Close database connection
    mysqli_close($connection);
    
    // Determine appropriate message for empty results
    $message = '';
    if (count($patients) === 0) {
        switch($filter) {
            case 'confirmed':
                $message = 'No patients with confirmed diagnoses at this time';
                break;
            case 'waiting':
                $message = 'No patients awaiting symptoms at this time';
                break;
            case 'all':
                $message = 'No patients in queue at this time';
                break;
            default:
                $message = 'No patients found for the selected filter';
        }
    }
    
    // Return JSON response
    echo json_encode(array(
        'success' => true,
        'patients' => $patients,
        'count' => count($patients),
        'filter' => $filter,
        'user_type' => $userType,
        'message' => $message
    ));
