<?php

// Start session
session_start();

// Set content type to JSON
header('Content-Type: application/json');

// Include necessary files
include('../process/functions.php');

// Create database connection
$con = ddxrxDBConnect();

// Check if user is logged in and has the correct user type
if(!isset($_SESSION['userType'])) {
    $output = array(
        'status' => false,
        'title' => 'error',
        'message' => 'User not logged in or invalid user type.'
    );
    echo json_encode($output);
    exit();
}

// Get the diagnosis ID and patient ID from the request
if(isset($_POST['diagnosis_id']) && isset($_POST['patient_id'])) {
    $diagnosis_id = $_POST['diagnosis_id'];
    $patient_id = $_POST['patient_id'];
} else {
    $output = array(
        'status' => false,
        'title' => 'error',
        'message' => 'Required parameters not provided.'
    );
    echo json_encode($output);
    exit();
}

// Prepare and execute the SQL statement to delete patient history
$query = "DELETE FROM `medical` WHERE id = ? AND patient_id = ?";
$stmt = $con->prepare($query);
$stmt->bind_param("ii", $diagnosis_id, $patient_id);
if($stmt->execute()) {
    $output = array(
        'status' => true,
        'title' => 'success',
        'message' => 'Patient history deleted successfully.'
    );
} else {
    $output = array(
        'status' => false,
        'title' => 'error',
        'message' => 'Failed to delete patient history.'
    );
}

// Close the statement and connection
$stmt->close();
$con->close();

// Return the output as JSON
echo json_encode($output);
exit();
