<?php

// Include functions file
include('functions.php');

// Set header to JSON
header('Content-Type: application/json');

$formInput = $_POST['savedInput'];
$waiting_room_id = $_POST['waiting_room_id'];

// Update waiting_room table with the $formInput
if (isset($formInput) && !empty($formInput)) {
    $conn = ddxrxDBConnect();

    // Prepare the SQL statement
    $sql = "UPDATE `waiting_room` SET `saved_input` = ?, `signed` = '1' WHERE `waitingroom_id` = ?";
    
    if ($stmt = $conn->prepare($sql)) {
        $stmt->bind_param("si", $formInput, $waiting_room_id);
        
        // Execute the statement
        if ($stmt->execute()) {
            // Return success response
            echo json_encode(array(
                'result' => true,
                'title' => 'success',
                'message' => 'Encounter notes saved successfully.',
                'icon' => 'success'
            ));
        } else {
            // Return error response
            echo json_encode(array(
                'result' => false,
                'title' => 'error',
                'message' => 'Failed to save encounter notes.',
                'icon' => 'error'
            ));
        }
        
        $stmt->close();
    } else {
        // Return error response for prepare failure
        echo json_encode(array(
            'result' => false,
            'title' => 'error',
            'message' => 'Database prepare failed.',
            'icon' => 'error'
        ));
    }

    $conn->close();
} else {
    // Return error response for empty input
    echo json_encode(array(
        'result' => false,
        'title' => 'error',
        'message' => 'No input provided.',
        'icon' => 'error'
    ));
}