<?php

// Include Functions
include('functions.php');

// Set header to JSON
header('Content-Type: application/json');

// Check if the session has expired
if(!isset($_SESSION['userid']) || !isset($_SESSION['user_type'])) {

    $output = array(
        'result' => false,
        'status_code' => 401,
        'title' => 'Session Expired',
        'message' => 'Your session has expired. Please login again.'
    );

    echo json_encode($output);
    die();
}

// Check if post data( patient_id, provider_id, order_type, order and signed_image) is set
if( isset($_POST['patient_id']) && isset($_POST['provider_id']) && isset($_POST['order_type']) && isset($_POST['order']) && isset($_POST['signed_image']) ){
    
    // Set the post data to variables
    $uid = $_POST['uid'];
    $patient_id = $_POST['patient_id'];
    $provider_id = $_POST['provider_id'];
    $order_type = $_POST['order_type'];
    $order = $_POST['order'];
    $signed_image = $_POST['signed_image'];
    
    // Set the date
    date_default_timezone_set('America/Chicago');
    $date = date('Y/m/d H:i:s');
    
    // Prepare the SQL statement
    $conn = ddxrxDBConnect();
    if( $order_type == 'write' ){
        $sql = "INSERT INTO signed_order (patient_id, provider_id, written_order, signature) VALUES (?, ?, ?, ?)";
    } else {
        $sql = "INSERT INTO signed_order (patient_id, provider_id, type_order, signature) VALUES (?, ?, ?, ?)";
    }
    
    $stmt = $conn->prepare($sql);
    $stmt->bind_param("iiss", $patient_id, $provider_id, $order, $signed_image);

    // Execute the statement and check if it was successful
    if ($stmt->execute()) {
        $output = array(
            'result' => true,
            'status_code' => 200,
            'title' => 'Success',
            'message' => 'Order has been saved successfully.',
            'patient_id' => $patient_id,
            'uid' => $uid
        );
    } else {
        $output = array(
            'result' => false,
            'status_code' => 500,
            'title' => 'Error',
            'message' => 'Error: ' . $stmt->error
        );
    }
    
    // Close the statement and the database connection
    $stmt->close();
    $conn->close();

} else {
    $output = array(
        'result' => false,
        'status_code' => 400,
        'title' => 'Bad Request',
        'message' => 'Please provide all the required fields.'
    );
}

// Output the result
echo json_encode($output);
?>