<?php
    session_start();
    
    if(!isset($_SESSION['userid']) || !isset($_SESSION['userType'])) {
        header("Location: provider_login.php");
        die();
    }
    if($_SESSION['userType'] != 'nurse' && $_SESSION['userType'] != 'doctor') {
        header("Location: view_record.php");
        die();
    }

    include('process/functions.php');
    
    $version = get_version();
    $patientsResult = mysqli_query(ddxrxDBConnect(), "SELECT * FROM patients WHERE user_id != 0 AND active = 1 AND groupid = '$version' ORDER BY patient_id DESC");

?>
<!DOCTYPE html>
<html>
    <head>
        <meta http-equiv="Content-Type" content="text/html; charset=utf-8">
        <title>Start Video Call - DDXRX</title>
        
        <link rel="stylesheet" type="text/css" href="assets/css/reset.css">
        <link rel="stylesheet" type="text/css" href="assets/css/grid.css">
        <link rel="stylesheet" type="text/css" href="assets/css/jquery.dataTables.min.css">
        <link rel="stylesheet" type="text/css" href="assets/css/responsive.css">
        <link rel="stylesheet" type="text/css" href="assets/css/top-bar.css">
        <link rel="stylesheet" type="text/css" href="assets/css/videocall.css">
        
        <script src="https://ajax.googleapis.com/ajax/libs/jquery/3.3.1/jquery.min.js"></script>
        <script type="module" src="https://unpkg.com/ionicons@5.5.2/dist/ionicons/ionicons.esm.js"></script>
        <script nomodule src="https://unpkg.com/ionicons@5.5.2/dist/ionicons/ionicons.js"></script>
        <script type="text/javascript" language="javascript" src="assets/js/jquery.dataTables.js"></script>
        
        <script>
        $(document).ready(function(){

            $('#patientsList').dataTable( {
                "order": [[ 0, "desc" ]]
            });

        });
        </script>
        
    </head>
    <body class="nooverflow" data-url="<?php echo 'https://'.get_version('url'); ?>">
    
        <div class="container optimized-container videocallwrapper">
            <div class="col-md-12">
                
                <?php include('nav/nav_videocall.php'); ?>
                
                <table id="patientsList" class="display table table-light table-hover table-striped patientsList" cellspacing="0" width="100%">
                    <thead>
                        <tr>
                            <td><strong>Last Name</strong></td>
                            <td><strong>First Name </strong></td>
                            <td><strong>Date of Birth </strong></td>
                            <td><strong>Call Status</strong></td>
                            <td style="text-align: right"><strong>Action </strong></td>
                        </tr>
                    </thead>
                    <tbody>
                        <?php while($row = mysqli_fetch_array( $patientsResult )): ?>
                        <tr>
                            <td class="lname"><?PHP echo ucwords($row['patient_lname']);?></td>
                            <td class="fname"><?PHP echo ucwords($row['patient_fname']);?></td>
                            <td><?PHP echo $row['patient_dob']?></p></a></td>
                            <td><div class="statusIcon inactive"></div> Inactive</td>
                            <td style="text-align: right">
                                    
                                <?php
                                    if( isset($row['cell']) ){

                                        $phone = $row['cell'];
                                        $phone = str_replace( ' ', '', $phone );
                                        $phone = str_replace( '+', '', $phone );
                                    
                                        echo '<a href="start_videocall.php?patient='.$row['patient_id'].'&username='.$row['user_id'].'&room_name='.$row['patient_id'].'&callid='.$row['patient_id'].'&uid='.$row['user_id'].'" target="_blank" class="init-call" data-phone="'.$phone.'" data-callid="'.$row['patient_id'].'" data-patient="'.$row['user_id'].'">Initiate Call</a>';

                                    }
                                ?>
                            </td>
                        </tr>
                    <?php endwhile; ?>
                    <?php mysqli_close(ddxrxDBConnect()); // Close the connection ?>
                    </tbody>
                </table>
                
            </div>
        </div>

        <?php
            if( $_SESSION['user_type'] == 'nurse' ){
                provider_bottom_nav();
            }elseif( $_SESSION['user_type'] == 'physician' || $_SESSION['user_type'] == 'doctor' ){
                physician_bottom_nav();
            }
        ?>

        <script>
            $(document).ready(function(){
                    $('body').on('click', '.init-call', function() { 

                    var url = $('body').data('url');
                    var callID = $(this).data('callid');
                    var phone = $(this).data('phone');
                    var patientId = $(this).data('patient');
                    var patient_fname = $(this).parent().siblings('.fname').html();
                    var patient_lname = $(this).parent().siblings('.lname').html();

                    var socketDataOBJ = {
                        roomNo: "0",
                        patientId: patientId,
                        type: "video_call",
                        isValid: true,
                        first_name: patient_fname,
                        last_name: patient_lname,
                        data: {
                            phone: phone,
                            url: url+'/start_videocall.php?patient='+callID+'&username=user_'+callID+'&room_name='+callID+'&callid='+callID, 
                            videocall_id: callID
                        }
                    }

                    var socketData = JSON.stringify(socketDataOBJ);

                    $.ajax({
                        url: 'https://clinician.club/push_data',
                        type: "POST",
                        data: socketData,
                        contentType: "application/json",
                        beforeSend: function () { },
                        success: function (response) { }
                    });

                })
            })
        </script>

    </body>
</html>