<?php

    session_start();
    
    include('../process/functions.php');

    if(!isset($_SESSION['userid']) || !isset($_SESSION['userType'])) {
        header("Location: ../login.php");
        die();
    }

    if($_SESSION['userType'] != 'nurse' && $_SESSION['userType'] != 'doctor') {
        header("Location: ../new_records.php");
        die();
    }

    function get_page_name() {
        return substr($_SERVER["SCRIPT_NAME"],strrpos($_SERVER["SCRIPT_NAME"],"/")+1);
    }
    function check_page_data(){
        
        // Check if page is available in database
        $page = substr($_SERVER["SCRIPT_NAME"],strrpos($_SERVER["SCRIPT_NAME"],"/")+1);
        $group_id = get_version();
        $sql = "SELECT * FROM `sitter` WHERE `group_id` ='$group_id'";
        $result = mysqli_query(ddxrxDBConnect(), $sql);
        $row = mysqli_fetch_assoc($result);

        if( isset($row['pageName']) ){
            return true;
        } else {
            return false;
        }

    }

    // Generate Character Random Number
    function generateRandomString($length = 10) {
        $characters = '0123456789';
        $charactersLength = strlen($characters);
        $randomString = '';
        for ($i = 0; $i < $length; $i++) {
            $randomString .= $characters[rand(0, $charactersLength - 1)];
        }
        return $randomString;
    }

    // Get vitals history
    function get_vitals_history($patient_id){
        $sql = "SELECT * FROM `vitals_history` WHERE `patient_id` ='$patient_id' ORDER BY `vitals_history`.`date_added` DESC LIMIT 1";
        $result = mysqli_query(ddxrxDBConnect(), $sql);
        $row = mysqli_fetch_assoc($result);
        return $row;
    }

?>
<!DOCTYPE html>
<html>
    <head>
        <meta http-equiv="Content-Type" content="text/html; charset=utf-8">
        <title>Start Video Call - DDXRX</title>
        
        <link rel="stylesheet" type="text/css" href="../assets/css/reset.css">
        <link rel="stylesheet" href="https://fonts.googleapis.com/css2?family=Material+Symbols+Outlined:opsz,wght,FILL,GRAD@20..48,100..700,0..1,-50..200" />
        <link rel="stylesheet" type="text/css" href="../assets/css/videocall.css">
        
        <script src="https://ajax.googleapis.com/ajax/libs/jquery/3.3.1/jquery.min.js"></script>
        <script type="module" src="https://unpkg.com/ionicons@5.5.2/dist/ionicons/ionicons.esm.js"></script>
        <script nomodule src="https://unpkg.com/ionicons@5.5.2/dist/ionicons/ionicons.js"></script>
        <script src="../assets/js/sitter.js" type="text/javascript"></script>

    </head>
    <body class="nooverflow">

        <div class="iframWrapper">
            <div class="iframeContainer">

                <div class="pagination-container">

                    <h2>Sitter View</h2>

                    <!-- Pagination -->
                    <div class="pagination">
                        <a href="#" class="active" data-page="1">Page 1</a>
                        <a href="#" data-page="2">Page 2</a>
                        <a href="#" data-page="3">Page 3</a>
                        <a href="#" data-page="4">Page 4</a>
                    </div>
                    <!-- Pagination -->

                </div>

                <?php                
                if (check_page_data() == true) {
                    // Generate
                    $counter = 0;
                    $page_counter = 0;
                    $iframeCounter = 0;
                    $page = substr($_SERVER["SCRIPT_NAME"], strrpos($_SERVER["SCRIPT_NAME"], "/") + 1);
                    $group_id = get_version();
                    $sql = "SELECT * FROM `sitter` WHERE `group_id` ='$group_id'";
                    $result = mysqli_query(ddxrxDBConnect(), $sql);
                    $row = mysqli_fetch_assoc($result);

                    $iframeData = json_decode($row['iframeData'], true);

                    // Ensure $iframeData is an array before proceeding
                    if (is_array($iframeData)) {

                        echo '<div class="item-container">';

                            foreach ($iframeData as $iframe) {
                                $counter++;
                                $iframeCounter++;
                                $page_counter++;

                                if ($iframe['source'] != '') {
                                    $closeBtn = '<ion-icon name="close-circle" class="remove"></ion-icon>';
                                    $refreshBtn = '<ion-icon name="refresh-circle" class="refresh"></ion-icon>';
                                } else {
                                    $closeBtn = '';
                                    $refreshBtn = '';
                                }

                                // Patient ID
                                if (isset($iframe['patientID']) && $iframe['patientID'] != '') {
                                    $patient_id = $iframe['patientID'];
                                } else {
                                    $patient_id = '0';
                                }

                                // Get vitals history
                                $vitals_history = get_vitals_history($patient_id);

                                // Default vitals
                                $systolic = 'N/A';
                                $diastolic = 'N/A';
                                $heartrate = 'N/A';
                                $pulseox = 'N/A';

                                // Check if vitals history is not empty
                                if (!empty($vitals_history)) {
                                    $systolic = $vitals_history['systolic'];
                                    $diastolic = $vitals_history['diastolic'];
                                    $heartrate = $vitals_history['heartrate'];
                                    $pulseox = $vitals_history['pulseox'];
                                }

                                if (!empty($iframe['source'])) {
                                    $vitals_data = '<ul class="stats" data-patient-id="' . $patient_id . '" id="patient-id-' . $patient_id . '">';
                                    $vitals_data .= '<li>Systolic: ' . $systolic . '</li>';
                                    $vitals_data .= '<li>Diastolic: ' . $diastolic . '</li>';
                                    $vitals_data .= '<li>Heart Rate: ' . $heartrate . '</li>';
                                    $vitals_data .= '<li>Pulse Ox: ' . $pulseox . '</li>';
                                    $vitals_data .= '</ul>';
                                } else {
                                    $vitals_data = '';
                                }

                                // Pager Start
                                if ($page_counter == 1) {
                                    echo '<div class="page page-1 active">';
                                } elseif ($page_counter == 13) {
                                    echo '<div class="page page-2">';
                                } elseif ($page_counter == 25) {
                                    echo '<div class="page page-3">';
                                } elseif ($page_counter == 37) {
                                    echo '<div class="page page-4">';
                                }

                                echo '  <div class="item" data-frame="' . $iframe['frame'] . '" data-room="' . $iframe['room'] . '" data-source="' . $iframe['source'] . '"  data-patient-id="' . $patient_id . '" id="item-patient-id-' . $patient_id . '">
                                            <ion-icon name="add-circle" class="add"></ion-icon>' . $closeBtn . $refreshBtn . '<div class="channel-label">' . $iframe['room'] . '</div>
                                            <iframe src="' . $iframe['source'] . '" name="' . $iframe['frame'] . '" class="iframe ' . $iframe['frame'] . '" id="iframe_' . $iframeCounter . '"></iframe>
                                            ' . $vitals_data . '
                                        </div>';

                                // Pager End
                                if ($page_counter == 12) {
                                    echo '</div>';
                                } elseif ($page_counter == 24) {
                                    echo '</div>';
                                } elseif ($page_counter == 36) {
                                    echo '</div>';
                                } elseif ($page_counter == 48) {
                                    echo '</div>';
                                }
                            }

                        echo '</div>';
                    
                    } else {
                        // Use default items if iframe data is not available
                        include('default_items.php');
                    }

                    echo '<div class="clear"></div>';
                } else {
                    // Use default items if page data is not available
                    include('default_items.php');
                }
                ?>

            </div>
        </div>
        
        <div class="sitterContainer">
            <ion-icon name="close" class="closeSitter"></ion-icon>
            <div class="container optimized-container" id="sitterContainer" data-current-frame="0">
                <a href="../start_videocall.php?patient=100006x803965705509524&username=803965705509524" class="target" target="iframe_1">Room <span>7138</span></a>
                <a href="../start_videocall.php?patient=100006x859706942830389&username=859706942830389" class="target" target="iframe_1">Room <span>7139</span></a>
                <a href="../start_videocall.php?patient=100006x113094897327515&username=113094897327515" class="target" target="iframe_1">Room <span>7140</span></a>
                <a href="../start_videocall.php?patient=100006x131944271835117&username=131944271835117" class="target" target="iframe_1">Room <span>7141</span></a>
                <a href="../start_videocall.php?patient=100006x126557770771903&username=126557770771903" class="target" target="iframe_1">Room <span>7142</span></a>
                <a href="../start_videocall.php?patient=100006x358668447923365&username=358668447923365" class="target" target="iframe_1">Room <span>7143</span></a>
                <a href="../start_videocall.php?patient=100006x157145212559194&username=157145212559194" class="target" target="iframe_1">Room <span>7144</span></a>
                <a href="../start_videocall.php?patient=100006x655236508515384&username=655236508515384" class="target" target="iframe_1">Room <span>7145</span></a>
                <a href="../start_videocall.php?patient=100006x110039611451102&username=110039611451102" class="target" target="iframe_1">Room <span>7146</span></a>
                <a href="../start_videocall.php?patient=100006x236744633888721&username=236744633888721" class="target" target="iframe_1">Room <span>7147</span></a>
                <a href="../start_videocall.php?patient=100006x391175962910979&username=391175962910979" class="target" target="iframe_1">Room <span>7148</span></a>
                <a href="../start_videocall.php?patient=100006x485406488549182&username=485406488549182" class="target" target="iframe_1">Room <span>7149</span></a>
                <a href="../start_videocall.php?patient=100006x927695890610287&username=927695890610287" class="target" target="iframe_1">Room <span>7150</span></a>
                <a href="../start_videocall.php?patient=100006x142469055352459&username=142469055352459" class="target" target="iframe_1">Room <span>7151</span></a>
                <a href="../start_videocall.php?patient=100006x323043233706011&username=323043233706011" class="target" target="iframe_1">Room <span>7152</span></a>
                <a href="../start_videocall.php?patient=100006x701728040742991&username=701728040742991" class="target" target="iframe_1">Room <span>7153</span></a>
                <a href="../start_videocall.php?patient=100006x224435628309830&username=224435628309830" class="target" target="iframe_1">Room <span>7154</span></a>
                <a href="../start_videocall.php?patient=100006x664988586073487&username=664988586073487" class="target" target="iframe_1">Room <span>7155</span></a>
                <a href="../start_videocall.php?patient=100006x064887162901006&username=064887162901006" class="target" target="iframe_1">Room <span>7156</span></a>
                <a href="../start_videocall.php?patient=100006x685305480525452&username=685305480525452" class="target" target="iframe_1">Room <span>7157</span></a>
                <a href="../start_videocall.php?patient=100006x784940862917827&username=784940862917827" class="target" target="iframe_1">Room <span>7158</span></a>
                <a href="../start_videocall.php?patient=100006x129028467212168&username=129028467212168" class="target" target="iframe_1">Room <span>7159</span></a>
                <a href="../start_videocall.php?patient=100006x812967375679654&username=812967375679654" class="target" target="iframe_1">Room <span>7160</span></a>
                <a href="../start_videocall.php?patient=100006x513297533992377&username=513297533992377" class="target" target="iframe_1">Room <span>7161</span></a>
                <a href="../start_videocall.php?patient=100006x189878409027615&username=189878409027615" class="target" target="iframe_1">Room <span>7162</span></a>
                <a href="../start_videocall.php?patient=100006x643007083838886&username=643007083838886" class="target" target="iframe_1">Room <span>7163</span></a>
                <a href="../start_videocall.php?patient=100006x407437856004357&username=407437856004357" class="target" target="iframe_1">Room <span>7164</span></a>
                <a href="../start_videocall.php?patient=100006x283292838151005&username=283292838151005" class="target" target="iframe_1">Room <span>7165</span></a>
                <a href="../start_videocall.php?patient=100006x966325279346253&username=966325279346253" class="target" target="iframe_1">Room <span>7166</span></a>
                <a href="../start_videocall.php?patient=100006x069112977581564&username=069112977581564" class="target" target="iframe_1">Room <span>7167</span></a>
                <a href="../start_videocall.php?patient=100006x847253657963665&username=847253657963665" class="target" target="iframe_1">Room <span>7168</span></a>
                <a href="../start_videocall.php?patient=100006x563953087345570&username=563953087345570" class="target" target="iframe_1">Room <span>7169</span></a>
                <a href="../start_videocall.php?patient=100006x837989538033925&username=837989538033925" class="target" target="iframe_1">Room <span>7170</span></a>
                <a href="../start_videocall.php?patient=100006x293068892830430&username=293068892830430" class="target" target="iframe_1">Room <span>7171</span></a>
                <a href="../start_videocall.php?patient=100006x685626613762694&username=685626613762694" class="target" target="iframe_1">Room <span>7172</span></a>
                <a href="../start_videocall.php?patient=100006x091761706575034&username=091761706575034" class="target" target="iframe_1">Room <span>7173</span></a>
                <a href="../start_videocall.php?patient=100006x365615896685693&username=365615896685693" class="target" target="iframe_1">Room <span>7174</span></a>
                <a href="../start_videocall.php?patient=100006x565791230452561&username=565791230452561" class="target" target="iframe_1">Room <span>7175</span></a>
                <a href="../start_videocall.php?patient=100006x846429260429160&username=846429260429160" class="target" target="iframe_1">Room <span>7176</span></a>
                <a href="../start_videocall.php?patient=100006x515419534255980&username=515419534255980" class="target" target="iframe_1">Room <span>7177</span></a>
                <a href="../start_videocall.php?patient=100006x540070551564454&username=540070551564454" class="target" target="iframe_1">Room <span>7178</span></a>
                <a href="../start_videocall.php?patient=100006x476809439579647&username=476809439579647" class="target" target="iframe_1">Room <span>7179</span></a>
                <a href="../start_videocall.php?patient=100006x744303958183918&username=744303958183918" class="target" target="iframe_1">Room <span>7180</span></a>
                <a href="../start_videocall.php?patient=100006x552258349248624&username=552258349248624" class="target" target="iframe_1">Room <span>7181</span></a>
            </div>
        </div>

    </body>
</html>