<?php

// Enable error reporting
error_reporting(1);

// Start the session
session_start();

// Include the functions file
include('process/functions.php');

// Set connection variable
$con = ddxrxDBConnect();

// Check if the session has expired
checkSessionTimeout();

if(!isset($_SESSION['userid']) || !isset($_SESSION['userType'])) {
    header("Location: login.php");
    die();
}

$patient_id = null;
if(isset($_SESSION['userid']) && isset($_SESSION['patient_id'])) {
    $patient_id = $_SESSION['patient_id'];
} else if($_SESSION['userType']!="patient" && isset($_GET['id']) ) {
    $patient_id = $_GET['id'];
}
if($patient_id != null) {

	$sql = "SELECT * FROM patients WHERE patient_id = '$patient_id' LIMIT 1";
	$result = mysqli_query($con, $sql) or die('SQL Error :: '.mysqli_error());
	$user = mysqli_fetch_assoc($result);
	
	$sql = "SELECT * FROM social WHERE patient_id = '$patient_id' LIMIT 1";
	$result = mysqli_query($con, $sql) or die('SQL Error :: '.mysqli_error());
	$social_history = mysqli_fetch_assoc($result);
	
    function get_social_record( $social_history, $type = null, $value = null ) {
        if($social_history[$type] == $value) {
            echo 'checked="checked"';
        }
    }
    ?>
    
    <!DOCTYPE html>
    <html  class="ui-mobile">
        <head><meta http-equiv="Content-Type" content="text/html; charset=utf-8">
            <title>DDXRX - Social History</title>
    
            <meta name="viewport" content="width=device-width, initial-scale=1.0">
    
            <script type="text/javascript" src="assets/js/jquery-3.3.1.min.js"></script>
            <script type="text/javascript" src="assets/js/jquery.slicknav.js"></script>
            <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
            <script type="text/javascript" src="assets/js/process/history_social.js"></script>
            <script type="text/javascript" src="assets/js/admin.js"></script>
            <script type="text/javascript" src="assets/js/init.js"></script>
            <script type="text/javascript" src="assets/js/general-ui.js"></script>
            <script type="text/javascript" src="assets/js/mobile.js"></script>
            <script type="text/javascript" src="assets/js/faq.js"></script>
    
            <link rel="stylesheet" type="text/css" href="assets/css/reset.css">
            <link rel="stylesheet" type="text/css" href="assets/css/grid.css">
            <link rel="stylesheet" type="text/css" href="assets/css/main-menu.css">
            <link rel="stylesheet" type="text/css" href="assets/css/slicknav.css">
            <link rel="stylesheet" type="text/css" href="assets/css/style.css">
            <link rel="stylesheet" type="text/css" href="assets/css/responsive.css">
            <link rel="stylesheet" type="text/css" href="assets/css/patient-records.css">
            <link rel="stylesheet" type="text/css" href="assets/css/general-ui.css">
            <link rel="stylesheet" type="text/css" href="assets/css/mobile.css">
            <link rel="stylesheet" type="text/css" href="assets/css/faq.css">
            
            <style>
            body{
                top: 0px!important;
            }
            .goog-te-banner-frame.skiptranslate {
                display: none !important;
            }
            #goog-gt-tt{
                display:none!important;
            }
            #google_translate_element{
                position: fixed; left:20px; top: 20px; z-index: 9999999;
            }
            </style>
            
            <script type="text/javascript">
            function googleTranslateElementInit() {
                new google.translate.TranslateElement({pageLanguage: 'en', 
                layout:     google.translate.TranslateElement.InlineLayout.VERTICAL,
                autoDisplay: false, 
                includedLanguages: ''}, 'google_translate_element');}
            </script>
            <script type="text/javascript" src="https://translate.google.com/translate_a/element.js?cb=googleTranslateElementInit"></script>
            
            <!-- Global site tag (gtag.js) - Google Analytics -->
            <script async src="https://www.googletagmanager.com/gtag/js?id=UA-148409281-5"></script>
            <script>
              window.dataLayer = window.dataLayer || [];
              function gtag(){dataLayer.push(arguments);}
              gtag('js', new Date());
            
              gtag('config', 'UA-148409281-5');
            </script>
                        
        </head>
        <body data-user-id="<?php echo $patient_id; ?>">
            
            <div class="loading-screen"></div>
            
            <div id="google_translate_element"></div>
            
            <?php include('dashboard_menu.php'); ?>
    
            <div class="container pb-100 optimized-container"<?php if( isset($_GET['id']) ){ echo ' data-user="'.$_GET['id'].'"'; } ?>>
                <div class="col-md-12">
                    <div id="toPrint">
                        <div class="form-container">
    
                            <div class="record-navigation-menu">
                                <?php include('emr_navigation.php'); ?>
                            </div>
                            
                            <div class="tab-content-container card">
                                <div class="row">
    
                                	<div class="col-xs-12">
    									<div class="social-container" data-id="<?php echo $patient_id; ?>">
    										
    										<h1>Tobaco</h1>
    										<p>Do you smoke any sort of tobaco?</p>
    
    										<label style="width: 100%!important;"><span>Current</span> <input type="radio" name="tobaco" value="current" <?php get_social_record($social_history, 'tobaco','current'); ?>></label>
    										<label style="width: 100%!important;"><span>Prior</span> <input type="radio" name="tobaco" value="prior" <?php get_social_record($social_history, 'tobaco','prior'); ?>></label>
    										<label style="width: 100%!important;"><span>Never</span> <input type="radio" name="tobaco" value="never" <?php get_social_record($social_history, 'tobaco','never'); ?>></label>
    
    										<div class="clear"></div>
    
    										<h1>Alcohol</h1>
    										<p>Do you drink any sort of alcohol?</p>
    
    										<label><span>Never</span> <input type="radio" name="alcohol" value="never" <?php get_social_record($social_history, 'alcohol','never'); ?>></label>
    										<label><span>Prior</span> <input type="radio" name="alcohol" value="prior" <?php get_social_record($social_history, 'alcohol','prior'); ?>></label>
    										<label><span>Occasional</span> <input type="radio" name="alcohol" value="occasional" <?php get_social_record($social_history, 'alcohol','occasional'); ?>></label>
    										<label><span>Daily</span> <input type="radio" name="alcohol" value="daily" <?php get_social_record($social_history, 'alcohol','daily'); ?>></label>
    
    										<div class="clear"></div>
    
    										<h1>Illicit Drug</h1>
    										<p>Do you take any Illicit Drug?</p>
    
    										<label><span>Yes</span> <input type="radio" name="drugs" value="yes" <?php get_social_record($social_history, 'drugs','yes'); ?>></label>
    										<label><span>No</span> <input type="radio" name="drugs" value="no" <?php get_social_record($social_history, 'drugs','no'); ?>></label>
    
    										<div class="clear"></div>
    
    										<h1>Occupation</h1>
    										<p>Do you have a job?</p>
    
    										<label><span>Unemployed</span> <input type="radio" name="occupation" value="unemployed" <?php get_social_record($social_history, 'occupation','unemployed'); ?>></label>
    										<label><span>Employed</span> <input type="radio" name="occupation" value="employed" <?php get_social_record($social_history, 'occupation','employed'); ?>></label>
    
    										<div class="clear"></div>
    
    										<h1>Prison History</h1>
    										<p>Where you detained in a prison before?</p>
    
    										<label><span>Yes</span> <input type="radio" name="prison" value="yes" <?php get_social_record($social_history, 'prison','yes'); ?>></label>
    										<label><span>No</span> <input type="radio" name="prison" value="no" <?php get_social_record($social_history, 'prison','no'); ?>></label>
    
    										<div class="clear"></div>
    
    										<h1>Travel</h1>
    										<p>Did you recently traveled?</p>
    
    										<label><span>Yes</span> <input type="radio" name="travel" value="yes" <?php get_social_record($social_history, 'travel','yes'); ?>></label>
    										<label><span>No</span> <input type="radio" name="travel" value="no" <?php get_social_record($social_history, 'travel','no'); ?>></label>
    
    										<div class="clear"></div>
    
    										<h1>Exercise</h1>
    										<p>Did you Exercise?</p>
    
    										<label><span>Yes</span> <input type="radio" name="exercise" value="yes" <?php get_social_record($social_history, 'exercise','yes'); ?>></label>
    										<label><span>No</span> <input type="radio" name="exercise" value="no" <?php get_social_record($social_history, 'exercise','no'); ?>></label>
    										
    										<div class="clear"></div>
    
    										<h1>Household Firearms</h1>
    										<p>Do you keep any firearms at home?</p>
    
    										<label><span>Yes</span> <input type="radio" name="firearms" value="yes" <?php get_social_record($social_history, 'firearms','yes'); ?>></label>
    										<label><span>No</span> <input type="radio" name="firearms" value="no" <?php get_social_record($social_history, 'firearms','no'); ?>></label>
    
    										<div class="clear"></div>
    
    									</div>
                                	</div>
    
                                </div>
                            </div>
    
                        </div>
                    </div>
                </div>
                <div class="clear"></div>
            </div>
    
            <?php
            	if( $_SESSION['userType'] == 'nurse' ){
            		provider_bottom_nav();
            	}elseif( $_SESSION['userType'] == 'doctor' ){
            		physician_bottom_nav();
            	}else{
            		bottom_nav();
            	}
            ?>
    
        </body>
    </html>

<?php

    } // End else if

    // Close the database connection
    $con->close();

?>