<?php

session_start();

// Add functions
include('process/functions.php');

if( isset($_POST['username']) || isset($_GET['username']) ){

    function generateRandomString($length = 10) {
        $halfLength = $length / 2;
        $numbers = '0123456789';
        $letters = 'abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ';
    
        $randomString = '';
    
        for ($i = 0; $i < $halfLength; $i++) {
            $randomString .= $numbers[rand(0, strlen($numbers) - 1)];
        }
    
        for ($i = $halfLength; $i < $length; $i++) {
            $randomString .= $letters[rand(0, strlen($letters) - 1)];
        }
    
        // Shuffle the string to mix the numbers and letters
        $randomString = str_shuffle($randomString);
    
        return $randomString;
    }

    // Variables
    $conn = ddxrxDBConnect();
    $version = get_version();
    $room_id = $version . 'x' . generateRandomString(30);
    $user_prefix = generateRandomString(5);
    $patient_id = $_GET['patient'];
    $uid = $_GET['uid'];
    
    // Set Provider Name
    if( $_SESSION['user_type'] == 'nurse' ){
        $username = 'Nurse_'.$user_prefix;
    }elseif( $_SESSION['user_type'] == 'physician' || $_SESSION['user_type'] == 'doctor' ){
        $username = 'Physician_'.$user_prefix;
    }elseif( $_SESSION['user_type'] == 'patient' ){
        $username = 'Patient_'.$user_prefix;
    }else{
        $username = 'user_'.$user_prefix;
    }
    
    // Set php session
    if( isset($_POST['username']) ){
        $_SESSION["username"] = $_POST['username'];
    }elseif( isset($_GET['username']) ){
        $_SESSION["username"] = $_GET['username'];
    }
    
    // Get patient phone number
    $patientPhoneNumber = getPatientInfo_pid( $patient_id, 'cell' );
    
    // Get patient name
    $patientName = getPatientInfo_pid( $patient_id, 'patient_fname' );
    
    $patientUserID = getPatientInfo_pid( $patient_id, 'user_id' );
    
    // Video call URL
    $initiator_url = base_url() . '/videocall_stream.php?room_name='.$room_id.'&uid='.$uid;
    $installer_url = base_url() . '/videocall_stream.php?room_name='.$room_id.'&noforce=false&username=' . $patientName . '&uid=' . $uid;
    $SMS_url = base_url() . '/videocall_stream.php?room_name='.$room_id;
    
    // Set SMS Message
    $message = 'Please tap the link below to join the video call ' . $SMS_url;
    
    // Send message to patient
    send_sms($patientPhoneNumber, $message);
    
    // Send video call link to kafka
    $setOptions = array(
        'userid' => $patientUserID,
    	'username' => $username,
    	'videocall_url' => $installer_url
    );
    sendVideoCalltoKafka( $setOptions );
    
    // Create video call record in database
    if( isset($_SESSION) ){
        $user_id = $_SESSION['userid'];
        $videoCallOptions = array(
            'meeting_id' => $room_id,
            'started_by' => $user_id,
            'patient_id' => $patient_id
        );
        //create_videocall($videoCallOptions);
    }
    
    // Redirect
    header( 'location: ' . $initiator_url );

}

?>

<?php if( !isset($_POST['username']) ){ ?>
<!DOCTYPE html>
<html>
    <head>
        <meta http-equiv="Content-Type" content="text/html; charset=utf-8">
    	
    	<title>Video Call Identification - DDXRX</title>
    	<meta name="viewport" content="width=device-width, initial-scale=1">
    
    	<link rel="stylesheet" type="text/css" href="../assets/css/reset.css">
    	<link rel="stylesheet" type="text/css" href="../assets/css/grid.css">
    	<link rel="stylesheet" type="text/css" href="../assets/css/videocall.css">
        
    	<script src="https://ajax.googleapis.com/ajax/libs/jquery/3.4.1/jquery.min.js"></script>
    	<script src="//cdn.jsdelivr.net/npm/sweetalert2@11"></script>
    	
    	<script>
    	    
    	    $(document).ready(function(){
    	        
    	        $('.authentication-container form').submit(function(e){
    	            
    	            var username = $('.textbox.username').val();
    	            
    	            if( username == '' ){
    	            
    	                e.preventDefault();
    	                
    	                Swal.fire({
                            icon: 'warning',
                            title: 'Empty Field',
                            text: 'Please enter a name or username to start video call'
                        });
    	            
    	            }
    	             
    	        });
    	        
    	    });
    	    
    	</script>
    	
    </head>
    
    <body>

        <div class="container">
            <div class="authentication-container">
                <div class="wrapper">
                    <div class="inner">
                        
                        <div class="col-md-8">
                            <img src="assets/images/authenticate.svg">
                        </div>
                        
                        <div class="col-md-4">
                            <form action="" method="POST">
                                <div class="form-container">
                                    
                                    <h6>Hi There!</h6>
                                    <p>Please enter your name so other participants can identify you</p>
                                    
                                    <label>
                                        <input type="text" class="textbox username" name="username" placeholder="Enter your name or username">
                                    </label>
                                    
                                    <input type="submit" class="button" value="Join Call">
                                    
                                </div>
                            </form>
                        </div>
                        
                    </div>
                </div>
            </div>
        </div>

    </body>
</html>

<?php } ?>