<?php

session_start();

// Include the functions file
include('process/functions.php');

// Check if the session has expired
checkSessionTimeout();

if( !isset($_SESSION['userType']) ){

    header("Location: logout.php");
    die();

}

if( isset($_GET['order_id']) ){

    $order_id = $_GET['order_id'];

    $sql = "SELECT * FROM signed_order JOIN patients ON signed_order.patient_id = patients.patient_id WHERE signed_order.id = '$order_id' LIMIT 1";
    $result = mysqli_query(ddxrxDBConnect(), $sql) or die('SQL Error :: '.mysqli_error());
    $user_order = mysqli_fetch_assoc($result);

    $providerSQL = "SELECT all_users.user_type, all_users.userid, physician.physician_fname, physician.physician_lname, nurse.nurse_fname, nurse.nurse_lname from all_users left join physician on all_users.userid = physician.user_id left join nurse on all_users.userid = nurse.user_id where all_users.userid = ".$_SESSION['userid'];
    $providerResult = mysqli_query(ddxrxDBConnect(), $providerSQL) or die('SQL Error :: '.mysqli_error());
    $provider = mysqli_fetch_assoc($providerResult);
    $provider_user_id = $provider['userid'];

    // Close the connection
    ddxrxDBConnect()->close();

    if($provider['user_type'] == "2") {
        $name = $provider['physician_fname']." ".$provider['physician_lname'];
    } else {
        $name = $provider['nurse_fname']." ".$provider['nurse_lname'];
    }

}else{

    // Create redirect based on user type
    if( $_SESSION['userType'] == 'nurse' || $_SESSION['userType'] == 'doctor' ){
        $redirect = 'new_records.php';
    }else{
        $redirect = 'view_record.php';
    }
    

    header("Location: $redirect");
    die();

}

?>
    
    <!DOCTYPE html>
    <html  class="ui-mobile">
        <head><meta http-equiv="Content-Type" content="text/html; charset=utf-8">
            <title>DDXRX - Type Order</title>
            
            <meta name="viewport" content="width=device-width, initial-scale=1.0">
            
            <script type="text/javascript" src="assets/js/jquery-3.3.1.min.js"></script>
            <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
            <script type="text/javascript" src="assets/js/jquery.jqscribble.js"></script>
            <script type="text/javascript" src="assets/js/pencil.js"></script>
            <script type="text/javascript" src="assets/js/mobile.js"></script>
            <script type="text/javascript" src="assets/js/jquery.jqscribble.js"></script>
            <script type="text/javascript" src="assets/js/jquery-liveedit.js"></script>
    
            <link rel="stylesheet" type="text/css" href="assets/css/reset.css">
            <link rel="stylesheet" type="text/css" href="assets/css/grid.css">
            <link rel="stylesheet" type="text/css" href="assets/css/style.css">
            <link rel="stylesheet" type="text/css" href="assets/css/responsive.css">
            <link rel="stylesheet" type="text/css" href="assets/css/patient-records.css">
            <link rel="stylesheet" type="text/css" href="assets/css/mobile.css">
            <link rel="stylesheet" type="text/css" href="assets/css/faq.css">
            <link rel="stylesheet" type="text/css" href="assets/css/jquery-liveedit.css">
            
            <style>
                body{
                    top: 0px!important;
                }
                .goog-te-banner-frame.skiptranslate {
                    display: none !important;
                }
                #goog-gt-tt{
                    display:none!important;
                }
                #google_translate_element{
                    position: fixed; left:20px; top: 20px; z-index: 9999999;
                }
            </style>
            
            <script type="text/javascript">
            function googleTranslateElementInit() {
                new google.translate.TranslateElement({pageLanguage: 'en', 
                layout:     google.translate.TranslateElement.InlineLayout.VERTICAL,
                autoDisplay: false, 
                includedLanguages: ''}, 'google_translate_element');}
            </script>
            <script type="text/javascript" src="https://translate.google.com/translate_a/element.js?cb=googleTranslateElementInit"></script>
            
        </head>
        <body data-user-id="<?php echo $patient_id; ?>">
            
            <div class="loading-screen"></div>
            
            <div id="google_translate_element non-printable"></div>
            
            <div class="non-printable"><?php include('dashboard_menu.php'); ?></div>
    
            <div class="container pb-100 optimized-container"<?php if( isset($_GET['patient_id']) ){ echo ' data-user="'.$_GET['patient_id'].'"'; } ?>>
                <div class="col-md-12">
                    <div id="toPrint">
                        <div class="form-container">
    
                            <div class="record-navigation-menu non-printable">
                                <?php include('emr_navigation.php'); ?>
                            </div>
                            
                            <div class="tab-content-container no-border">

                                <div class="order-header non-printable">
                                    <h6>Issued Date: <?php echo $user_order['sign_date']; ?></h6>
                                    <ul class="nav-menu">
                                        <li><a href="order_list.php?uid=<?php echo $user_order['user_id']; ?>&patient_id=<?php echo $user_order['patient_id']; ?>" class="current">Go Back</a></li>
                                        <li><a href="javascript:void(0);" class="print-order">Print</a></li>
                                    </ul>
                                </div>
                                
                                <?php
                                    if( isset($user_order['written_order']) ){
                                        echo '
                                            <div class="canvas-main-container"><img src="'.$user_order['written_order'].'" class="print-area"></div>';
                                    }elseif( isset($user_order['type_order']) ){
                                        echo '
                                            <article class="live-edit print-area" data-model="article" data-id="1" data-url="/articles">
                                            <div class="editable-section" data-editable="false" data-name="content" data-text-options="true" placeholder="Start typing order here...">
                                            '.$user_order['type_order'].'
                                            </div>
                                            </article>
                                        ';

                                    }
                                ?>
                                    
                            </div>
    
                        </div>
                    </div>
                </div>
                <div class="clear"></div>
            </div>
    
            <?php
                echo '<div class="non-printable">';
            	if( $_SESSION['userType'] == 'nurse' ){
            		provider_bottom_nav();
            	}elseif( $_SESSION['userType'] == 'doctor' ){
            		physician_bottom_nav();
            	}else{
            		bottom_nav();
            	}
                echo '</div>';
            ?>
    
        </body>
    </html>