$(document).ready(function(){
    
    // Handle patient creation form submission
    $('#patient_create_form').on('submit', function(e) {
        e.preventDefault(); // Prevent default form submission
        
        // Check for validation errors before submitting
        if($('.username-error').length > 0 || $('.email-error').length > 0 || $('.phone-error').length > 0 ||
           $('input[name="username"]').hasClass('is-invalid') || 
           $('input[name="patient_email"]').hasClass('is-invalid') ||
           $('input[name="mobile_phone"]').hasClass('is-invalid')) {
            
            Swal.fire({
                icon: 'warning',
                title: 'Validation Error',
                text: 'Please fix the validation errors before submitting the form.',
                showConfirmButton: true,
                confirmButtonText: 'OK'
            });
            return false;
        }
        
        // Combine country code and phone number before submitting
        var countryCode = $('#country_code').val();
        var phoneNumber = $('#mobile_phone').val().trim();
        
        if (phoneNumber) {
            // Remove any spaces, hyphens, parentheses from phone number
            phoneNumber = phoneNumber.replace(/[\s\-\(\)\.]/g, '');
            // Combine country code with phone number
            $('#mobile_phone').val(countryCode + phoneNumber);
        }
        
        // Get form data
        var formData = new FormData(this);
        
        // Show loading alert
        Swal.fire({
            title: 'Processing...',
            text: 'Adding new patient, please wait.',
            allowOutsideClick: false,
            allowEscapeKey: false,
            showConfirmButton: false,
            didOpen: () => {
                Swal.showLoading();
            }
        });
        
        // Submit form via Ajax
        $.ajax({
            url: 'process/add_patient.php',
            type: 'POST',
            data: formData,
            contentType: false,
            processData: false,
            dataType: 'json',
            success: function(response) {
                // Close loading alert
                Swal.close();
                
                if(response.result === true) {
                    // Success - show success message then redirect
                    Swal.fire({
                        icon: response.icon,
                        title: response.title,
                        text: response.message,
                        showConfirmButton: true,
                        confirmButtonText: 'Done',
                        allowOutsideClick: false
                    }).then((result) => {
                        if (result.isConfirmed) {
                            // Redirect to patients list page
                            window.location.href = 'patients.php';
                        }
                    });
                } else {
                    // Error - show error message
                    Swal.fire({
                        icon: response.icon,
                        title: response.title,
                        text: response.message,
                        showConfirmButton: true,
                        confirmButtonText: 'OK'
                    });
                }
            },
            error: function(xhr, status, error) {
                // Close loading alert
                Swal.close();
                
                // Show error message
                Swal.fire({
                    icon: 'error',
                    title: 'Connection Error',
                    text: 'There was an error connecting to the server. Please try again.',
                    showConfirmButton: true,
                    confirmButtonText: 'OK'
                });
                
                console.error('Ajax Error:', error);
                console.error('Status:', status);
                console.error('Response:', xhr.responseText);
            }
        });
    });
    
    // Form validation - check if username exists
    $('#patient_create_form input[name="username"]').on('blur', function() {
        var username = $(this).val();
        
        if(username.length > 0) {
            $.ajax({
                url: 'process/check_username.php',
                type: 'POST',
                data: { username: username },
                dataType: 'json',
                success: function(response) {
                    if(response.exists) {
                        $('#patient_create_form input[name="username"]').addClass('is-invalid');
                        if(!$('#patient_create_form .username-error').length) {
                            $('#patient_create_form input[name="username"]').after('<div class="username-error text-danger">Username already exists</div>');
                        }
                    } else {
                        $('#patient_create_form input[name="username"]').removeClass('is-invalid');
                        $('#patient_create_form .username-error').remove();
                    }
                }
            });
        }
    });
    
    // Form validation - check if email exists (only if email is provided)
    $('#patient_create_form input[name="patient_email"]').on('blur', function() {
        var email = $(this).val();
        
        if(email.length > 0 && isValidEmail(email)) {
            $.ajax({
                url: 'process/check_patient_email.php',
                type: 'POST',
                data: { email: email },
                dataType: 'json',
                success: function(response) {
                    console.log('Email check response:', response); // Debug log
                    
                    if(response.error) {
                        console.error('Email check error:', response.error);
                        // Don't show error to user, just log it
                        $('#patient_create_form input[name="patient_email"]').removeClass('is-invalid');
                        $('#patient_create_form .email-error').remove();
                    } else if(response.exists === true) {
                        $('#patient_create_form input[name="patient_email"]').addClass('is-invalid');
                        if(!$('#patient_create_form .email-error').length) {
                            $('#patient_create_form input[name="patient_email"]').after('<div class="email-error text-danger">Email already exists</div>');
                        }
                    } else {
                        $('#patient_create_form input[name="patient_email"]').removeClass('is-invalid');
                        $('#patient_create_form .email-error').remove();
                    }
                },
                error: function(xhr, status, error) {
                    console.error('Ajax error:', error);
                    console.error('Response text:', xhr.responseText);
                    // Remove any existing error styling on connection error
                    $('#patient_create_form input[name="patient_email"]').removeClass('is-invalid');
                    $('#patient_create_form .email-error').remove();
                }
            });
        } else if(email.length > 0 && !isValidEmail(email)) {
            // Invalid email format
            $('#patient_create_form input[name="patient_email"]').addClass('is-invalid');
            if(!$('#patient_create_form .email-error').length) {
                $('#patient_create_form input[name="patient_email"]').after('<div class="email-error text-danger">Please enter a valid email address</div>');
            }
        } else {
            // Empty email - remove validation styling (email is optional)
            $('#patient_create_form input[name="patient_email"]').removeClass('is-invalid');
            $('#patient_create_form .email-error').remove();
        }
    });
    
    // Form validation - check if phone exists (only if phone is provided)
    $('#patient_create_form input[name="mobile_phone"]').on('blur', function() {
        var phone = $(this).val();
        
        if(phone.length > 0) {
            $.ajax({
                url: 'process/check_patient_phone.php',
                type: 'POST',
                data: { phone: phone },
                dataType: 'json',
                success: function(response) {
                    console.log('Phone check response:', response); // Debug log
                    
                    if(response.error) {
                        console.error('Phone check error:', response.error);
                        // Don't show error to user, just log it
                        $('#patient_create_form input[name="mobile_phone"]').removeClass('is-invalid');
                        $('#patient_create_form .phone-error').remove();
                    } else if(response.exists === true) {
                        $('#patient_create_form input[name="mobile_phone"]').addClass('is-invalid');
                        if(!$('#patient_create_form .phone-error').length) {
                            $('#patient_create_form input[name="mobile_phone"]').after('<div class="phone-error text-danger">Phone number already exists</div>');
                        }
                    } else {
                        $('#patient_create_form input[name="mobile_phone"]').removeClass('is-invalid');
                        $('#patient_create_form .phone-error').remove();
                    }
                },
                error: function(xhr, status, error) {
                    console.error('Ajax error:', error);
                    console.error('Response text:', xhr.responseText);
                    // Remove any existing error styling on connection error
                    $('#patient_create_form input[name="mobile_phone"]').removeClass('is-invalid');
                    $('#patient_create_form .phone-error').remove();
                }
            });
        } else {
            // Empty phone - remove validation styling (phone is optional)
            $('#patient_create_form input[name="mobile_phone"]').removeClass('is-invalid');
            $('#patient_create_form .phone-error').remove();
        }
    });
    
    // Helper function to validate email format
    function isValidEmail(email) {
        var emailRegex = /^[^\s@]+@[^\s@]+\.[^\s@]+$/;
        return emailRegex.test(email);
    }

    $('#edit_patient_form').submit(function(e){
        e.preventDefault();
        
        // Get form value from name attribute
        var patientID = $(this).find('input[name="patient_id"]').val();
        var patient_username = $(this).find('input[name="username"]').val();
        var patient_fname = $(this).find('input[name="patient_fname"]').val();
        var patient_lname = $(this).find('input[name="patient_lname"]').val();
        var patient_email = $(this).find('input[name="email_address"]').val();
        var patient_dob = $(this).find('input[name="patient_dob"]').val();
        var patient_cell = $(this).find('input[name="cell"]').val();
        var patient_password = $(this).find('input[name="password"]').val();

        // AJAX request
        $.ajax({
            url: 'process/edit_patient.php',
            type: 'POST',
            data: {
                patient_id: patientID,
                username: patient_username,
                patient_fname: patient_fname,
                patient_lname: patient_lname,
                email_address: patient_email,
                patient_dob: patient_dob,
                cell: patient_cell,
                password: patient_password
            },
            success: function(response) {
                
                // Sweet Alert
                Swal.fire({
                    title: response.title,
                    text: response.text,
                    icon: response.icon
                });

            },
            error: function(xhr) {
                
                // Sweet Alert
                Swal.fire({
                    title: "Error",
                    text: "An error occurred while updating the patient.",
                    icon: "error"
                });

            },
        });

    });

});