$(document).ready(function() {
    // Handle settings form submission
    $('#settings_form').on('submit', function(e) {
        e.preventDefault();
        
        // Get form data
        var formData = new FormData(this);
        
        // Show loading alert
        Swal.fire({
            title: 'Processing...',
            text: 'Updating settings, please wait.',
            allowOutsideClick: false,
            allowEscapeKey: false,
            showConfirmButton: false,
            didOpen: function() {
                Swal.showLoading();
            }
        });
        
        // Submit form via Ajax
        $.ajax({
            url: 'process/update_settings.php',
            type: 'POST',
            data: formData,
            contentType: false,
            processData: false,
            dataType: 'json',
            success: function(response) {
                Swal.close();
                
                if(response.result === true) {
                    Swal.fire({
                        icon: response.icon,
                        title: response.title,
                        text: response.message,
                        showConfirmButton: true,
                        confirmButtonText: 'OK'
                    });
                } else {
                    Swal.fire({
                        icon: response.icon,
                        title: response.title,
                        text: response.message,
                        showConfirmButton: true,
                        confirmButtonText: 'OK'
                    });
                }
            },
            error: function(xhr, status, error) {
                Swal.close();
                
                Swal.fire({
                    icon: 'error',
                    title: 'Connection Error',
                    text: 'There was an error connecting to the server. Please try again.',
                    showConfirmButton: true,
                    confirmButtonText: 'OK'
                });
                
                console.error('Ajax Error:', error);
                console.error('Status:', status);
                console.error('Response:', xhr.responseText);
            }
        });
    });
});