$(document).ready(function(){

    $(".xls-upload-form").submit(function(e){
        
        // Prevent the form from uploading
        e.preventDefault();
    
        var sendURL = $(this).attr('action');
        var fileToUpload = $('#fileToUpload').prop('files')[0];
        var formData = new FormData();
        formData.append('file', fileToUpload);
    
        $.ajax({
            url: sendURL,
            type: 'POST',
            data: formData,
            contentType: false,
            processData: false,
            success: function(data) {

                if( data.response == true ){

                    Swal.fire({
                        title: 'User accounts created',
                        text: "Bulk uploaded successfully, users created from the bulk uploads",
                        icon: 'success',
                        showCancelButton: false,
                        confirmButtonColor: '#2ecc71',
                        confirmButtonText: 'Refresh Page',
                        allowOutsideClick: false
                    }).then((result) => {
                        
                        // Refresh Page
                        location.reload();

                    })

                }else{

                    // Handle success here
                    Swal.fire({
                        icon: 'error',
                        title: data.error_message,
                    });

                }

            },
            error: function(data) {

                // Handle error here
                Swal.fire({
                    title: 'Oops...',
                    text: 'Something went wrong!',
                    icon: 'error',
                });

            }
        });
    
    });

    $('.del-gen-user').click(function(){

        var userid = $(this).attr('data-userid');
        var username = $(this).attr('data-username');

        Swal.fire({
            title: 'Delete '+username,
            text: "Are you sure you want to delete "+username+", You won't be able to revert this!",
            icon: 'warning',
            showCancelButton: true,
            confirmButtonColor: '#3085d6',
            cancelButtonColor: '#d33',
            confirmButtonText: 'Yes, delete it!',
            allowOutsideClick: false
        }).then((result) => {
            if (result.isConfirmed) {
                
                $.ajax({
                    url: 'process/del-gen-user.php',
                    type: 'POST',
                    data: {
                        userid: userid,
                    },
                    success: function(data) {
        
                        if( data.response == true ){
        
                            Swal.fire({
                                icon: 'success',
                                title: 'User deleted',
                                text: "The selected user was successfully deleted",
                            });
        
                            $( '#user_'+userid ).remove();
        
                        }else{
        
                            // Handle success here
                            Swal.fire({
                                icon: 'error',
                                title: data.error_message,
                            });
        
                        }
        
                    },
                    error: function(data) {
        
                        // Handle error here
                        Swal.fire({
                            title: 'Oops...',
                            text: 'Something went wrong!',
                            icon: 'error',
                        });
        
                    }
                });

            }
        })

    });

});